/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.DeclarationTransformer;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.tsexport.ExportModelGeneratorKt;
import org.jetbrains.kotlin.ir.backend.js.utils.AnnotationUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.JsAnnotations;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeys;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.MemoryOptimizedCollectionUtilKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u0013H\u0016J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0017H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0018H\u0002J\u0012\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u0019H\u0002J\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00130\u0016*\u00020\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0007H\u0002J\f\u0010\u001c\u001a\u00020\u0007*\u00020\u001dH\u0002J\f\u0010\u001e\u001a\u00020\u0007*\u00020\u0013H\u0002J\f\u0010\u001f\u001a\u00020 *\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering;", "Lorg/jetbrains/kotlin/backend/common/DeclarationTransformer;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "strictImplicitExport", "", "jsExportCtor", "Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "getJsExportCtor", "()Lorg/jetbrains/kotlin/ir/symbols/IrConstructorSymbol;", "jsExportCtor$delegate", "Lkotlin/Lazy;", "jsImplicitExportCtor", "getJsImplicitExportCtor", "jsImplicitExportCtor$delegate", "transformFlat", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "declaration", "collectImplicitlyExportedDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "includeArguments", "isSpeciallyExportedType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "shouldBeMarkedWithImplicitExportOrUpgraded", "markWithJsImplicitExportOrUpgrade", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nImplicitlyExportedDeclarationsMarkingLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImplicitlyExportedDeclarationsMarkingLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,145:1\n1914#2,2:146\n1585#2:148\n1660#2,3:149\n1390#2:152\n1479#2,5:153\n1390#2:158\n1479#2,5:159\n1390#2:164\n1479#2,5:165\n1479#2,5:170\n1660#2,3:176\n16#3:175\n1#4:179\n*S KotlinDebug\n*F\n+ 1 ImplicitlyExportedDeclarationsMarkingLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/ImplicitlyExportedDeclarationsMarkingLowering\n*L\n44#1:146,2\n61#1:148\n61#1:149,3\n62#1:152\n62#1:153,5\n65#1:158\n65#1:159,5\n92#1:164\n92#1:165,5\n106#1:170,5\n131#1:176,3\n131#1:175\n*E\n"})
public final class ImplicitlyExportedDeclarationsMarkingLowering
implements DeclarationTransformer {
    @NotNull
    private final JsIrBackendContext context;
    private final boolean strictImplicitExport;
    @NotNull
    private final Lazy jsExportCtor$delegate;
    @NotNull
    private final Lazy jsImplicitExportCtor$delegate;

    public ImplicitlyExportedDeclarationsMarkingLowering(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.strictImplicitExport = this.context.getConfiguration().getBoolean(JSConfigurationKeys.GENERATE_STRICT_IMPLICIT_EXPORT);
        this.jsExportCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ImplicitlyExportedDeclarationsMarkingLowering.jsExportCtor_delegate$lambda$0(this));
        this.jsImplicitExportCtor$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ImplicitlyExportedDeclarationsMarkingLowering.jsImplicitExportCtor_delegate$lambda$0(this));
    }

    private final IrConstructorSymbol getJsExportCtor() {
        Lazy lazy = this.jsExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    private final IrConstructorSymbol getJsImplicitExportCtor() {
        Lazy lazy = this.jsImplicitExportCtor$delegate;
        return (IrConstructorSymbol)lazy.getValue();
    }

    @Nullable
    public List<IrDeclaration> transformFlat(@NotNull IrDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!ExportModelGeneratorKt.isExported(declaration, this.context)) {
            return null;
        }
        IrDeclaration irDeclaration = declaration;
        Set<IrDeclaration> implicitlyExportedDeclarations = irDeclaration instanceof IrFunction ? this.collectImplicitlyExportedDeclarations((IrFunction)declaration) : (irDeclaration instanceof IrClass ? this.collectImplicitlyExportedDeclarations((IrClass)declaration) : (irDeclaration instanceof IrProperty ? this.collectImplicitlyExportedDeclarations((IrProperty)declaration) : SetsKt.emptySet()));
        Iterable $this$forEach$iv = implicitlyExportedDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrDeclaration it = (IrDeclaration)element$iv;
            boolean bl = false;
            this.markWithJsImplicitExportOrUpgrade(it);
        }
        return null;
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrClass $this$collectImplicitlyExportedDeclarations) {
        return SequencesKt.toSet((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.distinct((Sequence)SequencesKt.flatMapIterable((Sequence)kotlin.collections.CollectionsKt.asSequence((Iterable)$this$collectImplicitlyExportedDeclarations.getTypeParameters()), ImplicitlyExportedDeclarationsMarkingLowering::collectImplicitlyExportedDeclarations$lambda$0)), arg_0 -> ImplicitlyExportedDeclarationsMarkingLowering.collectImplicitlyExportedDeclarations$lambda$1(this, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrFunction $this$collectImplicitlyExportedDeclarations) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMapTo$iv$iv2;
        void $this$flatMap$iv;
        IrTypeParameter it;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Set set;
        Set $this$collectImplicitlyExportedDeclarations_u24lambda_u242 = set = SetsKt.createSetBuilder();
        boolean $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = false;
        $this$collectImplicitlyExportedDeclarations_u24lambda_u242.add($this$collectImplicitlyExportedDeclarations.getReturnType());
        Iterable iterable = IrUtilsKt.getNonDispatchParameters((IrFunction)$this$collectImplicitlyExportedDeclarations);
        Set set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u242;
        boolean $i$f$map = false;
        void var9_12 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getType());
        }
        set2.addAll((List)destination$iv$iv);
        $this$map$iv = $this$collectImplicitlyExportedDeclarations.getTypeParameters();
        set2 = $this$collectImplicitlyExportedDeclarations_u24lambda_u242;
        boolean $i$f$flatMap = false;
        $this$mapTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
            it = (IrTypeParameter)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getSuperTypes();
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        set2.addAll((List)destination$iv$iv);
        Set types = SetsKt.build((Set)set);
        Iterable $this$flatMap$iv2 = types;
        boolean $i$f$flatMap2 = false;
        Iterable $i$a$-buildSet-ImplicitlyExportedDeclarationsMarkingLowering$collectImplicitlyExportedDeclarations$types$22 = $this$flatMap$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$flatMapTo2 = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            IrType it2 = (IrType)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = this.collectImplicitlyExportedDeclarations(it2, true);
            kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
        }
        return kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
    }

    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrProperty $this$collectImplicitlyExportedDeclarations) {
        Object object;
        Object setterImplicitlyExportedDeclarations;
        Object object2;
        Object getterImplicitlyExportedDeclarations;
        Object object3 = $this$collectImplicitlyExportedDeclarations.getGetter();
        if (object3 == null || (object3 = this.collectImplicitlyExportedDeclarations((IrFunction)object3)) == null) {
            object3 = getterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((object2 = $this$collectImplicitlyExportedDeclarations.getSetter()) == null || (object2 = this.collectImplicitlyExportedDeclarations((IrFunction)object2)) == null) {
            object2 = setterImplicitlyExportedDeclarations = SetsKt.emptySet();
        }
        if ((object = $this$collectImplicitlyExportedDeclarations.getBackingField()) == null || (object = object.getType()) == null || (object = this.collectImplicitlyExportedDeclarations((IrType)object, true)) == null) {
            object = SetsKt.emptySet();
        }
        Object fieldImplicitlyExportedDeclarations = object;
        return SetsKt.plus((Set)SetsKt.plus((Set)getterImplicitlyExportedDeclarations, (Iterable)((Iterable)setterImplicitlyExportedDeclarations)), (Iterable)((Iterable)fieldImplicitlyExportedDeclarations));
    }

    /*
     * WARNING - void declaration
     */
    private final Set<IrDeclaration> collectImplicitlyExportedDeclarations(IrType $this$collectImplicitlyExportedDeclarations, boolean includeArguments) {
        Set set;
        if ($this$collectImplicitlyExportedDeclarations instanceof IrDynamicType || !($this$collectImplicitlyExportedDeclarations instanceof IrSimpleType)) {
            return SetsKt.emptySet();
        }
        IrType irType = IrTypesKt.makeNotNull((IrType)$this$collectImplicitlyExportedDeclarations);
        Intrinsics.checkNotNull((Object)irType, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
        IrSimpleType nonNullType = (IrSimpleType)irType;
        IrClassifierSymbol classifier = nonNullType.getClassifier();
        if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)nonNullType), (boolean)false, (int)1, null) || IrTypeUtilsKt.isPrimitiveArray((IrType)((IrType)nonNullType)) || IrTypePredicatesKt.isAny((IrType)((IrType)nonNullType)) || IrTypePredicatesKt.isNothing((IrType)((IrType)nonNullType)) || IrTypePredicatesKt.isUnit((IrType)((IrType)nonNullType))) {
            set = SetsKt.emptySet();
        } else if (classifier instanceof IrTypeParameterSymbol) {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            Iterable iterable = ((IrTypeParameter)((IrTypeParameterSymbol)classifier).getOwner()).getSuperTypes();
            boolean $i$f$flatMap = false;
            void var7_9 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                IrType it = (IrType)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ImplicitlyExportedDeclarationsMarkingLowering.collectImplicitlyExportedDeclarations$default(this, it, false, 1, null);
                kotlin.collections.CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            set = kotlin.collections.CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        } else if (classifier instanceof IrClassSymbol) {
            IrClass klass = (IrClass)((IrClassSymbol)classifier).getOwner();
            Set result = new LinkedHashSet();
            boolean isSpeciallyExportedType = this.isSpeciallyExportedType(nonNullType);
            if (!isSpeciallyExportedType && this.shouldBeMarkedWithImplicitExportOrUpgraded((IrDeclaration)klass)) {
                result.add(klass);
            }
            if (includeArguments && (isSpeciallyExportedType || klass.isExternal() || Intrinsics.areEqual((Object)AnnotationUtilsKt.couldBeConvertedToExplicitExport((IrAnnotationContainer)klass), (Object)true) || ExportModelGeneratorKt.isExported((IrDeclaration)klass, this.context))) {
                void $this$flatMapTo$iv;
                Iterable destination$iv$iv = ((IrSimpleType)$this$collectImplicitlyExportedDeclarations).getArguments();
                Collection destination$iv = result;
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Set set2;
                    IrTypeArgument it = (IrTypeArgument)element$iv;
                    boolean bl = false;
                    IrTypeArgument irTypeArgument = it;
                    if (irTypeArgument instanceof IrStarProjection) {
                        set2 = SetsKt.emptySet();
                    } else if (irTypeArgument instanceof IrTypeProjection) {
                        set2 = ImplicitlyExportedDeclarationsMarkingLowering.collectImplicitlyExportedDeclarations$default(this, ((IrTypeProjection)it).getType(), false, 1, null);
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    Iterable list$iv = set2;
                    kotlin.collections.CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
            }
            set = result;
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    static /* synthetic */ Set collectImplicitlyExportedDeclarations$default(ImplicitlyExportedDeclarationsMarkingLowering implicitlyExportedDeclarationsMarkingLowering2, IrType irType, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return implicitlyExportedDeclarationsMarkingLowering2.collectImplicitlyExportedDeclarations(irType, bl);
    }

    private final boolean isSpeciallyExportedType(IrSimpleType $this$isSpeciallyExportedType) {
        return IrTypeUtilsKt.isFunction((IrType)((IrType)$this$isSpeciallyExportedType)) || IrTypeUtilsKt.isThrowable((IrType)((IrType)$this$isSpeciallyExportedType)) || IrTypePredicatesKt.isArray((IrType)((IrType)$this$isSpeciallyExportedType));
    }

    private final boolean shouldBeMarkedWithImplicitExportOrUpgraded(IrDeclaration $this$shouldBeMarkedWithImplicitExportOrUpgraded) {
        return $this$shouldBeMarkedWithImplicitExportOrUpgraded instanceof IrClass && !((IrClass)$this$shouldBeMarkedWithImplicitExportOrUpgraded).isExternal() && !ExportModelGeneratorKt.isExported($this$shouldBeMarkedWithImplicitExportOrUpgraded, this.context);
    }

    /*
     * WARNING - void declaration
     */
    private final void markWithJsImplicitExportOrUpgrade(IrDeclaration $this$markWithJsImplicitExportOrUpgrade) {
        block4: {
            void $this$markWithJsImplicitExportOrUpgrade_u24lambda_u241;
            IrConstructorCall irConstructorCall;
            block3: {
                void $this$mapTo$iv$iv;
                void $this$memoryOptimizedMap$iv;
                if (!Intrinsics.areEqual((Object)AnnotationUtilsKt.couldBeConvertedToExplicitExport((IrAnnotationContainer)$this$markWithJsImplicitExportOrUpgrade), (Object)true)) break block3;
                Collection collection = $this$markWithJsImplicitExportOrUpgrade.getAnnotations();
                IrDeclaration irDeclaration = $this$markWithJsImplicitExportOrUpgrade;
                boolean $i$f$memoryOptimizedMap = false;
                Iterable iterable = (Iterable)$this$memoryOptimizedMap$iv;
                Collection destination$iv$iv = new ArrayList($this$memoryOptimizedMap$iv.size());
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    IrConstructorCall irConstructorCall2 = (IrConstructorCall)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    collection2.add(IrUtilsKt.isAnnotation((IrConstructorCall)it, (FqName)JsAnnotations.INSTANCE.getJsImplicitExportFqn()) ? JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsExportCtor(), null, null, null, 0, 0, 62, null) : it);
                }
                irDeclaration.setAnnotations(CollectionsKt.compactIfPossible((List)((List)destination$iv$iv)));
                break block4;
            }
            if (!this.strictImplicitExport) break block4;
            IrConstructorCall $i$f$memoryOptimizedMap = irConstructorCall = JsIrBuilder.buildConstructorCall$default(JsIrBuilder.INSTANCE, this.getJsImplicitExportCtor(), null, null, null, 0, 0, 62, null);
            List list = $this$markWithJsImplicitExportOrUpgrade.getAnnotations();
            IrDeclaration irDeclaration = $this$markWithJsImplicitExportOrUpgrade;
            boolean bl = false;
            $this$markWithJsImplicitExportOrUpgrade_u24lambda_u241.getArguments().set(0, (Object)IrUtilsKt.toIrConst$default((Object)false, (IrType)this.context.getIrBuiltIns().getBooleanType(), (int)0, (int)0, (int)6, null));
            Unit unit = Unit.INSTANCE;
            irDeclaration.setAnnotations(MemoryOptimizedCollectionUtilKt.memoryOptimizedPlus((List)list, (Object)irConstructorCall));
            Object object = IrUtilsKt.getParentClassOrNull((IrDeclaration)$this$markWithJsImplicitExportOrUpgrade);
            if (object != null) {
                IrClass irClass;
                IrClass it = irClass = object;
                boolean bl2 = false;
                object = this.shouldBeMarkedWithImplicitExportOrUpgraded((IrDeclaration)it) ? irClass : null;
                if (object != null) {
                    this.markWithJsImplicitExportOrUpgrade((IrDeclaration)object);
                }
            }
        }
    }

    private static final IrConstructorSymbol jsExportCtor_delegate$lambda$0(ImplicitlyExportedDeclarationsMarkingLowering this$0) {
        return (IrConstructorSymbol)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this$0.context.getIntrinsics().getJsExportAnnotationSymbol()));
    }

    private static final IrConstructorSymbol jsImplicitExportCtor_delegate$lambda$0(ImplicitlyExportedDeclarationsMarkingLowering this$0) {
        return (IrConstructorSymbol)SequencesKt.single((Sequence)IrUtilsKt.getConstructors((IrClassSymbol)this$0.context.getIntrinsics().getJsImplicitExportAnnotationSymbol()));
    }

    private static final Iterable collectImplicitlyExportedDeclarations$lambda$0(IrTypeParameter it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getSuperTypes();
    }

    private static final Iterable collectImplicitlyExportedDeclarations$lambda$1(ImplicitlyExportedDeclarationsMarkingLowering this$0, IrType it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ImplicitlyExportedDeclarationsMarkingLowering.collectImplicitlyExportedDeclarations$default(this$0, it, false, 1, null);
    }
}

