/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.List;
import java.util.NoSuchElementException;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.CompilationExceptionKt;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.lower.VarargLoweringKt;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrConstructorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrConstructorSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eJ\u000e\u0010 \u001a\u00020\u001e2\u0006\u0010!\u001a\u00020\u001eJ\u0014\u0010\"\u001a\u00020\u001e2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u001e0$R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0019\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\fR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\f\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo;", "", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "elementType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "arrayType", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;Lorg/jetbrains/kotlin/ir/types/IrType;Lorg/jetbrains/kotlin/ir/types/IrType;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "getElementType", "()Lorg/jetbrains/kotlin/ir/types/IrType;", "getArrayType", "getInlinedClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getInlineClassUnderlyingType", "irClass", "arrayInlineClass", "getArrayInlineClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "inlined", "", "getInlined", "()Z", "primitiveElementType", "getPrimitiveElementType", "primitiveArrayType", "getPrimitiveArrayType", "boxArrayIfNeeded", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "array", "unboxElementIfNeeded", "element", "toPrimitiveArrayLiteral", "elements", "", "backend.js"})
@SourceDebugExtension(value={"SMAP\nVarargLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,254:1\n350#2,12:255\n*S KotlinDebug\n*F\n+ 1 VarargLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/InlineClassArrayInfo\n*L\n234#1:255,12\n*E\n"})
public final class InlineClassArrayInfo {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final IrType elementType;
    @NotNull
    private final IrType arrayType;
    @Nullable
    private final IrClass arrayInlineClass;
    private final boolean inlined;
    @NotNull
    private final IrType primitiveElementType;
    @NotNull
    private final IrType primitiveArrayType;

    public InlineClassArrayInfo(@NotNull JsIrBackendContext context, @NotNull IrType elementType, @NotNull IrType arrayType) {
        IrType irType;
        IrType irType2;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)elementType, (String)"elementType");
        Intrinsics.checkNotNullParameter((Object)arrayType, (String)"arrayType");
        this.context = context;
        this.elementType = elementType;
        this.arrayType = arrayType;
        this.arrayInlineClass = this.getInlinedClass(this.arrayType);
        boolean bl = this.inlined = this.arrayInlineClass != null;
        if (this.inlined) {
            IrClass irClass = this.getInlinedClass(this.elementType);
            if (irClass == null) {
                CompilationExceptionKt.compilationException((String)"Could not get inlined class", (IrType)this.elementType);
                throw new KotlinNothingValueException();
            }
            irType2 = this.getInlineClassUnderlyingType(irClass);
        } else {
            irType2 = this.primitiveElementType = this.elementType;
        }
        if (this.inlined) {
            IrClass irClass = this.arrayInlineClass;
            Intrinsics.checkNotNull((Object)irClass);
            irType = this.getInlineClassUnderlyingType(irClass);
        } else {
            irType = this.arrayType;
        }
        this.primitiveArrayType = irType;
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrType getElementType() {
        return this.elementType;
    }

    @NotNull
    public final IrType getArrayType() {
        return this.arrayType;
    }

    private final IrClass getInlinedClass(IrType $this$getInlinedClass) {
        return this.context.getInlineClassesUtils().getInlinedClass($this$getInlinedClass);
    }

    private final IrType getInlineClassUnderlyingType(IrClass irClass) {
        return this.context.getInlineClassesUtils().getInlineClassUnderlyingType(irClass);
    }

    @Nullable
    public final IrClass getArrayInlineClass() {
        return this.arrayInlineClass;
    }

    public final boolean getInlined() {
        return this.inlined;
    }

    @NotNull
    public final IrType getPrimitiveElementType() {
        return this.primitiveElementType;
    }

    @NotNull
    public final IrType getPrimitiveArrayType() {
        return this.primitiveArrayType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrExpression boxArrayIfNeeded(@NotNull IrExpression array) {
        IrExpression irExpression;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        if (this.arrayInlineClass == null) {
            irExpression = array;
        } else {
            void $this$single$iv;
            IrExpression $this$boxArrayIfNeeded_u24lambda_u240 = array;
            boolean bl = false;
            Sequence sequence = IrUtilsKt.getConstructors((IrClass)this.arrayInlineClass);
            IrType irType = (IrType)IrUtilsKt.getDefaultType((IrClass)this.arrayInlineClass);
            int n = $this$boxArrayIfNeeded_u24lambda_u240.getEndOffset();
            int n2 = $this$boxArrayIfNeeded_u24lambda_u240.getStartOffset();
            IrConstructorCallImpl.Companion companion = IrConstructorCallImpl.Companion;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$single$iv) {
                IrConstructor it = (IrConstructor)element$iv;
                boolean bl2 = false;
                if (!it.isPrimary()) continue;
                if (found$iv) {
                    throw new IllegalArgumentException("Sequence contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv = true;
            }
            if (!found$iv) {
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Object var16_18 = single$iv;
            Sequence $this$boxArrayIfNeeded_u24lambda_u240_u241 = sequence = BuildersKt.fromSymbolOwner$default((IrConstructorCallImpl.Companion)companion, (int)n2, (int)n, (IrType)irType, (IrConstructorSymbol)((IrConstructor)var16_18).getSymbol(), (int)this.arrayInlineClass.getTypeParameters().size(), null, (int)32, null);
            boolean bl3 = false;
            $this$boxArrayIfNeeded_u24lambda_u240_u241.getArguments().set(0, (Object)array);
            irExpression = (IrExpression)sequence;
        }
        return irExpression;
    }

    @NotNull
    public final IrExpression unboxElementIfNeeded(@NotNull IrExpression element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.arrayInlineClass == null) {
            return element;
        }
        IrExpression $this$unboxElementIfNeeded_u24lambda_u240 = element;
        boolean bl = false;
        IrClass irClass = this.getInlinedClass($this$unboxElementIfNeeded_u24lambda_u240.getType());
        if (irClass == null) {
            return element;
        }
        IrClass inlinedClass = irClass;
        IrField field = InlineClassesKt.getInlineClassBackingField((IrClass)inlinedClass);
        return (IrExpression)BuildersKt.IrGetFieldImpl$default((int)$this$unboxElementIfNeeded_u24lambda_u240.getStartOffset(), (int)$this$unboxElementIfNeeded_u24lambda_u240.getEndOffset(), (IrFieldSymbol)field.getSymbol(), (IrType)field.getType(), (IrExpression)$this$unboxElementIfNeeded_u24lambda_u240, null, null, (int)96, null);
    }

    @NotNull
    public final IrExpression toPrimitiveArrayLiteral(@NotNull List<? extends IrExpression> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        return VarargLoweringKt.access$toArrayLiteral(elements, this.context, this.primitiveArrayType, this.primitiveElementType);
    }
}

