/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsLoweredDeclarationOrigin;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrArithBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.BridgesConstruction;
import org.jetbrains.kotlin.ir.backend.js.lower.InlineClassArrayInfo;
import org.jetbrains.kotlin.ir.backend.js.utils.IrResolveUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.utils.MiscKt;
import org.jetbrains.kotlin.ir.backend.js.utils.NameTablesKt;
import org.jetbrains.kotlin.ir.builders.ExpressionHelpersKt;
import org.jetbrains.kotlin.ir.builders.IrBlockBodyBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilder;
import org.jetbrains.kotlin.ir.builders.IrBuilderKt;
import org.jetbrains.kotlin.ir.builders.IrStatementsBuilder;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrPossiblyExternalDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0019H\u0016J&\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019H\u0014J0\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001f*\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)H\u0002J2\u0010*\u001a\u00020%*\u00020\"2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010+\u001a\u00020'2\u0006\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020%0)H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u000b0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/BridgesConstruction;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "calculator", "Lorg/jetbrains/kotlin/ir/backend/js/ir/JsIrArithBuilder;", "jsArguments", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "jsArrayGet", "jsArrayLength", "jsArrayLike2Array", "jsSliceArrayLikeFromIndex", "jsSliceArrayLikeFromIndexToIndex", "primitiveArrays", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "primitiveToLiteralConstructor", "getFunctionSignature", "", "function", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "findConcreteSuperDeclaration", "getBridgeOrigin", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationOrigin;", "bridge", "extractParameters", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "blockBodyBuilder", "Lorg/jetbrains/kotlin/ir/builders/IrBlockBodyBuilder;", "irFunction", "createVarsForTrailingParameters", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "numberOfTrailingParameters", "", "firstTrailingParameterIndexVar", "Lkotlin/Lazy;", "emitCopyVarargToArray", "varargIndex", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsBridgesConstruction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsBridgesConstruction.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,164:1\n362#2,7:165\n1595#2:172\n1628#2,4:173\n*S KotlinDebug\n*F\n+ 1 JsBridgesConstruction.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsBridgesConstruction\n*L\n63#1:165,7\n108#1:172\n108#1:173,4\n*E\n"})
public final class JsBridgesConstruction
extends BridgesConstruction {
    @NotNull
    private final JsIrBackendContext context;
    @NotNull
    private final JsIrArithBuilder calculator;
    @NotNull
    private final IrSimpleFunctionSymbol jsArguments;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayGet;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayLength;
    @NotNull
    private final IrSimpleFunctionSymbol jsArrayLike2Array;
    @NotNull
    private final IrSimpleFunctionSymbol jsSliceArrayLikeFromIndex;
    @NotNull
    private final IrSimpleFunctionSymbol jsSliceArrayLikeFromIndexToIndex;
    @NotNull
    private final Map<IrClassSymbol, PrimitiveType> primitiveArrays;
    @NotNull
    private final Map<PrimitiveType, IrSimpleFunctionSymbol> primitiveToLiteralConstructor;

    public JsBridgesConstruction(@NotNull JsIrBackendContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.context = context;
        this.calculator = new JsIrArithBuilder(this.context);
        this.jsArguments = this.context.getIntrinsics().getJsArguments();
        this.jsArrayGet = this.context.getIntrinsics().getJsArrayGet();
        this.jsArrayLength = this.context.getIntrinsics().getJsArrayLength();
        this.jsArrayLike2Array = this.context.getIntrinsics().getJsArrayLike2Array();
        this.jsSliceArrayLikeFromIndex = this.context.getIntrinsics().getJsSliceArrayLikeFromIndex();
        this.jsSliceArrayLikeFromIndexToIndex = this.context.getIntrinsics().getJsSliceArrayLikeFromIndexToIndex();
        this.primitiveArrays = this.context.getIntrinsics().getPrimitiveArrays();
        this.primitiveToLiteralConstructor = this.context.getIntrinsics().getPrimitiveToLiteralConstructor();
    }

    @NotNull
    public final JsIrBackendContext getContext() {
        return this.context;
    }

    @Override
    @NotNull
    public String getFunctionSignature(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return NameTablesKt.jsFunctionSignature((IrFunction)function2, this.context);
    }

    @Override
    @NotNull
    public IrSimpleFunction findConcreteSuperDeclaration(@NotNull IrSimpleFunction function2) {
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        return this.isRealOrOverridesInterface(function2) ? function2 : IrResolveUtilsKt.getRealOverrideTarget(function2);
    }

    @Override
    @NotNull
    public IrDeclarationOrigin getBridgeOrigin(@NotNull IrSimpleFunction bridge) {
        Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
        return MiscKt.hasStableJsName((IrFunction)bridge, this.context) ? (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITH_STABLE_NAME() : (bridge.getCorrespondingPropertySymbol() != null ? (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_PROPERTY_ACCESSOR() : (IrDeclarationOrigin)JsLoweredDeclarationOrigin.INSTANCE.getBRIDGE_WITHOUT_STABLE_NAME());
    }

    @Override
    @NotNull
    protected List<IrValueDeclaration> extractParameters(@NotNull IrBlockBodyBuilder blockBodyBuilder, @NotNull IrSimpleFunction irFunction, @NotNull IrSimpleFunction bridge) {
        int varargIndex;
        Object item$iv2;
        block4: {
            int n;
            Intrinsics.checkNotNullParameter((Object)blockBodyBuilder, (String)"blockBodyBuilder");
            Intrinsics.checkNotNullParameter((Object)irFunction, (String)"irFunction");
            Intrinsics.checkNotNullParameter((Object)bridge, (String)"bridge");
            if (!IrUtilsKt.isEffectivelyExternal((IrPossiblyExternalDeclaration)((IrPossiblyExternalDeclaration)bridge))) {
                return super.extractParameters(blockBodyBuilder, irFunction, bridge);
            }
            List $this$indexOfFirst$iv = bridge.getParameters();
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            for (Object item$iv2 : $this$indexOfFirst$iv) {
                IrValueParameter it = (IrValueParameter)item$iv2;
                boolean bl = false;
                if (AdditionalIrUtilsKt.isVararg((IrValueParameter)it)) {
                    n = index$iv;
                    break block4;
                }
                ++index$iv;
            }
            n = varargIndex = -1;
        }
        if (varargIndex == -1) {
            return super.extractParameters(blockBodyBuilder, irFunction, bridge);
        }
        IrBlockBodyBuilder $this$extractParameters_u24lambda_u241 = blockBodyBuilder;
        boolean bl = false;
        int numberOfTrailingParameters = bridge.getParameters().size() - (varargIndex + 1);
        Object $this$extractParameters_u24lambda_u241_u240 = item$iv2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$extractParameters_u24lambda_u241), (IrSimpleFunctionSymbol)this.jsArrayLength);
        boolean bl2 = false;
        $this$extractParameters_u24lambda_u241_u240.getArguments().set(0, (Object)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$extractParameters_u24lambda_u241), (IrSimpleFunctionSymbol)this.jsArguments));
        $this$extractParameters_u24lambda_u241_u240.setType($this$extractParameters_u24lambda_u241.getContext().getIrBuiltIns().getIntType());
        Object getTotalNumberOfArguments = item$iv2;
        Lazy firstTrailingParameterIndexVar = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JsBridgesConstruction.extractParameters$lambda$1$1($this$extractParameters_u24lambda_u241, numberOfTrailingParameters, getTotalNumberOfArguments, this));
        IrVariable varargArrayVar = this.emitCopyVarargToArray($this$extractParameters_u24lambda_u241, bridge, varargIndex, numberOfTrailingParameters, (Lazy<? extends IrVariable>)firstTrailingParameterIndexVar);
        List<IrVariable> trailingParametersVars = this.createVarsForTrailingParameters($this$extractParameters_u24lambda_u241, bridge, numberOfTrailingParameters, (Lazy<? extends IrVariable>)firstTrailingParameterIndexVar);
        return CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)irFunction.getParameters(), (Object)varargArrayVar), (Iterable)trailingParametersVars);
    }

    /*
     * WARNING - void declaration
     */
    private final List<IrVariable> createVarsForTrailingParameters(IrBlockBodyBuilder $this$createVarsForTrailingParameters, IrSimpleFunction bridge, int numberOfTrailingParameters, Lazy<? extends IrVariable> firstTrailingParameterIndexVar) {
        void $this$mapIndexedTo$iv$iv;
        Iterable $this$mapIndexed$iv = CollectionsKt.takeLast((List)bridge.getParameters(), (int)numberOfTrailingParameters);
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void trailingParameter;
            void $this$createVarsForTrailingParameters_u24lambda_u240_u240;
            IrCall irCall;
            void index;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrValueParameter irValueParameter = (IrValueParameter)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrExpression parameterIndex = index == false ? (IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createVarsForTrailingParameters), (IrValueDeclaration)((IrValueDeclaration)firstTrailingParameterIndexVar.getValue())) : this.calculator.add((IrExpression)ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$createVarsForTrailingParameters), (IrValueDeclaration)((IrValueDeclaration)firstTrailingParameterIndexVar.getValue())), (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$createVarsForTrailingParameters), (int)index, null, (int)2, null));
            IrCall irCall2 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$createVarsForTrailingParameters), (IrSimpleFunctionSymbol)this.jsArrayGet);
            IrStatementsBuilder irStatementsBuilder = (IrStatementsBuilder)$this$createVarsForTrailingParameters;
            boolean bl2 = false;
            $this$createVarsForTrailingParameters_u24lambda_u240_u240.getArguments().set(0, (Object)ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$createVarsForTrailingParameters), (IrSimpleFunctionSymbol)this.jsArguments));
            $this$createVarsForTrailingParameters_u24lambda_u240_u240.getArguments().set(1, (Object)parameterIndex);
            collection.add(IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)irStatementsBuilder, (IrExpression)((IrExpression)irCall), (String)trailingParameter.getName().asString(), (boolean)false, null, (IrType)trailingParameter.getType(), (int)12, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final IrVariable emitCopyVarargToArray(IrBlockBodyBuilder $this$emitCopyVarargToArray, IrSimpleFunction bridge, int varargIndex, int numberOfTrailingParameters, Lazy<? extends IrVariable> firstTrailingParameterIndexVar) {
        IrExpression irExpression;
        IrCall irCall;
        IrValueParameter varargElement = (IrValueParameter)bridge.getParameters().get(varargIndex);
        Object[] objectArray = new IrExpression[]{ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$emitCopyVarargToArray), (IrSimpleFunctionSymbol)this.jsArguments)};
        List sliceIntrinsicArgs = CollectionsKt.mutableListOf((Object[])objectArray);
        IrSimpleFunctionSymbol sliceIntrinsic = this.jsArrayLike2Array;
        if (varargIndex != 0 || numberOfTrailingParameters > 0) {
            int nonDispatchVarargIndex = varargIndex - (bridge.getDispatchReceiverParameter() != null ? 1 : 0);
            sliceIntrinsicArgs.add(ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this$emitCopyVarargToArray), (int)nonDispatchVarargIndex, null, (int)2, null));
            sliceIntrinsic = this.jsSliceArrayLikeFromIndex;
        }
        if (numberOfTrailingParameters > 0) {
            sliceIntrinsicArgs.add(ExpressionHelpersKt.irGet((IrBuilder)((IrBuilder)$this$emitCopyVarargToArray), (IrValueDeclaration)((IrValueDeclaration)firstTrailingParameterIndexVar.getValue())));
            sliceIntrinsic = this.jsSliceArrayLikeFromIndexToIndex;
        }
        IrCall $this$emitCopyVarargToArray_u24lambda_u240 = irCall = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$emitCopyVarargToArray), (IrSimpleFunctionSymbol)sliceIntrinsic);
        boolean bl = false;
        List list = $this$emitCopyVarargToArray_u24lambda_u240.getTypeArguments();
        IrType irType = varargElement.getVarargElementType();
        Intrinsics.checkNotNull((Object)irType);
        list.set(0, irType);
        AddToStdlibKt.assignFrom((List)((List)$this$emitCopyVarargToArray_u24lambda_u240.getArguments()), (Collection)sliceIntrinsicArgs);
        IrCall arrayExpr = irCall;
        boolean bl2 = false;
        IrType irType2 = varargElement.getVarargElementType();
        Intrinsics.checkNotNull((Object)irType2);
        InlineClassArrayInfo arrayInfo = new InlineClassArrayInfo(this.context, irType2, varargElement.getType());
        PrimitiveType primitiveType = this.primitiveArrays.get(IrTypesKt.getClassifierOrNull((IrType)arrayInfo.getPrimitiveArrayType()));
        if (primitiveType != null) {
            void $this$emitCopyVarargToArray_u24lambda_u241_u240;
            IrCall irCall2;
            IrCall irCall3 = irCall2 = ExpressionHelpersKt.irCall((IrBuilder)((IrBuilder)$this$emitCopyVarargToArray), (IrSimpleFunctionSymbol)((IrSimpleFunctionSymbol)MapsKt.getValue(this.primitiveToLiteralConstructor, (Object)primitiveType)));
            InlineClassArrayInfo inlineClassArrayInfo = arrayInfo;
            boolean bl3 = false;
            $this$emitCopyVarargToArray_u24lambda_u241_u240.getArguments().set(0, (Object)arrayExpr);
            $this$emitCopyVarargToArray_u24lambda_u241_u240.setType(varargElement.getType());
            irExpression = inlineClassArrayInfo.boxArrayIfNeeded((IrExpression)irCall2);
        } else {
            irExpression = (IrExpression)arrayExpr;
        }
        IrExpression varargCopiedAsArray = irExpression;
        return IrBuilderKt.createTmpVariable$default((IrStatementsBuilder)((IrStatementsBuilder)$this$emitCopyVarargToArray), (IrExpression)varargCopiedAsArray, (String)varargElement.getName().asString(), (boolean)false, null, null, (int)28, null);
    }

    private static final IrVariable extractParameters$lambda$1$1(IrBlockBodyBuilder $this_run, int $numberOfTrailingParameters, IrCall $getTotalNumberOfArguments, JsBridgesConstruction this$0) {
        return ExpressionHelpersKt.irTemporary$default((IrStatementsBuilder)((IrStatementsBuilder)$this_run), (IrExpression)($numberOfTrailingParameters == 0 ? (IrExpression)$getTotalNumberOfArguments : this$0.calculator.sub((IrExpression)$getTotalNumberOfArguments, (IrExpression)ExpressionHelpersKt.irInt$default((IrBuilder)((IrBuilder)$this_run), (int)$numberOfTrailingParameters, null, (int)2, null))), (String)"firstTrailingParameterIndex", null, (boolean)false, null, (int)28, null);
    }
}

