/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\t\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector;", "Lorg/jetbrains/kotlin/js/backend/ast/RecursiveJsVisitor;", "<init>", "()V", "functionsStack", "", "Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "functionalScopes", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsFunction;", "visitVars", "", "x", "Lorg/jetbrains/kotlin/js/backend/ast/JsVars;", "visitFunction", "varWithNameExistsInScopeOf", "", "function", "variableName", "", "Scope", "backend.js"})
@SourceDebugExtension(value={"SMAP\nJsCodeOutliningLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,412:1\n1914#2,2:413\n1914#2,2:415\n*S KotlinDebug\n*F\n+ 1 JsCodeOutliningLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector\n*L\n357#1:413,2\n365#1:415,2\n*E\n"})
public final class JsScopesCollector
extends RecursiveJsVisitor {
    @NotNull
    private final List<Scope> functionsStack;
    @NotNull
    private final Map<JsFunction, Scope> functionalScopes;

    public JsScopesCollector() {
        Object[] objectArray = new Scope[]{new Scope(null)};
        this.functionsStack = CollectionsKt.mutableListOf((Object[])objectArray);
        objectArray = new Pair[]{TuplesKt.to(null, (Object)CollectionsKt.first(this.functionsStack))};
        this.functionalScopes = MapsKt.mutableMapOf((Pair[])objectArray);
    }

    @Override
    public void visitVars(@NotNull JsVars x) {
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        super.visitVars(x);
        Scope currentScope = (Scope)CollectionsKt.last(this.functionsStack);
        List<JsVars.JsVar> list = x.getVars();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getVars(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsVars.JsVar it = (JsVars.JsVar)element$iv;
            boolean bl = false;
            String string = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdent(...)");
            currentScope.add(string);
        }
    }

    @Override
    public void visitFunction(@NotNull JsFunction x) {
        String name;
        Scope scope;
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        Scope parentScope = (Scope)CollectionsKt.last(this.functionsStack);
        Scope $this$visitFunction_u24lambda_u240 = scope = new Scope(parentScope);
        boolean bl = false;
        JsName jsName = x.getName();
        String string = name = jsName != null ? jsName.getIdent() : null;
        if (name != null) {
            $this$visitFunction_u24lambda_u240.add(name);
        }
        List<JsParameter> list = x.getParameters();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JsParameter it = (JsParameter)element$iv;
            boolean bl2 = false;
            String string2 = it.getName().getIdent();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getIdent(...)");
            $this$visitFunction_u24lambda_u240.add(string2);
        }
        Scope newScope = scope;
        UtilsKt.push(this.functionsStack, (Object)newScope);
        this.functionalScopes.put(x, newScope);
        super.visitFunction(x);
        UtilsKt.pop(this.functionsStack);
    }

    public final boolean varWithNameExistsInScopeOf(@Nullable JsFunction function2, @NotNull String variableName) {
        Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
        Scope scope = this.functionalScopes.get(function2);
        Intrinsics.checkNotNull((Object)scope);
        return scope.variableWithNameExists(variableName);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\tR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\u0007\u001a\u0012\u0012\u0004\u0012\u00020\t0\bj\b\u0012\u0004\u0012\u00020\t`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "", "parent", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;)V", "getParent", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/JsScopesCollector$Scope;", "variables", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "add", "", "variableName", "variableWithNameExists", "", "backend.js"})
    private static final class Scope {
        @Nullable
        private final Scope parent;
        @NotNull
        private final HashSet<String> variables;

        public Scope(@Nullable Scope parent2) {
            this.parent = parent2;
            this.variables = new HashSet();
        }

        @Nullable
        public final Scope getParent() {
            return this.parent;
        }

        public final void add(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            this.variables.add(variableName);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean variableWithNameExists(@NotNull String variableName) {
            Intrinsics.checkNotNullParameter((Object)variableName, (String)"variableName");
            if (this.variables.contains(variableName)) return true;
            Scope scope = this.parent;
            if (scope == null) return false;
            if (!scope.variableWithNameExists(variableName)) return false;
            return true;
        }
    }
}

