/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower.coroutines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.UtilsKt;
import org.jetbrains.kotlin.backend.common.lower.FinallyBlocksLoweringKt;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.JsCommonBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsIrAttributesKt;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.LoopBounds;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.StateMachineBuilderKt;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.SuspendState;
import org.jetbrains.kotlin.ir.backend.js.lower.coroutines.TryState;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStatementOrigin;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperator;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrVarargElement;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrBlockImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrCompositeImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetObjectValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrGetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrReturnImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrSetValueImpl;
import org.jetbrains.kotlin.ir.expressions.impl.IrTypeOperatorCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFieldSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnTargetSymbol;
import org.jetbrains.kotlin.ir.symbols.IrReturnableBlockSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueParameterSymbol;
import org.jetbrains.kotlin.ir.symbols.IrValueSymbol;
import org.jetbrains.kotlin.ir.symbols.IrVariableSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.ReferencedSymbolRemapper;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.kotlin.ir.visitors.IrVisitorVoid;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00e2\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0085\u0001\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000e\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\f\u0012\u0006\u0010\u0010\u001a\u00020\f\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014\u0012\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0006\u0010A\u001a\u00020BJ\b\u0010C\u001a\u00020<H\u0002J\b\u0010K\u001a\u000200H\u0002J\b\u0010L\u001a\u00020BH\u0002J\u0010\u0010M\u001a\u00020B2\u0006\u0010L\u001a\u000200H\u0002J\b\u0010N\u001a\u00020\u0016H\u0002J\u0014\u0010O\u001a\u00020B*\u00020F2\u0006\u0010P\u001a\u00020\u0018H\u0002J\u0010\u0010O\u001a\u00020B2\u0006\u0010P\u001a\u00020\u0018H\u0002J\b\u0010Q\u001a\u00020.H\u0002J\u0010\u0010R\u001a\u00020.2\u0006\u0010S\u001a\u000200H\u0002J\u001a\u0010T\u001a\u00020B2\u0006\u0010S\u001a\u0002002\b\b\u0002\u0010U\u001a\u00020.H\u0002J \u0010V\u001a\u00020B2\u0006\u0010S\u001a\u0002002\u0006\u0010W\u001a\u00020F2\u0006\u0010U\u001a\u00020.H\u0002J\u0012\u0010X\u001a\u00020B2\b\b\u0002\u0010W\u001a\u00020FH\u0002J\u001c\u0010Y\u001a\u00020B2\u0012\u0010Z\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014H\u0002J\u0010\u0010[\u001a\u00020\\2\u0006\u0010S\u001a\u000200H\u0002J\u0010\u0010]\u001a\u00020B2\u0006\u0010^\u001a\u00020\u0004H\u0016J0\u0010_\u001a\u00020B2\u0006\u0010`\u001a\u00020\n2\u001e\u0010Z\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020B0aH\u0002J\u0010\u0010b\u001a\u00020B2\u0006\u0010`\u001a\u00020cH\u0016J\u0010\u0010d\u001a\u00020B2\u0006\u0010`\u001a\u00020eH\u0016J\u0018\u0010f\u001a\u00020g2\u0006\u0010h\u001a\u00020\u00162\u0006\u0010i\u001a\u00020\u0015H\u0002J\u0010\u0010j\u001a\u00020B2\u0006\u0010k\u001a\u00020lH\u0016J \u0010m\u001a\u00020B2\u0006\u0010n\u001a\u0002002\u0006\u0010o\u001a\u0002002\u0006\u0010p\u001a\u00020\u0015H\u0002J\u0010\u0010q\u001a\u00020B2\u0006\u0010r\u001a\u00020sH\u0016J\u0010\u0010t\u001a\u00020B2\u0006\u0010r\u001a\u00020uH\u0016J\u0010\u0010v\u001a\u00020B2\u0006\u0010`\u001a\u00020\nH\u0002J\u0018\u0010w\u001a\u00020x2\u0006\u0010k\u001a\u00020\u00162\u0006\u0010y\u001a\u00020zH\u0002J\u0010\u0010{\u001a\u00020B2\u0006\u0010k\u001a\u00020|H\u0016J\u0010\u0010}\u001a\u00020B2\u0006\u0010k\u001a\u00020~H\u0016J\u0011\u0010\u007f\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0080\u0001H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0082\u0001H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020B2\u0007\u0010\u0084\u0001\u001a\u000207H\u0016J\u0012\u0010\u0085\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0086\u0001H\u0016J\u001e\u0010\u0087\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0088\u00012\n\u0010\u0089\u0001\u001a\u0005\u0018\u00010\u008a\u0001H\u0016J\u0012\u0010\u008b\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u008c\u0001H\u0016J\u0012\u0010\u008d\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u008e\u0001H\u0016J\u0012\u0010\u008f\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0090\u0001H\u0016J&\u0010\u0091\u0001\u001a\u00020B\"\u000b\b\u0000\u0010\u0092\u0001*\u0004\u0018\u00010\u00162\u000e\u0010\u0093\u0001\u001a\t\u0012\u0005\u0012\u0003H\u0092\u000106H\u0002J\u0016\u0010\u0094\u0001\u001a\u00020B2\u000b\u0010k\u001a\u0007\u0012\u0002\b\u00030\u0095\u0001H\u0016J\u0012\u0010\u0096\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0097\u0001H\u0016J\u0012\u0010\u0098\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u0099\u0001H\u0016J\u0012\u0010\u009e\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u009f\u0001H\u0016J\t\u0010\u00a0\u0001\u001a\u00020BH\u0002J\u0011\u0010\u00a1\u0001\u001a\u00020.2\u0006\u0010k\u001a\u00020\u0016H\u0002J\u0012\u0010\u00a2\u0001\u001a\u00020B2\u0007\u0010k\u001a\u00030\u00a3\u0001H\u0016J\u0013\u0010\u00a4\u0001\u001a\u00020B2\b\u0010\u00a5\u0001\u001a\u00030\u00a6\u0001H\u0016J\u0011\u0010\u00a7\u0001\u001a\u00020B2\u0006\u0010S\u001a\u000200H\u0002J\t\u0010\u00a8\u0001\u001a\u00020lH\u0002J\t\u0010\u00a9\u0001\u001a\u00020lH\u0002J\t\u0010\u00aa\u0001\u001a\u00020IH\u0002J\u0019\u0010\u00ab\u0001\u001a\u00020g2\u0006\u0010h\u001a\u00020\u00162\u0006\u0010i\u001a\u00020\u0015H\u0002J\u001e\u0010\u00ac\u0001\u001a\u0002072\u0007\u0010\u00ad\u0001\u001a\u00020\u00152\n\b\u0002\u0010\u00ae\u0001\u001a\u00030\u00af\u0001H\u0002J\u0011\u0010\u00b0\u0001\u001a\u00020B2\u0006\u0010y\u001a\u000207H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00160\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00180\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u001f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!0 j\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020!`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010/\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u00103\u001a\u000200\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00102R\u0017\u00105\u001a\b\u0012\u0004\u0012\u00020706\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u000e\u0010:\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010;\u001a\u00020<X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u000e\u0010D\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020FX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010G\u001a\b\u0012\u0004\u0012\u00020006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010H\u001a\u001e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020I0 j\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020I`\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010J\u001a\b\u0012\u0004\u0012\u00020\u001606X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u009a\u0001\u001a\u00030\u009b\u00018BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u009c\u0001\u0010\u009d\u0001\u00a8\u0006\u00b1\u0001"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/StateMachineBuilder;", "Lorg/jetbrains/kotlin/ir/visitors/IrVisitorVoid;", "suspendableNodes", "", "Lorg/jetbrains/kotlin/ir/IrElement;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "function", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "rootLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrLoop;", "exceptionSymbolGetter", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "exceptionSymbolSetter", "exStateSymbolGetter", "exStateSymbolSetter", "stateSymbolSetter", "thisSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;", "getSuspendResultAsType", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "setSuspendResultValue", "Lorg/jetbrains/kotlin/ir/IrStatement;", "<init>", "(Ljava/util/Set;Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;Lorg/jetbrains/kotlin/ir/expressions/IrLoop;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;Lorg/jetbrains/kotlin/ir/symbols/IrValueParameterSymbol;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)V", "getContext", "()Lorg/jetbrains/kotlin/ir/backend/js/JsCommonBackendContext;", "getFunction", "()Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "loopMap", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/LoopBounds;", "Lkotlin/collections/HashMap;", "unit", "anyN", "nothing", "booleanNotSymbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "eqeqeqSymbol", "thisReceiver", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "getThisReceiver", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetValueImpl;", "hasExceptions", "", "entryState", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendState;", "getEntryState", "()Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/SuspendState;", "rootExceptionTrap", "getRootExceptionTrap", "allTheIntermediateLocals", "", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "getAllTheIntermediateLocals", "()Ljava/util/List;", "globalExceptionVar", "globalCatch", "Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "getGlobalCatch", "()Lorg/jetbrains/kotlin/ir/expressions/IrCatch;", "setGlobalCatch", "(Lorg/jetbrains/kotlin/ir/expressions/IrCatch;)V", "finalizeStateMachine", "", "buildGlobalCatch", "currentState", "currentBlock", "Lorg/jetbrains/kotlin/ir/expressions/IrContainerExpression;", "catchBlockStack", "tryStateMap", "Lorg/jetbrains/kotlin/ir/backend/js/lower/coroutines/TryState;", "tryLoopStack", "buildExceptionTrapState", "newState", "updateState", "lastExpression", "addStatement", "statement", "isBlockEnded", "maybeDoDispatch", "target", "doDispatch", "andContinue", "doDispatchImpl", "block", "doContinue", "transformLastExpression", "transformer", "buildDispatchBlock", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrCompositeImpl;", "visitElement", "element", "transformLoop", "loop", "Lkotlin/Function3;", "visitWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrWhileLoop;", "visitDoWhileLoop", "Lorg/jetbrains/kotlin/ir/expressions/IrDoWhileLoop;", "implicitCast", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrTypeOperatorCallImpl;", "value", "toType", "visitCall", "expression", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "buildUnboxingState", "unboxState", "continueState", "expectedType", "visitBreak", "jump", "Lorg/jetbrains/kotlin/ir/expressions/IrBreak;", "visitContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrContinue;", "resetExceptionStateIfNeeded", "wrap", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrSetValueImpl;", "variable", "Lorg/jetbrains/kotlin/ir/symbols/IrVariableSymbol;", "visitComposite", "Lorg/jetbrains/kotlin/ir/expressions/IrComposite;", "visitWhen", "Lorg/jetbrains/kotlin/ir/expressions/IrWhen;", "visitSetValue", "Lorg/jetbrains/kotlin/ir/expressions/IrSetValue;", "visitTypeOperator", "Lorg/jetbrains/kotlin/ir/expressions/IrTypeOperatorCall;", "visitVariable", "declaration", "visitGetField", "Lorg/jetbrains/kotlin/ir/expressions/IrGetField;", "visitDynamicMemberExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicMemberExpression;", "data", "", "visitDynamicOperatorExpression", "Lorg/jetbrains/kotlin/ir/expressions/IrDynamicOperatorExpression;", "visitGetClass", "Lorg/jetbrains/kotlin/ir/expressions/IrGetClass;", "visitVararg", "Lorg/jetbrains/kotlin/ir/expressions/IrVararg;", "transformArguments", "E", "arguments", "visitMemberAccess", "Lorg/jetbrains/kotlin/ir/expressions/IrMemberAccessExpression;", "visitSetField", "Lorg/jetbrains/kotlin/ir/expressions/IrSetField;", "visitStringConcatenation", "Lorg/jetbrains/kotlin/ir/expressions/IrStringConcatenation;", "unitValue", "Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "getUnitValue", "()Lorg/jetbrains/kotlin/ir/expressions/impl/IrGetObjectValueImpl;", "visitReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "addExceptionEdge", "hasResultingValue", "visitThrow", "Lorg/jetbrains/kotlin/ir/expressions/IrThrow;", "visitTry", "aTry", "Lorg/jetbrains/kotlin/ir/expressions/IrTry;", "setupExceptionState", "exceptionState", "pendingException", "buildTryState", "buildIsCheck", "tempVar", "type", "name", "", "registerLocal", "backend.js"})
@SourceDebugExtension(value={"SMAP\nStateMachineBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StateMachineBuilder.kt\norg/jetbrains/kotlin/ir/backend/js/lower/coroutines/StateMachineBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 6 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,798:1\n1#2:799\n1585#3:800\n1660#3,3:801\n1628#3,4:807\n1595#3:811\n1628#3,4:812\n1848#3,3:816\n282#4:804\n282#4:805\n282#4:806\n17#5,16:819\n33#5:836\n19#6:835\n*S KotlinDebug\n*F\n+ 1 StateMachineBuilder.kt\norg/jetbrains/kotlin/ir/backend/js/lower/coroutines/StateMachineBuilder\n*L\n421#1:800\n421#1:801,3\n541#1:807,4\n550#1:811\n550#1:812,4\n573#1:816,3\n452#1:804\n459#1:805\n465#1:806\n587#1:819,16\n587#1:836\n587#1:835\n*E\n"})
public final class StateMachineBuilder
extends IrVisitorVoid {
    @NotNull
    private final Set<IrElement> suspendableNodes;
    @NotNull
    private final JsCommonBackendContext context;
    @NotNull
    private final IrFunctionSymbol function;
    @NotNull
    private final IrLoop rootLoop;
    @NotNull
    private final IrSimpleFunction exceptionSymbolGetter;
    @NotNull
    private final IrSimpleFunction exceptionSymbolSetter;
    @NotNull
    private final IrSimpleFunction exStateSymbolGetter;
    @NotNull
    private final IrSimpleFunction exStateSymbolSetter;
    @NotNull
    private final IrSimpleFunction stateSymbolSetter;
    @NotNull
    private final IrValueParameterSymbol thisSymbol;
    @NotNull
    private final Function1<IrType, IrExpression> getSuspendResultAsType;
    @NotNull
    private final Function1<IrExpression, IrStatement> setSuspendResultValue;
    @NotNull
    private final HashMap<IrLoop, LoopBounds> loopMap;
    @NotNull
    private final IrType unit;
    @NotNull
    private final IrType anyN;
    @NotNull
    private final IrType nothing;
    @NotNull
    private final IrSimpleFunctionSymbol booleanNotSymbol;
    @NotNull
    private final IrSimpleFunctionSymbol eqeqeqSymbol;
    private boolean hasExceptions;
    @NotNull
    private final SuspendState entryState;
    @NotNull
    private final SuspendState rootExceptionTrap;
    @NotNull
    private final List<IrVariable> allTheIntermediateLocals;
    @NotNull
    private final IrVariable globalExceptionVar;
    public IrCatch globalCatch;
    @NotNull
    private SuspendState currentState;
    @NotNull
    private IrContainerExpression currentBlock;
    @NotNull
    private final List<SuspendState> catchBlockStack;
    @NotNull
    private final HashMap<IrExpression, TryState> tryStateMap;
    @NotNull
    private final List<IrExpression> tryLoopStack;

    public StateMachineBuilder(@NotNull Set<IrElement> suspendableNodes, @NotNull JsCommonBackendContext context, @NotNull IrFunctionSymbol function2, @NotNull IrLoop rootLoop, @NotNull IrSimpleFunction exceptionSymbolGetter, @NotNull IrSimpleFunction exceptionSymbolSetter, @NotNull IrSimpleFunction exStateSymbolGetter, @NotNull IrSimpleFunction exStateSymbolSetter, @NotNull IrSimpleFunction stateSymbolSetter, @NotNull IrValueParameterSymbol thisSymbol, @NotNull Function1<? super IrType, ? extends IrExpression> getSuspendResultAsType, @NotNull Function1<? super IrExpression, ? extends IrStatement> setSuspendResultValue) {
        Intrinsics.checkNotNullParameter(suspendableNodes, (String)"suspendableNodes");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)function2, (String)"function");
        Intrinsics.checkNotNullParameter((Object)rootLoop, (String)"rootLoop");
        Intrinsics.checkNotNullParameter((Object)exceptionSymbolGetter, (String)"exceptionSymbolGetter");
        Intrinsics.checkNotNullParameter((Object)exceptionSymbolSetter, (String)"exceptionSymbolSetter");
        Intrinsics.checkNotNullParameter((Object)exStateSymbolGetter, (String)"exStateSymbolGetter");
        Intrinsics.checkNotNullParameter((Object)exStateSymbolSetter, (String)"exStateSymbolSetter");
        Intrinsics.checkNotNullParameter((Object)stateSymbolSetter, (String)"stateSymbolSetter");
        Intrinsics.checkNotNullParameter((Object)thisSymbol, (String)"thisSymbol");
        Intrinsics.checkNotNullParameter(getSuspendResultAsType, (String)"getSuspendResultAsType");
        Intrinsics.checkNotNullParameter(setSuspendResultValue, (String)"setSuspendResultValue");
        this.suspendableNodes = suspendableNodes;
        this.context = context;
        this.function = function2;
        this.rootLoop = rootLoop;
        this.exceptionSymbolGetter = exceptionSymbolGetter;
        this.exceptionSymbolSetter = exceptionSymbolSetter;
        this.exStateSymbolGetter = exStateSymbolGetter;
        this.exStateSymbolSetter = exStateSymbolSetter;
        this.stateSymbolSetter = stateSymbolSetter;
        this.thisSymbol = thisSymbol;
        this.getSuspendResultAsType = getSuspendResultAsType;
        this.setSuspendResultValue = setSuspendResultValue;
        this.loopMap = new HashMap();
        this.unit = this.context.getIrBuiltIns().getUnitType();
        this.anyN = this.context.getIrBuiltIns().getAnyNType();
        this.nothing = this.context.getIrBuiltIns().getNothingType();
        this.booleanNotSymbol = this.context.getIrBuiltIns().getBooleanNotSymbol();
        this.eqeqeqSymbol = this.context.getIrBuiltIns().getEqeqeqSymbol();
        this.entryState = new SuspendState(this.unit);
        this.rootExceptionTrap = this.buildExceptionTrapState();
        this.allTheIntermediateLocals = new ArrayList();
        this.globalExceptionVar = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, IrTypesKt.makeNotNull((IrType)this.exceptionSymbolGetter.getReturnType()), (IrDeclarationParent)this.function.getOwner(), "e", false, false, false, null, null, 248, null);
        this.currentState = this.entryState;
        this.currentBlock = this.entryState.getEntryBlock();
        Object[] objectArray = new SuspendState[]{this.rootExceptionTrap};
        this.catchBlockStack = CollectionsKt.mutableListOf((Object[])objectArray);
        this.tryStateMap = new HashMap();
        this.tryLoopStack = new ArrayList();
    }

    @NotNull
    public final JsCommonBackendContext getContext() {
        return this.context;
    }

    @NotNull
    public final IrFunctionSymbol getFunction() {
        return this.function;
    }

    private final IrGetValueImpl getThisReceiver() {
        return JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)this.thisSymbol, null, 2, null);
    }

    @NotNull
    public final SuspendState getEntryState() {
        return this.entryState;
    }

    @NotNull
    public final SuspendState getRootExceptionTrap() {
        return this.rootExceptionTrap;
    }

    @NotNull
    public final List<IrVariable> getAllTheIntermediateLocals() {
        return this.allTheIntermediateLocals;
    }

    @NotNull
    public final IrCatch getGlobalCatch() {
        IrCatch irCatch = this.globalCatch;
        if (irCatch != null) {
            return irCatch;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"globalCatch");
        return null;
    }

    public final void setGlobalCatch(@NotNull IrCatch irCatch) {
        Intrinsics.checkNotNullParameter((Object)irCatch, (String)"<set-?>");
        this.globalCatch = irCatch;
    }

    public final void finalizeStateMachine() {
        this.setGlobalCatch(this.buildGlobalCatch());
        if (!(CollectionsKt.lastOrNull((List)this.currentBlock.getStatements()) instanceof IrReturn)) {
            this.addStatement((IrStatement)new IrReturnImpl(IrUtilsKt.getPreviousOffset((int)this.rootLoop.getEndOffset()), IrUtilsKt.getPreviousOffset((int)this.rootLoop.getEndOffset()), this.nothing, (IrReturnTargetSymbol)this.function, (IrExpression)this.getUnitValue()));
        }
        if (!this.hasExceptions) {
            ((Collection)this.entryState.getSuccessors()).add(this.rootExceptionTrap);
        }
    }

    private final IrCatch buildGlobalCatch() {
        IrVariable catchVariable = this.globalExceptionVar;
        IrVariableSymbol globalExceptionSymbol = this.globalExceptionVar.getSymbol();
        IrBlockImpl block = JsIrBuilder.INSTANCE.buildBlock(this.unit);
        if (this.hasExceptions) {
            IrCall irCall;
            IrBlockImpl thenBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit);
            IrBlockImpl elseBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit);
            Object object = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.eqeqeqSymbol, null, null, null, null, 0, 0, 126, null);
            IrCall $this$buildGlobalCatch_u24lambda_u240 = object;
            boolean bl = false;
            $this$buildGlobalCatch_u24lambda_u240.getArguments().set(0, (Object)this.exceptionState());
            $this$buildGlobalCatch_u24lambda_u240.getArguments().set(1, (Object)StateMachineBuilderKt.access$createDispatchPoint(this.rootExceptionTrap));
            IrCall check2 = object;
            ((Collection)block.getStatements()).add(JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.unit, (IrExpression)check2, (IrExpression)thenBlock, (IrExpression)elseBlock, 0, 0, 0, 0, 240, null));
            ((Collection)thenBlock.getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)globalExceptionSymbol, null, 2, null)));
            object = elseBlock.getStatements();
            IrCall $this$buildGlobalCatch_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, null, 0, 0, 124, null);
            boolean bl2 = false;
            $this$buildGlobalCatch_u24lambda_u241.getArguments().set(0, (Object)this.getThisReceiver());
            $this$buildGlobalCatch_u24lambda_u241.getArguments().set(1, (Object)this.exceptionState());
            object.add(irCall);
            object = elseBlock.getStatements();
            IrCall $this$buildGlobalCatch_u24lambda_u242 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exceptionSymbolSetter.getSymbol(), this.unit, null, null, null, 0, 0, 124, null);
            boolean bl3 = false;
            $this$buildGlobalCatch_u24lambda_u242.getArguments().set(0, (Object)this.getThisReceiver());
            $this$buildGlobalCatch_u24lambda_u242.getArguments().set(1, (Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)globalExceptionSymbol, null, 2, null));
            object.add(irCall);
        } else {
            ((Collection)block.getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)globalExceptionSymbol, null, 2, null)));
        }
        return (IrCatch)JsIrBuilder.INSTANCE.buildCatch(catchVariable, block);
    }

    private final SuspendState buildExceptionTrapState() {
        SuspendState state = new SuspendState(this.unit);
        ((Collection)state.getEntryBlock().getStatements()).add(JsIrBuilder.INSTANCE.buildThrow(this.nothing, (IrExpression)this.pendingException()));
        return state;
    }

    private final void newState() {
        SuspendState newState = new SuspendState(this.unit);
        StateMachineBuilder.doDispatch$default(this, newState, false, 2, null);
        this.updateState(newState);
    }

    private final void updateState(SuspendState newState) {
        this.currentState = newState;
        this.currentBlock = newState.getEntryBlock();
    }

    private final IrExpression lastExpression() {
        Object object = CollectionsKt.lastOrNull((List)this.currentBlock.getStatements());
        IrExpression irExpression = object instanceof IrExpression ? (IrExpression)object : null;
        if (irExpression == null) {
            irExpression = (IrExpression)this.getUnitValue();
        }
        return irExpression;
    }

    private final void addStatement(IrContainerExpression $this$addStatement, IrStatement statement) {
        $this$addStatement.getStatements().add(statement);
    }

    private final void addStatement(IrStatement statement) {
        this.addStatement(this.currentBlock, statement);
    }

    private final boolean isBlockEnded() {
        Object object = CollectionsKt.lastOrNull((List)this.currentBlock.getStatements());
        IrExpression irExpression = object instanceof IrExpression ? (IrExpression)object : null;
        if (irExpression == null) {
            return false;
        }
        IrExpression lastExpression = irExpression;
        return IrTypePredicatesKt.isNothing((IrType)lastExpression.getType());
    }

    private final boolean maybeDoDispatch(SuspendState target) {
        if (!this.isBlockEnded()) {
            StateMachineBuilder.doDispatch$default(this, target, false, 2, null);
            return true;
        }
        return false;
    }

    private final void doDispatch(SuspendState target, boolean andContinue) {
        this.doDispatchImpl(target, this.currentBlock, andContinue);
    }

    static /* synthetic */ void doDispatch$default(StateMachineBuilder stateMachineBuilder, SuspendState suspendState, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        stateMachineBuilder.doDispatch(suspendState, bl);
    }

    /*
     * WARNING - void declaration
     */
    private final void doDispatchImpl(SuspendState target, IrContainerExpression block, boolean andContinue) {
        void $this$doDispatchImpl_u24lambda_u240;
        IrCall irCall;
        IrComposite irDispatch = StateMachineBuilderKt.access$createDispatchPoint(target);
        this.currentState.getSuccessors().add(target);
        IrCall irCall2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, null, 0, 0, 124, null);
        IrContainerExpression irContainerExpression = block;
        StateMachineBuilder stateMachineBuilder = this;
        boolean bl = false;
        $this$doDispatchImpl_u24lambda_u240.getArguments().set(0, (Object)this.getThisReceiver());
        $this$doDispatchImpl_u24lambda_u240.getArguments().set(1, (Object)irDispatch);
        Unit unit = Unit.INSTANCE;
        stateMachineBuilder.addStatement(irContainerExpression, (IrStatement)irCall);
        if (andContinue) {
            this.doContinue(block);
        }
    }

    private final void doContinue(IrContainerExpression block) {
        this.addStatement(block, (IrStatement)JsIrBuilder.INSTANCE.buildContinue(this.nothing, this.rootLoop));
    }

    static /* synthetic */ void doContinue$default(StateMachineBuilder stateMachineBuilder, IrContainerExpression irContainerExpression, int n, Object object) {
        if ((n & 1) != 0) {
            irContainerExpression = stateMachineBuilder.currentBlock;
        }
        stateMachineBuilder.doContinue(irContainerExpression);
    }

    private final void transformLastExpression(Function1<? super IrExpression, ? extends IrStatement> transformer2) {
        IrExpression expression2 = this.lastExpression();
        IrStatement newStatement = (IrStatement)transformer2.invoke((Object)expression2);
        List it = this.currentBlock.getStatements();
        boolean bl = false;
        if (!((Collection)it).isEmpty()) {
            it.set(CollectionsKt.getLastIndex((List)it), newStatement);
        } else {
            ((Collection)it).add(newStatement);
        }
    }

    private final IrCompositeImpl buildDispatchBlock(SuspendState target) {
        IrCompositeImpl irCompositeImpl;
        IrCompositeImpl it = irCompositeImpl = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, this.unit, null, 2, null);
        boolean bl = false;
        this.doDispatchImpl(target, (IrContainerExpression)it, true);
        return irCompositeImpl;
    }

    public void visitElement(@NotNull IrElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (this.suspendableNodes.contains(element)) {
            IrVisitorsKt.acceptChildrenVoid((IrElement)element, (IrVisitorVoid)this);
        } else {
            this.addStatement((IrStatement)element);
        }
    }

    private final void transformLoop(IrLoop loop, Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit> transformer2) {
        boolean bl;
        if (!this.suspendableNodes.contains(loop)) {
            this.addStatement((IrStatement)loop);
            return;
        }
        this.newState();
        SuspendState loopHeadState = this.currentState;
        SuspendState loopExitState = new SuspendState(this.unit);
        ((Map)this.loopMap).put(loop, new LoopBounds(loopHeadState, loopExitState));
        UtilsKt.push(this.tryLoopStack, (Object)loop);
        transformer2.invoke((Object)loop, (Object)loopHeadState, (Object)loopExitState);
        Object object = UtilsKt.pop(this.tryLoopStack);
        IrExpression it = (IrExpression)object;
        boolean bl2 = false;
        boolean bl3 = bl = it == loop;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.loopMap.remove(loop);
        this.updateState(loopExitState);
    }

    public void visitWhileLoop(@NotNull IrWhileLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        this.transformLoop((IrLoop)loop, (Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit>)((Function3)(arg_0, arg_1, arg_2) -> StateMachineBuilder.visitWhileLoop$lambda$0(this, arg_0, arg_1, arg_2)));
    }

    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop) {
        Intrinsics.checkNotNullParameter((Object)loop, (String)"loop");
        this.transformLoop((IrLoop)loop, (Function3<? super IrLoop, ? super SuspendState, ? super SuspendState, Unit>)((Function3)(arg_0, arg_1, arg_2) -> StateMachineBuilder.visitDoWhileLoop$lambda$0(this, arg_0, arg_1, arg_2)));
    }

    private final IrTypeOperatorCallImpl implicitCast(IrExpression value, IrType toType) {
        return JsIrBuilder.INSTANCE.buildImplicitCast(value, toType);
    }

    /*
     * WARNING - void declaration
     */
    public void visitCall(@NotNull IrCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        super.visitCall(expression2);
        if (IrUtilsKt.isSuspend((IrCall)expression2)) {
            IrCall irCall;
            IrExpression result = this.lastExpression();
            IrType expectedType = ((IrSimpleFunction)expression2.getSymbol().getOwner()).getReturnType();
            boolean isInlineClassExpected = this.context.getInlineClassesUtils().getInlinedClass(expectedType) != null;
            SuspendState continueState = new SuspendState(this.unit);
            SuspendState unboxState = isInlineClassExpected ? new SuspendState(this.unit) : null;
            SuspendState suspendState = unboxState;
            if (suspendState == null) {
                suspendState = continueState;
            }
            IrComposite dispatch = StateMachineBuilderKt.access$createDispatchPoint(suspendState);
            if (unboxState != null) {
                ((Collection)this.currentState.getSuccessors()).add(unboxState);
            }
            ((Collection)this.currentState.getSuccessors()).add(continueState);
            this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitCall$lambda$0(this, dispatch, arg_0)));
            this.addStatement((IrStatement)this.setSuspendResultValue.invoke((Object)result));
            IrReturnImpl irReturn = JsIrBuilder.INSTANCE.buildReturn(this.function, (IrExpression)this.getSuspendResultAsType.invoke((Object)this.anyN), this.nothing);
            IrCall $this$visitCall_u24lambda_u241 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.eqeqeqSymbol, null, null, null, null, 0, 0, 126, null);
            boolean bl2 = false;
            $this$visitCall_u24lambda_u241.getArguments().set(0, this.getSuspendResultAsType.invoke((Object)this.anyN));
            $this$visitCall_u24lambda_u241.getArguments().set(1, (Object)JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.context.getSymbols().getCoroutineSuspendedGetter(), null, null, null, null, 0, 0, 126, null));
            IrCall check2 = irCall;
            IrBlockImpl suspensionBlock = JsIrBuilder.INSTANCE.buildBlock(this.unit, CollectionsKt.listOf((Object)irReturn));
            this.addStatement((IrStatement)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this.unit, (IrExpression)check2, (IrExpression)suspensionBlock, null, 0, 0, 0, 0, 248, null));
            if (isInlineClassExpected) {
                void $this$visitCall_u24lambda_u242;
                IrCall irCall2;
                IrCall bl2 = irCall2 = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.stateSymbolSetter.getSymbol(), this.unit, null, null, null, 0, 0, 124, null);
                StateMachineBuilder stateMachineBuilder = this;
                boolean bl3 = false;
                $this$visitCall_u24lambda_u242.getArguments().set(0, (Object)this.getThisReceiver());
                $this$visitCall_u24lambda_u242.getArguments().set(1, (Object)StateMachineBuilderKt.access$createDispatchPoint(continueState));
                stateMachineBuilder.addStatement((IrStatement)irCall2);
            }
            StateMachineBuilder.doContinue$default(this, null, 1, null);
            SuspendState suspendState2 = unboxState;
            if (suspendState2 != null) {
                SuspendState it = suspendState2;
                boolean bl4 = false;
                this.buildUnboxingState(it, continueState, expectedType);
            }
            this.updateState(continueState);
            this.addStatement((IrStatement)this.getSuspendResultAsType.invoke((Object)expression2.getType()));
        }
    }

    private final void buildUnboxingState(SuspendState unboxState, SuspendState continueState, IrType expectedType) {
        ((Collection)unboxState.getSuccessors()).add(continueState);
        this.updateState(unboxState);
        IrExpression result = (IrExpression)this.getSuspendResultAsType.invoke((Object)this.anyN);
        IrVariable tmp = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, expectedType, (IrDeclarationParent)this.function.getOwner(), "unboxed", false, false, false, result, null, 184, null);
        this.addStatement((IrStatement)tmp);
        this.addStatement((IrStatement)this.setSuspendResultValue.invoke((Object)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)tmp.getSymbol(), null, 2, null)));
        StateMachineBuilder.doDispatch$default(this, continueState, false, 2, null);
    }

    public void visitBreak(@NotNull IrBreak jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        LoopBounds loopBounds = this.loopMap.get(jump.getLoop());
        Intrinsics.checkNotNull((Object)loopBounds);
        SuspendState exitState = loopBounds.getExitState();
        this.resetExceptionStateIfNeeded(jump.getLoop());
        StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
    }

    public void visitContinue(@NotNull IrContinue jump) {
        Intrinsics.checkNotNullParameter((Object)jump, (String)"jump");
        LoopBounds loopBounds = this.loopMap.get(jump.getLoop());
        Intrinsics.checkNotNull((Object)loopBounds);
        SuspendState headState = loopBounds.getHeadState();
        this.resetExceptionStateIfNeeded(jump.getLoop());
        StateMachineBuilder.doDispatch$default(this, headState, false, 2, null);
    }

    private final void resetExceptionStateIfNeeded(IrLoop loop) {
        IrExpression nearestTry = null;
        boolean found = false;
        boolean needReset = false;
        for (IrExpression e : CollectionsKt.asReversedMutable(this.tryLoopStack)) {
            if (e instanceof IrTry) {
                boolean bl = needReset = !found;
            }
            if (e == loop) {
                found = true;
            }
            if (!found || !(e instanceof IrTry)) continue;
            nearestTry = e;
            break;
        }
        if (needReset) {
            Object object = (TryState)((Map)this.tryStateMap).get(nearestTry);
            if (object == null || (object = ((TryState)object).getCatchState()) == null) {
                object = this.rootExceptionTrap;
            }
            Object tryState = object;
            this.setupExceptionState((SuspendState)tryState);
        }
    }

    private final IrSetValueImpl wrap(IrExpression expression2, IrVariableSymbol variable) {
        return JsIrBuilder.INSTANCE.buildSetVariable(variable, expression2, this.unit);
    }

    public void visitComposite(@NotNull IrComposite expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (Intrinsics.areEqual((Object)expression2.getOrigin(), (Object)FinallyBlocksLoweringKt.getFINALLY_EXPRESSION())) {
            SuspendState suspendState = (SuspendState)UtilsKt.peek(this.catchBlockStack);
            if (suspendState != null) {
                SuspendState p0 = suspendState;
                boolean bl = false;
                this.setupExceptionState(p0);
            }
        }
        super.visitComposite(expression2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitWhen(@NotNull IrWhen expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        SuspendState exitState = new SuspendState(expression2.getType());
        IrVariableSymbol varSymbol = null;
        List branches = null;
        if (this.hasResultingValue((IrExpression)expression2)) {
            void $this$mapTo$iv$iv;
            IrVariable irVar = this.tempVar(expression2.getType(), "WHEN_RESULT");
            varSymbol = irVar.getSymbol();
            this.addStatement((IrStatement)irVar);
            Iterable $this$map$iv = expression2.getBranches();
            boolean $i$f$map = false;
            Object object = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                IrBranch irBranch = (IrBranch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                IrSetValueImpl wrapped = this.wrap(it.getResult(), varSymbol);
                if (this.suspendableNodes.contains(it.getResult())) {
                    ((Collection)this.suspendableNodes).add(wrapped);
                }
                collection.add(IrUtilsKt.isElseBranch((IrBranch)it) ? (IrBranch)BuildersKt.IrElseBranchImpl((int)it.getStartOffset(), (int)it.getEndOffset(), (IrExpression)it.getCondition(), (IrExpression)((IrExpression)wrapped)) : (IrBranch)BuildersKt.IrBranchImpl((int)it.getStartOffset(), (int)it.getEndOffset(), (IrExpression)it.getCondition(), (IrExpression)((IrExpression)wrapped)));
            }
            branches = (List)destination$iv$iv;
        } else {
            varSymbol = null;
            branches = expression2.getBranches();
        }
        boolean exitStateDispatched = false;
        for (IrBranch branch : branches) {
            if (!IrUtilsKt.isElseBranch((IrBranch)branch)) {
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)branch.getCondition()), (IrVisitorVoid)this);
                IrCompositeImpl branchBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, branch.getResult().getType(), null, 2, null);
                IrCompositeImpl elseBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, expression2.getType(), null, 2, null);
                SuspendState dispatchState = this.currentState;
                this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitWhen$lambda$1(this, branchBlock, elseBlock, arg_0)));
                this.currentBlock = (IrContainerExpression)branchBlock;
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)branch.getResult()), (IrVisitorVoid)this);
                boolean $this$ifTrue$iv = this.maybeDoDispatch(exitState);
                boolean $i$f$ifTrue = false;
                if ($this$ifTrue$iv) {
                    boolean bl = false;
                    exitStateDispatched = true;
                }
                this.currentState = dispatchState;
                this.currentBlock = (IrContainerExpression)elseBlock;
                continue;
            }
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)branch.getResult()), (IrVisitorVoid)this);
            boolean $this$ifTrue$iv = this.maybeDoDispatch(exitState);
            boolean $i$f$ifTrue = false;
            if (!$this$ifTrue$iv) break;
            boolean bl = false;
            exitStateDispatched = true;
            break;
        }
        boolean $this$ifTrue$iv = this.maybeDoDispatch(exitState);
        boolean $i$f$ifTrue = false;
        if ($this$ifTrue$iv) {
            boolean bl = false;
            exitStateDispatched = true;
        }
        if (exitStateDispatched) {
            this.updateState(exitState);
        }
        if (varSymbol != null) {
            this.addStatement((IrStatement)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)varSymbol, null, 2, null));
        }
    }

    public void visitSetValue(@NotNull IrSetValue expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitSetValue$lambda$0(expression2, arg_0)));
    }

    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitTypeOperator$lambda$0(expression2, arg_0)));
    }

    public void visitVariable(@NotNull IrVariable declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.registerLocal(declaration);
        IrExpression initializer = declaration.getInitializer();
        declaration.setInitializer(null);
        int startOffset = declaration.getStartOffset();
        int endOffset = declaration.getEndOffset();
        declaration.setStartOffset(-1);
        declaration.setEndOffset(-1);
        if (!this.suspendableNodes.contains(declaration)) {
            IrExpression irExpression = initializer;
            if (irExpression != null) {
                IrExpression it = irExpression;
                boolean bl = false;
                this.addStatement((IrStatement)JsIrBuilder.INSTANCE.buildSetValue((IrValueSymbol)declaration.getSymbol(), it, startOffset, endOffset));
            }
            return;
        }
        IrExpression irExpression = initializer;
        if (irExpression != null) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irExpression), (IrVisitorVoid)this);
        }
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitVariable$lambda$1(declaration, startOffset, endOffset, arg_0)));
    }

    public void visitGetField(@NotNull IrGetField expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitGetField$lambda$0(expression2, arg_0)));
    }

    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @Nullable Void data) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitDynamicMemberExpression$lambda$0(expression2, arg_0)));
    }

    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        this.transformArguments(expression2.getArguments());
        this.addStatement((IrStatement)expression2);
    }

    public void visitGetClass(@NotNull IrGetClass expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitGetClass$lambda$0(expression2, arg_0)));
    }

    /*
     * WARNING - void declaration
     */
    public void visitVararg(@NotNull IrVararg expression2) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Collection collection;
        void destination$iv;
        int n;
        Iterable $this$mapIndexedTo$iv;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        Set spreadIndices = new LinkedHashSet();
        Iterable iterable = expression2.getElements();
        Collection collection2 = new ArrayList();
        boolean $i$f$mapIndexedTo = false;
        int index$iv = 0;
        for (Object item$iv : $this$mapIndexedTo$iv) {
            IrExpression irExpression;
            void item;
            int n2;
            if ((n2 = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrVarargElement irVarargElement = (IrVarargElement)item$iv;
            n = n2;
            collection = destination$iv;
            boolean bl = false;
            if (item instanceof IrSpreadElement) {
                void index;
                spreadIndices.add((int)index);
                irExpression = ((IrSpreadElement)item).getExpression();
            } else {
                Intrinsics.checkNotNull((Object)item, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrExpression");
                irExpression = (IrExpression)item;
            }
            collection.add(irExpression);
        }
        $this$mapIndexedTo$iv = destination$iv;
        List p0 = (List)$this$mapIndexedTo$iv;
        boolean $i$a$-apply-StateMachineBuilder$visitVararg$newArgs$32 = false;
        this.transformArguments(p0);
        $this$mapIndexedTo$iv = $this$mapIndexedTo$iv;
        boolean $i$f$mapIndexed = false;
        void $i$a$-apply-StateMachineBuilder$visitVararg$newArgs$32 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo2 = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void item;
            void index;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            IrExpression bl = (IrExpression)item$iv$iv;
            int n3 = n;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(spreadIndices.contains((int)index) ? (IrElement)BuildersKt.IrSpreadElementImpl((int)item.getStartOffset(), (int)item.getEndOffset(), (IrExpression)item) : (IrElement)item);
        }
        List newArgs = (List)destination$iv$iv;
        this.addStatement((IrStatement)BuildersKt.IrVarargImpl((int)expression2.getStartOffset(), (int)expression2.getEndOffset(), (IrType)expression2.getType(), (IrType)expression2.getVarargElementType(), (List)newArgs));
    }

    /*
     * WARNING - void declaration
     */
    private final <E extends IrExpression> void transformArguments(List<E> arguments) {
        void $this$fold$iv;
        void initial$iv;
        Ref.IntRef suspendableCount = new Ref.IntRef();
        Iterable iterable = arguments;
        boolean bl = false;
        Ref.IntRef intRef = suspendableCount;
        boolean $i$f$fold = false;
        void accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void n;
            IrExpression irExpression = (IrExpression)element$iv;
            void r = accumulator$iv;
            boolean bl2 = false;
            accumulator$iv = n != null && this.suspendableNodes.contains(n) ? r + true : r;
        }
        void var13_13 = accumulator$iv;
        intRef.element = var13_13;
        arguments.replaceAll(arg_0 -> StateMachineBuilder.transformArguments$lambda$1(suspendableCount, this, arg_0));
    }

    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2) {
        Intrinsics.checkNotNullParameter(expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addExceptionEdge();
            this.addStatement((IrStatement)expression2);
            return;
        }
        this.transformArguments((List)expression2.getArguments());
        this.addExceptionEdge();
        this.addStatement((IrStatement)expression2);
    }

    /*
     * WARNING - void declaration
     */
    public void visitSetField(@NotNull IrSetField expression2) {
        void $this$visitSetField_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        Object object = new IrExpression[]{expression2.getReceiver(), expression2.getValue()};
        Object p0 = object = CollectionsKt.mutableListOf((Object[])object);
        boolean bl = false;
        this.transformArguments((List)p0);
        Object newArguments2 = object;
        IrExpression receiver = (IrExpression)newArguments2.get(0);
        Object e = newArguments2.get(1);
        Intrinsics.checkNotNull(e);
        IrExpression value = (IrExpression)e;
        IrSetField irSetField = expression2;
        StateMachineBuilder stateMachineBuilder = this;
        boolean bl2 = false;
        stateMachineBuilder.addStatement((IrStatement)BuildersKt.IrSetFieldImpl((int)$this$visitSetField_u24lambda_u240.getStartOffset(), (int)$this$visitSetField_u24lambda_u240.getEndOffset(), (IrFieldSymbol)$this$visitSetField_u24lambda_u240.getSymbol(), (IrExpression)receiver, (IrExpression)value, (IrType)this.unit, (IrStatementOrigin)$this$visitSetField_u24lambda_u240.getOrigin(), (IrClassSymbol)$this$visitSetField_u24lambda_u240.getSuperQualifierSymbol()));
    }

    /*
     * WARNING - void declaration
     */
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2) {
        void $this$visitStringConcatenation_u24lambda_u240;
        List list;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        if (!this.suspendableNodes.contains(expression2)) {
            this.addStatement((IrStatement)expression2);
            return;
        }
        List p0 = list = CollectionsKt.toMutableList((Collection)expression2.getArguments());
        boolean bl = false;
        this.transformArguments(p0);
        List newArguments2 = list;
        p0 = expression2;
        StateMachineBuilder stateMachineBuilder = this;
        boolean bl2 = false;
        stateMachineBuilder.addStatement((IrStatement)BuildersKt.IrStringConcatenationImpl((int)$this$visitStringConcatenation_u24lambda_u240.getStartOffset(), (int)$this$visitStringConcatenation_u24lambda_u240.getEndOffset(), (IrType)$this$visitStringConcatenation_u24lambda_u240.getType(), (Collection)newArguments2));
    }

    private final IrGetObjectValueImpl getUnitValue() {
        return JsIrBuilder.INSTANCE.buildGetObjectValue(this.unit, this.context.getIrBuiltIns().getUnitClass());
    }

    public void visitReturn(@NotNull IrReturn expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        IrReturnTargetSymbol returnTarget = expression2.getReturnTargetSymbol();
        if (!(returnTarget instanceof IrReturnableBlockSymbol)) {
            this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitReturn$lambda$0(expression2, arg_0)));
        }
    }

    private final void addExceptionEdge() {
        this.hasExceptions = true;
        Collection collection = this.currentState.getSuccessors();
        Object object = UtilsKt.peek(this.catchBlockStack);
        Intrinsics.checkNotNull((Object)object);
        collection.add(object);
    }

    private final boolean hasResultingValue(IrExpression expression2) {
        IrType $this$hasResultingValue_u24lambda_u240 = expression2.getType();
        boolean bl = false;
        return !(IrTypePredicatesKt.isNothing((IrType)$this$hasResultingValue_u24lambda_u240) || IrTypePredicatesKt.isUnit((IrType)$this$hasResultingValue_u24lambda_u240));
    }

    public void visitThrow(@NotNull IrThrow expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        IrVisitorsKt.acceptChildrenVoid((IrElement)((IrElement)expression2), (IrVisitorVoid)this);
        this.addExceptionEdge();
        this.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitThrow$lambda$0(expression2, arg_0)));
    }

    public void visitTry(@NotNull IrTry aTry) {
        boolean bl;
        IrExpression irExpression;
        IrSetValueImpl it;
        Object object;
        IrVariable varSymbol;
        Intrinsics.checkNotNullParameter((Object)aTry, (String)"aTry");
        if (!(aTry.getFinallyExpression() == null)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        TryState tryState = this.buildTryState();
        Object object2 = UtilsKt.peek(this.catchBlockStack);
        Intrinsics.checkNotNull((Object)object2);
        SuspendState enclosingCatch = (SuspendState)object2;
        ((Map)this.tryStateMap).put(aTry, tryState);
        UtilsKt.push(this.catchBlockStack, (Object)tryState.getCatchState());
        UtilsKt.push(this.tryLoopStack, (Object)aTry);
        SuspendState exitState = new SuspendState(this.unit);
        IrVariable irVariable = varSymbol = this.hasResultingValue((IrExpression)aTry) ? this.tempVar(aTry.getType(), "TRY_RESULT") : null;
        if (varSymbol != null) {
            this.addStatement((IrStatement)varSymbol);
        }
        this.setupExceptionState(tryState.getCatchState());
        if (varSymbol != null) {
            it = object = JsIrBuilder.INSTANCE.buildSetVariable(varSymbol.getSymbol(), aTry.getTryResult(), this.unit);
            boolean bl2 = false;
            if (this.suspendableNodes.contains(it.getValue())) {
                ((Collection)this.suspendableNodes).add(it);
            }
            irExpression = (IrExpression)object;
        } else {
            irExpression = aTry.getTryResult();
        }
        IrExpression tryResult = irExpression;
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)tryResult), (IrVisitorVoid)this);
        if (!this.isBlockEnded()) {
            this.setupExceptionState(enclosingCatch);
            StateMachineBuilder.doDispatch$default(this, exitState, false, 2, null);
        }
        this.addExceptionEdge();
        this.tryStateMap.remove(aTry);
        object = UtilsKt.pop(this.tryLoopStack);
        it = (IrExpression)object;
        boolean bl3 = false;
        boolean bl4 = bl = it == aTry;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        UtilsKt.pop(this.catchBlockStack);
        this.updateState(tryState.getCatchState());
        this.setupExceptionState(enclosingCatch);
        boolean rethrowNeeded = true;
        for (IrCatch irCatch : aTry.getCatches()) {
            IrExpression catchResult;
            IrExpression irExpression2;
            IrVariable irVariable2;
            IrType type = irCatch.getCatchParameter().getType();
            IrExpression initializer = !(type instanceof IrDynamicType) ? (IrExpression)this.implicitCast((IrExpression)this.pendingException(), type) : (IrExpression)this.pendingException();
            IrVariable it2 = irVariable2 = irCatch.getCatchParameter();
            boolean bl5 = false;
            it2.setInitializer(initializer);
            IrVariable irVar = irVariable2;
            if (varSymbol != null) {
                IrVariable it3 = it2 = JsIrBuilder.INSTANCE.buildSetVariable(varSymbol.getSymbol(), irCatch.getResult(), this.unit);
                boolean bl6 = false;
                if (this.suspendableNodes.contains(it3.getValue())) {
                    ((Collection)this.suspendableNodes).add(it3);
                }
                irExpression2 = (IrExpression)it2;
            } else {
                irExpression2 = catchResult = irCatch.getResult();
            }
            if (type instanceof IrDynamicType) {
                rethrowNeeded = false;
                this.addStatement((IrStatement)irVar);
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)catchResult), (IrVisitorVoid)this);
                this.maybeDoDispatch(exitState);
                continue;
            }
            IrTypeOperatorCallImpl check2 = this.buildIsCheck((IrExpression)this.pendingException(), type);
            IrCompositeImpl branchBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, catchResult.getType(), null, 2, null);
            IrCompositeImpl elseBlock = JsIrBuilder.buildComposite$default(JsIrBuilder.INSTANCE, catchResult.getType(), null, 2, null);
            IrWhen irIf = JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, catchResult.getType(), (IrExpression)check2, (IrExpression)branchBlock, (IrExpression)elseBlock, 0, 0, 0, 0, 240, null);
            IrContainerExpression ifBlock = this.currentBlock;
            this.currentBlock = (IrContainerExpression)branchBlock;
            this.addStatement((IrStatement)irVar);
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)catchResult), (IrVisitorVoid)this);
            this.maybeDoDispatch(exitState);
            this.currentBlock = ifBlock;
            this.addStatement((IrStatement)irIf);
            this.currentBlock = (IrContainerExpression)elseBlock;
        }
        if (rethrowNeeded) {
            this.addExceptionEdge();
            this.addStatement((IrStatement)JsIrBuilder.INSTANCE.buildThrow(this.nothing, (IrExpression)this.pendingException()));
        }
        ((Collection)this.currentState.getSuccessors()).add(enclosingCatch);
        this.updateState(exitState);
        this.setupExceptionState(enclosingCatch);
        if (varSymbol != null) {
            this.addStatement((IrStatement)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)varSymbol.getSymbol(), null, 2, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void setupExceptionState(SuspendState target) {
        void $this$setupExceptionState_u24lambda_u240;
        IrCall irCall;
        IrCall irCall2 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exStateSymbolSetter.getSymbol(), this.unit, null, null, null, 0, 0, 124, null);
        StateMachineBuilder stateMachineBuilder = this;
        boolean bl = false;
        $this$setupExceptionState_u24lambda_u240.getArguments().set(0, (Object)this.getThisReceiver());
        $this$setupExceptionState_u24lambda_u240.getArguments().set(1, (Object)StateMachineBuilderKt.access$createDispatchPoint(target));
        stateMachineBuilder.addStatement((IrStatement)irCall);
    }

    private final IrCall exceptionState() {
        IrCall irCall;
        IrCall it = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exStateSymbolGetter.getSymbol(), null, null, null, null, 0, 0, 126, null);
        boolean bl = false;
        it.setDispatchReceiver((IrExpression)this.getThisReceiver());
        return irCall;
    }

    private final IrCall pendingException() {
        IrCall irCall;
        IrCall it = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.exceptionSymbolGetter.getSymbol(), null, null, null, null, 0, 0, 126, null);
        boolean bl = false;
        it.setDispatchReceiver((IrExpression)this.getThisReceiver());
        return irCall;
    }

    private final TryState buildTryState() {
        return new TryState(this.currentState, new SuspendState(this.unit));
    }

    private final IrTypeOperatorCallImpl buildIsCheck(IrExpression value, IrType toType) {
        return JsIrBuilder.INSTANCE.buildTypeOperator(this.context.getIrBuiltIns().getBooleanType(), IrTypeOperator.INSTANCEOF, value, toType);
    }

    private final IrVariable tempVar(IrType type, String name) {
        IrVariable irVariable;
        IrVariable p0 = irVariable = JsIrBuilder.buildVar$default(JsIrBuilder.INSTANCE, type, (IrDeclarationParent)this.function.getOwner(), name, false, false, false, null, (IrDeclarationOrigin)IrDeclarationOrigin.Companion.getIR_TEMPORARY_VARIABLE(), 120, null);
        boolean bl = false;
        this.registerLocal(p0);
        return irVariable;
    }

    static /* synthetic */ IrVariable tempVar$default(StateMachineBuilder stateMachineBuilder, IrType irType, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "tmp";
        }
        return stateMachineBuilder.tempVar(irType, string);
    }

    /*
     * WARNING - void declaration
     */
    private final void registerLocal(IrVariable variable) {
        void $this$registerLocal_u24lambda_u240;
        IrVariable irVariable;
        IrVariable irVariable2 = irVariable = variable;
        List<IrVariable> list = this.allTheIntermediateLocals;
        boolean bl = false;
        JsIrAttributesKt.setWasMovedFromItsDeclarationPlace((IrVariable)$this$registerLocal_u24lambda_u240, true);
        list.add(irVariable);
    }

    private static final IrStatement visitWhileLoop$lambda$0$0(StateMachineBuilder this$0, SuspendState $exit, IrExpression it) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrCall $this$visitWhileLoop_u24lambda_u240_u240_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this$0.booleanNotSymbol, null, null, null, null, 0, 0, 126, null);
        boolean bl = false;
        $this$visitWhileLoop_u24lambda_u240_u240_u240.setDispatchReceiver(it);
        IrCall exitCond = irCall;
        IrCompositeImpl irBreak = this$0.buildDispatchBlock($exit);
        return (IrStatement)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this$0.unit, (IrExpression)exitCond, (IrExpression)irBreak, null, 0, 0, 0, 0, 248, null);
    }

    private static final Unit visitWhileLoop$lambda$0(StateMachineBuilder this$0, IrLoop l, SuspendState head, SuspendState exit) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)exit, (String)"exit");
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)l.getCondition()), (IrVisitorVoid)this$0);
        this$0.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitWhileLoop$lambda$0$0(this$0, exit, arg_0)));
        IrExpression irExpression = l.getBody();
        if (irExpression != null) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irExpression), (IrVisitorVoid)this$0);
        }
        StateMachineBuilder.doDispatch$default(this$0, head, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final IrStatement visitDoWhileLoop$lambda$0$0(StateMachineBuilder this$0, SuspendState $head, IrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrCompositeImpl irContinue = this$0.buildDispatchBlock($head);
        return (IrStatement)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this$0.unit, it, (IrExpression)irContinue, null, 0, 0, 0, 0, 248, null);
    }

    private static final Unit visitDoWhileLoop$lambda$0(StateMachineBuilder this$0, IrLoop l, SuspendState head, SuspendState exit) {
        Intrinsics.checkNotNullParameter((Object)l, (String)"l");
        Intrinsics.checkNotNullParameter((Object)head, (String)"head");
        Intrinsics.checkNotNullParameter((Object)exit, (String)"exit");
        IrExpression irExpression = l.getBody();
        if (irExpression != null) {
            IrVisitorsKt.acceptVoid((IrElement)((IrElement)irExpression), (IrVisitorVoid)this$0);
        }
        IrVisitorsKt.acceptVoid((IrElement)((IrElement)l.getCondition()), (IrVisitorVoid)this$0);
        this$0.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.visitDoWhileLoop$lambda$0$0(this$0, head, arg_0)));
        StateMachineBuilder.doDispatch$default(this$0, exit, false, 2, null);
        return Unit.INSTANCE;
    }

    private static final IrStatement visitCall$lambda$0(StateMachineBuilder this$0, IrComposite $dispatch, IrExpression it) {
        IrCall irCall;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrCall $this$visitCall_u24lambda_u240_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this$0.stateSymbolSetter.getSymbol(), this$0.unit, null, null, null, 0, 0, 124, null);
        boolean bl = false;
        $this$visitCall_u24lambda_u240_u240.getArguments().set(0, (Object)this$0.getThisReceiver());
        $this$visitCall_u24lambda_u240_u240.getArguments().set(1, (Object)$dispatch);
        return (IrStatement)irCall;
    }

    private static final IrStatement visitWhen$lambda$1(StateMachineBuilder this$0, IrCompositeImpl $branchBlock, IrCompositeImpl $elseBlock, IrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (IrStatement)JsIrBuilder.buildIfElse$default(JsIrBuilder.INSTANCE, this$0.unit, it, (IrExpression)$branchBlock, (IrExpression)$elseBlock, 0, 0, 0, 0, 240, null);
    }

    private static final IrStatement visitSetValue$lambda$0(IrSetValue $expression, IrExpression it) {
        IrSetValue irSetValue;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrSetValue $this$visitSetValue_u24lambda_u240_u240 = irSetValue = $expression;
        boolean bl = false;
        $this$visitSetValue_u24lambda_u240_u240.setValue(it);
        return (IrStatement)irSetValue;
    }

    private static final IrStatement visitTypeOperator$lambda$0(IrTypeOperatorCall $expression, IrExpression it) {
        IrTypeOperatorCall irTypeOperatorCall;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrTypeOperatorCall $this$visitTypeOperator_u24lambda_u240_u240 = irTypeOperatorCall = $expression;
        boolean bl = false;
        $this$visitTypeOperator_u24lambda_u240_u240.setArgument(it);
        return (IrStatement)irTypeOperatorCall;
    }

    private static final IrStatement visitVariable$lambda$1(IrVariable $declaration, int $startOffset, int $endOffset, IrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (IrStatement)JsIrBuilder.INSTANCE.buildSetValue((IrValueSymbol)$declaration.getSymbol(), it, $startOffset, $endOffset);
    }

    private static final IrStatement visitGetField$lambda$0(IrGetField $expression, IrExpression it) {
        IrGetField irGetField;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrGetField $this$visitGetField_u24lambda_u240_u240 = irGetField = $expression;
        boolean bl = false;
        $this$visitGetField_u24lambda_u240_u240.setReceiver(it);
        return (IrStatement)irGetField;
    }

    private static final IrStatement visitDynamicMemberExpression$lambda$0(IrDynamicMemberExpression $expression, IrExpression it) {
        IrDynamicMemberExpression irDynamicMemberExpression;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrDynamicMemberExpression $this$visitDynamicMemberExpression_u24lambda_u240_u240 = irDynamicMemberExpression = $expression;
        boolean bl = false;
        $this$visitDynamicMemberExpression_u24lambda_u240_u240.setReceiver(it);
        return (IrStatement)irDynamicMemberExpression;
    }

    private static final IrStatement visitGetClass$lambda$0(IrGetClass $expression, IrExpression it) {
        IrGetClass irGetClass;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrGetClass $this$visitGetClass_u24lambda_u240_u240 = irGetClass = $expression;
        boolean bl = false;
        $this$visitGetClass_u24lambda_u240_u240.setArgument(it);
        return (IrStatement)irGetClass;
    }

    private static final IrStatement transformArguments$lambda$1$0(IrVariable $irVar, IrExpression it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (IrStatement)JsIrBuilder.buildSetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)$irVar.getSymbol(), it, 0, 0, 12, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final IrExpression transformArguments$lambda$1(Ref.IntRef $suspendableCount, StateMachineBuilder this$0, IrExpression arg) {
        IrExpression irExpression;
        if (org.jetbrains.kotlin.backend.common.ir.IrUtilsKt.isPure$default((IrExpression)arg, (boolean)false, (boolean)false, null, (int)6, null)) {
            irExpression = arg;
        } else {
            if (!(arg != null)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if ($suspendableCount.element > 0) {
                if (this$0.suspendableNodes.contains(arg)) {
                    int n = $suspendableCount.element;
                    $suspendableCount.element = n + -1;
                }
                IrVisitorsKt.acceptVoid((IrElement)((IrElement)arg), (IrVisitorVoid)this$0);
                IrVariable irVar = this$0.tempVar(arg.getType(), "ARGUMENT");
                this$0.transformLastExpression((Function1<? super IrExpression, ? extends IrStatement>)((Function1)arg_0 -> StateMachineBuilder.transformArguments$lambda$1$0(irVar, arg_0)));
                irExpression = (IrExpression)JsIrBuilder.buildGetValue$default(JsIrBuilder.INSTANCE, (IrValueSymbol)irVar.getSymbol(), null, 2, null);
            } else {
                void $this$deepCopyWithSymbols_u24default$iv;
                IrElement irVar = (IrElement)arg;
                IrDeclarationParent initialParent$iv = (IrDeclarationParent)this$0.function.getOwner();
                boolean $i$f$deepCopyWithSymbols = false;
                void $this$deepCopyImpl$iv$iv = $this$deepCopyWithSymbols_u24default$iv;
                boolean $i$f$deepCopyImpl = false;
                DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
                IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyImpl$iv$iv, (IrVisitorVoid)((IrVisitorVoid)symbolRemapper$iv$iv));
                DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
                boolean bl = false;
                ReferencedSymbolRemapper p0 = (ReferencedSymbolRemapper)deepCopySymbolRemapper;
                TypeRemapper typeRemapper$iv$iv = (TypeRemapper)new DeepCopyTypeRemapper(p0);
                IrElement irElement = $this$deepCopyImpl$iv$iv.transform((IrTransformer)new DeepCopyIrTreeWithSymbols((SymbolRemapper)symbolRemapper$iv$iv, typeRemapper$iv$iv), null);
                if (irElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type E & Any");
                }
                irExpression = (IrExpression)PatchDeclarationParentsKt.patchDeclarationParents((IrElement)((IrElement)((IrExpression)irElement)), (IrDeclarationParent)initialParent$iv);
            }
        }
        return irExpression;
    }

    private static final IrStatement visitReturn$lambda$0(IrReturn $expression, IrExpression it) {
        IrReturn irReturn;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrReturn $this$visitReturn_u24lambda_u240_u240 = irReturn = $expression;
        boolean bl = false;
        $this$visitReturn_u24lambda_u240_u240.setValue(it);
        return (IrStatement)irReturn;
    }

    private static final IrStatement visitThrow$lambda$0(IrThrow $expression, IrExpression it) {
        IrThrow irThrow;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        IrThrow $this$visitThrow_u24lambda_u240_u240 = irThrow = $expression;
        boolean bl = false;
        $this$visitThrow_u24lambda_u240_u240.setValue(it);
        return (IrStatement)irThrow;
    }
}

