/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrFileEntry;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.backend.js.lower.JsCodeOutliningLowering;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.BaseIrElementToJsNodeTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsExpressionTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrElementToJsStatementTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.IrFunctionToJsTransformer;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsAstUtilsKt;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.JsClassGenerator;
import org.jetbrains.kotlin.ir.backend.js.utils.JsGenerationContext;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.util.IrInlineUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrVisitor;
import org.jetbrains.kotlin.js.backend.ast.JsCompositeBlock;
import org.jetbrains.kotlin.js.backend.ast.JsEmpty;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsStatement;
import org.jetbrains.kotlin.js.backend.ast.JsVars;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\n\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u0003H\u0016J\u0018\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0003H\u0016\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrDeclarationToJsTransformer;", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/BaseIrElementToJsNodeTransformer;", "Lorg/jetbrains/kotlin/js/backend/ast/JsStatement;", "Lorg/jetbrains/kotlin/ir/backend/js/utils/JsGenerationContext;", "<init>", "()V", "visitSimpleFunction", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "context", "visitConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "visitField", "Lorg/jetbrains/kotlin/ir/declarations/IrField;", "visitVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "visitScript", "irScript", "Lorg/jetbrains/kotlin/ir/declarations/IrScript;", "backend.js"})
@SourceDebugExtension(value={"SMAP\nIrDeclarationToJsTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrDeclarationToJsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrDeclarationToJsTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n1914#2,2:72\n*S KotlinDebug\n*F\n+ 1 IrDeclarationToJsTransformer.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/IrDeclarationToJsTransformer\n*L\n63#1:72,2\n*E\n"})
public final class IrDeclarationToJsTransformer
extends BaseIrElementToJsNodeTransformer<JsStatement, JsGenerationContext> {
    @NotNull
    public JsStatement visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!(!declaration.isExpect())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)JsCodeOutliningLowering.Companion.getOUTLINED_JS_CODE_ORIGIN())) {
            return JsEmpty.INSTANCE;
        }
        JsStatement jsStatement = ((JsFunction)declaration.accept((IrVisitor)new IrFunctionToJsTransformer(), (Object)context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitConstructor(@NotNull IrConstructor declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsStatement jsStatement = ((JsFunction)declaration.accept((IrVisitor)new IrFunctionToJsTransformer(), (Object)context)).makeStmt();
        Intrinsics.checkNotNullExpressionValue((Object)jsStatement, (String)"makeStmt(...)");
        return jsStatement;
    }

    @NotNull
    public JsStatement visitClass(@NotNull IrClass declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (Intrinsics.areEqual((Object)declaration.getSymbol(), (Object)context.getStaticContext().getBackendContext().getSymbols().getGenericSharedVariableBox().getKlass())) {
            return JsEmpty.INSTANCE;
        }
        IrFileEntry irFileEntry = IrInlineUtilsKt.getSourceFileWhenInlined((IrDeclaration)((IrDeclaration)declaration));
        if (irFileEntry == null) {
            irFileEntry = context.getCurrentFileEntry();
        }
        return new JsClassGenerator(declaration, JsGenerationContext.newDeclaration$default(context, null, null, irFileEntry, 3, null)).generate();
    }

    @NotNull
    public JsStatement visitField(@NotNull IrField declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsName fieldName = context.getNameForField(declaration);
        if (declaration.isExternal()) {
            return JsEmpty.INSTANCE;
        }
        if (declaration.getInitializer() != null) {
            IrClassSymbol eagerInitializationAnnotation = context.getStaticContext().getBackendContext().getPropertyLazyInitialization().getEagerInitialization();
            IrExpressionBody irExpressionBody = declaration.getInitializer();
            Intrinsics.checkNotNull((Object)irExpressionBody);
            JsExpression initializer = (JsExpression)irExpressionBody.accept((IrVisitor)new IrElementToJsExpressionTransformer(), (Object)context);
            IrPropertySymbol irPropertySymbol = declaration.getCorrespondingPropertySymbol();
            JsCompositeBlock initializerBlock = (irPropertySymbol != null && (irPropertySymbol = (IrProperty)irPropertySymbol.getOwner()) != null ? IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irPropertySymbol), (IrClassSymbol)eagerInitializationAnnotation) : false) ? context.getStaticContext().getEagerInitializerBlock() : context.getStaticContext().getInitializerBlock();
            List<JsStatement> list = initializerBlock.getStatements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
            Collection collection = list;
            JsNameRef jsNameRef = fieldName.makeRef();
            Intrinsics.checkNotNullExpressionValue((Object)jsNameRef, (String)"makeRef(...)");
            collection.add(JsAstUtilsKt.jsAssignment(jsNameRef, initializer).makeStmt());
        }
        return new JsVars(new JsVars.JsVar(fieldName));
    }

    @NotNull
    public JsStatement visitVariable(@NotNull IrVariable declaration, @NotNull JsGenerationContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return (JsStatement)declaration.accept((IrVisitor)new IrElementToJsStatementTransformer(), (Object)context);
    }

    @NotNull
    public JsStatement visitScript(@NotNull IrScript irScript, @NotNull JsGenerationContext context) {
        JsCompositeBlock jsCompositeBlock;
        Intrinsics.checkNotNullParameter((Object)irScript, (String)"irScript");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        JsCompositeBlock $this$visitScript_u24lambda_u240 = jsCompositeBlock = new JsCompositeBlock();
        boolean bl = false;
        Iterable $this$forEach$iv = irScript.getStatements();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrStatement it = (IrStatement)element$iv;
            boolean bl2 = false;
            List<JsStatement> list = $this$visitScript_u24lambda_u240.getStatements();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getStatements(...)");
            Collection collection = list;
            JsStatement jsStatement = it instanceof IrDeclaration ? (JsStatement)it.accept((IrVisitor)this, (Object)context) : (JsStatement)it.accept((IrVisitor)new IrElementToJsStatementTransformer(), (Object)context);
            collection.add(jsStatement);
        }
        return jsCompositeBlock;
    }
}

