/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.transformers.irToJs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.backend.js.transformers.irToJs.Scope;
import org.jetbrains.kotlin.js.backend.ast.HasName;
import org.jetbrains.kotlin.js.backend.ast.JsBreak;
import org.jetbrains.kotlin.js.backend.ast.JsCatch;
import org.jetbrains.kotlin.js.backend.ast.JsClass;
import org.jetbrains.kotlin.js.backend.ast.JsContinue;
import org.jetbrains.kotlin.js.backend.ast.JsDeclarationScope;
import org.jetbrains.kotlin.js.backend.ast.JsDynamicScope;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsFunction;
import org.jetbrains.kotlin.js.backend.ast.JsImport;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.JsNameRef;
import org.jetbrains.kotlin.js.backend.ast.JsNode;
import org.jetbrains.kotlin.js.backend.ast.JsParameter;
import org.jetbrains.kotlin.js.backend.ast.JsVars;
import org.jetbrains.kotlin.js.backend.ast.RecursiveJsVisitor;
import org.jetbrains.kotlin.js.backend.ast.metadata.HasMetadata;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\u0018\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u0002H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0007H\u0002\u001a\f\u0010\b\u001a\u00020\u0007*\u00020\u0002H\u0002\u00a8\u0006\t"}, d2={"resolveTemporaryNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsNode;", "resolveNames", "", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "liftUsedNames", "Lorg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/Scope;", "computeScopes", "backend.js"})
@SourceDebugExtension(value={"SMAP\nresolveTemporaryNames.kt\nKotlin\n*S Kotlin\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,145:1\n1#2:146\n1914#3,2:147\n1914#3,2:149\n*S KotlinDebug\n*F\n+ 1 resolveTemporaryNames.kt\norg/jetbrains/kotlin/ir/backend/js/transformers/irToJs/ResolveTemporaryNamesKt\n*L\n51#1:147,2\n62#1:149,2\n*E\n"})
public final class ResolveTemporaryNamesKt {
    public static final void resolveTemporaryNames(@NotNull JsNode $this$resolveTemporaryNames) {
        Intrinsics.checkNotNullParameter((Object)$this$resolveTemporaryNames, (String)"<this>");
        Map<JsName, JsName> renamings = ResolveTemporaryNamesKt.resolveNames($this$resolveTemporaryNames);
        $this$resolveTemporaryNames.accept(new RecursiveJsVisitor(renamings){
            final /* synthetic */ Map<JsName, JsName> $renamings;
            {
                this.$renamings = $renamings;
            }

            protected void visitElement(JsNode node) {
                block1: {
                    JsName name;
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    super.visitElement(node);
                    if (!(node instanceof HasName) || (name = ((HasName)((Object)node)).getName()) == null) break block1;
                    JsName jsName = this.$renamings.get(name);
                    if (jsName != null) {
                        JsName it = jsName;
                        boolean bl = false;
                        ((HasName)((Object)node)).setName(it);
                    }
                }
            }
        });
    }

    private static final Map<JsName, JsName> resolveNames(JsNode $this$resolveNames) {
        Scope rootScope = ResolveTemporaryNamesKt.liftUsedNames(ResolveTemporaryNamesKt.computeScopes($this$resolveNames));
        HashMap<JsName, JsName> replacements = new HashMap<JsName, JsName>();
        ResolveTemporaryNamesKt.resolveNames$traverse(replacements, rootScope);
        return replacements;
    }

    private static final Scope liftUsedNames(Scope $this$liftUsedNames) {
        ResolveTemporaryNamesKt.liftUsedNames$traverse($this$liftUsedNames);
        return $this$liftUsedNames;
    }

    private static final Scope computeScopes(JsNode $this$computeScopes) {
        Scope rootScope = new Scope();
        $this$computeScopes.accept(new RecursiveJsVisitor(rootScope){
            private Scope currentScope;
            {
                this.currentScope = $rootScope;
            }

            public final Scope getCurrentScope() {
                return this.currentScope;
            }

            public final void setCurrentScope(Scope scope) {
                Intrinsics.checkNotNullParameter((Object)scope, (String)"<set-?>");
                this.currentScope = scope;
            }

            public void visitClass(JsClass x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                JsName jsName = x.getName();
                if (jsName != null) {
                    JsName it = jsName;
                    boolean bl = false;
                    ((Collection)this.currentScope.getDeclaredNames()).add(it);
                }
                JsFunction jsFunction = x.getConstructor();
                if (jsFunction != null) {
                    jsFunction.accept(this);
                }
                JsExpression jsExpression = x.getBaseClass();
                if (jsExpression != null) {
                    jsExpression.accept(this);
                }
                Iterable $this$forEach$iv = x.getMembers();
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    JsFunction it = (JsFunction)element$iv;
                    boolean bl = false;
                    this.visitFunction(it, false);
                }
            }

            public void visitFunction(JsFunction x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                this.visitFunction(x, true);
            }

            /*
             * WARNING - void declaration
             */
            public final void visitFunction(JsFunction x, boolean shouldReserveName) {
                void $this$mapTo$iv$iv;
                void $this$visitFunction_u24lambda_u244;
                Object object;
                Object object2;
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Object object3 = x.getName();
                if (object3 != null) {
                    object2 = object3;
                    JsName it = object2;
                    boolean bl = false;
                    object3 = shouldReserveName ? object2 : null;
                    if (object3 != null) {
                        it = object3;
                        boolean bl2 = false;
                        ((Collection)this.currentScope.getDeclaredNames()).add(it);
                    }
                }
                Scope oldScope = this.currentScope;
                object2 = object = new Scope();
                Object object4 = this;
                boolean bl = false;
                ((Collection)this.currentScope.getChildren()).add($this$visitFunction_u24lambda_u244);
                object4.currentScope = object;
                object = this.currentScope.getDeclaredNames();
                List<JsParameter> list = x.getParameters();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getParameters(...)");
                Iterable $this$map$iv = list;
                boolean $i$f$map = false;
                Iterable bl2 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    JsParameter jsParameter = (JsParameter)item$iv$iv;
                    object4 = destination$iv$iv;
                    boolean bl3 = false;
                    JsName jsName = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)jsName, (String)"getName(...)");
                    object4.add(jsName);
                }
                object2 = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)object, (Iterable)object2);
                super.visitFunction(x);
                this.currentScope = oldScope;
            }

            public void visitCatch(JsCatch x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x.getParameter().getName());
                super.visitCatch(x);
            }

            public void visit(JsVars.JsVar x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                ((Collection)this.currentScope.getDeclaredNames()).add(x.getName());
                super.visit(x);
            }

            public void visitNameRef(JsNameRef nameRef) {
                Intrinsics.checkNotNullParameter((Object)nameRef, (String)"nameRef");
                if (nameRef.getQualifier() == null) {
                    JsName name = nameRef.getName();
                    Collection collection = this.currentScope.getUsedNames();
                    JsName jsName = name;
                    if (jsName == null) {
                        JsName jsName2 = JsDynamicScope.INSTANCE.declareName(nameRef.getIdent());
                        jsName = jsName2;
                        Intrinsics.checkNotNullExpressionValue((Object)jsName2, (String)"declareName(...)");
                    }
                    collection.add(jsName);
                }
                super.visitNameRef(nameRef);
            }

            public void visitImport(JsImport jsImport) {
                Intrinsics.checkNotNullParameter((Object)jsImport, (String)"import");
                JsImport.Target target = jsImport.getTarget();
                if (!(target instanceof JsImport.Target.Effect)) {
                    if (target instanceof JsImport.Target.All) {
                        JsName jsName = ((JsImport.Target.All)target).getAlias().getName();
                        if (jsName != null) {
                            JsName it = jsName;
                            boolean bl = false;
                            ((Collection)this.currentScope.getDeclaredNames()).add(it);
                        }
                    } else if (target instanceof JsImport.Target.Default) {
                        JsName jsName = ((JsImport.Target.Default)target).getName().getName();
                        if (jsName != null) {
                            JsName it = jsName;
                            boolean bl = false;
                            ((Collection)this.currentScope.getDeclaredNames()).add(it);
                        }
                    } else if (target instanceof JsImport.Target.Elements) {
                        Iterable $this$forEach$iv = ((JsImport.Target.Elements)target).getElements();
                        boolean $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            JsImport.Element it = (JsImport.Element)element$iv;
                            boolean bl = false;
                            Collection collection = this.currentScope.getDeclaredNames();
                            HasMetadata hasMetadata = it.getAlias();
                            if (hasMetadata == null || (hasMetadata = hasMetadata.getName()) == null) {
                                hasMetadata = it.getName();
                            }
                            collection.add(hasMetadata);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                super.visitImport(jsImport);
            }

            public void visitBreak(JsBreak x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }

            public void visitContinue(JsContinue x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
            }
        });
        return rootScope;
    }

    private static final boolean resolveNames$traverse$lambda$0(JsName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !it.isTemporary();
    }

    private static final String resolveNames$traverse$lambda$1(JsName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getIdent();
    }

    private static final String resolveNames$traverse$lambda$2(HashMap $replacements, JsName it) {
        String string;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (!it.isTemporary()) {
            string = it.getIdent();
        } else {
            JsName jsName = (JsName)$replacements.get(it);
            string = jsName != null ? jsName.getIdent() : null;
        }
        return string;
    }

    private static final boolean resolveNames$traverse$lambda$3(JsName it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isTemporary();
    }

    private static final void resolveNames$traverse(HashMap<JsName, JsName> replacements, Scope scope) {
        Set occupiedNames = SequencesKt.toMutableSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)scope.getDeclaredNames()), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$0), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$1));
        CollectionsKt.addAll((Collection)occupiedNames, (Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)scope.getUsedNames()), arg_0 -> ResolveTemporaryNamesKt.resolveNames$traverse$lambda$2(replacements, arg_0)));
        HashMap nextSuffix = new HashMap();
        for (JsName temporaryName : SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)scope.getDeclaredNames()), ResolveTemporaryNamesKt::resolveNames$traverse$lambda$3)) {
            JsName jsName;
            String resolvedName;
            Intrinsics.checkNotNullExpressionValue((Object)temporaryName.getIdent(), (String)"getIdent(...)");
            Integer n = nextSuffix.getOrDefault(temporaryName.getIdent(), 0);
            Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getOrDefault(...)");
            int suffix = ((Number)n).intValue();
            while (JsDeclarationScope.Companion.getRESERVED_WORDS().contains(resolvedName) || occupiedNames.contains(resolvedName)) {
                resolvedName = temporaryName.getIdent() + '_' + suffix++;
            }
            ((Map)nextSuffix).put(temporaryName.getIdent(), suffix);
            Map map = replacements;
            JsName $this$resolveNames_u24traverse_u24lambda_u244 = jsName = JsDynamicScope.INSTANCE.declareName(resolvedName);
            boolean bl = false;
            $this$resolveNames_u24traverse_u24lambda_u244.copyMetadataFrom(temporaryName);
            map.put(temporaryName, jsName);
            ((Collection)occupiedNames).add(resolvedName);
        }
        Iterable $this$forEach$iv = scope.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope p0 = (Scope)element$iv;
            boolean bl = false;
            ResolveTemporaryNamesKt.resolveNames$traverse(replacements, p0);
        }
    }

    private static final void liftUsedNames$traverse(Scope scope) {
        Iterable $this$forEach$iv = scope.getChildren();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Scope child = (Scope)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)scope.getUsedNames(), (Iterable)child.getDeclaredNames());
            ResolveTemporaryNamesKt.liftUsedNames$traverse(child);
            CollectionsKt.addAll((Collection)scope.getUsedNames(), (Iterable)child.getUsedNames());
        }
    }
}

