/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.resolve.diagnostics;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.js.resolve.diagnostics.ErrorsJs;
import org.jetbrains.kotlin.js.resolve.diagnostics.JsModuleCheckUtilKt;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtElementImplStub;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "<init>", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkSuperClass", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "js.frontend"})
@SourceDebugExtension(value={"SMAP\nJsModuleChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JsModuleChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n295#2,2:67\n*S KotlinDebug\n*F\n+ 1 JsModuleChecker.kt\norg/jetbrains/kotlin/js/resolve/diagnostics/JsModuleChecker\n*L\n59#1:67,2\n*E\n"})
public final class JsModuleChecker
implements DeclarationChecker {
    @NotNull
    public static final JsModuleChecker INSTANCE = new JsModuleChecker();

    private JsModuleChecker() {
    }

    @Override
    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        BindingTrace trace = context.getTrace();
        this.checkSuperClass(declaration, descriptor, trace);
        if (AnnotationsUtils.getModuleName(descriptor) == null && !AnnotationsUtils.isNonModule(descriptor)) {
            return;
        }
        if (descriptor instanceof PropertyDescriptor && ((PropertyDescriptor)descriptor).isVar()) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_VAR.on((KtElement)((PsiElement)declaration)));
        }
        if (!AnnotationsUtils.isNativeObject(descriptor)) {
            trace.report(ErrorsJs.JS_MODULE_PROHIBITED_ON_NON_NATIVE.on((KtElement)((PsiElement)declaration)));
        }
        if (DescriptorUtils.isTopLevelDeclaration(descriptor)) {
            boolean isFileModuleOrNonModule;
            boolean bl = isFileModuleOrNonModule = AnnotationsUtils.getFileModuleName(trace.getBindingContext(), descriptor) != null || AnnotationsUtils.isFromNonModuleFile(trace.getBindingContext(), descriptor);
            if (isFileModuleOrNonModule) {
                trace.report(ErrorsJs.NESTED_JS_MODULE_PROHIBITED.on((KtElement)((PsiElement)declaration)));
            }
        }
    }

    private final void checkSuperClass(KtDeclaration declaration, DeclarationDescriptor descriptor, BindingTrace trace) {
        Object v2;
        ClassDescriptor superClass;
        block3: {
            if (!(descriptor instanceof ClassDescriptor)) {
                return;
            }
            ClassDescriptor classDescriptor = DescriptorUtilsKt.getSuperClassNotAny((ClassDescriptor)descriptor);
            if (classDescriptor == null) {
                return;
            }
            superClass = classDescriptor;
            Intrinsics.checkNotNull((Object)declaration, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtClassOrObject");
            Iterable $this$firstOrNull$iv = ((KtClassOrObject)declaration).getSuperTypeListEntries();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                KtSuperTypeListEntry entry = (KtSuperTypeListEntry)element$iv;
                boolean bl = false;
                Object object = (KotlinType)trace.get(BindingContext.TYPE, entry.getTypeReference());
                if (!Intrinsics.areEqual((Object)(object != null && (object = ((KotlinType)object).getConstructor()) != null ? object.getDeclarationDescriptor() : null), (Object)superClass)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        KtSuperTypeListEntry psi = v2;
        BindingContext bindingContext = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        KtSuperTypeListEntry ktSuperTypeListEntry = psi;
        JsModuleCheckUtilKt.checkJsModuleUsage(bindingContext, trace, descriptor, superClass, (PsiElement)(ktSuperTypeListEntry != null ? (KtElementImplStub)ktSuperTypeListEntry : (KtElementImplStub)declaration));
    }
}

