/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.CallableMemberDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithVisibility;
import org.jetbrains.kotlin.descriptors.DescriptorVisibilities;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.incremental.components.LookupLocation;
import org.jetbrains.kotlin.incremental.components.NoLookupLocation;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderImpl;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignature;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureKt;
import org.jetbrains.kotlin.resolve.calls.results.FlatSignatureUtilsKt;
import org.jetbrains.kotlin.resolve.calls.results.OverloadabilitySpecificityCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.SimpleConstraintSystem;
import org.jetbrains.kotlin.resolve.calls.results.SpecificityComparisonCallbacks;
import org.jetbrains.kotlin.resolve.calls.results.TypeSpecificityComparator;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J \u0010\u0012\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\f\u0010\u0015\u001a\u00020\u0016*\u00020\u0017H\u0002J\u0018\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0014H\u0002J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001cH\u0002J$\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00140\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00140\u001fH\u0002J \u0010!\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006#"}, d2={"Lorg/jetbrains/kotlin/resolve/ShadowedExtensionChecker;", "", "typeSpecificityComparator", "Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "trace", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;)V", "getTypeSpecificityComparator", "()Lorg/jetbrains/kotlin/resolve/calls/results/TypeSpecificityComparator;", "getTrace", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "checkDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "checkShadowedExtensionFunction", "extensionFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isPublic", "", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptorWithVisibility;", "isExtensionFunctionShadowedByMemberFunction", "extension", "member", "getInvokeOperatorShadowingExtensionFunction", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isSignatureEquallyOrMoreSpecific", "extensionSignature", "Lorg/jetbrains/kotlin/resolve/calls/results/FlatSignature;", "memberSignature", "checkShadowedExtensionProperty", "extensionProperty", "frontend"})
@SourceDebugExtension(value={"SMAP\nShadowedExtensionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShadowedExtensionChecker.kt\norg/jetbrains/kotlin/resolve/ShadowedExtensionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,139:1\n295#2,2:140\n295#2,2:142\n*S KotlinDebug\n*F\n+ 1 ShadowedExtensionChecker.kt\norg/jetbrains/kotlin/resolve/ShadowedExtensionChecker\n*L\n115#1:140,2\n132#1:142,2\n*E\n"})
public final class ShadowedExtensionChecker {
    @NotNull
    private final TypeSpecificityComparator typeSpecificityComparator;
    @NotNull
    private final DiagnosticSink trace;

    public ShadowedExtensionChecker(@NotNull TypeSpecificityComparator typeSpecificityComparator, @NotNull DiagnosticSink trace) {
        Intrinsics.checkNotNullParameter((Object)typeSpecificityComparator, (String)"typeSpecificityComparator");
        Intrinsics.checkNotNullParameter((Object)trace, (String)"trace");
        this.typeSpecificityComparator = typeSpecificityComparator;
        this.trace = trace;
    }

    @NotNull
    public final TypeSpecificityComparator getTypeSpecificityComparator() {
        return this.typeSpecificityComparator;
    }

    @NotNull
    public final DiagnosticSink getTrace() {
        return this.trace;
    }

    public final void checkDeclaration(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        if (declaration.getName() == null) {
            return;
        }
        if (!(descriptor instanceof CallableMemberDescriptor)) {
            return;
        }
        if (AnnotationsForResolveUtilsKt.hasHidesMembersAnnotation((CallableDescriptor)descriptor)) {
            return;
        }
        Annotated annotated = ((CallableMemberDescriptor)descriptor).getExtensionReceiverParameter();
        if (annotated == null || (annotated = annotated.getType()) == null) {
            return;
        }
        Annotated extensionReceiverType = annotated;
        if (KotlinTypeKt.isError((KotlinType)extensionReceiverType)) {
            return;
        }
        if (((KotlinType)extensionReceiverType).isMarkedNullable()) {
            return;
        }
        CallableMemberDescriptor callableMemberDescriptor = (CallableMemberDescriptor)descriptor;
        if (callableMemberDescriptor instanceof FunctionDescriptor) {
            this.checkShadowedExtensionFunction(declaration, (FunctionDescriptor)descriptor, this.trace);
        } else if (callableMemberDescriptor instanceof PropertyDescriptor) {
            this.checkShadowedExtensionProperty(declaration, (PropertyDescriptor)descriptor, this.trace);
        }
    }

    private final void checkShadowedExtensionFunction(KtDeclaration declaration, FunctionDescriptor extensionFunction, DiagnosticSink trace) {
        Object object = extensionFunction.getExtensionReceiverParameter();
        if (object == null || (object = object.getType()) == null || (object = ((KotlinType)object).getMemberScope()) == null) {
            return;
        }
        Object memberScope2 = object;
        Name name = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
        Collection<? extends SimpleFunctionDescriptor> contributedFunctions = memberScope2.getContributedFunctions(name, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (SimpleFunctionDescriptor simpleFunctionDescriptor : contributedFunctions) {
            if (!this.isPublic(simpleFunctionDescriptor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, simpleFunctionDescriptor)) continue;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration), simpleFunctionDescriptor));
            return;
        }
        Name name2 = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"getName(...)");
        ClassifierDescriptor nestedClass = memberScope2.getContributedClassifier(name2, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        if (nestedClass instanceof ClassDescriptor && ((ClassDescriptor)nestedClass).isInner() && this.isPublic((DeclarationDescriptorWithVisibility)((Object)nestedClass))) {
            for (ClassConstructorDescriptor constructor : ((ClassDescriptor)nestedClass).getConstructors()) {
                Intrinsics.checkNotNull((Object)constructor);
                if (!this.isPublic(constructor) || !this.isExtensionFunctionShadowedByMemberFunction(extensionFunction, constructor)) continue;
                trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_INNER_CLASS_CONSTRUCTOR.on((KtDeclaration)((PsiElement)declaration), constructor));
                return;
            }
        }
        Name name3 = extensionFunction.getName();
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"getName(...)");
        Collection<? extends PropertyDescriptor> collection = memberScope2.getContributedVariables(name3, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
        for (PropertyDescriptor propertyDescriptor : collection) {
            FunctionDescriptor invokeOperator;
            if (!this.isPublic(propertyDescriptor) || (invokeOperator = this.getInvokeOperatorShadowingExtensionFunction(extensionFunction, propertyDescriptor)) == null) continue;
            trace.report(Errors.EXTENSION_FUNCTION_SHADOWED_BY_MEMBER_PROPERTY_WITH_INVOKE.on((KtDeclaration)((PsiElement)declaration), propertyDescriptor, invokeOperator));
            return;
        }
    }

    private final boolean isPublic(DeclarationDescriptorWithVisibility $this$isPublic) {
        return Intrinsics.areEqual((Object)$this$isPublic.getVisibility().normalize(), (Object)DescriptorVisibilities.PUBLIC);
    }

    private final boolean isExtensionFunctionShadowedByMemberFunction(FunctionDescriptor extension, FunctionDescriptor member) {
        if (extension.getValueParameters().size() != member.getValueParameters().size()) {
            return false;
        }
        if (DescriptorUtilsKt.varargParameterPosition(extension) != DescriptorUtilsKt.varargParameterPosition(member)) {
            return false;
        }
        if (extension.isOperator() && !member.isOperator()) {
            return false;
        }
        if (extension.isInfix() && !member.isInfix()) {
            return false;
        }
        FlatSignature<CallableDescriptor> extensionSignature = FlatSignatureUtilsKt.createForPossiblyShadowedExtension(FlatSignature.Companion, (CallableDescriptor)extension);
        FlatSignature<CallableDescriptor> memberSignature = FlatSignatureUtilsKt.createFromCallableDescriptor(FlatSignature.Companion, (CallableDescriptor)member);
        return this.isSignatureEquallyOrMoreSpecific(extensionSignature, memberSignature);
    }

    private final FunctionDescriptor getInvokeOperatorShadowingExtensionFunction(FunctionDescriptor extension, PropertyDescriptor member) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = member.getType().getMemberScope().getContributedFunctions(OperatorNameConventions.INVOKE, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                SimpleFunctionDescriptor it = (SimpleFunctionDescriptor)element$iv;
                boolean bl = false;
                if (!(this.isPublic(it) && it.isOperator() && this.isExtensionFunctionShadowedByMemberFunction(extension, it))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isSignatureEquallyOrMoreSpecific(FlatSignature<? extends FunctionDescriptor> extensionSignature, FlatSignature<? extends FunctionDescriptor> memberSignature) {
        return FlatSignatureKt.isSignatureEquallyOrMoreSpecific$default((SimpleConstraintSystem)ConstraintSystemBuilderImpl.Companion.forSpecificity(), extensionSignature, memberSignature, (SpecificityComparisonCallbacks)((SpecificityComparisonCallbacks)OverloadabilitySpecificityCallbacks.INSTANCE), (TypeSpecificityComparator)this.typeSpecificityComparator, (boolean)false, (int)16, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkShadowedExtensionProperty(KtDeclaration declaration, PropertyDescriptor extensionProperty, DiagnosticSink trace) {
        block3: {
            Object v2;
            block2: {
                void $this$firstOrNull$iv;
                Object object = extensionProperty.getExtensionReceiverParameter();
                if (object == null || (object = object.getType()) == null || (object = ((KotlinType)object).getMemberScope()) == null) {
                    return;
                }
                Object memberScope2 = object;
                Name name = extensionProperty.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"getName(...)");
                Iterable iterable = memberScope2.getContributedVariables(name, (LookupLocation)NoLookupLocation.WHEN_CHECK_DECLARATION_CONFLICTS);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PropertyDescriptor it = (PropertyDescriptor)element$iv;
                    boolean bl = false;
                    if (!(this.isPublic(it) && !DescriptorUtilsKt.isExtension(it))) continue;
                    v2 = element$iv;
                    break block2;
                }
                v2 = null;
            }
            PropertyDescriptor propertyDescriptor = v2;
            if (propertyDescriptor == null) break block3;
            PropertyDescriptor memberProperty = propertyDescriptor;
            boolean bl = false;
            trace.report(Errors.EXTENSION_SHADOWED_BY_MEMBER.on((KtDeclaration)((PsiElement)declaration), memberProperty));
        }
    }
}

