/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.smartcasts;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.context.ResolutionContext;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValue;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueFactory;
import org.jetbrains.kotlin.resolve.calls.smartcasts.DataFlowValueKindUtilsKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfo;
import org.jetbrains.kotlin.resolve.calls.smartcasts.IdentifierInfoKt;
import org.jetbrains.kotlin.resolve.calls.smartcasts.Nullability;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.expressions.ExpressionTypingUtils;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0016J*\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J$\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0016J(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactoryImpl;", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValueFactory;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "createDataFlowValue", "Lorg/jetbrains/kotlin/resolve/calls/smartcasts/DataFlowValue;", "receiverValue", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "resolutionContext", "Lorg/jetbrains/kotlin/resolve/calls/context/ResolutionContext;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "containingDeclarationOrModule", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "createDataFlowValueForStableReceiver", "receiver", "createDataFlowValueForProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "usageContainingModule", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "isComplexExpression", "", "frontend"})
public final class DataFlowValueFactoryImpl
implements DataFlowValueFactory {
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;

    public DataFlowValueFactoryImpl(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.languageVersionSettings = languageVersionSettings;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkNotNullParameter((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkNotNullParameter(resolutionContext, (String)"resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        return this.createDataFlowValue(receiverValue, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull ReceiverValue receiverValue, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        DataFlowValue dataFlowValue;
        Intrinsics.checkNotNullParameter((Object)receiverValue, (String)"receiverValue");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue2 instanceof TransientReceiver || receiverValue2 instanceof ImplicitReceiver) {
            dataFlowValue = this.createDataFlowValueForStableReceiver(receiverValue);
        } else if (receiverValue2 instanceof ExpressionReceiver) {
            KtExpression ktExpression = ((ExpressionReceiver)receiverValue).getExpression();
            KotlinType kotlinType = receiverValue.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            dataFlowValue = this.createDataFlowValue(ktExpression, kotlinType, bindingContext, containingDeclarationOrModule);
        } else {
            throw new UnsupportedOperationException("Unsupported receiver value: " + receiverValue.getClass().getName());
        }
        return dataFlowValue;
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForStableReceiver(@NotNull ReceiverValue receiver) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        IdentifierInfo identifierInfo = new IdentifierInfo.Receiver(receiver);
        KotlinType kotlinType = receiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        return new DataFlowValue(identifierInfo, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValueForProperty(@NotNull KtProperty property2, @NotNull VariableDescriptor variableDescriptor, @NotNull BindingContext bindingContext, @Nullable ModuleDescriptor usageContainingModule) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        Intrinsics.checkNotNullParameter((Object)variableDescriptor, (String)"variableDescriptor");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        IdentifierInfo.Variable identifierInfo = new IdentifierInfo.Variable(variableDescriptor, DataFlowValueKindUtilsKt.variableKind(variableDescriptor, usageContainingModule, bindingContext, (KtElement)property2, this.languageVersionSettings), (DataFlowValue)bindingContext.get(BindingContext.BOUND_INITIALIZER_VALUE, variableDescriptor));
        IdentifierInfo identifierInfo2 = identifierInfo;
        KotlinType kotlinType = variableDescriptor.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
        return new DataFlowValue(identifierInfo2, kotlinType, null, 4, null);
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type, @NotNull ResolutionContext<?> resolutionContext) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter(resolutionContext, (String)"resolutionContext");
        BindingContext bindingContext = resolutionContext.trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"getBindingContext(...)");
        return this.createDataFlowValue(expression2, type, bindingContext, resolutionContext.scope.getOwnerDescriptor());
    }

    @Override
    @NotNull
    public DataFlowValue createDataFlowValue(@NotNull KtExpression expression2, @NotNull KotlinType type, @NotNull BindingContext bindingContext, @NotNull DeclarationDescriptor containingDeclarationOrModule) {
        IdentifierInfo result;
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)bindingContext, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)containingDeclarationOrModule, (String)"containingDeclarationOrModule");
        return expression2 instanceof KtConstantExpression && ((KtConstantExpression)expression2).getNode().getElementType() == KtNodeTypes.NULL ? DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule)) : (KotlinTypeKt.isError(type) ? DataFlowValue.ERROR : (KotlinBuiltIns.isNullableNothing(type) ? DataFlowValue.Companion.nullValue(DescriptorUtilsKt.getBuiltIns(containingDeclarationOrModule)) : (ExpressionTypingUtils.isExclExclExpression(KtPsiUtil.deparenthesize((KtExpression)expression2)) ? new DataFlowValue(new IdentifierInfo.Expression(expression2, false, 2, null), type, Nullability.NOT_NULL) : (this.isComplexExpression(expression2) ? new DataFlowValue(new IdentifierInfo.Expression(expression2, true), type, null, 4, null) : new DataFlowValue((result = IdentifierInfoKt.getIdForStableIdentifier(expression2, bindingContext, containingDeclarationOrModule, this.languageVersionSettings)) == IdentifierInfo.NO.INSTANCE ? (IdentifierInfo)new IdentifierInfo.Expression(expression2, false, 2, null) : result, type, null, 4, null)))));
    }

    private final boolean isComplexExpression(KtExpression expression2) {
        KtExpression deparenthesized;
        KtExpression ktExpression = expression2;
        boolean bl = ktExpression instanceof KtBlockExpression || ktExpression instanceof KtIfExpression || ktExpression instanceof KtWhenExpression ? true : (ktExpression instanceof KtBinaryExpression ? ((KtBinaryExpression)expression2).getOperationToken() == KtTokens.ELVIS : (ktExpression instanceof KtParenthesizedExpression ? (deparenthesized = KtPsiUtil.deparenthesize((KtExpression)expression2)) != null && this.isComplexExpression(deparenthesized) : false));
        return bl;
    }
}

