/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.tower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.progress.ProgressIndicatorAndCompilationCanceledStatus;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.inference.model.ConstraintSystemError;
import org.jetbrains.kotlin.resolve.calls.inference.model.LowerPriorityToPreserveCompatibility;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnostic;
import org.jetbrains.kotlin.resolve.calls.model.KotlinCallDiagnosticsKt;
import org.jetbrains.kotlin.resolve.calls.tower.Candidate;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicabilityKt;
import org.jetbrains.kotlin.resolve.calls.tower.ContextReceiversGroupScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.HidesMembersTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitScopeTower;
import org.jetbrains.kotlin.resolve.calls.tower.ImplicitsExtensionsResolutionFilter;
import org.jetbrains.kotlin.resolve.calls.tower.ImportingScopeBasedTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.MemberScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeBasedTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeTowerProcessor;
import org.jetbrains.kotlin.resolve.calls.tower.ScopeWithImplicitsExtensionsResolutionInfo;
import org.jetbrains.kotlin.resolve.calls.tower.SyntheticScopeBasedTowerLevel;
import org.jetbrains.kotlin.resolve.calls.tower.TowerData;
import org.jetbrains.kotlin.resolve.calls.tower.TowerResolver$Task$localLevels_delegate$lambda$0$;
import org.jetbrains.kotlin.resolve.descriptorUtil.AnnotationsForResolveKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.ImportingScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValueWithSmartCastInfo;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.DynamicTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0004\u0018\u0019\u001a\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ4\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\u0006\u0010\u000e\u001a\u00020\u000fJH\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u0007*\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J:\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00060\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0006\u0010\f\u001a\u00020\rJF\u0010\u0015\u001a\n\u0012\u0004\u0012\u0002H\u0006\u0018\u00010\u0005\"\b\b\u0000\u0010\u0006*\u00020\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00060\u000b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00060\u00132\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;", "", "<init>", "()V", "runResolve", "", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "scopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "processor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "useOrder", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "collectAllCandidates", "run", "resultCollector", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;", "runWithEmptyTowerData", "processTowerData", "towerData", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "Task", "ResultCollector", "AllCandidatesCollector", "SuccessfulResultCollector", "resolution"})
@SourceDebugExtension(value={"SMAP\nTowerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,493:1\n1#2:494\n*E\n"})
public final class TowerResolver {
    @NotNull
    public final <C extends Candidate> Collection<C> runResolve(@NotNull ImplicitScopeTower scopeTower, @NotNull ScopeTowerProcessor<? extends C> processor, boolean useOrder, @NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.run(scopeTower, processor, new SuccessfulResultCollector(), useOrder, name);
    }

    @NotNull
    public final <C extends Candidate> Collection<C> collectAllCandidates(@NotNull ImplicitScopeTower scopeTower, @NotNull ScopeTowerProcessor<? extends C> processor, @NotNull Name name) {
        Intrinsics.checkNotNullParameter((Object)scopeTower, (String)"scopeTower");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.run(scopeTower, processor, new AllCandidatesCollector(), false, name);
    }

    private final <C extends Candidate> Collection<C> run(ImplicitScopeTower $this$run, ScopeTowerProcessor<? extends C> processor, ResultCollector<C> resultCollector, boolean useOrder, Name name) {
        return new Task<C>($this$run, processor, resultCollector, useOrder, name).run();
    }

    @NotNull
    public final <C extends Candidate> Collection<C> runWithEmptyTowerData(@NotNull ScopeTowerProcessor<? extends C> processor, @NotNull ResultCollector<C> resultCollector, boolean useOrder) {
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        Intrinsics.checkNotNullParameter(resultCollector, (String)"resultCollector");
        Collection<Object> collection = this.processTowerData(processor, resultCollector, useOrder, TowerData.Empty.INSTANCE);
        if (collection == null) {
            collection = resultCollector.getFinalCandidates();
        }
        return collection;
    }

    private final <C extends Candidate> Collection<C> processTowerData(ScopeTowerProcessor<? extends C> processor, ResultCollector<C> resultCollector, boolean useOrder, TowerData towerData) {
        ProgressIndicatorAndCompilationCanceledStatus.checkCanceled();
        List candidatesGroups = useOrder ? processor.process(towerData) : CollectionsKt.listOf((Object)CollectionsKt.flatten((Iterable)processor.process(towerData)));
        for (Collection candidatesGroup : candidatesGroups) {
            resultCollector.pushCandidates(candidatesGroup);
            Collection<C> collection = resultCollector.getSuccessfulCandidates();
            if (collection == null) continue;
            Collection<C> it = collection;
            boolean bl = false;
            return it;
        }
        return null;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\tH\u0016J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$AllCandidatesCollector;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;", "<init>", "()V", "allCandidates", "Ljava/util/ArrayList;", "getSuccessfulCandidates", "", "getFinalCandidates", "pushCandidates", "", "candidates", "resolution"})
    @SourceDebugExtension(value={"SMAP\nTowerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$AllCandidatesCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,493:1\n861#2,2:494\n*S KotlinDebug\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$AllCandidatesCollector\n*L\n413#1:494,2\n*E\n"})
    public static final class AllCandidatesCollector<C extends Candidate>
    extends ResultCollector<C> {
        @NotNull
        private final ArrayList<C> allCandidates = new ArrayList();

        @Override
        @Nullable
        public Collection<C> getSuccessfulCandidates() {
            return null;
        }

        @Override
        @NotNull
        public Collection<C> getFinalCandidates() {
            return this.allCandidates;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void pushCandidates(@NotNull Collection<? extends C> candidates) {
            void $this$filterNotTo$iv;
            Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
            Iterable iterable = candidates;
            Collection destination$iv = this.allCandidates;
            boolean $i$f$filterNotTo = false;
            for (Object element$iv : $this$filterNotTo$iv) {
                Candidate it = (Candidate)element$iv;
                boolean bl = false;
                if (it.getResultingApplicability() == CandidateApplicability.HIDDEN) continue;
                destination$iv.add(element$iv);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0007H&J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H&J\u0016\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007H&\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "", "<init>", "()V", "getSuccessfulCandidates", "", "getFinalCandidates", "pushCandidates", "", "candidates", "resolution"})
    public static abstract class ResultCollector<C extends Candidate> {
        @Nullable
        public abstract Collection<C> getSuccessfulCandidates();

        @NotNull
        public abstract Collection<C> getFinalCandidates();

        public abstract void pushCandidates(@NotNull Collection<? extends C> var1);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\bH\u0016J\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016R*\u0010\u0006\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b0\u0007j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\b`\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0016\u001a\u00020\u0017*\b\u0012\u0004\u0012\u00028\u00000\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$SuccessfulResultCollector;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;", "<init>", "()V", "candidateGroups", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "isSuccessful", "", "getSuccessfulCandidates", "needToReportCompatibilityWarning", "candidate", "(Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;)Z", "shouldStopResolveOnCandidate", "isPreserveCompatibilityCandidate", "pushCandidates", "", "candidates", "getFinalCandidates", "groupApplicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "getGroupApplicability", "(Ljava/util/Collection;)Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "resolution"})
    @SourceDebugExtension(value={"SMAP\nTowerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$SuccessfulResultCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,493:1\n1914#2,2:494\n776#2:496\n872#2,2:497\n1806#2,3:499\n1806#2,3:502\n776#2:505\n872#2,2:506\n2044#2,14:508\n776#2:522\n872#2,2:523\n1#3:525\n*S KotlinDebug\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$SuccessfulResultCollector\n*L\n447#1:494,2\n450#1:496\n450#1:497,2\n454#1:499,3\n466#1:502,3\n477#1:505\n477#1:506,2\n482#1:508,14\n486#1:522\n486#1:523,2\n*E\n"})
    public static final class SuccessfulResultCollector<C extends Candidate>
    extends ResultCollector<C> {
        @NotNull
        private ArrayList<Collection<C>> candidateGroups = new ArrayList();
        private boolean isSuccessful;

        /*
         * WARNING - void declaration
         */
        @Override
        @Nullable
        public Collection<C> getSuccessfulCandidates() {
            void $this$filterTo$iv$iv;
            if (!this.isSuccessful) {
                return null;
            }
            Candidate compatibilityCandidate = null;
            Collection<C> compatibilityGroup = null;
            Collection<C> shouldStopGroup = null;
            Iterator<Collection<C>> iterator2 = this.candidateGroups.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            Iterator<Collection<C>> iterator3 = iterator2;
            block0: while (iterator3.hasNext()) {
                Collection<C> group;
                Intrinsics.checkNotNullExpressionValue(iterator3.next(), (String)"next(...)");
                for (Candidate candidate : group) {
                    if (this.shouldStopResolveOnCandidate(candidate)) {
                        shouldStopGroup = group;
                        break block0;
                    }
                    if (compatibilityCandidate != null || !this.isPreserveCompatibilityCandidate(candidate)) continue;
                    compatibilityGroup = group;
                    compatibilityCandidate = candidate;
                }
            }
            if (shouldStopGroup == null) {
                return null;
            }
            if (compatibilityCandidate != null && compatibilityGroup != shouldStopGroup && this.needToReportCompatibilityWarning(compatibilityCandidate)) {
                Iterable $this$forEach$iv = shouldStopGroup;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Candidate it = (Candidate)element$iv;
                    boolean bl = false;
                    it.addCompatibilityWarning(compatibilityCandidate);
                }
            }
            Iterable $this$filter$iv = shouldStopGroup;
            boolean $i$f$filter = false;
            Iterator iterator4 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Candidate p0 = (Candidate)element$iv$iv;
                boolean bl = false;
                if (!this.shouldStopResolveOnCandidate(p0)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean needToReportCompatibilityWarning(C candidate) {
            boolean bl;
            if (!(candidate instanceof ResolutionCandidate)) return false;
            Iterable $this$any$iv = ((ResolutionCandidate)candidate).getDiagnostics();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator2 = $this$any$iv.iterator();
            do {
                if (!iterator2.hasNext()) return false;
                Object element$iv = iterator2.next();
                KotlinCallDiagnostic it = (KotlinCallDiagnostic)element$iv;
                boolean bl2 = false;
                ConstraintSystemError constraintSystemError = KotlinCallDiagnosticsKt.getConstraintSystemError(it);
                LowerPriorityToPreserveCompatibility lowerPriorityToPreserveCompatibility = constraintSystemError instanceof LowerPriorityToPreserveCompatibility ? (LowerPriorityToPreserveCompatibility)constraintSystemError : null;
                if (lowerPriorityToPreserveCompatibility != null) {
                    if (lowerPriorityToPreserveCompatibility.getNeedToReportWarning()) {
                        return true;
                    }
                    bl = false;
                    continue;
                }
                bl = false;
            } while (!bl);
            return true;
        }

        private final boolean shouldStopResolveOnCandidate(C candidate) {
            return CandidateApplicabilityKt.getShouldStopResolve((CandidateApplicability)candidate.getResultingApplicability());
        }

        private final boolean isPreserveCompatibilityCandidate(C candidate) {
            return candidate.getResultingApplicability() == CandidateApplicability.RESOLVED_NEED_PRESERVE_COMPATIBILITY;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void pushCandidates(@NotNull Collection<? extends C> candidates) {
            boolean thereIsSuccessful;
            Iterable $this$any$iv;
            block7: {
                boolean bl;
                Intrinsics.checkNotNullParameter(candidates, (String)"candidates");
                $this$any$iv = candidates;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Candidate it = (Candidate)element$iv;
                        boolean bl2 = false;
                        if (!it.isSuccessful()) continue;
                        bl = true;
                        break block7;
                    }
                    bl = thereIsSuccessful = false;
                }
            }
            if (!this.isSuccessful && !thereIsSuccessful) {
                this.candidateGroups.add(candidates);
                return;
            }
            if (!this.isSuccessful) {
                this.candidateGroups.clear();
                this.isSuccessful = true;
            }
            if (thereIsSuccessful) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                $this$any$iv = candidates;
                ArrayList<Collection<C>> arrayList = this.candidateGroups;
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Candidate it = (Candidate)element$iv$iv;
                    boolean bl = false;
                    if (!it.isSuccessful()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                arrayList.add((List)destination$iv$iv);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public Collection<C> getFinalCandidates() {
            void $this$filterTo$iv$iv;
            Object v0;
            Iterable $this$maxByOrNull$iv = this.candidateGroups;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v0 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v0 = maxElem$iv;
                } else {
                    Collection it = (Collection)maxElem$iv;
                    boolean bl = false;
                    Comparable maxValue$iv = (Comparable)this.getGroupApplicability(it);
                    do {
                        Object e$iv = iterator$iv.next();
                        Collection it2 = (Collection)e$iv;
                        $i$a$-maxByOrNull-TowerResolver$SuccessfulResultCollector$getFinalCandidates$moreSuitableGroup$1 = false;
                        Comparable v$iv = (Comparable)this.getGroupApplicability(it2);
                        if (maxValue$iv.compareTo(v$iv) >= 0) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v0 = maxElem$iv;
                }
            }
            Collection collection = v0;
            if (collection == null) {
                return CollectionsKt.emptyList();
            }
            Collection moreSuitableGroup = collection;
            CandidateApplicability groupApplicability = this.getGroupApplicability(moreSuitableGroup);
            if (groupApplicability == CandidateApplicability.HIDDEN) {
                return CollectionsKt.emptyList();
            }
            Iterable $this$filter$iv = moreSuitableGroup;
            boolean $i$f$filter = false;
            iterator$iv = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Candidate it = (Candidate)element$iv$iv;
                boolean bl = false;
                if (!(it.getResultingApplicability() == groupApplicability)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        private final CandidateApplicability getGroupApplicability(Collection<? extends C> $this$groupApplicability) {
            CandidateApplicability candidateApplicability;
            Comparable comparable;
            Iterator iterator2 = ((Iterable)$this$groupApplicability).iterator();
            if (!iterator2.hasNext()) {
                comparable = null;
            } else {
                Candidate it = (Candidate)iterator2.next();
                boolean bl = false;
                Comparable comparable2 = (Comparable)it.getResultingApplicability();
                while (iterator2.hasNext()) {
                    Candidate it2 = (Candidate)iterator2.next();
                    $i$a$-maxOfOrNull-TowerResolver$SuccessfulResultCollector$groupApplicability$1 = false;
                    Comparable comparable3 = (Comparable)it2.getResultingApplicability();
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            if ((candidateApplicability = (CandidateApplicability)comparable) == null) {
                candidateApplicability = CandidateApplicability.HIDDEN;
            }
            return candidateApplicability;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B;\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0012\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015*\u00020\u0005H\u0002J\u0014\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0015*\u00020\u0013H\u0002J\u001c\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0015*\u00020\u00132\u0006\u0010(\u001a\u00020\u000bH\u0002J\f\u0010)\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015J \u0010*\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00152\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u000bH\u0002J\b\u0010.\u001a\u00020/H\u0002J\u0014\u0010(\u001a\u00020\u000b*\u00020,2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010(\u001a\u00020\u000b*\u0002002\u0006\u0010\f\u001a\u00020\rH\u0002J\u0014\u0010(\u001a\u00020\u000b*\u0002012\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\u001a\u001a\u0004\b\u001c\u0010\u0018R\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$Task;", "C", "Lorg/jetbrains/kotlin/resolve/calls/tower/Candidate;", "", "implicitScopeTower", "Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;", "processor", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;", "resultCollector", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;", "useOrder", "", "name", "Lorg/jetbrains/kotlin/name/Name;", "<init>", "(Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver;Lorg/jetbrains/kotlin/resolve/calls/tower/ImplicitScopeTower;Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerProcessor;Lorg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$ResultCollector;ZLorg/jetbrains/kotlin/name/Name;)V", "isNameForHidesMember", "skippedDataForLookup", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/TowerData;", "localLevels", "", "Lorg/jetbrains/kotlin/resolve/calls/tower/ScopeTowerLevel;", "getLocalLevels", "()Ljava/util/Collection;", "localLevels$delegate", "Lkotlin/Lazy;", "nonLocalLevels", "getNonLocalLevels", "nonLocalLevels$delegate", "hidesMembersLevel", "Lorg/jetbrains/kotlin/resolve/calls/tower/HidesMembersTowerLevel;", "getHidesMembersLevel", "()Lorg/jetbrains/kotlin/resolve/calls/tower/HidesMembersTowerLevel;", "syntheticLevel", "Lorg/jetbrains/kotlin/resolve/calls/tower/SyntheticScopeBasedTowerLevel;", "getSyntheticLevel", "()Lorg/jetbrains/kotlin/resolve/calls/tower/SyntheticScopeBasedTowerLevel;", "createNonLocalLevels", "process", "mayFitForName", "run", "processImplicitReceiver", "implicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValueWithSmartCastInfo;", "resolveExtensions", "recordLookups", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/resolve/scopes/ResolutionScope;", "resolution"})
    @SourceDebugExtension(value={"SMAP\nTowerResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$Task\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,493:1\n1341#2,2:494\n478#2:504\n1341#2,2:508\n1914#3,2:496\n1914#3,2:498\n1806#3,3:501\n1806#3,3:505\n1914#3,2:510\n1#4:500\n*S KotlinDebug\n*F\n+ 1 TowerResolver.kt\norg/jetbrains/kotlin/resolve/calls/tower/TowerResolver$Task\n*L\n180#1:494,2\n128#1:504\n278#1:508,2\n201#1:496,2\n202#1:498,2\n356#1:501,3\n170#1:505,3\n294#1:510,2\n*E\n"})
    private final class Task<C extends Candidate> {
        @NotNull
        private final ImplicitScopeTower implicitScopeTower;
        @NotNull
        private final ScopeTowerProcessor<C> processor;
        @NotNull
        private final ResultCollector<C> resultCollector;
        private final boolean useOrder;
        @NotNull
        private final Name name;
        private final boolean isNameForHidesMember;
        @NotNull
        private final List<TowerData> skippedDataForLookup;
        @NotNull
        private final Lazy localLevels$delegate;
        @NotNull
        private final Lazy nonLocalLevels$delegate;
        @NotNull
        private final HidesMembersTowerLevel hidesMembersLevel;
        @NotNull
        private final SyntheticScopeBasedTowerLevel syntheticLevel;

        public Task(@NotNull ImplicitScopeTower implicitScopeTower, @NotNull ScopeTowerProcessor<? extends C> processor, ResultCollector<C> resultCollector, @NotNull boolean useOrder, Name name) {
            Intrinsics.checkNotNullParameter((Object)implicitScopeTower, (String)"implicitScopeTower");
            Intrinsics.checkNotNullParameter(processor, (String)"processor");
            Intrinsics.checkNotNullParameter(resultCollector, (String)"resultCollector");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.implicitScopeTower = implicitScopeTower;
            this.processor = processor;
            this.resultCollector = resultCollector;
            this.useOrder = useOrder;
            this.name = name;
            this.isNameForHidesMember = AnnotationsForResolveKt.getHIDES_MEMBERS_NAME_LIST().contains(this.name) || CollectionsKt.contains((Iterable)AnnotationsForResolveKt.getHIDES_MEMBERS_NAME_LIST(), (Object)this.implicitScopeTower.getNameForGivenImportAlias(this.name));
            this.skippedDataForLookup = new ArrayList();
            this.localLevels$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Task.localLevels_delegate$lambda$0(this));
            this.nonLocalLevels$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> Task.nonLocalLevels_delegate$lambda$0(this));
            this.hidesMembersLevel = new HidesMembersTowerLevel(this.implicitScopeTower);
            this.syntheticLevel = new SyntheticScopeBasedTowerLevel(this.implicitScopeTower, this.implicitScopeTower.getSyntheticScopes());
        }

        private final Collection<ScopeTowerLevel> getLocalLevels() {
            Lazy lazy = this.localLevels$delegate;
            return (Collection)lazy.getValue();
        }

        private final Collection<ScopeTowerLevel> getNonLocalLevels() {
            Lazy lazy = this.nonLocalLevels$delegate;
            return (Collection)lazy.getValue();
        }

        @NotNull
        public final HidesMembersTowerLevel getHidesMembersLevel() {
            return this.hidesMembersLevel;
        }

        @NotNull
        public final SyntheticScopeBasedTowerLevel getSyntheticLevel() {
            return this.syntheticLevel;
        }

        private final Collection<ScopeTowerLevel> createNonLocalLevels(ImplicitScopeTower $this$createNonLocalLevels) {
            Object p0;
            List mainResult = new ArrayList();
            if (!$this$createNonLocalLevels.getAreContextReceiversEnabled()) {
                Sequence<HierarchicalScope> $this$forEach$iv = ScopeUtilsKt.getParentsWithSelf($this$createNonLocalLevels.getLexicalScope());
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HierarchicalScope scope = (HierarchicalScope)element$iv;
                    boolean bl = false;
                    if (scope instanceof LexicalScope) {
                        Task.createNonLocalLevels$addLevelForLexicalScope($this$createNonLocalLevels, this, mainResult, (LexicalScope)scope);
                        continue;
                    }
                    Task.createNonLocalLevels$addLevelForImportingScope($this$createNonLocalLevels, this, mainResult, scope);
                }
                return mainResult;
            }
            List parentScopes = SequencesKt.toList(ScopeUtilsKt.getParentsWithSelf($this$createNonLocalLevels.getLexicalScope()));
            List contextReceiversGroups = new ArrayList();
            int firstImportingScopeIndex = 0;
            Iterator element$iv = ((Iterable)parentScopes).iterator();
            int scope = 0;
            while (element$iv.hasNext()) {
                int i = scope++;
                HierarchicalScope scope2 = (HierarchicalScope)element$iv.next();
                if (!(scope2 instanceof LexicalScope)) {
                    firstImportingScopeIndex = i;
                    break;
                }
                Task.createNonLocalLevels$addLevelForLexicalScope($this$createNonLocalLevels, this, mainResult, (LexicalScope)scope2);
                List<ReceiverValueWithSmartCastInfo> contextReceiversGroup = $this$createNonLocalLevels.getContextReceivers((LexicalScope)scope2);
                if (!(!((Collection)contextReceiversGroup).isEmpty())) continue;
                contextReceiversGroups.add(contextReceiversGroup);
            }
            Iterable $this$forEach$iv = contextReceiversGroups;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                p0 = (List)element$iv2;
                boolean bl = false;
                Task.createNonLocalLevels$addLevelForContextReceiverGroup($this$createNonLocalLevels, this, mainResult, (List<ReceiverValueWithSmartCastInfo>)p0);
            }
            $this$forEach$iv = parentScopes.subList(firstImportingScopeIndex, parentScopes.size());
            $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                p0 = (HierarchicalScope)element$iv2;
                boolean bl = false;
                Task.createNonLocalLevels$addLevelForImportingScope($this$createNonLocalLevels, this, mainResult, (HierarchicalScope)p0);
            }
            return mainResult;
        }

        private final Collection<C> process(TowerData $this$process) {
            Collection collection;
            Collection collection2 = TowerResolver.this.processTowerData(this.processor, this.resultCollector, this.useOrder, $this$process);
            if (collection2 != null) {
                Collection collection3;
                Collection it = collection3 = collection2;
                boolean bl = false;
                this.recordLookups();
                collection = collection3;
            } else {
                collection = null;
            }
            return collection;
        }

        private final Collection<C> process(TowerData $this$process, boolean mayFitForName) {
            if (!mayFitForName) {
                this.skippedDataForLookup.add($this$process);
                return null;
            }
            return this.process($this$process);
        }

        @NotNull
        public final Collection<C> run() {
            Collection<C> collection;
            Collection<C> collection2;
            if (this.isNameForHidesMember && (collection2 = this.process(new TowerData.TowerLevel(this.hidesMembersLevel))) != null) {
                Collection<C> it = collection2;
                boolean bl = false;
                return it;
            }
            collection2 = this.process(TowerData.Empty.INSTANCE);
            if (collection2 != null) {
                Collection<C> it = collection2;
                boolean bl = false;
                return it;
            }
            collection2 = this.process(new TowerData.TowerLevel(this.syntheticLevel));
            if (collection2 != null) {
                Collection<C> it = collection2;
                boolean bl = false;
                return it;
            }
            for (ScopeTowerLevel localLevel : this.getLocalLevels()) {
                Collection<C> it = this.process(new TowerData.TowerLevel(localLevel));
                if (it == null) continue;
                Collection<C> it2 = it;
                boolean bl = false;
                return it2;
            }
            List contextReceiversGroups = new ArrayList();
            if (this.implicitScopeTower.getImplicitsResolutionFilter() == ImplicitsExtensionsResolutionFilter.Default.INSTANCE) {
                collection = Task.run$processScopes(this, contextReceiversGroups, ScopeUtilsKt.getParentsWithSelf(this.implicitScopeTower.getLexicalScope()), (Function1<? super HierarchicalScope, Boolean>)((Function1)Task::run$lambda$15));
            } else {
                Sequence<ScopeWithImplicitsExtensionsResolutionInfo> scopeInfos = this.implicitScopeTower.allScopesWithImplicitsResolutionInfo();
                Map scopeToResolveExtensionsForImplicitReceiverMap = MapsKt.toMap((Sequence)SequencesKt.map(scopeInfos, Task::run$lambda$16));
                collection = Task.run$processScopes(this, contextReceiversGroups, (Sequence<? extends HierarchicalScope>)SequencesKt.map(scopeInfos, Task::run$lambda$17), (Function1<? super HierarchicalScope, Boolean>)((Function1)arg_0 -> Task.run$lambda$18(scopeToResolveExtensionsForImplicitReceiverMap, arg_0)));
            }
            this.recordLookups();
            return this.resultCollector.getFinalCandidates();
        }

        private final Collection<C> processImplicitReceiver(ReceiverValueWithSmartCastInfo implicitReceiver, boolean resolveExtensions) {
            Collection<C> collection;
            if (this.isNameForHidesMember && (collection = this.process(new TowerData.BothTowerLevelAndImplicitReceiver(this.hidesMembersLevel, implicitReceiver))) != null) {
                Collection<C> it = collection;
                boolean bl = false;
                return it;
            }
            collection = this.process(new TowerData.TowerLevel(new MemberScopeTowerLevel(this.implicitScopeTower, implicitReceiver)), this.mayFitForName(implicitReceiver, this.name));
            if (collection != null) {
                Collection<C> it = collection;
                boolean bl = false;
                return it;
            }
            collection = this.process(new TowerData.BothTowerLevelAndImplicitReceiver(this.syntheticLevel, implicitReceiver));
            if (collection != null) {
                Collection<C> it = collection;
                boolean bl = false;
                return it;
            }
            if (resolveExtensions) {
                Collection<C> collection2;
                collection = this.process(new TowerData.OnlyImplicitReceiver(implicitReceiver));
                if (collection != null) {
                    Collection<C> it = collection;
                    boolean bl = false;
                    return it;
                }
                for (ScopeTowerLevel localLevel : this.getLocalLevels()) {
                    collection2 = this.process(new TowerData.BothTowerLevelAndImplicitReceiver(localLevel, implicitReceiver));
                    if (collection2 == null) continue;
                    Collection<C> it = collection2;
                    boolean bl = false;
                    return it;
                }
                for (ScopeTowerLevel nonLocalLevel : this.getNonLocalLevels()) {
                    collection2 = this.process(new TowerData.BothTowerLevelAndImplicitReceiver(nonLocalLevel, implicitReceiver));
                    if (collection2 == null) continue;
                    Collection<C> it = collection2;
                    boolean bl = false;
                    return it;
                }
            }
            return null;
        }

        private final void recordLookups() {
            this.processor.recordLookups((Collection<TowerData>)this.skippedDataForLookup, this.name);
        }

        private final boolean mayFitForName(ReceiverValueWithSmartCastInfo $this$mayFitForName, Name name) {
            boolean bl;
            block5: {
                KotlinType kotlinType = $this$mayFitForName.getReceiverValue().getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
                if (this.mayFitForName(kotlinType, name)) {
                    return true;
                }
                if (!$this$mayFitForName.hasTypesFromSmartCasts()) {
                    return false;
                }
                Iterable $this$any$iv = $this$mayFitForName.getTypesFromSmartCasts();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        KotlinType it = (KotlinType)element$iv;
                        boolean bl2 = false;
                        if (!this.mayFitForName(it, name)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final boolean mayFitForName(KotlinType $this$mayFitForName, Name name) {
            return DynamicTypesKt.isDynamic($this$mayFitForName) || !$this$mayFitForName.getMemberScope().definitelyDoesNotContainName(name) || !$this$mayFitForName.getMemberScope().definitelyDoesNotContainName(OperatorNameConventions.INVOKE);
        }

        private final boolean mayFitForName(ResolutionScope $this$mayFitForName, Name name) {
            return !$this$mayFitForName.definitelyDoesNotContainName(name) || !$this$mayFitForName.definitelyDoesNotContainName(OperatorNameConventions.INVOKE);
        }

        private static final boolean localLevels_delegate$lambda$0$0(Task this$0, LexicalScope it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getKind().getWithLocalDescriptors() && this$0.mayFitForName(it, this$0.name);
        }

        private static final ScopeBasedTowerLevel localLevels_delegate$lambda$0$1(Task this$0, LexicalScope it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return new ScopeBasedTowerLevel(this$0.implicitScopeTower, it);
        }

        private static final List localLevels_delegate$lambda$0(Task this$0) {
            Sequence<HierarchicalScope> $this$filterIsInstance$iv = ScopeUtilsKt.getParentsWithSelf(this$0.implicitScopeTower.getLexicalScope());
            boolean $i$f$filterIsInstance = false;
            Sequence sequence = SequencesKt.filter($this$filterIsInstance$iv, (Function1)Task$localLevels_delegate$lambda$0$$inlined$filterIsInstance$1.INSTANCE);
            Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
            return SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)sequence, arg_0 -> Task.localLevels_delegate$lambda$0$0(this$0, arg_0)), arg_0 -> Task.localLevels_delegate$lambda$0$1(this$0, arg_0)));
        }

        private static final Collection nonLocalLevels_delegate$lambda$0(Task this$0) {
            return this$0.createNonLocalLevels(this$0.implicitScopeTower);
        }

        private static final <C extends Candidate> void createNonLocalLevels$addLevel(List<ScopeTowerLevel> mainResult, Task<? extends C> this$0, ScopeTowerLevel scopeTowerLevel, boolean mayFitForName) {
            boolean bl = mayFitForName ? mainResult.add(scopeTowerLevel) : this$0.skippedDataForLookup.add(new TowerData.ForLookupForNoExplicitReceiver(scopeTowerLevel));
        }

        private static final <C extends Candidate> void createNonLocalLevels$addLevelForLexicalScope(ImplicitScopeTower $this_createNonLocalLevels, Task<? extends C> this$0, List<ScopeTowerLevel> mainResult, LexicalScope scope) {
            block1: {
                if (!scope.getKind().getWithLocalDescriptors()) {
                    Task.createNonLocalLevels$addLevel(mainResult, this$0, new ScopeBasedTowerLevel($this_createNonLocalLevels, scope), super.mayFitForName(scope, this$0.name));
                }
                ReceiverValueWithSmartCastInfo receiverValueWithSmartCastInfo = $this_createNonLocalLevels.getImplicitReceiver(scope);
                if (receiverValueWithSmartCastInfo == null) break block1;
                ReceiverValueWithSmartCastInfo it = receiverValueWithSmartCastInfo;
                boolean bl = false;
                Task.createNonLocalLevels$addLevel(mainResult, this$0, new MemberScopeTowerLevel($this_createNonLocalLevels, it), super.mayFitForName(it, this$0.name));
            }
        }

        /*
         * WARNING - void declaration
         */
        private static final <C extends Candidate> void createNonLocalLevels$addLevelForContextReceiverGroup(ImplicitScopeTower $this_createNonLocalLevels, Task<? extends C> this$0, List<ScopeTowerLevel> mainResult, List<ReceiverValueWithSmartCastInfo> contextReceiversGroup) {
            boolean bl;
            List<ScopeTowerLevel> list;
            Task<? extends C> task;
            ScopeTowerLevel scopeTowerLevel;
            block3: {
                void $this$any$iv;
                Iterable iterable = contextReceiversGroup;
                scopeTowerLevel = new ContextReceiversGroupScopeTowerLevel($this_createNonLocalLevels, contextReceiversGroup);
                task = this$0;
                list = mainResult;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ReceiverValueWithSmartCastInfo it = (ReceiverValueWithSmartCastInfo)element$iv;
                        boolean bl2 = false;
                        if (!super.mayFitForName(it, this$0.name)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            boolean bl3 = bl;
            Task.createNonLocalLevels$addLevel(list, task, scopeTowerLevel, bl3);
        }

        private static final <C extends Candidate> void createNonLocalLevels$addLevelForImportingScope(ImplicitScopeTower $this_createNonLocalLevels, Task<? extends C> this$0, List<ScopeTowerLevel> mainResult, HierarchicalScope scope) {
            Intrinsics.checkNotNull((Object)scope, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.ImportingScope");
            Task.createNonLocalLevels$addLevel(mainResult, this$0, new ImportingScopeBasedTowerLevel($this_createNonLocalLevels, (ImportingScope)scope), super.mayFitForName(scope, this$0.name));
        }

        private static final <C extends Candidate> Collection<C> run$processLexicalScope(Task<? extends C> this$0, List<List<ReceiverValueWithSmartCastInfo>> contextReceiversGroups, LexicalScope scope, boolean resolveExtensionsForImplicitReceiver) {
            Object object;
            List<ReceiverValueWithSmartCastInfo> contextReceiversGroup;
            if (this$0.implicitScopeTower.getAreContextReceiversEnabled() && !((Collection)(contextReceiversGroup = this$0.implicitScopeTower.getContextReceivers(scope))).isEmpty()) {
                contextReceiversGroups.add(contextReceiversGroup);
            }
            if (!scope.getKind().getWithLocalDescriptors() && (object = super.process(new TowerData.TowerLevel(new ScopeBasedTowerLevel(this$0.implicitScopeTower, scope)), super.mayFitForName(scope, this$0.name))) != null) {
                Object it = object;
                boolean bl = false;
                return it;
            }
            object = this$0.implicitScopeTower.getImplicitReceiver(scope);
            if (object != null) {
                Object it = object;
                boolean bl = false;
                Collection<? extends C> collection = super.processImplicitReceiver((ReceiverValueWithSmartCastInfo)it, resolveExtensionsForImplicitReceiver);
                if (collection != null) {
                    it = collection;
                    boolean bl2 = false;
                    return it;
                }
            }
            return null;
        }

        private static final <C extends Candidate> Collection<C> run$processContextReceiverGroup(Task<? extends C> this$0, List<ReceiverValueWithSmartCastInfo> contextReceiversGroup) {
            Collection<Object> collection = super.process(new TowerData.TowerLevel(new ContextReceiversGroupScopeTowerLevel(this$0.implicitScopeTower, contextReceiversGroup)));
            if (collection != null) {
                Collection<? extends C> it = collection;
                boolean bl = false;
                return it;
            }
            collection = super.process(new TowerData.BothTowerLevelAndContextReceiversGroup(this$0.syntheticLevel, contextReceiversGroup));
            if (collection != null) {
                Collection<? extends C> it = collection;
                boolean bl = false;
                return it;
            }
            for (ScopeTowerLevel nonLocalLevel : super.getNonLocalLevels()) {
                Collection<? extends C> collection2 = super.process(new TowerData.BothTowerLevelAndContextReceiversGroup(nonLocalLevel, contextReceiversGroup));
                if (collection2 == null) continue;
                Collection<? extends C> it = collection2;
                boolean bl = false;
                return it;
            }
            return null;
        }

        private static final <C extends Candidate> Collection<C> run$processImportingScope(Task<? extends C> this$0, ImportingScope scope) {
            Collection<? extends C> collection = super.process(new TowerData.TowerLevel(new ImportingScopeBasedTowerLevel(this$0.implicitScopeTower, scope)), super.mayFitForName(scope, this$0.name));
            if (collection != null) {
                Collection<? extends C> it = collection;
                boolean bl = false;
                return it;
            }
            return null;
        }

        private static final <C extends Candidate> Collection<C> run$processScopes(Task<? extends C> this$0, List<List<ReceiverValueWithSmartCastInfo>> contextReceiversGroups, Sequence<? extends HierarchicalScope> scopes, Function1<? super HierarchicalScope, Boolean> resolveExtensionsForImplicitReceiver) {
            if (!this$0.implicitScopeTower.getAreContextReceiversEnabled()) {
                Sequence<? extends HierarchicalScope> $this$forEach$iv = scopes;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    HierarchicalScope scope = (HierarchicalScope)element$iv;
                    boolean bl = false;
                    if (scope instanceof LexicalScope) {
                        Collection<? extends C> collection = Task.run$processLexicalScope(this$0, contextReceiversGroups, (LexicalScope)scope, (Boolean)resolveExtensionsForImplicitReceiver.invoke((Object)scope));
                        if (collection == null) continue;
                        Collection<? extends C> it = collection;
                        boolean bl2 = false;
                        return it;
                    }
                    Intrinsics.checkNotNull((Object)scope, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.ImportingScope");
                    Collection<? extends C> collection = Task.run$processImportingScope(this$0, (ImportingScope)scope);
                    if (collection == null) continue;
                    Collection<? extends C> it = collection;
                    boolean bl3 = false;
                    return it;
                }
                return null;
            }
            boolean firstImportingScopePassed = false;
            for (HierarchicalScope scope : scopes) {
                Collection<C> it;
                if (scope instanceof LexicalScope) {
                    Collection<C> element$iv = Task.run$processLexicalScope(this$0, contextReceiversGroups, (LexicalScope)scope, (Boolean)resolveExtensionsForImplicitReceiver.invoke((Object)scope));
                    if (element$iv == null) continue;
                    it = element$iv;
                    boolean bl = false;
                    return it;
                }
                if (!firstImportingScopePassed) {
                    firstImportingScopePassed = true;
                    Iterable $this$forEach$iv = contextReceiversGroups;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        List contextReceiversGroup = (List)element$iv;
                        boolean bl = false;
                        Collection<? extends C> collection = Task.run$processContextReceiverGroup(this$0, contextReceiversGroup);
                        if (collection == null) continue;
                        Collection<? extends C> it2 = collection;
                        boolean bl4 = false;
                        return it2;
                    }
                }
                Intrinsics.checkNotNull((Object)scope, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.resolve.scopes.ImportingScope");
                Collection<? extends C> collection = Task.run$processImportingScope(this$0, (ImportingScope)scope);
                if (collection == null) continue;
                it = collection;
                boolean bl = false;
                return it;
            }
            return null;
        }

        private static final boolean run$lambda$15(HierarchicalScope it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        private static final Pair run$lambda$16(ScopeWithImplicitsExtensionsResolutionInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return TuplesKt.to((Object)it.getScope(), (Object)it.getResolveExtensionsForImplicitReceiver());
        }

        private static final HierarchicalScope run$lambda$17(ScopeWithImplicitsExtensionsResolutionInfo it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it.getScope();
        }

        private static final boolean run$lambda$18(Map $scopeToResolveExtensionsForImplicitReceiverMap, HierarchicalScope it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            Boolean bl = (Boolean)$scopeToResolveExtensionsForImplicitReceiverMap.get(it);
            return bl != null ? bl : false;
        }
    }
}

