/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.ValueParameterDescriptorImpl;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\"\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"createValueParametersForInvokeInFunctionType", "", "Lorg/jetbrains/kotlin/descriptors/ValueParameterDescriptor;", "functionDescriptor", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "parameterTypes", "Lorg/jetbrains/kotlin/types/TypeProjection;", "getValueParametersCountFromFunctionType", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "resolution"})
@SourceDebugExtension(value={"SMAP\nfunctionTypeResolveUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 functionTypeResolveUtils.kt\norg/jetbrains/kotlin/resolve/calls/util/FunctionTypeResolveUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,50:1\n1595#2:51\n1628#2,4:52\n1#3:56\n*S KotlinDebug\n*F\n+ 1 functionTypeResolveUtils.kt\norg/jetbrains/kotlin/resolve/calls/util/FunctionTypeResolveUtilsKt\n*L\n33#1:51\n33#1:52,4\n*E\n"})
public final class FunctionTypeResolveUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ValueParameterDescriptor> createValueParametersForInvokeInFunctionType(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<? extends TypeProjection> parameterTypes) {
        void $this$mapIndexedTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)functionDescriptor, (String)"functionDescriptor");
        Intrinsics.checkNotNullParameter(parameterTypes, (String)"parameterTypes");
        Iterable $this$mapIndexed$iv = parameterTypes;
        boolean $i$f$mapIndexed = false;
        Iterable iterable = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void typeProjection;
            void i;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection2 = (TypeProjection)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CallableDescriptor callableDescriptor = functionDescriptor;
            Annotations annotations = Annotations.Companion.getEMPTY();
            Name name = Name.identifier((String)("" + 'p' + (int)(i + true)));
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            KotlinType kotlinType = typeProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"getType(...)");
            SourceElement sourceElement = SourceElement.NO_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"NO_SOURCE");
            collection.add(new ValueParameterDescriptorImpl(callableDescriptor, null, (int)i, annotations, name, kotlinType, false, false, false, null, sourceElement));
        }
        return (List)destination$iv$iv;
    }

    public static final int getValueParametersCountFromFunctionType(@NotNull KotlinType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        boolean bl = FunctionTypesKt.isBuiltinFunctionalType(type);
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Not a function type: " + type;
            throw new AssertionError((Object)string);
        }
        return type.getArguments().size() - (FunctionTypesKt.isBuiltinExtensionFunctionalType(type) ? 1 : 0) - 1;
    }
}

