/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.sam;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;
import org.jetbrains.kotlin.resolve.sam.SamWithReceiverResolver;
import org.jetbrains.kotlin.storage.CacheWithNullableValues;
import org.jetbrains.kotlin.storage.StorageManager;
import org.jetbrains.kotlin.types.SimpleType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u000fB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u000bH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl;", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "samWithReceiverResolvers", "", "Lorg/jetbrains/kotlin/resolve/sam/SamWithReceiverResolver;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;Ljava/lang/Iterable;)V", "functionTypesForSamInterfaces", "Lorg/jetbrains/kotlin/storage/CacheWithNullableValues;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "Lorg/jetbrains/kotlin/types/SimpleType;", "resolveFunctionTypeIfSamInterface", "classDescriptor", "SamConversionResolverWithoutReceiverConversion", "descriptors"})
@SourceDebugExtension(value={"SMAP\nSamConversionResolverImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SamConversionResolverImpl.kt\norg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1806#2,3:181\n*S KotlinDebug\n*F\n+ 1 SamConversionResolverImpl.kt\norg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl\n*L\n39#1:181,3\n*E\n"})
public final class SamConversionResolverImpl
implements SamConversionResolver {
    @NotNull
    private final Iterable<SamWithReceiverResolver> samWithReceiverResolvers;
    @NotNull
    private final CacheWithNullableValues<ClassDescriptor, SimpleType> functionTypesForSamInterfaces;

    public SamConversionResolverImpl(@NotNull StorageManager storageManager, @NotNull Iterable<? extends SamWithReceiverResolver> samWithReceiverResolvers) {
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter(samWithReceiverResolvers, (String)"samWithReceiverResolvers");
        this.samWithReceiverResolvers = samWithReceiverResolvers;
        this.functionTypesForSamInterfaces = storageManager.createCacheWithNullableValues();
    }

    @Override
    @Nullable
    public SimpleType resolveFunctionTypeIfSamInterface(@NotNull ClassDescriptor classDescriptor) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
        return (SimpleType)this.functionTypesForSamInterfaces.computeIfAbsent((Object)classDescriptor, () -> SamConversionResolverImpl.resolveFunctionTypeIfSamInterface$lambda$0(classDescriptor, this));
    }

    private static final SimpleType resolveFunctionTypeIfSamInterface$lambda$0(ClassDescriptor $classDescriptor, SamConversionResolverImpl this$0) {
        boolean bl;
        FunctionDescriptor abstractMethod;
        block4: {
            FunctionDescriptor functionDescriptor = SamConversionResolverImplKt.getSingleAbstractMethodOrNull($classDescriptor);
            if (functionDescriptor == null) {
                return null;
            }
            abstractMethod = functionDescriptor;
            Iterable<SamWithReceiverResolver> $this$any$iv = this$0.samWithReceiverResolvers;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                Iterator<SamWithReceiverResolver> iterator2 = $this$any$iv.iterator();
                while (iterator2.hasNext()) {
                    SamWithReceiverResolver element$iv;
                    SamWithReceiverResolver it = element$iv = iterator2.next();
                    boolean bl2 = false;
                    if (!it.shouldConvertFirstSamParameterToReceiver(abstractMethod)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean shouldConvertFirstParameterToDescriptor = bl;
        return SamConversionResolverImplKt.getFunctionTypeForAbstractMethod(abstractMethod, shouldConvertFirstParameterToDescriptor);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl$SamConversionResolverWithoutReceiverConversion;", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolver;", "storageManager", "Lorg/jetbrains/kotlin/storage/StorageManager;", "<init>", "(Lorg/jetbrains/kotlin/storage/StorageManager;)V", "resolver", "Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl;", "getResolver", "()Lorg/jetbrains/kotlin/resolve/sam/SamConversionResolverImpl;", "resolveFunctionTypeIfSamInterface", "Lorg/jetbrains/kotlin/types/SimpleType;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "descriptors"})
    public static final class SamConversionResolverWithoutReceiverConversion
    implements SamConversionResolver {
        @NotNull
        private final SamConversionResolverImpl resolver;

        public SamConversionResolverWithoutReceiverConversion(@NotNull StorageManager storageManager) {
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
            this.resolver = new SamConversionResolverImpl(storageManager, CollectionsKt.emptyList());
        }

        @NotNull
        public final SamConversionResolverImpl getResolver() {
            return this.resolver;
        }

        @Override
        @Nullable
        public SimpleType resolveFunctionTypeIfSamInterface(@NotNull ClassDescriptor classDescriptor) {
            Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"classDescriptor");
            return this.resolver.resolveFunctionTypeIfSamInterface(classDescriptor);
        }
    }
}

