/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureSet;
import com.jetbrains.ml.tools.data.DataFrame;
import com.jetbrains.ml.tools.model.MLModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fH\u0016J\u0019\u0010\u0010\u001a\u00028\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f\u00a2\u0006\u0002\u0010\u0013J.\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0015J@\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0019\u0012\u0004\u0012\u00028\u00000\u0018\"\u0004\b\u0001\u0010\u00192\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u0002H\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0018J0\u0010\u001a\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u000f0\u0015H$J\u001b\u0010\u001b\u001a\u00028\u00002\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH$\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/ml/tools/model/MLModel;", "P", "", "()V", "inputFeatures", "Lcom/jetbrains/ml/api/feature/FeatureSet;", "getInputFeatures", "()Lcom/jetbrains/ml/api/feature/FeatureSet;", "predictedType", "Ljava/lang/Class;", "getPredictedType", "()Ljava/lang/Class;", "buildPredictionsDataFrame", "Lcom/jetbrains/ml/tools/data/DataFrame;", "predictions", "", "predict", "features", "Lcom/jetbrains/ml/api/feature/Feature;", "(Ljava/util/Collection;)Ljava/lang/Object;", "predictBatch", "", "contextFeatures", "itemFeatures", "", "T", "predictBatchWithInputFeatures", "predictWithInputFeatures", "validateRow", "", "ml-tools"})
@SourceDebugExtension(value={"SMAP\nMLModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MLModel.kt\ncom/jetbrains/ml/tools/model/MLModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,106:1\n1477#2:107\n1502#2,3:108\n1505#2,3:118\n1549#2:128\n1620#2,3:129\n1179#2,2:132\n1253#2,4:134\n372#3,7:111\n526#3:121\n511#3,6:122\n*S KotlinDebug\n*F\n+ 1 MLModel.kt\ncom/jetbrains/ml/tools/model/MLModel\n*L\n77#1:107\n77#1:108,3\n77#1:118,3\n98#1:128\n98#1:129,3\n99#1:132,2\n99#1:134,4\n77#1:111,7\n77#1:121\n77#1:122,6\n*E\n"})
public abstract class MLModel<P> {
    @NotNull
    public abstract Class<? extends P> getPredictedType();

    @NotNull
    public abstract FeatureSet getInputFeatures();

    @NotNull
    protected abstract P predictWithInputFeatures(@NotNull Collection<? extends Feature> var1);

    @NotNull
    protected abstract List<P> predictBatchWithInputFeatures(@NotNull Collection<? extends Feature> var1, @NotNull List<? extends Collection<? extends Feature>> var2);

    @NotNull
    public final P predict(@NotNull Collection<? extends Feature> features) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        this.validateRow(features);
        return this.predictWithInputFeatures(features);
    }

    @NotNull
    public final List<P> predictBatch(@NotNull Collection<? extends Feature> contextFeatures, @NotNull List<? extends Collection<? extends Feature>> itemFeatures) {
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Iterator<? extends Collection<? extends Feature>> iterator = itemFeatures.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            int rowI = n++;
            Collection<? extends Feature> itemFeatures2 = iterator.next();
            try {
                this.validateRow(CollectionsKt.plus(contextFeatures, (Iterable)itemFeatures2));
            }
            catch (Throwable e) {
                throw new Exception("Batch row #" + rowI + " is not valid", e);
            }
        }
        return this.predictBatchWithInputFeatures(contextFeatures, itemFeatures);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateRow(Collection<? extends Feature> features) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Object it;
        void $this$groupByTo$iv$iv;
        Collection missing = this.getInputFeatures().selectMissingFeatures(features);
        Collection redundant = this.getInputFeatures().selectFeaturesNotFromThis(features);
        Object $this$groupBy$iv = features;
        boolean $i$f$groupBy = false;
        Iterable iterable = $this$groupBy$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        for (Object element$iv$iv : $this$groupByTo$iv$iv) {
            Object object;
            it = (Feature)element$iv$iv;
            boolean bl = false;
            String key$iv$iv = it.getName();
            Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl2 = false;
                List answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        $this$groupBy$iv = destination$iv$iv;
        boolean $i$f$filter = false;
        $this$groupByTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator<Object> iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv;
            it = element$iv$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            if (!(((List)it.getValue()).size() > 1)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map duplicated = destination$iv$iv;
        if (!(missing.isEmpty() && redundant.isEmpty() && duplicated.isEmpty())) {
            boolean bl = false;
            Iterable $this$validateRow_u24lambda_u243_u24lambda_u242 = iterable = CollectionsKt.createListBuilder();
            boolean bl3 = false;
            if (!missing.isEmpty()) {
                $this$validateRow_u24lambda_u243_u24lambda_u242.add("Missing: " + missing);
            }
            if (!redundant.isEmpty()) {
                $this$validateRow_u24lambda_u243_u24lambda_u242.add("Redundant: " + redundant);
            }
            if (!duplicated.isEmpty()) {
                $this$validateRow_u24lambda_u243_u24lambda_u242.add("Duplicated: " + duplicated);
            }
            List infos = CollectionsKt.build((List)iterable);
            String string = "ML model " + this + " has received inconsistent feature set:\n" + CollectionsKt.joinToString$default((Iterable)infos, (CharSequence)"\n", null, null, (int)0, null, (Function1)validateRow.1.1.INSTANCE, (int)30, null) + "\n";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> Map<T, P> predictBatch(@NotNull Collection<? extends Feature> contextFeatures, @NotNull Map<T, ? extends Collection<? extends Feature>> itemFeatures) {
        void $this$associateTo$iv$iv;
        Collection<Collection> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        List itemFeaturesOrder = CollectionsKt.toList((Iterable)itemFeatures.entrySet());
        Iterable iterable = itemFeaturesOrder;
        Collection<? extends Feature> collection2 = contextFeatures;
        MLModel mLModel = this;
        boolean $i$f$map = false;
        void var7_8 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Collection)it.getValue());
        }
        collection = (List)destination$iv$iv;
        List<P> predictions = mLModel.predictBatch(collection2, (List<Collection<Feature>>)collection);
        Iterable $this$associate$iv = CollectionsKt.zip((Iterable)itemFeaturesOrder, (Iterable)predictions);
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv2;
            Pair it = (Pair)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to(((Map.Entry)it.getFirst()).getKey(), (Object)it.getSecond());
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv2;
    }

    @NotNull
    public DataFrame buildPredictionsDataFrame(@NotNull Collection<? extends P> predictions) {
        Intrinsics.checkNotNullParameter(predictions, (String)"predictions");
        throw new NotImplementedError("Serialization to DataFrame for " + this + " is not implemented");
    }
}

