/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.reactnative;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunConfigurationEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.RadioButtonEnumModel;
import com.jetbrains.plugins.reactnative.PackagerRunner;
import com.jetbrains.plugins.reactnative.ReactNativeConfigurationEditorKt;
import com.jetbrains.plugins.reactnative.ReactNativeDebuggerBundle;
import com.jetbrains.plugins.reactnative.ReactNativePackagerConfiguration;
import com.jetbrains.plugins.reactnative.ReactNativeRunConfigurationKt;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001b\u001a\u00020\u001cH\u0014J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010 H\u0014J\b\u0010!\u001a\u00020\u001eH\u0014J\u000e\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/plugins/reactnative/ReactNativePackagerConfigurationEditor;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "packagerRunnerPanel", "Ljavax/swing/JPanel;", "packagerRunnerModel", "Lcom/intellij/util/ui/RadioButtonEnumModel;", "Lcom/jetbrains/plugins/reactnative/PackagerRunner;", "packagerScriptSelectorLabel", "Ljavax/swing/JLabel;", "packagerScriptSelector", "Lcom/intellij/ui/TextFieldWithHistory;", "Lorg/jetbrains/annotations/NotNull;", "nodeInterpreterField", "Lcom/intellij/javascript/nodejs/interpreter/NodeJsInterpreterField;", "reactNativeFieldLabel", "reactNativeField", "Lcom/intellij/javascript/nodejs/util/NodePackageField;", "packagerArgumentsField", "Lcom/intellij/ui/RawCommandLineEditor;", "workingDirField", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "envVarsComponent", "Lcom/intellij/execution/configuration/EnvironmentVariablesTextFieldWithBrowseButton;", "getDimensionServiceKey", "", "updatePackagerRunnerVisibility", "", "createCenterPanel", "Ljavax/swing/JComponent;", "doOKAction", "doValidateAll", "", "Lcom/intellij/openapi/ui/ValidationInfo;", "intellij.javascript.reactNativeDebugger"})
@SourceDebugExtension(value={"SMAP\nReactNativePackagerConfigurationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactNativePackagerConfigurationEditor.kt\ncom/jetbrains/plugins/reactnative/ReactNativePackagerConfigurationEditor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,142:1\n1#2:143\n*E\n"})
public final class ReactNativePackagerConfigurationEditor
extends DialogWrapper {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel packagerRunnerPanel;
    @NotNull
    private final RadioButtonEnumModel<PackagerRunner> packagerRunnerModel;
    @NotNull
    private final JLabel packagerScriptSelectorLabel;
    @NotNull
    private final TextFieldWithHistory packagerScriptSelector;
    @NotNull
    private final NodeJsInterpreterField nodeInterpreterField;
    @NotNull
    private final JLabel reactNativeFieldLabel;
    @NotNull
    private final NodePackageField reactNativeField;
    @NotNull
    private final RawCommandLineEditor packagerArgumentsField;
    @NotNull
    private final TextFieldWithBrowseButton workingDirField;
    @NotNull
    private final EnvironmentVariablesTextFieldWithBrowseButton envVarsComponent;

    public ReactNativePackagerConfigurationEditor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.project = project;
        this.packagerRunnerPanel = new JPanel(new GridBagLayout());
        this.packagerRunnerModel = ReactNativeConfigurationEditorKt.createRadioButtonGroup(PackagerRunner.class, this.packagerRunnerPanel);
        this.packagerScriptSelectorLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.packager.config.script", new Object[0]));
        TextFieldWithHistory textFieldWithHistory = NpmRunConfigurationEditor.createRunScriptsField((Project)this.project, () -> ReactNativePackagerConfigurationEditor.packagerScriptSelector$lambda$0(this));
        Intrinsics.checkNotNullExpressionValue((Object)textFieldWithHistory, (String)"createRunScriptsField(...)");
        this.packagerScriptSelector = textFieldWithHistory;
        this.nodeInterpreterField = new NodeJsInterpreterField(this.project, false);
        this.reactNativeFieldLabel = new JLabel(ReactNativeDebuggerBundle.message("react.native.packager.config.package", new Object[0]));
        this.reactNativeField = ReactNativeConfigurationEditorKt.createReactNativePackageField(this.nodeInterpreterField);
        this.packagerArgumentsField = new RawCommandLineEditor();
        this.workingDirField = new TextFieldWithBrowseButton();
        this.envVarsComponent = new EnvironmentVariablesTextFieldWithBrowseButton();
        this.init();
        this.setTitle(ReactNativeDebuggerBundle.message("react.native.packager.config.title", new Object[0]));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#com.jetbrains.plugins.reactnative.ReactNativePackagerConfigurationEditor";
    }

    private final void updatePackagerRunnerVisibility() {
        boolean isNpm = this.packagerRunnerModel.getSelected() == PackagerRunner.NPM;
        this.packagerScriptSelector.setVisible(isNpm);
        this.packagerScriptSelectorLabel.setVisible(isNpm);
        this.reactNativeField.setVisible(!isNpm);
        this.reactNativeFieldLabel.setVisible(!isNpm);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        this.packagerScriptSelectorLabel.setLabelFor((Component)this.packagerScriptSelector);
        this.packagerRunnerModel.addActionListener(arg_0 -> ReactNativePackagerConfigurationEditor.createCenterPanel$lambda$0(this, arg_0));
        FormBuilder formBuilder2 = new FormBuilder(){

            protected int getFill(JComponent component) {
                return 2;
            }
        };
        formBuilder2.addLabeledComponent(ReactNativeDebuggerBundle.message("react.native.packager.config.command", new Object[0]), (JComponent)this.packagerRunnerPanel).addLabeledComponent((JComponent)this.packagerScriptSelectorLabel, (JComponent)this.packagerScriptSelector).addLabeledComponent((JComponent)this.reactNativeFieldLabel, (JComponent)this.reactNativeField).addLabeledComponent(ReactNativeDebuggerBundle.message("react.native.config.arguments", new Object[0]), (JComponent)this.packagerArgumentsField).addLabeledComponent(ReactNativeDebuggerBundle.message("react.native.config.interpreter", new Object[0]), (JComponent)this.nodeInterpreterField, 12).addLabeledComponent(ReactNativeDebuggerBundle.message("react.native.config.directory", new Object[0]), (JComponent)this.workingDirField).addLabeledComponent(ReactNativeDebuggerBundle.message("react.native.config.env", new Object[0]), (JComponent)this.envVarsComponent);
        ReactNativePackagerConfiguration configuration = ReactNativePackagerConfiguration.Companion.getInstance(this.project);
        if (configuration.getScripts().isEmpty()) {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.BUILT_IN);
        } else {
            this.packagerRunnerModel.setSelected((Enum)PackagerRunner.NPM);
            this.packagerScriptSelector.setTextAndAddToHistory(ParametersListUtil.join(configuration.getScripts()));
        }
        this.packagerArgumentsField.setText(configuration.getArguments());
        NodePackage nodePackage = configuration.getReactNativePackage();
        if (nodePackage != null) {
            NodePackage it = nodePackage;
            boolean bl = false;
            this.reactNativeField.setSelected(it);
        }
        this.nodeInterpreterField.setInterpreterRef(configuration.getNodeInterpreter());
        this.workingDirField.setText(ReactNativeRunConfigurationKt.findEffectiveWorkingDirectory(configuration.getWorkingDirectory(), this.project));
        this.envVarsComponent.setData(configuration.getEnvData());
        this.updatePackagerRunnerVisibility();
        return formBuilder2.getPanel();
    }

    protected void doOKAction() {
        List list;
        if (this.packagerRunnerModel.getSelected() == PackagerRunner.NPM) {
            List list2 = ParametersListUtil.parse((String)this.packagerScriptSelector.getText());
            list = list2;
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"parse(...)");
        } else {
            list = CollectionsKt.emptyList();
        }
        List scripts = list;
        ReactNativePackagerConfiguration configuration = ReactNativePackagerConfiguration.Companion.getInstance(this.project);
        configuration.setScripts(CollectionsKt.toMutableList((Collection)scripts));
        configuration.setArguments(this.packagerArgumentsField.getText());
        NodeJsInterpreterRef nodeJsInterpreterRef = this.nodeInterpreterField.getInterpreterRef();
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterRef, (String)"getInterpreterRef(...)");
        configuration.setNodeInterpreter(nodeJsInterpreterRef);
        configuration.setReactNativePackage(this.reactNativeField.getSelected());
        configuration.setWorkingDirectory(this.workingDirField.getText());
        EnvironmentVariablesData environmentVariablesData = this.envVarsComponent.getData();
        Intrinsics.checkNotNullExpressionValue((Object)environmentVariablesData, (String)"getData(...)");
        configuration.setEnvData(environmentVariablesData);
        super.doOKAction();
    }

    @NotNull
    protected List<ValidationInfo> doValidateAll() {
        List result = new ArrayList();
        try {
            NodeJsLocalInterpreter.checkForRunConfiguration((NodeJsInterpreter)this.nodeInterpreterField.getInterpreter());
        }
        catch (RuntimeConfigurationException e) {
            result.add(new ValidationInfo(e.getLocalizedMessage(), (JComponent)this.nodeInterpreterField));
        }
        if (this.packagerRunnerModel.getSelected() == PackagerRunner.BUILT_IN) {
            if (((CharSequence)this.reactNativeField.getSelected().getSystemDependentPath()).length() == 0) {
                result.add(new ValidationInfo(ReactNativeDebuggerBundle.message("react.native.packager.config.validation.react", new Object[0]), (JComponent)this.reactNativeField));
            }
        } else {
            String string = this.packagerScriptSelector.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (((CharSequence)string).length() == 0) {
                result.add(new ValidationInfo(ReactNativeDebuggerBundle.message("react.native.packager.config.validation.npm", new Object[0]), (JComponent)this.packagerScriptSelector));
            }
        }
        return result;
    }

    private static final String packagerScriptSelector$lambda$0(ReactNativePackagerConfigurationEditor this$0) {
        String[] stringArray = new String[]{this$0.workingDirField.getText(), "package.json"};
        return FileUtil.join((String[])stringArray);
    }

    private static final void createCenterPanel$lambda$0(ReactNativePackagerConfigurationEditor this$0, ActionEvent it) {
        this$0.updatePackagerRunnerVisibility();
    }
}

