/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class AnsiStreamingLexer {
    static final AnsiElementType TEXT = new AnsiElementType("TEXT");
    static final AnsiElementType SGR = new AnsiElementType("SGR");
    static final AnsiElementType CONTROL = new AnsiElementType("CONTROL");
    static final char ESCAPE = '\u001b';
    static final String CSI = "\u001b[";
    static final char SGR_SUFFIX = 'm';
    private String myBuffer = "";
    private int myStartOffset = 0;
    private int myEndOffset = 0;
    private AnsiElementType myElementType = null;

    public void append(@NotNull String text) {
        if (text == null) {
            AnsiStreamingLexer.$$$reportNull$$$0(0);
        }
        this.myBuffer = this.myEndOffset < this.myBuffer.length() ? this.myBuffer.substring(this.myEndOffset) + text : text;
        this.myStartOffset = 0;
        this.myEndOffset = 0;
    }

    @Nullable
    AnsiElementType getElementType() {
        return this.myElementType;
    }

    @Nullable
    String getElementText() {
        return this.myElementType == null ? null : this.myBuffer.substring(this.myStartOffset, this.myEndOffset);
    }

    @Nullable
    String getElementTextSmart() {
        if (this.myElementType == SGR) {
            return this.myBuffer.substring(this.myStartOffset + CSI.length(), this.myEndOffset - 1);
        }
        return this.getElementText();
    }

    @Nullable
    public String getNextText() {
        do {
            this.advance();
            if (this.getElementType() != TEXT) continue;
            return this.getElementText();
        } while (this.getElementType() != null);
        return null;
    }

    void advance() {
        if (this.myEndOffset == this.myBuffer.length()) {
            this.myElementType = null;
            return;
        }
        this.myStartOffset = this.myEndOffset;
        if (this.myBuffer.charAt(this.myEndOffset) != '\u001b') {
            this.advanceToEscape();
            return;
        }
        if (this.myEndOffset + 1 == this.myBuffer.length()) {
            this.incompleteSequence();
            return;
        }
        ++this.myEndOffset;
        if (this.decodeEscapeSequence()) {
            return;
        }
        this.advanceToEscape();
    }

    private void processCSISequence() {
        while (this.myEndOffset < this.myBuffer.length() && AnsiStreamingLexer.isInRange(this.myBuffer.charAt(this.myEndOffset), '0', '?')) {
            ++this.myEndOffset;
        }
        while (this.myEndOffset < this.myBuffer.length() && AnsiStreamingLexer.isInRange(this.myBuffer.charAt(this.myEndOffset), ' ', '/')) {
            ++this.myEndOffset;
        }
        if (this.myEndOffset == this.myBuffer.length()) {
            this.incompleteSequence();
            return;
        }
        char lastChar = this.myBuffer.charAt(this.myEndOffset);
        ++this.myEndOffset;
        if (lastChar == 'm') {
            this.myElementType = SGR;
        } else if ('@' <= lastChar && lastChar <= '~') {
            this.myElementType = CONTROL;
        } else {
            this.advanceToEscape();
        }
    }

    private boolean decodeEscapeSequence() {
        switch (this.myBuffer.charAt(this.myEndOffset)) {
            case '[': {
                ++this.myEndOffset;
                this.processCSISequence();
                return true;
            }
            case '=': {
                this.myElementType = CONTROL;
                ++this.myEndOffset;
                return true;
            }
        }
        return false;
    }

    private void advanceToEscape() {
        int escapeIndex = this.myBuffer.indexOf(27, this.myEndOffset);
        this.myEndOffset = escapeIndex != -1 ? escapeIndex : this.myBuffer.length();
        this.myElementType = TEXT;
    }

    private void incompleteSequence() {
        this.myElementType = null;
        this.myEndOffset = this.myStartOffset;
    }

    private static boolean isInRange(char character, char startRange, char endRange) {
        return startRange <= character && character <= endRange;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/execution/process/AnsiStreamingLexer", "append"));
    }

    static final class AnsiElementType {
        private final String myName;

        private AnsiElementType(String name) {
            this.myName = name;
        }

        public String toString() {
            return "ANSI: " + this.myName;
        }
    }
}

