/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.backend.ed.annotation.attr;

import com.intellij.jpa.jpb.model.backend.ed.annotation.Annotation;
import com.intellij.jpa.jpb.model.backend.ed.indexing.CustomTypeModel;
import com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModel;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.AnnotationModelBuilder;
import com.intellij.jpa.jpb.model.core.backend.ed.annotation.ClassParameter;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0016J\u001a\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0016J\u0018\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00160\u001b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/HibernateJavaTypeAnnotation;", "Lcom/intellij/jpa/jpb/model/backend/ed/annotation/Annotation;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "pluginProjectConfig", "Lcom/intellij/jpa/jpb/model/config/JpaPluginProjectConfig;", "declaredType", "Lcom/intellij/jpa/jpb/model/backend/ed/indexing/HibernateCustomTypeModel;", "isInsert", "", "attribute", "Lcom/intellij/jpa/jpb/model/model/EntityAttribute;", "entity", "Lcom/intellij/jpa/jpb/model/model/Entity;", "generateModel", "Lcom/intellij/jpa/jpb/model/core/backend/ed/annotation/AnnotationModel;", "attr", "getFqn", "", "module", "Lcom/intellij/openapi/module/Module;", "getName", "knownAttributes", "", "Companion", "intellij.javaee.jpa.jpb.model"})
@SourceDebugExtension(value={"SMAP\nHibernateJavaTypeAnnotation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HibernateJavaTypeAnnotation.kt\ncom/intellij/jpa/jpb/model/backend/ed/annotation/attr/HibernateJavaTypeAnnotation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,55:1\n295#2,2:56\n*S KotlinDebug\n*F\n+ 1 HibernateJavaTypeAnnotation.kt\ncom/intellij/jpa/jpb/model/backend/ed/annotation/attr/HibernateJavaTypeAnnotation\n*L\n29#1:56,2\n*E\n"})
public final class HibernateJavaTypeAnnotation
extends Annotation {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final JpaPluginProjectConfig pluginProjectConfig;
    @Nullable
    private HibernateCustomTypeModel declaredType;
    @NotNull
    public static final String FQN = "org.hibernate.annotations.JavaType";
    @NotNull
    public static final String NAME = "JavaType";

    public HibernateJavaTypeAnnotation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.pluginProjectConfig = JpaPluginProjectConfig.Companion.getInstance(this.project);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isInsert(@NotNull EntityAttribute attribute, @NotNull Entity entity) {
        Object v3;
        block5: {
            void $this$firstOrNull$iv;
            Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            if (this.pluginProjectConfig == null) {
                return false;
            }
            if (!(attribute.getConverter() instanceof HibernateCustomTypeModel)) {
                return false;
            }
            CustomTypeModel customTypeModel = attribute.getConverter();
            Intrinsics.checkNotNull((Object)customTypeModel, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel");
            PsiClass psiClass = ((HibernateCustomTypeModel)customTypeModel).getTypeClass();
            if (psiClass == null) {
                return false;
            }
            PsiClass typeClass = psiClass;
            if (!InheritanceUtil.isInheritor((PsiClass)typeClass, (String)"org.hibernate.type.descriptor.java.BasicJavaType")) {
                return false;
            }
            List<HibernateCustomTypeModel> list = entity.getHibernateTypes();
            Intrinsics.checkNotNullExpressionValue(list, (String)"getHibernateTypes(...)");
            Iterable iterable = list;
            HibernateJavaTypeAnnotation hibernateJavaTypeAnnotation = this;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                HibernateCustomTypeModel it = (HibernateCustomTypeModel)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getTypeClass(), (Object)typeClass)) continue;
                v3 = element$iv;
                break block5;
            }
            v3 = null;
        }
        hibernateJavaTypeAnnotation.declaredType = v3;
        return this.declaredType != null || !this.pluginProjectConfig.getState().generateTypeOnEntity;
    }

    @Override
    @NotNull
    public AnnotationModel generateModel(@NotNull EntityAttribute attr, @NotNull Entity entity, @NotNull Project project) {
        Object fqn;
        Intrinsics.checkNotNullParameter((Object)attr, (String)"attr");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AnnotationModelBuilder builder = new AnnotationModelBuilder(FQN);
        CustomTypeModel customTypeModel = attr.getConverter();
        Intrinsics.checkNotNull((Object)customTypeModel, (String)"null cannot be cast to non-null type com.intellij.jpa.jpb.model.backend.ed.indexing.HibernateCustomTypeModel");
        HibernateCustomTypeModel converter = (HibernateCustomTypeModel)customTypeModel;
        Object object = this.declaredType;
        if (object == null || (object = ((HibernateCustomTypeModel)object).getName()) == null) {
            PsiClass psiClass = converter.getTypeClass();
            object = psiClass != null ? psiClass.getQualifiedName() : null;
        }
        if ((fqn = object) != null) {
            builder.add("value", new ClassParameter((String)fqn));
        }
        return builder.build();
    }

    @Override
    @NotNull
    public String getFqn(@NotNull Project project, @Nullable Module module) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return FQN;
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public List<String> knownAttributes(@Nullable EntityAttribute attribute) {
        Object[] objectArray = new String[]{"value"};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/jpa/jpb/model/backend/ed/annotation/attr/HibernateJavaTypeAnnotation$Companion;", "", "<init>", "()V", "FQN", "", "NAME", "intellij.javaee.jpa.jpb.model"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

