/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.complition;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.jpa.jpb.model.complition.JpbLookupElements;
import com.intellij.jpa.jpb.model.util.AttributeUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassPropertyCompletionHelper {
    public static LookupElement createLookupElement(PsiField property) {
        String className = ClassPropertyCompletionHelper.getFieldType((PsiMember)property);
        return JpbLookupElements.element(property.getName(), className);
    }

    public static LookupElement createLookupElement(PsiMethod method) {
        PsiType returnType = method.getReturnType();
        String typeText = returnType != null ? returnType.getPresentableText() : "";
        String fieldName = ClassPropertyCompletionHelper.toFieldName(method.getName());
        return JpbLookupElements.element(fieldName, typeText);
    }

    private static String toFieldName(String name) {
        String getPrefix = "get";
        if (name.startsWith("get")) {
            String restPart = name.substring("get".length());
            if (!restPart.isEmpty() && Character.isUpperCase(restPart.charAt(0))) {
                return Character.toLowerCase(restPart.charAt(0)) + restPart.substring(1);
            }
            return restPart;
        }
        return name;
    }

    public static String getFieldType(@NotNull PsiMember member) {
        PsiMethod[] getters;
        PsiType fieldType;
        if (member == null) {
            ClassPropertyCompletionHelper.$$$reportNull$$$0(0);
        }
        if ((fieldType = AttributeUtil.getMemberType(member)) == null) {
            return "<unknown>";
        }
        String fieldTypeName = fieldType.getPresentableText();
        PsiClass containingClass = member.getContainingClass();
        if (containingClass == null) {
            return fieldTypeName;
        }
        for (PsiMethod getter : getters = containingClass.findMethodsByName("get" + StringUtil.capitalize((String)member.getName()), false)) {
            String getterTypeName;
            if (getter.getParameterList().getParametersCount() != 0) continue;
            PsiType returnType = getter.getReturnType();
            if (returnType == null || fieldTypeName.equals(getterTypeName = returnType.getPresentableText())) break;
            return String.format("%s (%s)", fieldTypeName, getterTypeName);
        }
        return fieldTypeName;
    }

    @Nullable
    public static LookupElementBuilder createLookupElement(PsiClass psiClass) {
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName == null) {
            return null;
        }
        Object packageName = ClassUtil.extractPackageName((String)qualifiedName);
        if (!StringUtils.isEmpty((CharSequence)packageName)) {
            packageName = "(" + (String)packageName + ")";
        }
        return LookupElementBuilder.create((String)psiClass.getQualifiedName()).withLookupStrings(Arrays.asList(psiClass.getQualifiedName(), psiClass.getName())).withPresentableText(psiClass.getName()).withIcon(AllIcons.Nodes.Class).withTypeText((String)packageName, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/jpa/jpb/model/complition/ClassPropertyCompletionHelper", "getFieldType"));
    }
}

