/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.NonExtendable
@ApiStatus.Experimental
public interface NullabilitySource {
    default public NullabilitySource inherited() {
        return new ExtendsBound(this);
    }

    @NotNull
    public static NullabilitySource multiSource(@NotNull @NotNull Collection<@NotNull NullabilitySource> sources) {
        if (sources == null) {
            NullabilitySource.$$$reportNull$$$0(0);
        }
        LinkedHashSet<NullabilitySource> set = new LinkedHashSet<NullabilitySource>();
        for (NullabilitySource source : sources) {
            if (source instanceof MultiSource) {
                set.addAll(((MultiSource)source).sources());
                continue;
            }
            if (source == Standard.NONE) continue;
            set.add(source);
        }
        if (set.isEmpty()) {
            Standard standard = Standard.NONE;
            if (standard == null) {
                NullabilitySource.$$$reportNull$$$0(1);
            }
            return standard;
        }
        if (set.size() == 1) {
            NullabilitySource nullabilitySource = (NullabilitySource)set.iterator().next();
            if (nullabilitySource == null) {
                NullabilitySource.$$$reportNull$$$0(2);
            }
            return nullabilitySource;
        }
        return new MultiSource(set);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullabilitySource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullabilitySource";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "multiSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "multiSource";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class ExtendsBound
    implements NullabilitySource {
        @NotNull
        private final NullabilitySource myBoundSource;

        public ExtendsBound(@NotNull NullabilitySource source) {
            if (source == null) {
                ExtendsBound.$$$reportNull$$$0(0);
            }
            this.myBoundSource = source;
        }

        @NotNull
        public NullabilitySource boundSource() {
            NullabilitySource nullabilitySource = this.myBoundSource;
            if (nullabilitySource == null) {
                ExtendsBound.$$$reportNull$$$0(1);
            }
            return nullabilitySource;
        }

        @Override
        public ExtendsBound inherited() {
            return this;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtendsBound bound = (ExtendsBound)o;
            return this.myBoundSource.equals(bound.myBoundSource);
        }

        public int hashCode() {
            return this.myBoundSource.hashCode();
        }

        public String toString() {
            return "inherited " + this.myBoundSource;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "source";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/NullabilitySource$ExtendsBound";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/NullabilitySource$ExtendsBound";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "boundSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class MultiSource
    implements NullabilitySource {
        @NotNull
        private final @NotNull Set<@NotNull NullabilitySource> mySources;

        MultiSource(@NotNull @NotNull Set<@NotNull NullabilitySource> sources) {
            if (sources == null) {
                MultiSource.$$$reportNull$$$0(0);
            }
            if (sources.size() <= 1) {
                throw new IllegalArgumentException("MultiSource must have at least two sources");
            }
            this.mySources = sources;
        }

        @NotNull
        public @NotNull Set<@NotNull NullabilitySource> sources() {
            Set<NullabilitySource> set = this.mySources;
            if (set == null) {
                MultiSource.$$$reportNull$$$0(1);
            }
            return set;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MultiSource source = (MultiSource)o;
            return this.mySources.equals(source.mySources);
        }

        public int hashCode() {
            return this.mySources.hashCode();
        }

        public String toString() {
            return this.mySources.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/NullabilitySource$MultiSource";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/NullabilitySource$MultiSource";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static enum Standard implements NullabilitySource
    {
        NONE{

            @Override
            public NullabilitySource inherited() {
                return this;
            }
        }
        ,
        MANDATED,
        LANGUAGE_DEFINED;

    }

    public static final class ContainerAnnotation
    implements NullabilitySource {
        @NotNull
        private final PsiAnnotation myAnnotation;

        public ContainerAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                ContainerAnnotation.$$$reportNull$$$0(0);
            }
            this.myAnnotation = annotation;
            this.container();
        }

        @NotNull
        public PsiModifierListOwner container() {
            PsiModifierList modifierList = (PsiModifierList)Objects.requireNonNull(this.myAnnotation.getOwner(), "Annotation has no owner");
            PsiElement owner = Objects.requireNonNull(modifierList.getParent(), "Modifier list has no parent");
            if (owner instanceof PsiModifierListOwner) {
                PsiModifierListOwner member = (PsiModifierListOwner)owner;
                if (member.getModifierList() != modifierList) {
                    throw new IllegalStateException("Modifier list parent is incorrect");
                }
                PsiModifierListOwner psiModifierListOwner = member;
                if (psiModifierListOwner == null) {
                    ContainerAnnotation.$$$reportNull$$$0(1);
                }
                return psiModifierListOwner;
            }
            if (owner instanceof PsiPackageStatement) {
                PsiPackageStatement packageStatement = (PsiPackageStatement)owner;
                if (packageStatement.getAnnotationList() != modifierList) {
                    throw new IllegalStateException("Modifier list parent is incorrect");
                }
                String packageName = packageStatement.getPackageName();
                if (packageName == null) {
                    throw new IllegalStateException("Package name is empty");
                }
                PsiPackage psiPackage = JavaPsiFacade.getInstance(packageStatement.getProject()).findPackage(packageName);
                if (psiPackage == null) {
                    throw new IllegalStateException("Package reference is not resolved");
                }
                PsiPackage psiPackage2 = psiPackage;
                if (psiPackage2 == null) {
                    ContainerAnnotation.$$$reportNull$$$0(2);
                }
                return psiPackage2;
            }
            throw new IllegalStateException("Unsupported modifier list parent: " + owner.getClass().getName());
        }

        @NotNull
        public PsiAnnotation annotation() {
            PsiAnnotation psiAnnotation = this.myAnnotation;
            if (psiAnnotation == null) {
                ContainerAnnotation.$$$reportNull$$$0(3);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ContainerAnnotation that = (ContainerAnnotation)o;
            return this.myAnnotation.equals(that.myAnnotation);
        }

        public int hashCode() {
            return this.myAnnotation.hashCode();
        }

        public String toString() {
            PsiModifierListOwner container = this.container();
            String containerInfo = container instanceof PsiClass ? "class " + ((PsiClass)container).getName() : (container instanceof PsiField ? "field " + ((PsiField)container).getName() : (container instanceof PsiMethod ? "method " + ((PsiMethod)container).getName() : (container instanceof PsiPackage ? "package " + ((PsiPackage)container).getName() : (container instanceof PsiJavaModule ? "module " + ((PsiJavaModule)container).getName() : container.getClass().getSimpleName()))));
            PsiJavaCodeReferenceElement ref = this.annotation().getNameReferenceElement();
            String annotationInfo = ref == null ? "@<unknown>" : "@" + ref.getReferenceName();
            return annotationInfo + " on " + containerInfo;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/NullabilitySource$ContainerAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/NullabilitySource$ContainerAnnotation";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "container";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "annotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ExplicitAnnotation
    implements NullabilitySource {
        @NotNull
        private final PsiAnnotation myAnnotation;

        public ExplicitAnnotation(@NotNull PsiAnnotation annotation) {
            if (annotation == null) {
                ExplicitAnnotation.$$$reportNull$$$0(0);
            }
            this.myAnnotation = annotation;
        }

        @NotNull
        public PsiAnnotation annotation() {
            PsiAnnotation psiAnnotation = this.myAnnotation;
            if (psiAnnotation == null) {
                ExplicitAnnotation.$$$reportNull$$$0(1);
            }
            return psiAnnotation;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExplicitAnnotation that = (ExplicitAnnotation)o;
            return this.myAnnotation.equals(that.myAnnotation);
        }

        public int hashCode() {
            return this.myAnnotation.hashCode();
        }

        public String toString() {
            PsiJavaCodeReferenceElement ref = this.annotation().getNameReferenceElement();
            if (ref == null) {
                return "@<unknown>";
            }
            return "@" + ref.getReferenceName();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInsight/NullabilitySource$ExplicitAnnotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInsight/NullabilitySource$ExplicitAnnotation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "annotation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

