/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.syntax.parser;

import com.intellij.java.syntax.JavaSyntaxBundle;
import com.intellij.java.syntax.element.JavaSyntaxElementType;
import com.intellij.java.syntax.element.JavaSyntaxTokenType;
import com.intellij.java.syntax.element.WhiteSpaceAndCommentSetHolder;
import com.intellij.java.syntax.parser.DeclarationParser;
import com.intellij.java.syntax.parser.FileParserKt;
import com.intellij.java.syntax.parser.JavaParser;
import com.intellij.java.syntax.parser.JavaParserUtil;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.i18n.ResourceBundle;
import com.intellij.platform.syntax.parser.SyntaxTreeBuilder;
import com.intellij.platform.syntax.util.parser.SyntaxBuilderUtil;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J2\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\tH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J0\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\r0\u00182\u0006\u0010\b\u001a\u00020\t2\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\r0\fH\u0004J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00152\u0006\u0010\b\u001a\u00020\tH\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/intellij/java/syntax/parser/FileParser;", "", "myParser", "Lcom/intellij/java/syntax/parser/JavaParser;", "<init>", "(Lcom/intellij/java/syntax/parser/JavaParser;)V", "parse", "", "builder", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder;", "parseFile", "importListStopper", "Lkotlin/Function1;", "", "bundle", "Lcom/intellij/platform/syntax/i18n/ResourceBundle;", "errorMessageKey", "", "stopImportListParsing", "b", "parseInitial", "Lcom/intellij/platform/syntax/parser/SyntaxTreeBuilder$Marker;", "parsePackageStatement", "parseImportList", "Lkotlin/Pair;", "stopper", "parseImportStatement", "getImportType", "Lcom/intellij/platform/syntax/SyntaxElementType;", "intellij.java.syntax"})
public class FileParser {
    @NotNull
    private final JavaParser myParser;

    public FileParser(@NotNull JavaParser myParser) {
        this.myParser = myParser;
    }

    public void parse(@NotNull SyntaxTreeBuilder builder) {
        this.parseFile(builder, (Function1<? super SyntaxTreeBuilder, Boolean>)((Function1)arg_0 -> FileParser.parse$lambda$0(this, arg_0)), JavaSyntaxBundle.INSTANCE.getResourceBundle(), "expected.class.or.interface");
    }

    public final void parseFile(@NotNull SyntaxTreeBuilder builder, @NotNull Function1<? super SyntaxTreeBuilder, Boolean> importListStopper, @NotNull ResourceBundle bundle, @NotNull String errorMessageKey) {
        this.parsePackageStatement(builder);
        Pair<SyntaxTreeBuilder.Marker, Boolean> impListInfo = this.parseImportList(builder, importListStopper);
        Boolean firstDeclarationOk = null;
        SyntaxTreeBuilder.Marker firstDeclaration = null;
        SyntaxTreeBuilder.Marker invalidElements = null;
        boolean isImplicitClass = false;
        while (!builder.eof()) {
            SyntaxTreeBuilder.Marker declaration;
            if (builder.getTokenType() == JavaSyntaxTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            SyntaxTreeBuilder.Marker marker = this.myParser.getModuleParser().parse(builder);
            if (marker == null) {
                marker = this.parseInitial(builder);
            }
            if ((declaration = marker) != null) {
                if (invalidElements != null) {
                    invalidElements.errorBefore(bundle.message(errorMessageKey, new Object[0]), declaration);
                    invalidElements = null;
                }
                if (firstDeclarationOk == null) {
                    firstDeclarationOk = JavaParserUtil.INSTANCE.exprType(declaration) != JavaSyntaxElementType.MODIFIER_LIST;
                }
                if (firstDeclaration == null) {
                    firstDeclaration = declaration;
                }
                if (isImplicitClass || !FileParserKt.access$getIMPLICIT_CLASS_INDICATORS$p().containsNullable(JavaParserUtil.INSTANCE.exprType(declaration))) continue;
                isImplicitClass = true;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
            if (firstDeclarationOk != null) continue;
            firstDeclarationOk = false;
        }
        SyntaxTreeBuilder.Marker marker = invalidElements;
        if (marker != null) {
            marker.error(bundle.message(errorMessageKey, new Object[0]));
        }
        if (((Boolean)impListInfo.getSecond()).booleanValue() && Intrinsics.areEqual(firstDeclarationOk, (Object)true)) {
            ((SyntaxTreeBuilder.Marker)impListInfo.getFirst()).setCustomEdgeTokenBinders(WhiteSpaceAndCommentSetHolder.INSTANCE.getPrecedingCommentBinder(this.myParser.getLanguageLevel()), null);
            SyntaxTreeBuilder.Marker marker2 = firstDeclaration;
            Intrinsics.checkNotNull((Object)marker2);
            marker2.setCustomEdgeTokenBinders(WhiteSpaceAndCommentSetHolder.INSTANCE.getSpecialPrecedingCommentBinder(this.myParser.getLanguageLevel()), null);
        }
        if (isImplicitClass) {
            SyntaxTreeBuilder.Marker marker3 = firstDeclaration;
            Intrinsics.checkNotNull(marker3);
            SyntaxTreeBuilder.Marker beforeFirst = marker3.precede();
            JavaParserUtil.INSTANCE.done(beforeFirst, JavaSyntaxElementType.IMPLICIT_CLASS, this.myParser.getLanguageLevel());
        }
    }

    private final boolean stopImportListParsing(SyntaxTreeBuilder b) {
        String text;
        SyntaxElementType type = b.getTokenType();
        if (FileParserKt.getIMPORT_LIST_STOPPER_SET().containsNullable(type) || this.myParser.getDeclarationParser().isRecordToken(b, type)) {
            return true;
        }
        return type == JavaSyntaxTokenType.IDENTIFIER && (Intrinsics.areEqual((Object)(text = b.getTokenText()), (Object)"open") || Intrinsics.areEqual((Object)text, (Object)"module"));
    }

    @Nullable
    protected SyntaxTreeBuilder.Marker parseInitial(@NotNull SyntaxTreeBuilder builder) {
        return this.myParser.getDeclarationParser().parse(builder, DeclarationParser.Context.FILE);
    }

    private final void parsePackageStatement(SyntaxTreeBuilder builder) {
        SyntaxTreeBuilder.Marker statement = builder.mark();
        SyntaxTreeBuilder.Marker modList = builder.mark();
        if (!Intrinsics.areEqual((Object)builder.getTokenType(), (Object)JavaSyntaxTokenType.PACKAGE_KEYWORD)) {
            this.myParser.getDeclarationParser().parseAnnotations(builder);
        }
        JavaParserUtil.INSTANCE.done(modList, JavaSyntaxElementType.MODIFIER_LIST, this.myParser.getLanguageLevel());
        if (!SyntaxBuilderUtil.expect((SyntaxTreeBuilder)builder, (SyntaxElementType)JavaSyntaxTokenType.PACKAGE_KEYWORD)) {
            statement.rollbackTo();
            return;
        }
        SyntaxTreeBuilder.Marker ref = this.myParser.getReferenceParser().parseJavaCodeReference(builder, true, false, false, false);
        if (ref == null) {
            statement.error(JavaSyntaxBundle.message("expected.class.or.interface", new Object[0]));
            return;
        }
        JavaParserUtil.INSTANCE.semicolon(builder);
        JavaParserUtil.INSTANCE.done(statement, JavaSyntaxElementType.PACKAGE_STATEMENT, this.myParser.getLanguageLevel());
    }

    @NotNull
    protected final Pair<SyntaxTreeBuilder.Marker, Boolean> parseImportList(@NotNull SyntaxTreeBuilder builder, @NotNull Function1<? super SyntaxTreeBuilder, Boolean> stopper) {
        SyntaxTreeBuilder.Marker list = builder.mark();
        boolean isEmpty = true;
        SyntaxTreeBuilder.Marker invalidElements = null;
        while (!builder.eof() && !((Boolean)stopper.invoke((Object)builder)).booleanValue()) {
            if (builder.getTokenType() == JavaSyntaxTokenType.SEMICOLON) {
                builder.advanceLexer();
                continue;
            }
            SyntaxTreeBuilder.Marker statement = this.parseImportStatement(builder);
            if (statement != null) {
                isEmpty = false;
                if (invalidElements == null) continue;
                invalidElements.errorBefore(JavaSyntaxBundle.message("unexpected.token", new Object[0]), statement);
                invalidElements = null;
                continue;
            }
            if (invalidElements == null) {
                invalidElements = builder.mark();
            }
            builder.advanceLexer();
        }
        SyntaxTreeBuilder.Marker marker = invalidElements;
        if (marker != null) {
            marker.rollbackTo();
        }
        if (isEmpty) {
            SyntaxTreeBuilder.Marker precede = list.precede();
            list.rollbackTo();
            list = precede;
        }
        JavaParserUtil.INSTANCE.done(list, JavaSyntaxElementType.IMPORT_LIST, this.myParser.getLanguageLevel());
        return new Pair((Object)list, (Object)isEmpty);
    }

    @Nullable
    protected final SyntaxTreeBuilder.Marker parseImportStatement(@NotNull SyntaxTreeBuilder builder) {
        boolean isOk;
        boolean isModule;
        if (builder.getTokenType() != JavaSyntaxTokenType.IMPORT_KEYWORD) {
            return null;
        }
        SyntaxTreeBuilder.Marker statement = builder.mark();
        builder.advanceLexer();
        String identifierText = builder.getTokenText();
        SyntaxElementType type = this.getImportType(builder);
        boolean isStatic = type == JavaSyntaxElementType.IMPORT_STATIC_STATEMENT;
        boolean bl = isModule = type == JavaSyntaxElementType.IMPORT_MODULE_STATEMENT;
        boolean bl2 = isModule ? this.myParser.getModuleParser().parseName(builder) != null : (isOk = this.myParser.getReferenceParser().parseImportCodeReference(builder, isStatic));
        if (isOk && !isModule && !isStatic && builder.getTokenType() != JavaSyntaxTokenType.SEMICOLON && Intrinsics.areEqual((Object)identifierText, (Object)"module")) {
            JavaParserUtil.error(builder, JavaSyntaxBundle.message("expected.identifier.or.semicolon", new Object[0]));
        } else if (isOk) {
            JavaParserUtil.INSTANCE.semicolon(builder);
        }
        JavaParserUtil.INSTANCE.done(statement, type, this.myParser.getLanguageLevel());
        return statement;
    }

    private final SyntaxElementType getImportType(SyntaxTreeBuilder builder) {
        SyntaxElementType type = builder.getTokenType();
        if (type == JavaSyntaxTokenType.STATIC_KEYWORD) {
            builder.advanceLexer();
            return JavaSyntaxElementType.IMPORT_STATIC_STATEMENT;
        }
        if (type == JavaSyntaxTokenType.IDENTIFIER && Intrinsics.areEqual((Object)builder.getTokenText(), (Object)"module") && builder.lookAhead(1) == JavaSyntaxTokenType.IDENTIFIER) {
            builder.remapCurrentToken(JavaSyntaxTokenType.MODULE_KEYWORD);
            builder.advanceLexer();
            return JavaSyntaxElementType.IMPORT_MODULE_STATEMENT;
        }
        return JavaSyntaxElementType.IMPORT_STATEMENT;
    }

    private static final boolean parse$lambda$0(FileParser this$0, SyntaxTreeBuilder b) {
        return this$0.stopImportListParsing(b);
    }
}

