/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.ExpressionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Predicates;
import com.intellij.psi.ImplicitVariable;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPatternVariable;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchBlock;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchLabelStatementBase;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.augment.PsiAugmentProvider;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.CallInstruction;
import com.intellij.psi.controlFlow.ConditionalBranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalGoToInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowInstructionVisitor;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.InstructionClientVisitor;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.controlFlow.ReadVariableInstruction;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ReturnStatementsVisitor;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.controlFlow.WriteVariableInstruction;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UnmodifiableHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ControlFlowUtil {
    private static final Logger LOG = Logger.getInstance(ControlFlowUtil.class);
    public static final Class<? extends PsiStatement>[] DEFAULT_EXIT_STATEMENTS_CLASSES = new Class[]{PsiReturnStatement.class, PsiBreakStatement.class, PsiContinueStatement.class};
    public static final int NORMAL_COMPLETION_REASON = 1;
    private static final int RETURN_COMPLETION_REASON = 2;

    @Nullable
    public static PsiElement getScopeEnforcingEffectiveFinality(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        PsiElement[] scope;
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(0);
        }
        if (context == null) {
            ControlFlowUtil.$$$reportNull$$$0(1);
        }
        if ((scope = ControlFlowUtil.getVariableScope(variable)).length < 1 || scope[0] == null || scope[0].getContainingFile() != context.getContainingFile()) {
            return null;
        }
        PsiElement prevParent = context;
        block0: for (PsiElement parent = context.getParent(); parent != null; parent = parent.getParent()) {
            for (PsiElement scopeElement : scope) {
                if (parent.equals((Object)scopeElement)) break block0;
            }
            if (!(!(parent instanceof PsiClass) || prevParent instanceof PsiExpressionList && parent instanceof PsiAnonymousClass)) {
                return parent;
            }
            if (parent instanceof PsiLambdaExpression) {
                return parent;
            }
            if (parent instanceof PsiSwitchLabelStatementBase && ((PsiSwitchLabelStatementBase)parent).getGuardExpression() == prevParent) {
                return parent;
            }
            prevParent = parent;
        }
        return null;
    }

    private static PsiElement @NotNull [] getVariableScope(@NotNull PsiVariable variable) {
        PsiElement[] scope;
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(2);
        }
        if (variable instanceof PsiResourceVariable) {
            scope = ((PsiResourceVariable)variable).getDeclarationScope();
        } else if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            scope = new PsiElement[]{parent != null ? parent.getParent() : null};
        } else {
            scope = variable instanceof PsiParameter ? new PsiElement[]{((PsiParameter)variable).getDeclarationScope()} : new PsiElement[]{variable.getParent()};
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(3);
        }
        return scope;
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(5);
        }
        return ControlFlowUtil.isEffectivelyFinal(variable, scope, null);
    }

    public static boolean isEffectivelyFinal(@NotNull PsiVariable variable, @NotNull PsiElement scope, @Nullable PsiJavaCodeReferenceElement context) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(6);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(7);
        }
        if (variable instanceof PsiParameter) {
            return !ControlFlowUtil.variableIsAssigned(variable, ((PsiParameter)variable).getDeclarationScope());
        }
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable, (PsiElement)context);
        if (codeBlock == null) {
            return true;
        }
        Collection result = (Collection)CachedValuesManager.getCachedValue((PsiElement)codeBlock, () -> {
            ControlFlow flow = ControlFlowUtil.getControlFlow(codeBlock);
            List initializedTwice = flow == null ? Collections.emptyList() : ControlFlowUtil.addReassignedInLoopProblems(ControlFlowUtil.getInitializedTwice(flow), flow);
            return new CachedValueProvider.Result(initializedTwice, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return !result.contains(new VariableInfo(variable, null)) && !ControlFlowUtil.variableIsAssigned(variable, scope);
    }

    @Nullable
    private static ControlFlow getControlFlow(PsiElement codeBlock) {
        try {
            LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
            return ControlFlowFactory.getControlFlow(codeBlock, policy, ControlFlowOptions.create(true, true, true));
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    private static boolean variableIsAssigned(@NotNull PsiVariable variable, @NotNull PsiElement scope) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(8);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(9);
        }
        return !PsiTreeUtil.processElements((PsiElement)scope, PsiReferenceExpression.class, e -> !PsiUtil.isAccessedForWriting(e) || !e.isReferenceTo(variable));
    }

    public static boolean isFieldInitializedAfterObjectConstruction(@NotNull PsiField field) {
        if (field == null) {
            ControlFlowUtil.$$$reportNull$$$0(10);
        }
        if (field.hasInitializer()) {
            return true;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiClass aClass = field.getContainingClass();
        if (aClass == null) {
            return false;
        }
        if (ControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, Predicates.alwaysTrue())) {
            return true;
        }
        if (ControlFlowUtil.isFieldInitializedInClassInitializer(field)) {
            return true;
        }
        if (isFieldStatic) {
            return false;
        }
        PsiMethod[] constructors = aClass.getConstructors();
        if (constructors.length == 0) {
            return false;
        }
        block0: for (PsiMethod constructor : constructors) {
            PsiCodeBlock ctrBody = constructor.getBody();
            if (ctrBody == null) {
                return false;
            }
            for (PsiMethod redirectedConstructor : JavaPsiConstructorUtil.getChainedConstructors(constructor)) {
                PsiCodeBlock body = redirectedConstructor.getBody();
                if (body == null || !ControlFlowUtil.variableDefinitelyAssignedIn(field, body, true)) continue;
                continue block0;
            }
            if (!ctrBody.isValid() || ControlFlowUtil.variableDefinitelyAssignedIn(field, ctrBody, true)) continue;
            return false;
        }
        return true;
    }

    private static boolean isFieldInitializedInClassInitializer(@NotNull PsiField field) {
        boolean isFieldStatic;
        PsiClass aClass;
        if (field == null) {
            ControlFlowUtil.$$$reportNull$$$0(11);
        }
        if ((aClass = field.getContainingClass()) == null) {
            return false;
        }
        Object[] initializers = aClass.getInitializers();
        return ContainerUtil.find((Object[])initializers, arg_0 -> ControlFlowUtil.lambda$isFieldInitializedInClassInitializer$2(isFieldStatic = field.hasModifierProperty("static"), field, arg_0)) != null;
    }

    private static boolean isFieldInitializedInOtherFieldInitializer(@NotNull PsiClass aClass, @NotNull PsiField field, @NotNull Predicate<? super PsiField> condition) {
        if (aClass == null) {
            ControlFlowUtil.$$$reportNull$$$0(12);
        }
        if (field == null) {
            ControlFlowUtil.$$$reportNull$$$0(13);
        }
        if (condition == null) {
            ControlFlowUtil.$$$reportNull$$$0(14);
        }
        boolean fieldStatic = field.hasModifierProperty("static");
        for (PsiField psiField : aClass.getFields()) {
            if (psiField == field || psiField.hasModifierProperty("static") != fieldStatic || !ControlFlowUtil.variableDefinitelyAssignedIn(field, psiField, true) || !condition.test(psiField)) continue;
            return true;
        }
        return false;
    }

    private static PsiField findEnclosingFieldInitializer(@NotNull PsiElement entry) {
        if (entry == null) {
            ControlFlowUtil.$$$reportNull$$$0(15);
        }
        PsiElement element = entry;
        while (element != null) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiField) {
                PsiField field = (PsiField)parent;
                if (element == field.getInitializer()) {
                    return field;
                }
                if (field instanceof PsiEnumConstant && element == ((PsiEnumConstant)field).getArgumentList()) {
                    return field;
                }
            }
            if (element instanceof PsiClass || element instanceof PsiMethod) {
                return null;
            }
            element = parent;
        }
        return null;
    }

    public static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement scope) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(16);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(17);
        }
        return ControlFlowUtil.variableDefinitelyAssignedIn(variable, scope, false);
    }

    private static boolean variableDefinitelyAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement scope, boolean resultOnIncompleteCode) {
        ControlFlow flow;
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(18);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(19);
        }
        return (flow = ControlFlowUtil.getControlFlow(scope)) == null ? resultOnIncompleteCode : ControlFlowUtil.isVariableDefinitelyAssigned(variable, flow);
    }

    public static boolean isInitializedBeforeUsage(@NotNull PsiReferenceExpression expression, @NotNull PsiVariable variable, @NotNull Map<? super PsiElement, Collection<PsiReferenceExpression>> uninitializedVarProblems, boolean treatNonFinalFieldsAsNonInitialized) {
        Collection<PsiReferenceExpression> codeBlockProblems;
        if (expression == null) {
            ControlFlowUtil.$$$reportNull$$$0(20);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(21);
        }
        if (uninitializedVarProblems == null) {
            ControlFlowUtil.$$$reportNull$$$0(22);
        }
        if (variable instanceof ImplicitVariable) {
            return true;
        }
        if (!PsiUtil.isAccessedForReading(expression)) {
            return true;
        }
        int startOffset = expression.getTextRange().getStartOffset();
        PsiElement topBlock = ControlFlowUtil.getTopBlock(expression, variable);
        if (topBlock == null) {
            return true;
        }
        if (!variable.hasInitializer() && variable instanceof PsiField) {
            PsiClass aClass;
            PsiCodeBlock block;
            PsiField field = (PsiField)variable;
            if (!treatNonFinalFieldsAsNonInitialized && !variable.hasModifierProperty("final")) {
                return true;
            }
            if (PsiUtil.findEnclosingConstructorOrInitializer(expression) == null && ControlFlowUtil.findEnclosingFieldInitializer(expression) == null) {
                return true;
            }
            PsiElement parent = topBlock.getParent();
            if (ControlFlowUtil.inInnerClass(expression, field.getContainingClass())) {
                return true;
            }
            if (parent instanceof PsiMethod) {
                PsiMethod constructor = (PsiMethod)parent;
                if (!constructor.getManager().areElementsEquivalent((PsiElement)constructor.getContainingClass(), (PsiElement)field.getContainingClass())) {
                    return true;
                }
                if (variable.hasModifierProperty("static")) {
                    return true;
                }
                for (PsiMethod redirectedConstructor : JavaPsiConstructorUtil.getChainedConstructors(constructor)) {
                    if (JavaPsiRecordUtil.isCompactConstructor(redirectedConstructor)) {
                        return true;
                    }
                    PsiCodeBlock body = redirectedConstructor.getBody();
                    if (body == null || !ControlFlowUtil.variableDefinitelyAssignedIn(variable, body, true)) continue;
                    return true;
                }
                block = constructor.getBody();
                aClass = constructor.getContainingClass();
            } else if (parent instanceof PsiClassInitializer) {
                PsiClassInitializer classInitializer = (PsiClassInitializer)parent;
                if (!classInitializer.getManager().areElementsEquivalent((PsiElement)classInitializer.getContainingClass(), (PsiElement)field.getContainingClass())) {
                    return true;
                }
                block = classInitializer.getBody();
                aClass = classInitializer.getContainingClass();
                if (aClass == null || ControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, f -> startOffset > f.getTextOffset())) {
                    return true;
                }
            } else {
                aClass = field.getContainingClass();
                PsiField anotherField = (PsiField)PsiTreeUtil.getTopmostParentOfType((PsiElement)expression, PsiField.class);
                if (aClass == null || ControlFlowUtil.isFieldInitializedInOtherFieldInitializer(aClass, field, f -> f != anotherField && startOffset > f.getTextOffset())) {
                    return true;
                }
                if (anotherField != null && !anotherField.hasModifierProperty("static") && field.hasModifierProperty("static") && ControlFlowUtil.isFieldInitializedInClassInitializer(field)) {
                    return true;
                }
                if (anotherField != null && anotherField.hasInitializer() && !PsiAugmentProvider.canTrustFieldInitializer(anotherField)) {
                    return true;
                }
                int offset = startOffset;
                if (anotherField != null && anotherField.getContainingClass() == aClass && !field.hasModifierProperty("static")) {
                    offset = 0;
                }
                block = null;
                for (PsiMethod constructor : aClass.getConstructors()) {
                    if (offset < constructor.getTextRange().getStartOffset()) continue;
                    PsiCodeBlock body = constructor.getBody();
                    if (body != null && ControlFlowUtil.variableDefinitelyAssignedIn(variable, body)) {
                        return true;
                    }
                    for (PsiMethod redirectedConstructor : JavaPsiConstructorUtil.getChainedConstructors(constructor)) {
                        PsiCodeBlock redirectedBody;
                        if (offset < redirectedConstructor.getTextRange().getStartOffset() || (redirectedBody = redirectedConstructor.getBody()) == null || !ControlFlowUtil.variableDefinitelyAssignedIn(variable, redirectedBody)) continue;
                        return true;
                    }
                }
            }
            if (aClass != null) {
                PsiClassInitializer initializer;
                PsiCodeBlock body;
                PsiClassInitializer[] psiClassInitializerArray = aClass.getInitializers();
                int n = psiClassInitializerArray.length;
                for (int i = 0; i < n && (body = (initializer = psiClassInitializerArray[i]).getBody()) != block; ++i) {
                    boolean shouldCheckInitializerOrder;
                    boolean bl = shouldCheckInitializerOrder = block == null || block.getParent() instanceof PsiClassInitializer;
                    if (shouldCheckInitializerOrder && startOffset < initializer.getTextRange().getStartOffset() || initializer.hasModifierProperty("static") != variable.hasModifierProperty("static") || !ControlFlowUtil.variableDefinitelyAssignedIn(variable, body)) continue;
                    return true;
                }
            }
        }
        if ((codeBlockProblems = uninitializedVarProblems.get(topBlock)) == null) {
            try {
                ControlFlow controlFlow = ControlFlowUtil.getControlFlow(topBlock);
                codeBlockProblems = controlFlow == null ? Collections.emptyList() : ControlFlowUtil.getReadBeforeWriteLocals(controlFlow);
            }
            catch (IndexNotReadyException e) {
                codeBlockProblems = Collections.emptyList();
            }
            uninitializedVarProblems.put((PsiElement)topBlock, codeBlockProblems);
        }
        return !codeBlockProblems.contains(expression);
    }

    @Nullable
    private static PsiElement getTopBlock(@NotNull PsiReferenceExpression expression, @NotNull PsiVariable variable) {
        PsiClass scope;
        if (expression == null) {
            ControlFlowUtil.$$$reportNull$$$0(23);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(24);
        }
        if (variable.hasInitializer()) {
            return PsiUtil.getVariableCodeBlock(variable, variable);
        }
        PsiClass psiClass = variable instanceof PsiField ? ((PsiField)variable).getContainingClass() : (scope = variable.getParent() != null ? variable.getParent().getParent() : null);
        while (scope instanceof PsiCodeBlock && scope.getParent() instanceof PsiSwitchBlock) {
            scope = PsiTreeUtil.getParentOfType((PsiElement)scope, PsiCodeBlock.class);
        }
        return FileTypeUtils.isInServerPageFile(scope) && scope instanceof PsiFile ? scope : PsiUtil.getTopLevelEnclosingCodeBlock(expression, scope);
    }

    private static boolean inInnerClass(@NotNull PsiElement psiElement, @Nullable PsiClass containingClass) {
        if (psiElement == null) {
            ControlFlowUtil.$$$reportNull$$$0(25);
        }
        for (PsiElement element = psiElement; element != null; element = element.getParent()) {
            boolean innerClass;
            if (!(element instanceof PsiClass)) continue;
            PsiClass aClass = (PsiClass)element;
            boolean bl = innerClass = !psiElement.getManager().areElementsEquivalent(element, (PsiElement)containingClass);
            if (innerClass) {
                if (element instanceof PsiAnonymousClass) {
                    if (PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)element).getArgumentList(), (PsiElement)psiElement, (boolean)false)) continue;
                    return !ControlFlowUtil.insideClassInitialization(containingClass, aClass);
                }
                PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiLambdaExpression.class);
                return lambdaExpression == null || !ControlFlowUtil.insideClassInitialization(containingClass, aClass);
            }
            return false;
        }
        return false;
    }

    private static boolean insideClassInitialization(@Nullable PsiClass containingClass, PsiClass aClass) {
        PsiMember member = aClass;
        while (member != null) {
            if (member.getContainingClass() == containingClass) {
                return member instanceof PsiField || member instanceof PsiMethod && ((PsiMethod)member).isConstructor() || member instanceof PsiClassInitializer;
            }
            member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)member, PsiMember.class, (boolean)true);
        }
        return false;
    }

    private static boolean variableDefinitelyNotAssignedIn(@NotNull PsiVariable variable, @NotNull PsiElement context) {
        ControlFlow flow;
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(26);
        }
        if (context == null) {
            ControlFlowUtil.$$$reportNull$$$0(27);
        }
        return (flow = ControlFlowUtil.getControlFlow(context)) == null || ControlFlowUtil.isVariableDefinitelyNotAssigned(variable, flow);
    }

    @NotNull
    public static DoubleInitializationProblem findFinalVariableAlreadyInitializedProblem(@NotNull PsiVariable variable, @NotNull PsiReferenceExpression expression, @NotNull Map<PsiElement, Collection<VariableInfo>> finalVarProblems) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(28);
        }
        if (expression == null) {
            ControlFlowUtil.$$$reportNull$$$0(29);
        }
        if (finalVarProblems == null) {
            ControlFlowUtil.$$$reportNull$$$0(30);
        }
        if (!PsiUtil.isAccessedForWriting(expression)) {
            DoubleInitializationProblem doubleInitializationProblem = DoubleInitializationProblem.NO_PROBLEM;
            if (doubleInitializationProblem == null) {
                ControlFlowUtil.$$$reportNull$$$0(31);
            }
            return doubleInitializationProblem;
        }
        Object scope = variable instanceof PsiField ? variable.getParent() : (variable.getParent() == null ? null : variable.getParent().getParent());
        PsiElement codeBlock = PsiUtil.getTopLevelEnclosingCodeBlock(expression, scope);
        if (codeBlock == null) {
            DoubleInitializationProblem doubleInitializationProblem = DoubleInitializationProblem.NO_PROBLEM;
            if (doubleInitializationProblem == null) {
                ControlFlowUtil.$$$reportNull$$$0(32);
            }
            return doubleInitializationProblem;
        }
        Collection<VariableInfo> codeBlockProblems = ControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, codeBlock);
        VariableInfo variableInfo = (VariableInfo)ContainerUtil.find(codeBlockProblems, vi -> vi.expression == expression);
        if (variableInfo == null) {
            DoubleInitializationProblem problem;
            if (variable instanceof PsiField && (problem = ControlFlowUtil.isFieldInitializedInAnotherMember((PsiField)variable, expression, codeBlock)) != null) {
                DoubleInitializationProblem doubleInitializationProblem = problem;
                if (doubleInitializationProblem == null) {
                    ControlFlowUtil.$$$reportNull$$$0(33);
                }
                return doubleInitializationProblem;
            }
            DoubleInitializationProblem doubleInitializationProblem = DoubleInitializationProblem.NO_PROBLEM;
            if (doubleInitializationProblem == null) {
                ControlFlowUtil.$$$reportNull$$$0(34);
            }
            return doubleInitializationProblem;
        }
        DoubleInitializationProblem doubleInitializationProblem = variableInfo instanceof InitializedInLoopProblemInfo ? DoubleInitializationProblem.IN_LOOP : DoubleInitializationProblem.NORMAL;
        if (doubleInitializationProblem == null) {
            ControlFlowUtil.$$$reportNull$$$0(35);
        }
        return doubleInitializationProblem;
    }

    private static DoubleInitializationProblem isFieldInitializedInAnotherMember(@NotNull PsiField field, @NotNull PsiReferenceExpression expression, @NotNull PsiElement codeBlock) {
        PsiMethodCallExpression chainedCall;
        PsiClass aClass;
        if (field == null) {
            ControlFlowUtil.$$$reportNull$$$0(36);
        }
        if (expression == null) {
            ControlFlowUtil.$$$reportNull$$$0(37);
        }
        if (codeBlock == null) {
            ControlFlowUtil.$$$reportNull$$$0(38);
        }
        if ((aClass = field.getContainingClass()) == null) {
            return null;
        }
        boolean isFieldStatic = field.hasModifierProperty("static");
        PsiMember enclosingConstructorOrInitializer = PsiUtil.findEnclosingConstructorOrInitializer(expression);
        if (!isFieldStatic && enclosingConstructorOrInitializer instanceof PsiMethod && JavaPsiConstructorUtil.isChainedConstructorCall(chainedCall = JavaPsiConstructorUtil.findThisOrSuperCallInConstructor((PsiMethod)enclosingConstructorOrInitializer))) {
            return DoubleInitializationProblem.IN_CONSTRUCTOR;
        }
        ArrayList<PsiField> members = new ArrayList<PsiField>(Arrays.asList(aClass.getFields()));
        if (enclosingConstructorOrInitializer != null && aClass.getManager().areElementsEquivalent((PsiElement)enclosingConstructorOrInitializer.getContainingClass(), (PsiElement)aClass)) {
            members.addAll(Arrays.asList(aClass.getInitializers()));
            members.sort(PsiUtil.BY_POSITION);
        }
        for (PsiMember psiMember : members) {
            Object context;
            if (psiMember == field || (context = psiMember instanceof PsiField ? ((PsiField)psiMember).getInitializer() : ((PsiClassInitializer)psiMember).getBody()) == null || psiMember.hasModifierProperty("static") != isFieldStatic || ControlFlowUtil.variableDefinitelyNotAssignedIn(field, context)) continue;
            return context == codeBlock ? null : (psiMember instanceof PsiField ? DoubleInitializationProblem.IN_FIELD_INITIALIZER : DoubleInitializationProblem.IN_INITIALIZER);
        }
        return null;
    }

    @NotNull
    private static Collection<VariableInfo> getFinalVariableProblemsInBlock(@NotNull Map<PsiElement, Collection<VariableInfo>> finalVarProblems, @NotNull PsiElement codeBlock) {
        Collection codeBlockProblems;
        if (finalVarProblems == null) {
            ControlFlowUtil.$$$reportNull$$$0(39);
        }
        if (codeBlock == null) {
            ControlFlowUtil.$$$reportNull$$$0(40);
        }
        Collection collection = codeBlockProblems = finalVarProblems.computeIfAbsent(codeBlock, cb -> {
            ControlFlow controlFlow = ControlFlowUtil.getControlFlow(codeBlock);
            return controlFlow == null ? Collections.emptyList() : ControlFlowUtil.addReassignedInLoopProblems(ControlFlowUtil.getInitializedTwice(controlFlow), controlFlow);
        });
        if (collection == null) {
            ControlFlowUtil.$$$reportNull$$$0(41);
        }
        return collection;
    }

    private static Collection<VariableInfo> addReassignedInLoopProblems(@NotNull Collection<VariableInfo> codeBlockProblems, @NotNull ControlFlow controlFlow) {
        if (codeBlockProblems == null) {
            ControlFlowUtil.$$$reportNull$$$0(42);
        }
        if (controlFlow == null) {
            ControlFlowUtil.$$$reportNull$$$0(43);
        }
        List<Instruction> instructions = controlFlow.getInstructions();
        for (int index = 0; index < instructions.size(); ++index) {
            InitializedInLoopProblemInfo varInfo;
            PsiExpression ref;
            PsiElement anchor;
            PsiVariable variable;
            Instruction instruction = instructions.get(index);
            if (!(instruction instanceof WriteVariableInstruction) || !((variable = ((WriteVariableInstruction)instruction).variable) instanceof PsiLocalVariable) && !(variable instanceof PsiField) || !((anchor = controlFlow.getElement(index)) instanceof PsiAssignmentExpression) || !((ref = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)anchor).getLExpression())) instanceof PsiReferenceExpression) || codeBlockProblems.contains(varInfo = new InitializedInLoopProblemInfo(variable, ref)) || !ControlFlowUtil.isInstructionReachable(controlFlow, index, index)) continue;
            if (!(codeBlockProblems instanceof HashSet)) {
                codeBlockProblems = new HashSet<VariableInfo>(codeBlockProblems);
            }
            codeBlockProblems.add(varInfo);
        }
        return codeBlockProblems;
    }

    public static boolean isReassigned(@NotNull PsiVariable variable, @NotNull Map<PsiElement, Collection<VariableInfo>> finalVarProblems) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(44);
        }
        if (finalVarProblems == null) {
            ControlFlowUtil.$$$reportNull$$$0(45);
        }
        if (variable instanceof PsiLocalVariable) {
            PsiElement parent = variable.getParent();
            if (parent == null) {
                return false;
            }
            PsiElement declarationScope = parent.getParent();
            if (declarationScope == null) {
                return false;
            }
            Collection<VariableInfo> codeBlockProblems = ControlFlowUtil.getFinalVariableProblemsInBlock(finalVarProblems, declarationScope);
            return codeBlockProblems.contains(new VariableInfo(variable, null));
        }
        if (variable instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)variable;
            return ControlFlowUtil.variableIsAssigned(parameter, parameter.getDeclarationScope());
        }
        return false;
    }

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(46);
        }
        return ControlFlowUtil.getSSAVariables(flow, 0, flow.getSize(), false);
    }

    @NotNull
    public static List<PsiVariable> getSSAVariables(@NotNull ControlFlow flow, int from, int to, boolean reportVarsIfNonInitializingPathExists) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(47);
        }
        List<Instruction> instructions = flow.getInstructions();
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, from, to, false);
        ArrayList<PsiVariable> result = new ArrayList<PsiVariable>(1);
        block0: for (PsiVariable psiVariable : writtenVariables) {
            PsiManager psiManager = psiVariable.getManager();
            ArrayList<SSAInstructionState> queue = new ArrayList<SSAInstructionState>();
            queue.add(new SSAInstructionState(0, from));
            HashSet<SSAInstructionState> processedStates = new HashSet<SSAInstructionState>();
            while (!queue.isEmpty()) {
                SSAInstructionState state = (SSAInstructionState)queue.remove(0);
                if (state.getWriteCount() > 1) continue block0;
                if (processedStates.contains(state)) continue;
                processedStates.add(state);
                int i = state.getInstructionIdx();
                if (i < to) {
                    Instruction instruction = instructions.get(i);
                    if (instruction instanceof ReturnInstruction) {
                        int[] offsets;
                        for (int offset : offsets = ((ReturnInstruction)instruction).getPossibleReturnOffsets()) {
                            queue.add(new SSAInstructionState(state.getWriteCount(), Math.min(offset, to)));
                        }
                        continue;
                    }
                    if (instruction instanceof GoToInstruction) {
                        int nextOffset = ((GoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ThrowToInstruction) {
                        int nextOffset = ((ThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        continue;
                    }
                    if (instruction instanceof ConditionalGoToInstruction) {
                        int nextOffset = ((ConditionalGoToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof ConditionalThrowToInstruction) {
                        int nextOffset = ((ConditionalThrowToInstruction)instruction).offset;
                        nextOffset = Math.min(nextOffset, to);
                        queue.add(new SSAInstructionState(state.getWriteCount(), nextOffset));
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    if (instruction instanceof WriteVariableInstruction) {
                        WriteVariableInstruction write = (WriteVariableInstruction)instruction;
                        queue.add(new SSAInstructionState(state.getWriteCount() + (psiManager.areElementsEquivalent((PsiElement)write.variable, (PsiElement)psiVariable) ? 1 : 0), i + 1));
                        continue;
                    }
                    if (instruction instanceof ReadVariableInstruction) {
                        ReadVariableInstruction read = (ReadVariableInstruction)instruction;
                        if (psiManager.areElementsEquivalent((PsiElement)read.variable, (PsiElement)psiVariable) && state.getWriteCount() == 0) continue block0;
                        queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                        continue;
                    }
                    queue.add(new SSAInstructionState(state.getWriteCount(), i + 1));
                    continue;
                }
                if (reportVarsIfNonInitializingPathExists || state.getWriteCount() != 0) continue;
                continue block0;
            }
            result.add(psiVariable);
        }
        ArrayList<PsiVariable> arrayList = result;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(48);
        }
        return arrayList;
    }

    public static boolean needVariableValueAt(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow, final int offset) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(49);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(50);
        }
        InstructionClientVisitor<Boolean> visitor = new InstructionClientVisitor<Boolean>(){
            final boolean[] neededBelow;
            {
                this.neededBelow = new boolean[flow.getSize() + 1];
            }

            @Override
            public void procedureEntered(int startOffset, int endOffset) {
                for (int i = startOffset; i < endOffset; ++i) {
                    this.neededBelow[i] = false;
                }
            }

            @Override
            public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = true;
                }
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                if (instruction.variable.equals(variable)) {
                    needed = false;
                }
                this.neededBelow[offset2] = needed;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean needed = this.neededBelow[nextOffset];
                int n = offset2;
                this.neededBelow[n] = this.neededBelow[n] | needed;
            }

            @Override
            public Boolean getResult() {
                return this.neededBelow[offset];
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor, offset, flow.getSize());
        return (Boolean)visitor.getResult();
    }

    @NotNull
    public static Collection<PsiVariable> getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(51);
        }
        HashSet<PsiVariable> set = new HashSet<PsiVariable>();
        ControlFlowUtil.getWrittenVariables(flow, start, end, ignoreNotReachingWrites, set);
        HashSet<PsiVariable> hashSet = set;
        if (hashSet == null) {
            ControlFlowUtil.$$$reportNull$$$0(52);
        }
        return hashSet;
    }

    public static void getWrittenVariables(@NotNull ControlFlow flow, int start, int end, boolean ignoreNotReachingWrites, @NotNull Collection<? super PsiVariable> set) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(53);
        }
        if (set == null) {
            ControlFlowUtil.$$$reportNull$$$0(54);
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || ignoreNotReachingWrites && !ControlFlowUtil.isInstructionReachable(flow, end, i)) continue;
            set.add(((WriteVariableInstruction)instruction).variable);
        }
    }

    @NotNull
    public static List<PsiVariable> getUsedVariables(@NotNull ControlFlow flow, int start, int end) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(55);
        }
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        if (start < 0) {
            ArrayList<PsiVariable> arrayList = array;
            if (arrayList == null) {
                ControlFlowUtil.$$$reportNull$$$0(56);
            }
            return arrayList;
        }
        List<Instruction> instructions = flow.getInstructions();
        for (int i = start; i < end; ++i) {
            PsiVariable variable;
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                variable = ((ReadVariableInstruction)instruction).variable;
                if (array.contains(variable)) continue;
                array.add(variable);
                continue;
            }
            if (!(instruction instanceof WriteVariableInstruction) || array.contains(variable = ((WriteVariableInstruction)instruction).variable)) continue;
            array.add(variable);
        }
        ArrayList<PsiVariable> arrayList = array;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(57);
        }
        return arrayList;
    }

    public static boolean isVariableUsed(@NotNull ControlFlow flow, int start, int end, @NotNull PsiVariable variable) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(58);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(59);
        }
        List<Instruction> instructions = flow.getInstructions();
        LOG.assertTrue(start >= 0, (Object)"flow start");
        LOG.assertTrue(end <= instructions.size(), (Object)"flow end");
        PsiManager psiManager = variable.getManager();
        for (int i = start; i < end; ++i) {
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof ReadVariableInstruction ? psiManager.areElementsEquivalent((PsiElement)((ReadVariableInstruction)instruction).variable, (PsiElement)variable) : instruction instanceof WriteVariableInstruction && psiManager.areElementsEquivalent((PsiElement)((WriteVariableInstruction)instruction).variable, (PsiElement)variable))) continue;
            return true;
        }
        return false;
    }

    private static int findSingleReadOffset(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull PsiVariable variable) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(60);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(61);
        }
        List<Instruction> instructions = flow.getInstructions();
        if (startOffset < 0 || endOffset < 0 || endOffset > instructions.size()) {
            return -1;
        }
        PsiManager psiManager = variable.getManager();
        int readOffset = -1;
        for (int i = startOffset; i < endOffset; ++i) {
            Instruction instruction = instructions.get(i);
            if (instruction instanceof ReadVariableInstruction) {
                if (!psiManager.areElementsEquivalent((PsiElement)((ReadVariableInstruction)instruction).variable, (PsiElement)variable)) continue;
                if (readOffset < 0) {
                    readOffset = i;
                    continue;
                }
                return -1;
            }
            if (!(instruction instanceof WriteVariableInstruction) || !psiManager.areElementsEquivalent((PsiElement)((WriteVariableInstruction)instruction).variable, (PsiElement)variable)) continue;
            return -1;
        }
        return readOffset;
    }

    public static PsiReferenceExpression findSingleReadOccurrence(@NotNull ControlFlow flow, @NotNull PsiElement element, @NotNull PsiVariable variable) {
        int readOffset;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(62);
        }
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(63);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(64);
        }
        if ((readOffset = ControlFlowUtil.findSingleReadOffset(flow, flow.getStartOffset(element), flow.getEndOffset(element), variable)) >= 0) {
            PsiElement readElement = flow.getElement(readOffset);
            if ((readElement = PsiTreeUtil.findFirstParent((PsiElement)readElement, (boolean)false, e -> e == element || e instanceof PsiReferenceExpression)) instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)readElement;
            }
        }
        return null;
    }

    public static boolean isVariableReadInFinally(@NotNull ControlFlow flow, @Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment, @NotNull PsiVariable variable) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(65);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(66);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(67);
        }
        PsiManager psiManager = variable.getManager();
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiCodeBlock finallyBlock;
            PsiTryStatement tryStatement;
            PsiElement parent;
            if (!(element instanceof PsiCodeBlock) || !((parent = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent).getTryBlock() != element || (finallyBlock = tryStatement.getFinallyBlock()) == null) continue;
            List<Instruction> instructions = flow.getInstructions();
            int startOffset = flow.getStartOffset(finallyBlock);
            int endOffset = flow.getEndOffset(finallyBlock);
            LOG.assertTrue(startOffset >= 0, (Object)"flow start");
            LOG.assertTrue(endOffset <= instructions.size(), (Object)"flow end");
            for (int i = startOffset; i < endOffset; ++i) {
                Instruction instruction = instructions.get(i);
                if (!(instruction instanceof ReadVariableInstruction) || !psiManager.areElementsEquivalent((PsiElement)((ReadVariableInstruction)instruction).variable, (PsiElement)variable)) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static List<PsiVariable> getInputVariables(@NotNull ControlFlow flow, int start, int end) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(68);
        }
        List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(flow, start, end);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>(usedVariables.size());
        for (PsiVariable variable : usedVariables) {
            if (!ControlFlowUtil.needVariableValueAt(variable, flow, start)) continue;
            array.add(variable);
        }
        ArrayList<PsiVariable> arrayList = array;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(69);
        }
        return arrayList;
    }

    public static PsiVariable @NotNull [] getOutputVariables(@NotNull ControlFlow flow, int start, int end, int @NotNull [] exitPoints) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(70);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(71);
        }
        return ControlFlowUtil.getOutputVariables(flow, start, end, exitPoints, Integer.MAX_VALUE);
    }

    public static PsiVariable @NotNull [] getOutputVariables(@NotNull ControlFlow flow, int start, int end, int @NotNull [] exitPoints, int limit) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(72);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(73);
        }
        Collection<PsiVariable> writtenVariables = ControlFlowUtil.getWrittenVariables(flow, start, end, false);
        ArrayList<PsiVariable> array = new ArrayList<PsiVariable>();
        block0: for (PsiVariable variable : writtenVariables) {
            int[] nArray = exitPoints;
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                int exitPoint = nArray[i];
                if (!ControlFlowUtil.needVariableValueAt(variable, flow, exitPoint)) continue;
                array.add(variable);
                if (array.size() >= limit) break block0;
            }
        }
        PsiVariable[] outputVariables = array.toArray(new PsiVariable[0]);
        if (LOG.isDebugEnabled()) {
            LOG.debug("output variables:");
            for (PsiVariable variable : outputVariables) {
                LOG.debug("  " + variable);
            }
        }
        if (outputVariables == null) {
            ControlFlowUtil.$$$reportNull$$$0(74);
        }
        return outputVariables;
    }

    @SafeVarargs
    @NotNull
    public static Collection<PsiStatement> findExitPointsAndStatements(final @NotNull ControlFlow flow, final int start, final int end, final @NotNull IntList exitPoints, final Class<? extends PsiStatement> ... classesFilter) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(75);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(76);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(77);
        }
        if (end == start) {
            exitPoints.add(end);
            List<PsiStatement> list = Collections.emptyList();
            if (list == null) {
                ControlFlowUtil.$$$reportNull$$$0(78);
            }
            return list;
        }
        final HashSet<PsiStatement> exitStatements = new HashSet<PsiStatement>();
        InstructionClientVisitor<Void> visitor = new InstructionClientVisitor<Void>(){

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGotoStatement(exitStatements, ControlFlowUtil.findStatement(flow, offset), classesFilter);
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                ControlFlowUtil.processGoto(flow, start, end, exitPoints, exitStatements, instruction, ControlFlowUtil.findStatement(flow, offset), classesFilter);
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (offset >= end - 1) {
                    int exitOffset = end;
                    if (!exitPoints.contains(exitOffset = ControlFlowUtil.promoteThroughGotoChain(flow, exitOffset))) {
                        exitPoints.add(exitOffset);
                    }
                }
            }

            @Override
            public Void getResult() {
                return null;
            }
        };
        ControlFlowUtil.depthFirstSearch(flow, visitor, start, end);
        HashSet<PsiStatement> hashSet = exitStatements;
        if (hashSet == null) {
            ControlFlowUtil.$$$reportNull$$$0(79);
        }
        return hashSet;
    }

    @SafeVarargs
    private static void processGoto(@NotNull ControlFlow flow, int start, int end, @NotNull IntList exitPoints, @NotNull Collection<? super PsiStatement> exitStatements, @NotNull BranchingInstruction instruction, PsiStatement statement, Class<? extends PsiStatement> ... classesFilter) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(80);
        }
        if (exitPoints == null) {
            ControlFlowUtil.$$$reportNull$$$0(81);
        }
        if (exitStatements == null) {
            ControlFlowUtil.$$$reportNull$$$0(82);
        }
        if (instruction == null) {
            ControlFlowUtil.$$$reportNull$$$0(83);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(84);
        }
        if (statement == null) {
            return;
        }
        int gotoOffset = instruction.offset;
        if (start > gotoOffset || gotoOffset >= end || ControlFlowUtil.isElementOfClass(statement, classesFilter)) {
            if (!((gotoOffset = ControlFlowUtil.promoteThroughGotoChain(flow, gotoOffset)) <= 0 || gotoOffset < end && gotoOffset >= start || exitPoints.contains(gotoOffset))) {
                exitPoints.add(gotoOffset);
            }
            if (gotoOffset >= end || gotoOffset < start) {
                ControlFlowUtil.processGotoStatement(exitStatements, statement, classesFilter);
            } else {
                boolean isReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                Instruction gotoInstruction = flow.getInstructions().get(gotoOffset);
                if (isReturn |= gotoInstruction instanceof GoToInstruction && ((GoToInstruction)gotoInstruction).isReturn) {
                    ControlFlowUtil.processGotoStatement(exitStatements, statement, classesFilter);
                }
            }
        }
    }

    @SafeVarargs
    private static void processGotoStatement(@NotNull Collection<? super PsiStatement> exitStatements, PsiStatement statement, Class<? extends PsiStatement> ... classesFilter) {
        if (exitStatements == null) {
            ControlFlowUtil.$$$reportNull$$$0(85);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(86);
        }
        if (statement != null && ControlFlowUtil.isElementOfClass(statement, classesFilter)) {
            exitStatements.add(statement);
        }
    }

    @SafeVarargs
    private static boolean isElementOfClass(@NotNull PsiElement element, Class<? extends PsiStatement> ... classesFilter) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(87);
        }
        if (classesFilter == null) {
            ControlFlowUtil.$$$reportNull$$$0(88);
        }
        for (Class<? extends PsiStatement> aClassesFilter : classesFilter) {
            if (!ReflectionUtil.isAssignable(aClassesFilter, (Class)element.getClass())) continue;
            return true;
        }
        return false;
    }

    private static int promoteThroughGotoChain(@NotNull ControlFlow flow, int offset) {
        Instruction instruction;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(89);
        }
        List<Instruction> instructions = flow.getInstructions();
        while (offset < instructions.size() && (instruction = instructions.get(offset)) instanceof GoToInstruction && !((GoToInstruction)instruction).isReturn) {
            offset = ((BranchingInstruction)instruction).offset;
        }
        return offset;
    }

    private static PsiStatement findStatement(@NotNull ControlFlow flow, int offset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(90);
        }
        PsiElement element = flow.getElement(offset);
        return (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class, (boolean)false);
    }

    public static boolean hasObservableThrowExitPoints(@NotNull ControlFlow flow, final int flowStart, final int flowEnd, PsiElement @NotNull [] elements, @NotNull PsiElement enclosingCodeFragment) {
        List<Instruction> instructions;
        Worker worker;
        Map writeOffsets;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(91);
        }
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(92);
        }
        if (elements == null) {
            ControlFlowUtil.$$$reportNull$$$0(93);
        }
        class Worker {
            final /* synthetic */ List val$instructions;
            final /* synthetic */ ControlFlow val$flow;

            Worker() {
                this.val$instructions = list;
                this.val$flow = controlFlow;
            }

            @NotNull
            private Map<PsiVariable, IntList> getWritesOffsets() {
                HashMap<PsiVariable, IntList> writeOffsets = new HashMap<PsiVariable, IntList>();
                for (int i = flowStart; i < flowEnd; ++i) {
                    PsiVariable variable;
                    Instruction instruction = (Instruction)this.val$instructions.get(i);
                    if (!(instruction instanceof WriteVariableInstruction) || !((variable = ((WriteVariableInstruction)instruction).variable) instanceof PsiLocalVariable) && !(variable instanceof PsiParameter)) continue;
                    writeOffsets.computeIfAbsent(variable, k -> new IntArrayList()).add(i);
                }
                LOG.debug("writeOffsets:", new Object[]{writeOffsets});
                HashMap<PsiVariable, IntList> hashMap = writeOffsets;
                if (hashMap == null) {
                    Worker.$$$reportNull$$$0(0);
                }
                return hashMap;
            }

            @NotNull
            private Map<PsiVariable, IntList> getVisibleReadsOffsets(@NotNull Map<PsiVariable, IntList> writeOffsets, @NotNull PsiCodeBlock tryBlock) {
                if (writeOffsets == null) {
                    Worker.$$$reportNull$$$0(1);
                }
                if (tryBlock == null) {
                    Worker.$$$reportNull$$$0(2);
                }
                HashMap<PsiVariable, IntList> visibleReadOffsets = new HashMap<PsiVariable, IntList>();
                for (PsiVariable variable : writeOffsets.keySet()) {
                    if (PsiTreeUtil.isAncestor((PsiElement)tryBlock, (PsiElement)variable, (boolean)true)) continue;
                    visibleReadOffsets.put(variable, (IntList)new IntArrayList());
                }
                if (visibleReadOffsets.isEmpty()) {
                    HashMap<PsiVariable, IntList> hashMap = visibleReadOffsets;
                    if (hashMap == null) {
                        Worker.$$$reportNull$$$0(3);
                    }
                    return hashMap;
                }
                for (int i = 0; i < this.val$instructions.size(); ++i) {
                    PsiVariable variable;
                    IntList readOffsets;
                    Instruction instruction = (Instruction)this.val$instructions.get(i);
                    if (!(instruction instanceof ReadVariableInstruction) || (readOffsets = (IntList)visibleReadOffsets.get(variable = ((ReadVariableInstruction)instruction).variable)) == null) continue;
                    readOffsets.add(i);
                }
                LOG.debug("visibleReadOffsets:", new Object[]{visibleReadOffsets});
                HashMap<PsiVariable, IntList> hashMap = visibleReadOffsets;
                if (hashMap == null) {
                    Worker.$$$reportNull$$$0(4);
                }
                return hashMap;
            }

            @NotNull
            private Map<PsiVariable, Set<PsiElement>> getReachableAfterWrite(@NotNull Map<PsiVariable, IntList> writeOffsets, @NotNull Map<PsiVariable, IntList> visibleReadOffsets) {
                if (writeOffsets == null) {
                    Worker.$$$reportNull$$$0(5);
                }
                if (visibleReadOffsets == null) {
                    Worker.$$$reportNull$$$0(6);
                }
                HashMap<PsiVariable, Set<PsiElement>> afterWrite = new HashMap<PsiVariable, Set<PsiElement>>();
                IntFunction<BitSet> calculator = this.getReachableInstructionsCalculator();
                for (PsiVariable variable : visibleReadOffsets.keySet()) {
                    BitSet collectedOffsets = new BitSet(flowEnd);
                    for (int writeOffset : writeOffsets.get(variable).toIntArray()) {
                        PsiElement nextOffsetElement;
                        LOG.assertTrue(writeOffset >= flowStart, (Object)"writeOffset");
                        BitSet reachableOffsets = calculator.apply(writeOffset);
                        reachableOffsets.set(writeOffset, false);
                        if (writeOffset + 1 < this.val$flow.getSize() && (nextOffsetElement = this.val$flow.getElement(writeOffset + 1)) instanceof PsiExpressionStatement && this.val$flow.getElement(writeOffset) == ((PsiExpressionStatement)nextOffsetElement).getExpression()) {
                            reachableOffsets.set(writeOffset + 1, false);
                        }
                        collectedOffsets.or(reachableOffsets);
                    }
                    Set throwSources = afterWrite.getOrDefault(variable, new HashSet());
                    for (int i = flowStart; i < flowEnd; ++i) {
                        if (!collectedOffsets.get(i)) continue;
                        throwSources.add(this.val$flow.getElement(i));
                    }
                    ArrayList<PsiElement> subordinates = new ArrayList<PsiElement>();
                    for (PsiElement element : throwSources) {
                        if (!throwSources.contains(element.getParent())) continue;
                        subordinates.add(element);
                    }
                    subordinates.forEach(throwSources::remove);
                    if (throwSources.isEmpty()) {
                        afterWrite.remove(variable);
                        continue;
                    }
                    afterWrite.put(variable, throwSources);
                }
                LOG.debug("afterWrite:", new Object[]{afterWrite});
                HashMap<PsiVariable, Set<PsiElement>> hashMap = afterWrite;
                if (hashMap == null) {
                    Worker.$$$reportNull$$$0(7);
                }
                return hashMap;
            }

            @NotNull
            private IntList getCatchOrFinallyOffsets(@NotNull List<? extends PsiTryStatement> tryStatements, @NotNull List<? extends PsiClassType> thrownExceptions) {
                if (tryStatements == null) {
                    Worker.$$$reportNull$$$0(8);
                }
                if (thrownExceptions == null) {
                    Worker.$$$reportNull$$$0(9);
                }
                IntArrayList catchOrFinallyOffsets = new IntArrayList();
                for (PsiTryStatement psiTryStatement : tryStatements) {
                    int offset;
                    PsiCodeBlock finallyBlock = psiTryStatement.getFinallyBlock();
                    if (finallyBlock != null && (offset = this.val$flow.getStartOffset(finallyBlock)) >= 0) {
                        catchOrFinallyOffsets.add(offset - 2);
                    }
                    for (PsiCatchSection catchSection : psiTryStatement.getCatchSections()) {
                        PsiCodeBlock catchBlock = catchSection.getCatchBlock();
                        PsiParameter parameter = catchSection.getParameter();
                        if (catchBlock == null || parameter == null) continue;
                        for (PsiClassType psiClassType : thrownExceptions) {
                            int offset2;
                            if (!ControlFlowUtil.isCaughtExceptionType(psiClassType, parameter.getType()) || (offset2 = this.val$flow.getStartOffset(catchBlock)) < 0) continue;
                            catchOrFinallyOffsets.add(offset2 - 1);
                        }
                    }
                }
                IntArrayList intArrayList = catchOrFinallyOffsets;
                if (intArrayList == null) {
                    Worker.$$$reportNull$$$0(10);
                }
                return intArrayList;
            }

            private boolean isAnyReadOffsetReachableFrom(@Nullable IntList readOffsets, @NotNull IntList fromOffsets) {
                if (fromOffsets == null) {
                    Worker.$$$reportNull$$$0(11);
                }
                if (readOffsets != null && !readOffsets.isEmpty()) {
                    int[] readOffsetsArray = readOffsets.toIntArray();
                    for (int j = 0; j < fromOffsets.size(); ++j) {
                        int fromOffset = fromOffsets.getInt(j);
                        if (!ControlFlowUtil.areInstructionsReachable(this.val$flow, readOffsetsArray, fromOffset)) continue;
                        LOG.debug("reachableFromOffset:", new Object[]{fromOffset});
                        return true;
                    }
                }
                return false;
            }

            @NotNull
            private IntFunction<BitSet> getReachableInstructionsCalculator() {
                ControlFlowGraph graph = new ControlFlowGraph(this.val$flow.getSize()){

                    @Override
                    void addArc(int offset, int nextOffset) {
                        if ((nextOffset = ControlFlowUtil.promoteThroughGotoChain(val$flow, nextOffset)) >= flowStart && nextOffset < flowEnd) {
                            super.addArc(offset, nextOffset);
                        }
                    }
                };
                graph.buildFrom(this.val$flow);
                IntFunction<BitSet> intFunction = startOffset -> {
                    BitSet visitedOffsets = new BitSet(flowEnd);
                    graph.depthFirstSearch(startOffset, visitedOffsets);
                    return visitedOffsets;
                };
                if (intFunction == null) {
                    Worker.$$$reportNull$$$0(12);
                }
                return intFunction;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$1Worker";
                        break;
                    }
                    case 1: 
                    case 5: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "writeOffsets";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tryBlock";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "visibleReadOffsets";
                        break;
                    }
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "tryStatements";
                        break;
                    }
                    case 9: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "thrownExceptions";
                        break;
                    }
                    case 11: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "fromOffsets";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getWritesOffsets";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$1Worker";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getVisibleReadsOffsets";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReachableAfterWrite";
                        break;
                    }
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getCatchOrFinallyOffsets";
                        break;
                    }
                    case 12: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getReachableInstructionsCalculator";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "getVisibleReadsOffsets";
                        break;
                    }
                    case 5: 
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getReachableAfterWrite";
                        break;
                    }
                    case 8: 
                    case 9: {
                        objectArray = objectArray;
                        objectArray[2] = "getCatchOrFinallyOffsets";
                        break;
                    }
                    case 11: {
                        objectArray = objectArray;
                        objectArray[2] = "isAnyReadOffsetReachableFrom";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 11: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        }
        if ((writeOffsets = (worker = new Worker()).getWritesOffsets()).isEmpty()) {
            return false;
        }
        PsiElement commonParent = elements.length != 1 ? PsiTreeUtil.findCommonParent((PsiElement[])elements) : elements[0].getParent();
        List<PsiTryStatement> tryStatements = ControlFlowUtil.collectTryStatementStack(commonParent, enclosingCodeFragment);
        if (tryStatements.isEmpty()) {
            return false;
        }
        PsiCodeBlock tryBlock = tryStatements.get(0).getTryBlock();
        if (tryBlock == null) {
            return false;
        }
        Map visibleReadOffsets = worker.getVisibleReadsOffsets(writeOffsets, tryBlock);
        if (visibleReadOffsets.isEmpty()) {
            return false;
        }
        Map afterWrite = worker.getReachableAfterWrite(writeOffsets, visibleReadOffsets);
        if (afterWrite.isEmpty()) {
            return false;
        }
        PsiClassType runtimeException = PsiType.getJavaLangRuntimeException(tryBlock.getManager(), tryBlock.getResolveScope());
        boolean runtimeExceptionIsCaught = ContainerUtil.exists(tryStatements, tryStatement -> ControlFlowUtil.isExceptionCaught(tryStatement, runtimeException));
        for (Map.Entry entry : afterWrite.entrySet()) {
            PsiVariable variable = (PsiVariable)entry.getKey();
            PsiElement[] psiElements = ((Set)entry.getValue()).toArray(PsiElement.EMPTY_ARRAY);
            List<PsiClassType> thrownExceptions = ExceptionUtil.getThrownExceptions(psiElements);
            if (runtimeExceptionIsCaught) {
                thrownExceptions.add(runtimeException);
            }
            if (thrownExceptions.isEmpty()) continue;
            IntList catchOrFinallyOffsets = worker.getCatchOrFinallyOffsets(tryStatements, thrownExceptions);
            if (!worker.isAnyReadOffsetReachableFrom((IntList)visibleReadOffsets.get(variable), catchOrFinallyOffsets)) continue;
            return true;
        }
        return false;
    }

    private static boolean isExceptionCaught(@NotNull PsiTryStatement tryStatement, @NotNull PsiClassType exceptionType) {
        if (tryStatement == null) {
            ControlFlowUtil.$$$reportNull$$$0(94);
        }
        if (exceptionType == null) {
            ControlFlowUtil.$$$reportNull$$$0(95);
        }
        return ContainerUtil.exists((Object[])tryStatement.getCatchBlockParameters(), parameter -> exceptionType.isAssignableFrom(exceptionType));
    }

    @Nullable
    private static PsiTryStatement getEnclosingTryStatementHavingCatchOrFinally(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(96);
        }
        for (PsiElement element = startElement; element != null && element != enclosingCodeFragment; element = element.getParent()) {
            PsiTryStatement tryStatement;
            PsiElement parent;
            if (!(element instanceof PsiCodeBlock) || !((parent = element.getParent()) instanceof PsiTryStatement) || (tryStatement = (PsiTryStatement)parent).getTryBlock() != element || tryStatement.getFinallyBlock() == null && tryStatement.getCatchBlocks().length == 0) continue;
            return tryStatement;
        }
        return null;
    }

    @NotNull
    private static List<PsiTryStatement> collectTryStatementStack(@Nullable PsiElement startElement, @NotNull PsiElement enclosingCodeFragment) {
        if (enclosingCodeFragment == null) {
            ControlFlowUtil.$$$reportNull$$$0(97);
        }
        ArrayList<PsiTryStatement> stack = new ArrayList<PsiTryStatement>();
        PsiTryStatement tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(startElement, enclosingCodeFragment);
        while (tryStatement != null) {
            stack.add(tryStatement);
            tryStatement = ControlFlowUtil.getEnclosingTryStatementHavingCatchOrFinally(tryStatement, enclosingCodeFragment);
        }
        ArrayList<PsiTryStatement> arrayList = stack;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(98);
        }
        return arrayList;
    }

    @NotNull
    public static PsiElement findCodeFragment(@NotNull PsiElement element) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(99);
        }
        PsiElement codeFragment = element;
        for (PsiElement parent = codeFragment.getParent(); !(parent == null || parent instanceof PsiDirectory || parent instanceof PsiMethod || parent instanceof PsiField || parent instanceof PsiClassInitializer || parent instanceof DummyHolder || parent instanceof PsiLambdaExpression); parent = parent.getParent()) {
            codeFragment = parent;
        }
        PsiElement psiElement = codeFragment;
        if (psiElement == null) {
            ControlFlowUtil.$$$reportNull$$$0(100);
        }
        return psiElement;
    }

    private static boolean checkReferenceExpressionScope(@NotNull PsiReferenceExpression ref, @NotNull PsiElement targetClassMember) {
        JavaResolveResult resolveResult;
        PsiElement def;
        if (ref == null) {
            ControlFlowUtil.$$$reportNull$$$0(101);
        }
        if (targetClassMember == null) {
            ControlFlowUtil.$$$reportNull$$$0(102);
        }
        if ((def = (resolveResult = ref.advancedResolve(false)).getElement()) != null) {
            PsiElement commonParent;
            PsiElement parent = def.getParent();
            PsiElement psiElement = commonParent = parent == null ? null : PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)targetClassMember);
            if (commonParent == null) {
                parent = resolveResult.getCurrentFileResolveScope();
            }
            if (parent instanceof PsiClass) {
                PsiClass psiClass = (PsiClass)parent;
                if (PsiTreeUtil.isAncestor((PsiElement)targetClassMember, (PsiElement)psiClass, (boolean)false)) {
                    return false;
                }
                for (PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiClass.class); containingClass != null; containingClass = containingClass.getContainingClass()) {
                    if (!containingClass.isInheritor(psiClass, true) || !PsiTreeUtil.isAncestor((PsiElement)targetClassMember, (PsiElement)containingClass, (boolean)false)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean collectOuterLocals(@NotNull List<? super PsiVariable> array, @NotNull PsiElement scope, @NotNull PsiElement member, @NotNull PsiElement targetClassMember) {
        PsiJavaCodeReferenceElement qualifier;
        PsiMethodCallExpression call;
        if (array == null) {
            ControlFlowUtil.$$$reportNull$$$0(103);
        }
        if (scope == null) {
            ControlFlowUtil.$$$reportNull$$$0(104);
        }
        if (member == null) {
            ControlFlowUtil.$$$reportNull$$$0(105);
        }
        if (targetClassMember == null) {
            ControlFlowUtil.$$$reportNull$$$0(106);
        }
        if (scope instanceof PsiMethodCallExpression ? !ControlFlowUtil.checkReferenceExpressionScope((call = (PsiMethodCallExpression)scope).getMethodExpression(), targetClassMember) : scope instanceof PsiReferenceExpression && !ControlFlowUtil.checkReferenceExpressionScope((PsiReferenceExpression)scope, targetClassMember)) {
            return false;
        }
        if (scope instanceof PsiJavaCodeReferenceElement) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)scope;
            JavaResolveResult result = ref.advancedResolve(false);
            PsiElement refElement = result.getElement();
            if (refElement != null) {
                PsiElement parent = refElement.getParent();
                PsiElement psiElement = parent = parent != null ? PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)member) : null;
                if (parent == null) {
                    parent = result.getCurrentFileResolveScope();
                }
                if (parent != null && !member.equals((Object)parent) && targetClassMember.equals((Object)(parent = PsiTreeUtil.findCommonParent((PsiElement)parent, (PsiElement)targetClassMember)))) {
                    if (!(refElement instanceof PsiVariable)) return false;
                    if (scope instanceof PsiReferenceExpression && PsiUtil.isAccessedForWriting((PsiReferenceExpression)scope)) {
                        return false;
                    }
                    PsiVariable variable = (PsiVariable)refElement;
                    if (!array.contains(variable)) {
                        array.add(variable);
                    }
                }
            }
        } else if (scope instanceof PsiThisExpression ? (qualifier = ((PsiThisExpression)scope).getQualifier()) == null : scope instanceof PsiSuperExpression && ((PsiSuperExpression)scope).getQualifier() == null) {
            return false;
        }
        for (PsiElement child = scope.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (ControlFlowUtil.collectOuterLocals(array, child, member, targetClassMember)) continue;
            return false;
        }
        return true;
    }

    public static boolean returnPresent(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(107);
        }
        ReturnPresentClientVisitor visitor = new ReturnPresentClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return (Boolean)((InstructionClientVisitor)visitor).getResult();
    }

    public static boolean processReturns(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor afterVisitor) throws IncorrectOperationException {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(108);
        }
        if (afterVisitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(109);
        }
        ConvertReturnClientVisitor instructionsVisitor = new ConvertReturnClientVisitor(flow, afterVisitor);
        ControlFlowUtil.depthFirstSearch(flow, instructionsVisitor);
        instructionsVisitor.afterProcessing();
        return instructionsVisitor.getResult();
    }

    public static boolean returnPresentBetween(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(110);
        }
        final class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] isNormalCompletion;

            MyVisitor() {
                int i;
                this.isNormalCompletion = new boolean[flow.getSize() + 1];
                int length = flow.getSize();
                for (i = 0; i < startOffset; ++i) {
                    this.isNormalCompletion[i] = true;
                }
                for (i = endOffset; i <= length; ++i) {
                    this.isNormalCompletion[i] = true;
                }
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                boolean isNormal;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                if (throwToOffset == nextOffset) {
                    if (throwToOffset > endOffset) return;
                    isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                } else {
                    isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                }
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset];
                    int n = offset;
                    this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isRethrowFromFinally = instruction instanceof ReturnInstruction && ((ReturnInstruction)instruction).isRethrowFromFinally();
                boolean isNormal = !instruction.isReturn && this.isNormalCompletion[nextOffset] && !isRethrowFromFinally;
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
                int n = offset;
                this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = !this.isNormalCompletion[startOffset];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$1MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
        return visitor.getResult();
    }

    public static boolean canCompleteNormally(final @NotNull ControlFlow flow, final int startOffset, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(111);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] canCompleteNormally;

            MyVisitor() {
                this.canCompleteNormally = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitConditionalGoToInstruction(ConditionalGoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, instruction.isReturn);
            }

            private void checkInstruction(int offset, int nextOffset, boolean isReturn) {
                boolean isNormal;
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean bl = isNormal = nextOffset <= endOffset && !isReturn && (nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                if (isNormal && nextOffset == endOffset) {
                    PsiStatement continuedStatement;
                    PsiElement element = flow.getElement(offset);
                    if (element instanceof PsiBreakStatement) {
                        PsiStatement exitedStatement = ((PsiBreakStatement)element).findExitedStatement();
                        if (exitedStatement == null || flow.getStartOffset(exitedStatement) < startOffset) {
                            isNormal = false;
                        }
                    } else if (element instanceof PsiYieldStatement) {
                        PsiSwitchExpression exitedSwitch = ((PsiYieldStatement)element).findEnclosingExpression();
                        if (exitedSwitch == null || flow.getStartOffset(exitedSwitch) < startOffset) {
                            isNormal = false;
                        }
                    } else if (element instanceof PsiContinueStatement && ((continuedStatement = ((PsiContinueStatement)element).findContinuedStatement()) == null || flow.getStartOffset(continuedStatement) < startOffset)) {
                        isNormal = false;
                    }
                }
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                int throwToOffset = instruction.offset;
                boolean isNormal = throwToOffset == nextOffset && nextOffset == endOffset && offset + 1 == nextOffset && !(flow.getElement(offset) instanceof PsiThrowStatement) ? true : (throwToOffset == nextOffset ? throwToOffset <= endOffset && !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset] : nextOffset == endOffset || this.canCompleteNormally[nextOffset]);
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset <= endOffset) {
                    boolean isNormal = !this.isLeaf(nextOffset) && this.canCompleteNormally[nextOffset];
                    int n = offset;
                    this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
                }
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (offset > endOffset) {
                    return;
                }
                if (nextOffset > endOffset && nextOffset != offset + 1) {
                    return;
                }
                boolean isNormal = this.canCompleteNormally[nextOffset];
                int n = offset;
                this.canCompleteNormally[n] = this.canCompleteNormally[n] | isNormal;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                this.checkInstruction(offset, nextOffset, false);
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.canCompleteNormally[startOffset];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$2MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
        return visitor.getResult();
    }

    public static PsiElement getUnreachableStatement(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(112);
        }
        UnreachableStatementClientVisitor visitor = new UnreachableStatementClientVisitor(flow);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return (PsiElement)((InstructionClientVisitor)visitor).getResult();
    }

    private static PsiReferenceExpression getEnclosingReferenceExpression(@NotNull PsiElement element, @NotNull PsiVariable variable) {
        PsiReferenceExpression reference;
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(113);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(114);
        }
        if ((reference = ControlFlowUtil.findReferenceTo(element, variable)) != null) {
            return reference;
        }
        while (element != null) {
            if (element instanceof PsiReferenceExpression) {
                return (PsiReferenceExpression)element;
            }
            if (element instanceof PsiMethod || element instanceof PsiClass) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiReferenceExpression findReferenceTo(@NotNull PsiElement element, @NotNull PsiVariable variable) {
        if (element == null) {
            ControlFlowUtil.$$$reportNull$$$0(115);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(116);
        }
        if (element instanceof PsiReferenceExpression && ExpressionUtil.isEffectivelyUnqualified((PsiReferenceExpression)element) && ((PsiReferenceExpression)element).isReferenceTo(variable)) {
            return (PsiReferenceExpression)element;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            PsiReferenceExpression reference = ControlFlowUtil.findReferenceTo(child, variable);
            if (reference == null) continue;
            return reference;
        }
        return null;
    }

    public static boolean isDominator(ControlFlow flow, final int maybeDominator, final int target) {
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final BitSet myReachedWithoutDominator = new BitSet();

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                super.visitInstruction(instruction, offset, nextOffset);
                if (nextOffset != maybeDominator && (target == nextOffset || this.myReachedWithoutDominator.get(nextOffset))) {
                    this.myReachedWithoutDominator.set(offset);
                }
            }

            @Override
            public Boolean getResult() {
                return this.myReachedWithoutDominator.get(0);
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, 0, target);
        return visitor.getResult() == false;
    }

    public static boolean isVariableDefinitelyAssigned(@NotNull PsiVariable variable, @NotNull ControlFlow flow) {
        PsiElement parent;
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(117);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(118);
        }
        int variableDeclarationOffset = (parent = variable.getParent()) == null ? -1 : flow.getStartOffset(parent);
        int offset = variableDeclarationOffset > -1 ? variableDeclarationOffset : 0;
        boolean[] unassignedOffsets = ControlFlowUtil.getVariablePossiblyUnassignedOffsets(variable, flow);
        return !unassignedOffsets[offset];
    }

    public static boolean[] getVariablePossiblyUnassignedOffsets(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(119);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(120);
        }
        if (flow.getSize() == 0) {
            return new boolean[]{true};
        }
        class MyVisitor
        extends InstructionClientVisitor<boolean[]> {
            final PsiManager psiManager;
            private final boolean[] maybeUnassigned;

            MyVisitor() {
                this.psiManager = variable.getManager();
                this.maybeUnassigned = new boolean[flow.getSize() + 1];
                this.maybeUnassigned[this.maybeUnassigned.length - 1] = true;
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (this.psiManager.areElementsEquivalent((PsiElement)instruction.variable, (PsiElement)variable)) {
                    this.maybeUnassigned[offset] = false;
                } else {
                    this.visitInstruction(instruction, offset, nextOffset);
                }
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = offset == flow.getSize() - 1 || !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                this.visitInstruction(instruction, offset, nextOffset);
                for (int i = instruction.procBegin; i < instruction.procEnd + 3; ++i) {
                    this.maybeUnassigned[i] = false;
                }
            }

            @Override
            public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
                if (instruction.isReturn && variable instanceof PsiLocalVariable) {
                    if (nextOffset > flow.getSize()) {
                        nextOffset = flow.getSize();
                    }
                    boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                    int n = offset;
                    this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
                } else {
                    super.visitGoToInstruction(instruction, offset, nextOffset);
                }
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = !this.isLeaf(nextOffset) && this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean unassigned = this.isLeaf(nextOffset) || this.maybeUnassigned[nextOffset];
                int n = offset;
                this.maybeUnassigned[n] = this.maybeUnassigned[n] | unassigned;
            }

            @Override
            public boolean @NotNull [] getResult() {
                if (this.maybeUnassigned == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return this.maybeUnassigned;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$4MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    public static boolean isVariableDefinitelyNotAssigned(final @NotNull PsiVariable variable, final @NotNull ControlFlow flow) {
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(121);
        }
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(122);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            final PsiManager psiManager;
            private final boolean[] maybeAssigned;

            MyVisitor() {
                this.psiManager = variable.getManager();
                this.maybeAssigned = new boolean[flow.getSize() + 1];
            }

            @Override
            public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.psiManager.areElementsEquivalent((PsiElement)instruction.variable, (PsiElement)variable) || this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
                int throwToOffset;
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = (throwToOffset = instruction.offset) == nextOffset ? !this.isLeaf(nextOffset) && this.maybeAssigned[nextOffset] : this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                boolean assigned = this.maybeAssigned[nextOffset];
                int n = offset;
                this.maybeAssigned[n] = this.maybeAssigned[n] | assigned;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = !this.maybeAssigned[0];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$5MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    public static boolean isValueUsedWithoutVisitingStop(final @NotNull ControlFlow flow, final int start, final int stop, final @NotNull PsiVariable variable) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(123);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(124);
        }
        if (start == stop) {
            return false;
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private final boolean[] maybeReferenced;
            final PsiManager psiManager;

            MyVisitor() {
                this.maybeReferenced = new boolean[flow.getSize() + 1];
                this.psiManager = variable.getManager();
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                boolean nextState;
                if (offset == stop) {
                    this.maybeReferenced[offset] = false;
                    return;
                }
                if (instruction instanceof WriteVariableInstruction && this.psiManager.areElementsEquivalent((PsiElement)((WriteVariableInstruction)instruction).variable, (PsiElement)variable)) {
                    this.maybeReferenced[offset] = false;
                    return;
                }
                if (this.maybeReferenced[offset]) {
                    return;
                }
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                this.maybeReferenced[offset] = (nextState = this.maybeReferenced[nextOffset]) || instruction instanceof ReadVariableInstruction && this.psiManager.areElementsEquivalent((PsiElement)((ReadVariableInstruction)instruction).variable, (PsiElement)variable);
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.maybeReferenced[start];
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$6MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, start, flow.getSize());
        return visitor.getResult();
    }

    public static boolean isVariableAccess(@NotNull ControlFlow flow, int offset, @NotNull PsiVariable variable) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(125);
        }
        if (variable == null) {
            ControlFlowUtil.$$$reportNull$$$0(126);
        }
        Instruction instruction = flow.getInstructions().get(offset);
        PsiManager psiManager = variable.getManager();
        return instruction instanceof ReadVariableInstruction && psiManager.areElementsEquivalent((PsiElement)((ReadVariableInstruction)instruction).variable, (PsiElement)variable) || instruction instanceof WriteVariableInstruction && psiManager.areElementsEquivalent((PsiElement)((WriteVariableInstruction)instruction).variable, (PsiElement)variable);
    }

    @NotNull
    public static List<ControlFlowEdge> getEdges(@NotNull ControlFlow flow, int start) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(127);
        }
        final ArrayList<ControlFlowEdge> list = new ArrayList<ControlFlowEdge>();
        ControlFlowUtil.depthFirstSearch(flow, new InstructionClientVisitor<Void>(){

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                list.add(new ControlFlowEdge(offset, nextOffset));
            }

            @Override
            public Void getResult() {
                return null;
            }
        }, start, flow.getSize());
        ArrayList<ControlFlowEdge> arrayList = list;
        if (arrayList == null) {
            ControlFlowUtil.$$$reportNull$$$0(128);
        }
        return arrayList;
    }

    public static int getMinDefinitelyReachedOffset(final @NotNull ControlFlow flow, final int sourceOffset, final @NotNull List<? extends PsiElement> references) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(129);
        }
        if (references == null) {
            ControlFlowUtil.$$$reportNull$$$0(130);
        }
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final IntSet[] exitPoints;

            MyVisitor() {
                this.exitPoints = new IntOpenHashSet[flow.getSize()];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (nextOffset > flow.getSize()) {
                    nextOffset = flow.getSize();
                }
                if (this.exitPoints[offset] == null) {
                    this.exitPoints[offset] = new IntOpenHashSet();
                }
                if (this.isLeaf(nextOffset)) {
                    this.exitPoints[offset].add(offset);
                } else if (this.exitPoints[nextOffset] != null) {
                    this.exitPoints[offset].addAll((IntCollection)this.exitPoints[nextOffset]);
                }
            }

            @Override
            @NotNull
            public Integer getResult() {
                int minOffset = flow.getSize();
                int maxExitPoints = 0;
                block0: for (int i = sourceOffset; i < this.exitPoints.length; ++i) {
                    int size;
                    IntSet exitPointSet = this.exitPoints[i];
                    int n = size = exitPointSet == null ? 0 : exitPointSet.size();
                    if (size <= maxExitPoints) continue;
                    for (PsiElement element : references) {
                        int endOffset;
                        PsiElement statement = PsiUtil.getEnclosingStatement(element);
                        if (statement == null || (endOffset = flow.getEndOffset(statement)) == -1 || i == endOffset || ControlFlowUtil.isInstructionReachable(flow, i, endOffset)) continue;
                        continue block0;
                    }
                    minOffset = i;
                    maxExitPoints = size;
                }
                Integer n = minOffset;
                if (n == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$7MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        return visitor.getResult();
    }

    private static int findUnprocessed(int startOffset, int endOffset, @NotNull InstructionClientVisitor<?> visitor) {
        if (visitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(131);
        }
        for (int i = startOffset; i < endOffset; ++i) {
            if (visitor.processedInstructions[i]) continue;
            return i;
        }
        return endOffset;
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor<?> visitor) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(132);
        }
        if (visitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(133);
        }
        ControlFlowUtil.depthFirstSearch(flow, visitor, 0, flow.getSize());
    }

    private static void depthFirstSearch(@NotNull ControlFlow flow, @NotNull InstructionClientVisitor<?> visitor, int startOffset, int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(134);
        }
        if (visitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(135);
        }
        visitor.processedInstructions = new boolean[endOffset];
        ControlFlowUtil.internalDepthFirstSearch(flow.getInstructions(), visitor, startOffset, endOffset);
    }

    private static void internalDepthFirstSearch(final @NotNull List<? extends Instruction> instructions, final @NotNull InstructionClientVisitor<?> clientVisitor, int startOffset, int endOffset) {
        if (instructions == null) {
            ControlFlowUtil.$$$reportNull$$$0(136);
        }
        if (clientVisitor == null) {
            ControlFlowUtil.$$$reportNull$$$0(137);
        }
        final WalkThroughStack walkThroughStack = new WalkThroughStack(instructions.size() / 2);
        walkThroughStack.push(startOffset);
        ControlFlowInstructionVisitor getNextOffsetVisitor = new ControlFlowInstructionVisitor(){

            @Override
            public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
                int i;
                int newOffset = instruction.offset;
                for (i = instruction.procBegin; i < clientVisitor.processedInstructions.length && (i < instruction.procEnd || i < instructions.size() && instructions.get(i) instanceof ReturnInstruction); ++i) {
                    clientVisitor.processedInstructions[i] = false;
                }
                clientVisitor.procedureEntered(instruction.procBegin, i);
                walkThroughStack.currentStack = new CallStackItem(walkThroughStack.currentStack, offset + 1);
                walkThroughStack.push(offset, newOffset);
                walkThroughStack.push(newOffset);
            }

            @Override
            public void visitReturnInstruction(ReturnInstruction instruction, int offset, int nextOffset) {
                int newOffset = -1;
                if (walkThroughStack.currentStack != null) {
                    newOffset = ((WalkThroughStack)walkThroughStack).currentStack.target;
                    walkThroughStack.currentStack = ((WalkThroughStack)walkThroughStack).currentStack.next;
                }
                if (instruction.offset != 0) {
                    newOffset = instruction.offset;
                }
                if (newOffset != -1) {
                    walkThroughStack.push(offset, newOffset);
                    walkThroughStack.push(newOffset);
                }
            }

            @Override
            public void visitBranchingInstruction(BranchingInstruction instruction, int offset, int nextOffset) {
                int newOffset = instruction.offset;
                walkThroughStack.push(offset, newOffset);
                walkThroughStack.push(newOffset);
            }

            @Override
            public void visitConditionalBranchingInstruction(ConditionalBranchingInstruction instruction, int offset, int nextOffset) {
                int newOffset = instruction.offset;
                walkThroughStack.push(offset, newOffset);
                walkThroughStack.push(offset, offset + 1);
                walkThroughStack.push(newOffset);
                walkThroughStack.push(offset + 1);
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                int newOffset = offset + 1;
                walkThroughStack.push(offset, newOffset);
                walkThroughStack.push(newOffset);
            }
        };
        while (!walkThroughStack.isEmpty()) {
            int offset = walkThroughStack.peekOldOffset();
            int newOffset = walkThroughStack.popNewOffset();
            if (offset >= endOffset) continue;
            Instruction instruction = instructions.get(offset);
            if (clientVisitor.processedInstructions[offset]) {
                if (newOffset == -1) continue;
                instruction.accept(clientVisitor, offset, newOffset);
                continue;
            }
            clientVisitor.processedInstructions[offset] = true;
            instruction.accept(getNextOffsetVisitor, offset, newOffset);
        }
    }

    private static boolean isInsideReturnStatement(PsiElement element) {
        while (element instanceof PsiExpression) {
            element = element.getParent();
        }
        return element instanceof PsiReturnStatement;
    }

    private static void merge(int offset, @NotNull UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> source, @NotNull @NotNull UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> @NotNull [] target) {
        if (source == null) {
            ControlFlowUtil.$$$reportNull$$$0(138);
        }
        if (target == null) {
            ControlFlowUtil.$$$reportNull$$$0(139);
        }
        target[offset] = target[offset].withAll(source);
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWriteLocals(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(140);
        }
        ReadBeforeWriteClientVisitor visitor = new ReadBeforeWriteClientVisitor(flow, true);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        List list = (List)((InstructionClientVisitor)visitor).getResult();
        if (list == null) {
            ControlFlowUtil.$$$reportNull$$$0(141);
        }
        return list;
    }

    @NotNull
    public static List<PsiReferenceExpression> getReadBeforeWrite(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(142);
        }
        if (flow.getSize() == 0) {
            List<PsiReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                ControlFlowUtil.$$$reportNull$$$0(143);
            }
            return list;
        }
        ReadBeforeWriteClientVisitor visitor = new ReadBeforeWriteClientVisitor(flow, false);
        ControlFlowUtil.depthFirstSearch(flow, visitor);
        Object object = visitor.getResult();
        if (object == null) {
            ControlFlowUtil.$$$reportNull$$$0(144);
        }
        return object;
    }

    public static int getCompletionReasons(final @NotNull ControlFlow flow, final int offset, final int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(145);
        }
        class MyVisitor
        extends InstructionClientVisitor<Integer> {
            private final boolean[] normalCompletion;
            private final boolean[] returnCalled;

            MyVisitor() {
                this.normalCompletion = new boolean[endOffset];
                this.returnCalled = new boolean[endOffset];
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset2, int nextOffset) {
                boolean goToReturn;
                boolean ret = nextOffset < endOffset && this.returnCalled[nextOffset];
                boolean normal = nextOffset < endOffset && this.normalCompletion[nextOffset];
                PsiElement element = flow.getElement(offset2);
                boolean bl = goToReturn = instruction instanceof GoToInstruction && ((GoToInstruction)instruction).isReturn;
                if (goToReturn || ControlFlowUtil.isInsideReturnStatement(element)) {
                    ret = true;
                } else if (instruction instanceof ConditionalThrowToInstruction) {
                    int throwOffset = ((ConditionalThrowToInstruction)instruction).offset;
                    boolean normalWhenThrow = throwOffset < endOffset && this.normalCompletion[throwOffset];
                    boolean normalWhenNotThrow = offset2 == endOffset - 1 || this.normalCompletion[offset2 + 1];
                    normal = normalWhenThrow || normalWhenNotThrow;
                } else if (!(instruction instanceof ThrowToInstruction) && nextOffset >= endOffset) {
                    normal = true;
                }
                int n = offset2;
                this.returnCalled[n] = this.returnCalled[n] | ret;
                int n2 = offset2;
                this.normalCompletion[n2] = this.normalCompletion[n2] | normal;
            }

            @Override
            @NotNull
            public Integer getResult() {
                Integer n = (this.returnCalled[offset] ? 2 : 0) | (this.normalCompletion[offset] ? 1 : 0);
                if (n == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return n;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$8MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, offset, endOffset);
        return visitor.getResult();
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(146);
        }
        return ControlFlowUtil.getInitializedTwice(flow, 0, flow.getSize());
    }

    @NotNull
    public static Collection<VariableInfo> getInitializedTwice(@NotNull ControlFlow flow, int startOffset, int endOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(147);
        }
        HashSet<VariableInfo> result = new HashSet<VariableInfo>();
        while (startOffset < endOffset) {
            InitializedTwiceClientVisitor visitor = new InitializedTwiceClientVisitor(flow, startOffset);
            ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, endOffset);
            result.addAll((Collection<VariableInfo>)visitor.getResult());
            startOffset = ControlFlowUtil.findUnprocessed(startOffset, endOffset, visitor);
        }
        HashSet<VariableInfo> hashSet = result;
        if (hashSet == null) {
            ControlFlowUtil.$$$reportNull$$$0(148);
        }
        return hashSet;
    }

    @NotNull
    public static Map<PsiElement, PsiVariable> getWritesBeforeReads(@NotNull ControlFlow flow, @NotNull Set<? extends PsiVariable> writeVars, @NotNull Set<? extends PsiVariable> readVars, int stopPoint) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(149);
        }
        if (writeVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(150);
        }
        if (readVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(151);
        }
        LinkedHashMap<PsiElement, PsiVariable> writes = new LinkedHashMap<PsiElement, PsiVariable>();
        List<Instruction> instructions = flow.getInstructions();
        for (int i = 0; i < instructions.size(); ++i) {
            PsiVariable writtenVar;
            Instruction instruction = instructions.get(i);
            if (!(instruction instanceof WriteVariableInstruction) || !writeVars.contains(writtenVar = ((WriteVariableInstruction)instruction).variable) || !ControlFlowUtil.readBeforeStopPoint(flow, readVars, i, stopPoint)) continue;
            writes.put(flow.getElement(i), writtenVar);
        }
        LinkedHashMap<PsiElement, PsiVariable> linkedHashMap = writes;
        if (linkedHashMap == null) {
            ControlFlowUtil.$$$reportNull$$$0(152);
        }
        return linkedHashMap;
    }

    private static boolean readBeforeStopPoint(@NotNull ControlFlow flow, final @NotNull Set<? extends PsiVariable> readVars, int startOffset, final int stopPoint) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(153);
        }
        if (readVars == null) {
            ControlFlowUtil.$$$reportNull$$$0(154);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable = false;

            MyVisitor() {
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                if (offset == stopPoint || this.isWriteToReadVar(instruction)) {
                    this.reachable = false;
                    return;
                }
                boolean foundRead = instruction instanceof ReadVariableInstruction && readVars.contains(((ReadVariableInstruction)instruction).variable);
                this.reachable |= foundRead;
            }

            private boolean isWriteToReadVar(Instruction instruction) {
                return instruction instanceof WriteVariableInstruction && readVars.contains(((WriteVariableInstruction)instruction).variable);
            }

            @Override
            public Boolean getResult() {
                return this.reachable;
            }
        }
        MyVisitor visitor = new MyVisitor();
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, flow.getSize());
        return visitor.getResult();
    }

    public static boolean isInstructionReachable(@NotNull ControlFlow flow, int instructionOffset, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(155);
        }
        return ControlFlowUtil.areInstructionsReachable(flow, new int[]{instructionOffset}, startOffset);
    }

    private static boolean areInstructionsReachable(@NotNull ControlFlow flow, int @NotNull [] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(156);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(157);
        }
        if (startOffset != 0 && ControlFlowUtil.hasCalls(flow)) {
            return ControlFlowUtil.areInstructionsReachableWithCalls(flow, instructionOffsets, startOffset);
        }
        class MyVisitor
        extends InstructionClientVisitor<Boolean> {
            private boolean reachable;
            final /* synthetic */ int[] val$instructionOffsets;

            MyVisitor(int[] nArray) {
                this.val$instructionOffsets = nArray;
            }

            @Override
            public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
                this.reachable |= ArrayUtil.indexOf((int[])this.val$instructionOffsets, (int)nextOffset) >= 0;
            }

            @Override
            @NotNull
            public Boolean getResult() {
                Boolean bl = this.reachable;
                if (bl == null) {
                    MyVisitor.$$$reportNull$$$0(0);
                }
                return bl;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/controlFlow/ControlFlowUtil$10MyVisitor", "getResult"));
            }
        }
        MyVisitor visitor = new MyVisitor(instructionOffsets);
        ControlFlowUtil.depthFirstSearch(flow, visitor, startOffset, flow.getSize());
        return visitor.getResult();
    }

    private static boolean hasCalls(@NotNull ControlFlow flow) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(158);
        }
        for (Instruction instruction : flow.getInstructions()) {
            if (!(instruction instanceof CallInstruction)) continue;
            return true;
        }
        return false;
    }

    private static boolean areInstructionsReachableWithCalls(@NotNull ControlFlow flow, final int @NotNull [] instructionOffsets, int startOffset) {
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(159);
        }
        if (instructionOffsets == null) {
            ControlFlowUtil.$$$reportNull$$$0(160);
        }
        ControlFlowGraph graph = new ControlFlowGraph(flow.getSize()){

            @Override
            boolean isComplete(int offset, int nextOffset) {
                return ArrayUtil.indexOf((int[])instructionOffsets, (int)nextOffset) >= 0;
            }
        };
        graph.buildFrom(flow);
        return graph.depthFirstSearch(startOffset);
    }

    public static boolean isVariableAssignedInLoop(@NotNull PsiReferenceExpression expression, @NotNull PsiElement resolved) {
        ControlFlow flow;
        if (expression == null) {
            ControlFlowUtil.$$$reportNull$$$0(161);
        }
        if (resolved == null) {
            ControlFlowUtil.$$$reportNull$$$0(162);
        }
        if (!(expression.getParent() instanceof PsiAssignmentExpression) || ((PsiAssignmentExpression)expression.getParent()).getLExpression() != expression) {
            return false;
        }
        PsiExpression qualifier = expression.getQualifierExpression();
        if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
            return false;
        }
        if (!(resolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)resolved;
        PsiElement codeBlock = PsiUtil.getVariableCodeBlock(variable, expression);
        if (codeBlock == null) {
            return false;
        }
        try {
            ControlFlowFactory factory = ControlFlowFactory.getInstance(codeBlock.getProject());
            flow = factory.getControlFlow(codeBlock, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), true);
        }
        catch (AnalysisCanceledException e) {
            return false;
        }
        PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)expression.getParent();
        int startOffset = flow.getStartOffset(assignmentExpression);
        return startOffset != -1 && ControlFlowUtil.isInstructionReachable(flow, startOffset, startOffset);
    }

    static boolean isCaughtExceptionType(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(163);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(164);
        }
        return catchType.isAssignableFrom(throwType) || ControlFlowUtil.mightBeAssignableFromSubclass(throwType, catchType);
    }

    private static boolean mightBeAssignableFromSubclass(@NotNull PsiClassType throwType, @NotNull PsiType catchType) {
        if (throwType == null) {
            ControlFlowUtil.$$$reportNull$$$0(165);
        }
        if (catchType == null) {
            ControlFlowUtil.$$$reportNull$$$0(166);
        }
        if (catchType instanceof PsiDisjunctionType) {
            for (PsiType catchDisjunction : ((PsiDisjunctionType)catchType).getDisjunctions()) {
                if (!throwType.isAssignableFrom(catchDisjunction)) continue;
                return true;
            }
            return false;
        }
        return throwType.isAssignableFrom(catchType);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean areVariablesUnmodifiedAtLocations(@NotNull ControlFlow flow, int startOffset, int endOffset, @NotNull Set<? extends PsiVariable> variables, @NotNull Iterable<? extends PsiElement> locations) {
        void var8_10;
        if (flow == null) {
            ControlFlowUtil.$$$reportNull$$$0(167);
        }
        if (variables == null) {
            ControlFlowUtil.$$$reportNull$$$0(168);
        }
        if (locations == null) {
            ControlFlowUtil.$$$reportNull$$$0(169);
        }
        List<Instruction> instructions = flow.getInstructions();
        startOffset = Math.max(startOffset, 0);
        endOffset = Math.min(endOffset, instructions.size());
        IntArrayList locationOffsetList = new IntArrayList();
        for (PsiElement psiElement : locations) {
            int offset = flow.getStartOffset(psiElement);
            if (offset < startOffset || offset >= endOffset) continue;
            locationOffsetList.add(offset);
        }
        int[] locationOffsets = locationOffsetList.toIntArray();
        int n = startOffset;
        while (var8_10 < endOffset) {
            Instruction instruction = instructions.get((int)var8_10);
            if (instruction instanceof WriteVariableInstruction && variables.contains(((WriteVariableInstruction)instruction).variable) && ControlFlowUtil.areInstructionsReachable(flow, locationOffsets, (int)var8_10)) {
                return false;
            }
            ++var8_10;
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$isFieldInitializedInClassInitializer$2(boolean isFieldStatic, PsiField field, PsiClassInitializer initializer) {
        return initializer.hasModifierProperty("static") == isFieldStatic && ControlFlowUtil.variableDefinitelyAssignedIn(field, initializer.getBody(), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 57: 
            case 69: 
            case 74: 
            case 78: 
            case 79: 
            case 98: 
            case 100: 
            case 128: 
            case 141: 
            case 143: 
            case 144: 
            case 148: 
            case 152: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 57: 
            case 69: 
            case 74: 
            case 78: 
            case 79: 
            case 98: 
            case 100: 
            case 128: 
            case 141: 
            case 143: 
            case 144: 
            case 148: 
            case 152: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 1: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 57: 
            case 69: 
            case 74: 
            case 78: 
            case 79: 
            case 98: 
            case 100: 
            case 128: 
            case 141: 
            case 143: 
            case 144: 
            case 148: 
            case 152: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 5: 
            case 7: 
            case 9: 
            case 17: 
            case 19: 
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 10: 
            case 11: 
            case 13: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
            case 20: 
            case 23: 
            case 29: 
            case 37: 
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uninitializedVarProblems";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 30: 
            case 39: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finalVarProblems";
                break;
            }
            case 38: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlock";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeBlockProblems";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controlFlow";
                break;
            }
            case 46: 
            case 47: 
            case 50: 
            case 51: 
            case 53: 
            case 55: 
            case 58: 
            case 60: 
            case 62: 
            case 65: 
            case 68: 
            case 70: 
            case 72: 
            case 75: 
            case 80: 
            case 89: 
            case 90: 
            case 91: 
            case 107: 
            case 108: 
            case 110: 
            case 111: 
            case 112: 
            case 118: 
            case 120: 
            case 122: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 132: 
            case 134: 
            case 140: 
            case 142: 
            case 145: 
            case 146: 
            case 147: 
            case 149: 
            case 153: 
            case 155: 
            case 156: 
            case 158: 
            case 159: 
            case 167: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flow";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 63: 
            case 87: 
            case 99: 
            case 113: 
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 66: 
            case 92: 
            case 96: 
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enclosingCodeFragment";
                break;
            }
            case 71: 
            case 73: 
            case 76: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitPoints";
                break;
            }
            case 77: 
            case 84: 
            case 86: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classesFilter";
                break;
            }
            case 82: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exitStatements";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tryStatement";
                break;
            }
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 102: 
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassMember";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 109: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterVisitor";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 131: 
            case 133: 
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 137: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clientVisitor";
                break;
            }
            case 138: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writeVars";
                break;
            }
            case 151: 
            case 154: {
                objectArray2 = objectArray3;
                objectArray3[0] = "readVars";
                break;
            }
            case 157: 
            case 160: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructionOffsets";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 163: 
            case 165: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwType";
                break;
            }
            case 164: 
            case 166: {
                objectArray2 = objectArray3;
                objectArray3[0] = "catchType";
                break;
            }
            case 168: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variables";
                break;
            }
            case 169: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariableScope";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "findFinalVariableAlreadyInitializedProblem";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getFinalVariableProblemsInBlock";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getSSAVariables";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getWrittenVariables";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedVariables";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputVariables";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputVariables";
                break;
            }
            case 78: 
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "findExitPointsAndStatements";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTryStatementStack";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "findCodeFragment";
                break;
            }
            case 128: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 141: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadBeforeWriteLocals";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray2;
                objectArray2[1] = "getReadBeforeWrite";
                break;
            }
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitializedTwice";
                break;
            }
            case 152: {
                objectArray = objectArray2;
                objectArray2[1] = "getWritesBeforeReads";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getScopeEnforcingEffectiveFinality";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getVariableScope";
                break;
            }
            case 3: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 57: 
            case 69: 
            case 74: 
            case 78: 
            case 79: 
            case 98: 
            case 100: 
            case 128: 
            case 141: 
            case 143: 
            case 144: 
            case 148: 
            case 152: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEffectivelyFinal";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "variableIsAssigned";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedAfterObjectConstruction";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInClassInitializer";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInOtherFieldInitializer";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findEnclosingFieldInitializer";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyAssignedIn";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isInitializedBeforeUsage";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getTopBlock";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "inInnerClass";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "variableDefinitelyNotAssignedIn";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findFinalVariableAlreadyInitializedProblem";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isFieldInitializedInAnotherMember";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getFinalVariableProblemsInBlock";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "addReassignedInLoopProblems";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isReassigned";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getSSAVariables";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "needVariableValueAt";
                break;
            }
            case 51: 
            case 53: 
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getWrittenVariables";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getUsedVariables";
                break;
            }
            case 58: 
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "isVariableUsed";
                break;
            }
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOffset";
                break;
            }
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "findSingleReadOccurrence";
                break;
            }
            case 65: 
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "isVariableReadInFinally";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getInputVariables";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getOutputVariables";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findExitPointsAndStatements";
                break;
            }
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "processGoto";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "processGotoStatement";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isElementOfClass";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "promoteThroughGotoChain";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "findStatement";
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "hasObservableThrowExitPoints";
                break;
            }
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "isExceptionCaught";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingTryStatementHavingCatchOrFinally";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "collectTryStatementStack";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "findCodeFragment";
                break;
            }
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "checkReferenceExpressionScope";
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "collectOuterLocals";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "returnPresent";
                break;
            }
            case 108: 
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "processReturns";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "returnPresentBetween";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "canCompleteNormally";
                break;
            }
            case 112: {
                objectArray = objectArray;
                objectArray[2] = "getUnreachableStatement";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "getEnclosingReferenceExpression";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "findReferenceTo";
                break;
            }
            case 117: 
            case 118: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDefinitelyAssigned";
                break;
            }
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "getVariablePossiblyUnassignedOffsets";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "isVariableDefinitelyNotAssigned";
                break;
            }
            case 123: 
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isValueUsedWithoutVisitingStop";
                break;
            }
            case 125: 
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAccess";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getEdges";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getMinDefinitelyReachedOffset";
                break;
            }
            case 131: {
                objectArray = objectArray;
                objectArray[2] = "findUnprocessed";
                break;
            }
            case 132: 
            case 133: 
            case 134: 
            case 135: {
                objectArray = objectArray;
                objectArray[2] = "depthFirstSearch";
                break;
            }
            case 136: 
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "internalDepthFirstSearch";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getReadBeforeWriteLocals";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getReadBeforeWrite";
                break;
            }
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "getCompletionReasons";
                break;
            }
            case 146: 
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "getInitializedTwice";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getWritesBeforeReads";
                break;
            }
            case 153: 
            case 154: {
                objectArray = objectArray;
                objectArray[2] = "readBeforeStopPoint";
                break;
            }
            case 155: {
                objectArray = objectArray;
                objectArray[2] = "isInstructionReachable";
                break;
            }
            case 156: 
            case 157: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachable";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "hasCalls";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray;
                objectArray[2] = "areInstructionsReachableWithCalls";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "isVariableAssignedInLoop";
                break;
            }
            case 163: 
            case 164: {
                objectArray = objectArray;
                objectArray[2] = "isCaughtExceptionType";
                break;
            }
            case 165: 
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "mightBeAssignableFromSubclass";
                break;
            }
            case 167: 
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "areVariablesUnmodifiedAtLocations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 57: 
            case 69: 
            case 74: 
            case 78: 
            case 79: 
            case 98: 
            case 100: 
            case 128: 
            case 141: 
            case 143: 
            case 144: 
            case 148: 
            case 152: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class VariableInfo {
        private final PsiVariable variable;
        public final PsiElement expression;

        public VariableInfo(@NotNull PsiVariable variable, @Nullable PsiElement expression) {
            if (variable == null) {
                VariableInfo.$$$reportNull$$$0(0);
            }
            this.variable = variable;
            this.expression = expression;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof VariableInfo && this.variable.equals(((VariableInfo)o).variable);
        }

        public int hashCode() {
            return this.variable.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowUtil$VariableInfo", "<init>"));
        }
    }

    public static enum DoubleInitializationProblem {
        NO_PROBLEM,
        NORMAL,
        IN_LOOP,
        IN_CONSTRUCTOR,
        IN_INITIALIZER,
        IN_FIELD_INITIALIZER;

    }

    private static class InitializedInLoopProblemInfo
    extends VariableInfo {
        InitializedInLoopProblemInfo(@NotNull PsiVariable variable, @Nullable PsiElement expression) {
            if (variable == null) {
                InitializedInLoopProblemInfo.$$$reportNull$$$0(0);
            }
            super(variable, expression);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedInLoopProblemInfo", "<init>"));
        }
    }

    private static class SSAInstructionState {
        private final int myWriteCount;
        private final int myInstructionIdx;

        SSAInstructionState(int writeCount, int instructionIdx) {
            this.myWriteCount = writeCount;
            this.myInstructionIdx = instructionIdx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SSAInstructionState)) {
                return false;
            }
            SSAInstructionState ssaInstructionState = (SSAInstructionState)o;
            if (this.myInstructionIdx != ssaInstructionState.myInstructionIdx) {
                return false;
            }
            return Math.min(2, this.myWriteCount) == Math.min(2, ssaInstructionState.myWriteCount);
        }

        public int hashCode() {
            return 29 * Math.min(2, this.myWriteCount) + this.myInstructionIdx;
        }

        int getWriteCount() {
            return this.myWriteCount;
        }

        int getInstructionIdx() {
            return this.myInstructionIdx;
        }
    }

    private static class ReturnPresentClientVisitor
    extends InstructionClientVisitor<Boolean> {
        private final boolean[] isNormalCompletion;
        protected final ControlFlow myFlow;

        ReturnPresentClientVisitor(@NotNull ControlFlow flow) {
            if (flow == null) {
                ReturnPresentClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.isNormalCompletion = new boolean[this.myFlow.getSize() + 1];
            this.isNormalCompletion[this.myFlow.getSize()] = true;
        }

        @Override
        public void visitConditionalThrowToInstruction(ConditionalThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = instruction.offset == nextOffset && nextOffset != offset + 1 ? !this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset] : this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        public void visitThrowToInstruction(ThrowToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!this.isLeaf(nextOffset) && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | (!instruction.isReturn && this.isNormalCompletion[nextOffset]);
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.myFlow.getSize()) {
                nextOffset = this.myFlow.getSize();
            }
            boolean isNormal = this.isLeaf(nextOffset) || this.isNormalCompletion[nextOffset];
            int n = offset;
            this.isNormalCompletion[n] = this.isNormalCompletion[n] | isNormal;
        }

        @Override
        @NotNull
        public Boolean getResult() {
            Boolean bl = !this.isNormalCompletion[0];
            if (bl == null) {
                ReturnPresentClientVisitor.$$$reportNull$$$0(1);
            }
            return bl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$ReturnPresentClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$ReturnPresentClientVisitor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class ConvertReturnClientVisitor
    extends ReturnPresentClientVisitor {
        private final List<PsiReturnStatement> myAffectedReturns;
        private final ReturnStatementsVisitor myVisitor;

        ConvertReturnClientVisitor(@NotNull ControlFlow flow, @NotNull ReturnStatementsVisitor visitor) {
            if (flow == null) {
                ConvertReturnClientVisitor.$$$reportNull$$$0(0);
            }
            if (visitor == null) {
                ConvertReturnClientVisitor.$$$reportNull$$$0(1);
            }
            super(flow);
            this.myAffectedReturns = new ArrayList<PsiReturnStatement>();
            this.myVisitor = visitor;
        }

        @Override
        public void visitGoToInstruction(GoToInstruction instruction, int offset, int nextOffset) {
            PsiElement element;
            super.visitGoToInstruction(instruction, offset, nextOffset);
            if (instruction.isReturn && (element = this.myFlow.getElement(offset)) instanceof PsiReturnStatement) {
                PsiReturnStatement returnStatement = (PsiReturnStatement)element;
                this.myAffectedReturns.add(returnStatement);
            }
        }

        void afterProcessing() throws IncorrectOperationException {
            this.myVisitor.visit(this.myAffectedReturns);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "visitor";
                    break;
                }
            }
            objectArray[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$ConvertReturnClientVisitor";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class UnreachableStatementClientVisitor
    extends InstructionClientVisitor<PsiElement> {
        private final ControlFlow myFlow;

        UnreachableStatementClientVisitor(@NotNull ControlFlow flow) {
            if (flow == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
        }

        @Override
        public PsiElement getResult() {
            for (int i = 0; i < this.processedInstructions.length; ++i) {
                int startOffset;
                int endOffset;
                if (this.processedInstructions[i]) continue;
                PsiElement element = this.myFlow.getElement(i);
                PsiElement unreachableParent = UnreachableStatementClientVisitor.getUnreachableExpressionParent(element);
                if (unreachableParent != null) {
                    return UnreachableStatementClientVisitor.correctUnreachableStatement(unreachableParent);
                }
                if (element == null || !PsiUtil.isStatement(element) || element.getParent() instanceof PsiExpression) continue;
                while (element instanceof PsiExpression) {
                    element = element.getParent();
                }
                if (element instanceof PsiStatement && element.getParent() instanceof PsiForStatement && element == ((PsiForStatement)element.getParent()).getUpdate() || (endOffset = this.myFlow.getEndOffset(element)) != i + 1 || 0 <= (startOffset = this.myFlow.getStartOffset(element)) && startOffset < this.processedInstructions.length && this.processedInstructions[startOffset]) continue;
                PsiElement enclosingStatement = UnreachableStatementClientVisitor.getEnclosingUnreachableStatement(element);
                return enclosingStatement != null ? enclosingStatement : element;
            }
            return null;
        }

        private static PsiElement correctUnreachableStatement(PsiElement statement) {
            if (!(statement instanceof PsiStatement)) {
                return statement;
            }
            while (true) {
                PsiElement grandParent;
                PsiElement parent;
                if ((parent = statement.getParent()) instanceof PsiDoWhileStatement || parent instanceof PsiLabeledStatement) {
                    statement = parent;
                    continue;
                }
                if (!(parent instanceof PsiCodeBlock) || PsiTreeUtil.getPrevSiblingOfType((PsiElement)statement, PsiStatement.class) != null || !((grandParent = parent.getParent()) instanceof PsiBlockStatement)) break;
                statement = grandParent;
            }
            return statement;
        }

        @Nullable
        private static PsiElement getUnreachableExpressionParent(@Nullable PsiElement element) {
            if (element instanceof PsiExpression) {
                PsiElement expression = PsiTreeUtil.findFirstParent((PsiElement)element, e -> !(e.getParent() instanceof PsiParenthesizedExpression));
                while (expression != null) {
                    PsiElement parent = expression.getParent();
                    if (parent instanceof PsiExpressionStatement) {
                        PsiElement grandParent = parent.getParent();
                        if (grandParent instanceof PsiForStatement) {
                            if (((PsiForStatement)grandParent).getInitialization() == parent) {
                                return grandParent;
                            }
                            return null;
                        }
                        return parent;
                    }
                    if (parent instanceof PsiLocalVariable && ((PsiLocalVariable)parent).getInitializer() == expression) {
                        PsiElement grandParent = parent.getParent();
                        if (grandParent instanceof PsiDeclarationStatement) {
                            return grandParent;
                        }
                        if (grandParent instanceof PsiResourceList && grandParent.getParent() instanceof PsiTryStatement) {
                            return grandParent.getParent();
                        }
                        return null;
                    }
                    if (parent instanceof PsiIfStatement && ((PsiIfStatement)parent).getCondition() == expression || parent instanceof PsiSwitchBlock && ((PsiSwitchBlock)parent).getExpression() == expression || parent instanceof PsiWhileStatement && ((PsiWhileStatement)parent).getCondition() == expression || parent instanceof PsiForeachStatement && ((PsiForeachStatement)parent).getIteratedValue() == expression || parent instanceof PsiReturnStatement && ((PsiReturnStatement)parent).getReturnValue() == expression || parent instanceof PsiYieldStatement && ((PsiYieldStatement)parent).getExpression() == expression || parent instanceof PsiThrowStatement && ((PsiThrowStatement)parent).getException() == expression || parent instanceof PsiSynchronizedStatement && ((PsiSynchronizedStatement)parent).getLockExpression() == expression || parent instanceof PsiAssertStatement && ((PsiAssertStatement)parent).getAssertCondition() == expression) {
                        return parent;
                    }
                    if (!(parent instanceof PsiExpression)) break;
                    expression = parent;
                }
            }
            return null;
        }

        @Nullable
        private static PsiElement getEnclosingUnreachableStatement(@NotNull PsiElement statement) {
            PsiElement blockParent;
            PsiBlockStatement blockStatement;
            PsiElement parent;
            if (statement == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(1);
            }
            if ((parent = statement.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)parent).getBody() == statement) {
                return parent;
            }
            if (parent instanceof PsiCodeBlock && PsiTreeUtil.getNextSiblingOfType((PsiElement)parent.getFirstChild(), PsiStatement.class) == statement && (blockStatement = (PsiBlockStatement)ObjectUtils.tryCast((Object)parent.getParent(), PsiBlockStatement.class)) != null && (blockParent = blockStatement.getParent()) instanceof PsiDoWhileStatement && ((PsiDoWhileStatement)blockParent).getBody() == blockStatement) {
                return blockParent;
            }
            return UnreachableStatementClientVisitor.getUnreachableStatementParent(statement);
        }

        @Nullable
        private static PsiElement getUnreachableStatementParent(@NotNull PsiElement statement) {
            PsiElement parent;
            if (statement == null) {
                UnreachableStatementClientVisitor.$$$reportNull$$$0(2);
            }
            if ((parent = statement.getParent()) instanceof PsiForStatement && ((PsiForStatement)parent).getInitialization() == statement) {
                return parent;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$UnreachableStatementClientVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getEnclosingUnreachableStatement";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getUnreachableStatementParent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class WalkThroughStack {
        private int[] oldOffsets;
        private int[] newOffsets;
        private CallStackItem[] callStacks;
        private CallStackItem currentStack;
        private int size;

        WalkThroughStack(int initialSize) {
            if (initialSize < 2) {
                initialSize = 2;
            }
            this.oldOffsets = new int[initialSize];
            this.newOffsets = new int[initialSize];
            this.callStacks = new CallStackItem[initialSize];
        }

        void push(int oldOffset, int newOffset) {
            LOG.assertTrue(oldOffset >= 0, (Object)"negative offset is pushed to walk-through stack");
            if (this.size >= this.newOffsets.length) {
                int newSize = this.size * 3 / 2;
                this.oldOffsets = Arrays.copyOf(this.oldOffsets, newSize);
                this.newOffsets = Arrays.copyOf(this.newOffsets, newSize);
                this.callStacks = Arrays.copyOf(this.callStacks, newSize);
            }
            this.oldOffsets[this.size] = oldOffset;
            this.newOffsets[this.size] = newOffset;
            this.callStacks[this.size] = this.currentStack;
            ++this.size;
        }

        void push(int offset) {
            this.push(offset, -1);
        }

        int peekOldOffset() {
            return this.oldOffsets[this.size - 1];
        }

        int popNewOffset() {
            this.currentStack = this.callStacks[--this.size];
            return this.newOffsets[this.size];
        }

        boolean isEmpty() {
            return this.size == 0;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.size; ++i) {
                if (s.length() != 0) {
                    s.append(' ');
                }
                if (this.newOffsets[i] != -1) {
                    s.append('(').append(this.oldOffsets[i]).append("->").append(this.newOffsets[i]).append(')');
                    continue;
                }
                s.append('[').append(this.oldOffsets[i]).append(']');
            }
            return s.toString();
        }
    }

    private static class ReadBeforeWriteClientVisitor
    extends InstructionClientVisitor<List<PsiReferenceExpression>> {
        private final UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>[] readVariables;
        private final ControlFlow myFlow;
        private final boolean localVariablesOnly;

        ReadBeforeWriteClientVisitor(@NotNull ControlFlow flow, boolean localVariablesOnly) {
            if (flow == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.localVariablesOnly = localVariablesOnly;
            this.readVariables = new UnmodifiableHashMap[this.myFlow.getSize() + 1];
            Arrays.fill(this.readVariables, UnmodifiableHashMap.empty());
        }

        @Override
        public void visitReadVariableInstruction(ReadVariableInstruction instruction, int offset, int nextOffset) {
            PsiReferenceExpression expression;
            UnmodifiableHashMap readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            PsiVariable variable = instruction.variable;
            if (!(this.localVariablesOnly && ReadBeforeWriteClientVisitor.isImplicitlyInitialized(variable) || (expression = ControlFlowUtil.getEnclosingReferenceExpression(this.myFlow.getElement(offset), variable)) == null)) {
                readVars = readVars.with((Object)variable, (Object)expression);
            }
            ControlFlowUtil.merge(offset, (UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>)readVars, this.readVariables);
        }

        @Override
        public void visitWriteVariableInstruction(WriteVariableInstruction instruction, int offset, int nextOffset) {
            UnmodifiableHashMap readVars = this.readVariables[Math.min(nextOffset, this.myFlow.getSize())];
            if (readVars.isEmpty()) {
                return;
            }
            PsiVariable variable = instruction.variable;
            if (!this.localVariablesOnly || !ReadBeforeWriteClientVisitor.isImplicitlyInitialized(variable)) {
                readVars = readVars.without((Object)variable);
            }
            ControlFlowUtil.merge(offset, (UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>)readVars, this.readVariables);
        }

        private static boolean isImplicitlyInitialized(@NotNull PsiVariable variable) {
            if (variable == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(1);
            }
            if (variable instanceof PsiPatternVariable) {
                return true;
            }
            if (variable instanceof PsiParameter) {
                PsiParameter parameter = (PsiParameter)variable;
                return !(parameter.getDeclarationScope() instanceof PsiForeachStatement);
            }
            return false;
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            ControlFlowUtil.merge(offset, (UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>)this.readVariables[Math.min(nextOffset, this.myFlow.getSize())], this.readVariables);
        }

        @Override
        public void visitCallInstruction(CallInstruction instruction, int offset, int nextOffset) {
            this.visitInstruction(instruction, offset, nextOffset);
            Arrays.fill(this.readVariables, instruction.procBegin, instruction.procEnd + 1, UnmodifiableHashMap.empty());
        }

        @Override
        @NotNull
        public List<PsiReferenceExpression> getResult() {
            UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> topReadVariables = this.readVariables[0];
            if (topReadVariables.isEmpty()) {
                List<PsiReferenceExpression> list = Collections.emptyList();
                if (list == null) {
                    ReadBeforeWriteClientVisitor.$$$reportNull$$$0(2);
                }
                return list;
            }
            List<PsiReferenceExpression> list = topReadVariables.values().stream().sorted(PsiUtil.BY_POSITION).collect(Collectors.toList());
            if (list == null) {
                ReadBeforeWriteClientVisitor.$$$reportNull$$$0(3);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$ReadBeforeWriteClientVisitor";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "isImplicitlyInitialized";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InitializedTwiceClientVisitor
    extends InstructionClientVisitor<Collection<VariableInfo>> {
        @NotNull
        private final @NotNull UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> @NotNull [] writtenVariables;
        @NotNull
        private final @NotNull UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> @NotNull [] writtenTwiceVariables;
        private final ControlFlow myFlow;
        private final int myStartOffset;

        InitializedTwiceClientVisitor(@NotNull ControlFlow flow, int startOffset) {
            if (flow == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(0);
            }
            this.myFlow = flow;
            this.myStartOffset = startOffset;
            this.writtenVariables = new UnmodifiableHashMap[this.myFlow.getSize() + 1];
            Arrays.fill(this.writtenVariables, UnmodifiableHashMap.empty());
            this.writtenTwiceVariables = (UnmodifiableHashMap[])this.writtenVariables.clone();
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            int safeNextOffset = Math.min(nextOffset, this.myFlow.getSize());
            UnmodifiableHashMap writeVars = this.writtenVariables[safeNextOffset];
            UnmodifiableHashMap writeTwiceVars = this.writtenTwiceVariables[safeNextOffset];
            if (instruction instanceof WriteVariableInstruction) {
                PsiVariable variable = ((WriteVariableInstruction)instruction).variable;
                PsiReferenceExpression latestWriteVarExpression = InitializedTwiceClientVisitor.getLatestWriteVarExpression(writeVars, variable);
                if (latestWriteVarExpression == null) {
                    PsiReferenceExpression expression = InitializedTwiceClientVisitor.getExpression(this.myFlow.getElement(offset));
                    if (expression != null) {
                        writeVars = writeVars.with((Object)variable, (Object)expression);
                    }
                } else {
                    writeTwiceVars = writeTwiceVars.with((Object)variable, (Object)latestWriteVarExpression);
                }
            }
            ControlFlowUtil.merge(offset, (UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>)writeVars, this.writtenVariables);
            ControlFlowUtil.merge(offset, (UnmodifiableHashMap<PsiVariable, PsiReferenceExpression>)writeTwiceVars, this.writtenTwiceVariables);
        }

        @Nullable
        private static PsiReferenceExpression getExpression(@NotNull PsiElement element) {
            if (element == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(1);
            }
            if (element instanceof PsiAssignmentExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown(((PsiAssignmentExpression)element).getLExpression());
                return (PsiReferenceExpression)ObjectUtils.tryCast((Object)target, PsiReferenceExpression.class);
            }
            if (element instanceof PsiUnaryExpression) {
                PsiExpression target = PsiUtil.skipParenthesizedExprDown(((PsiUnaryExpression)element).getOperand());
                return (PsiReferenceExpression)ObjectUtils.tryCast((Object)target, PsiReferenceExpression.class);
            }
            return null;
        }

        @Nullable
        private static PsiReferenceExpression getLatestWriteVarExpression(@NotNull UnmodifiableHashMap<PsiVariable, PsiReferenceExpression> writeVars, @NotNull PsiVariable variable) {
            if (writeVars == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(2);
            }
            if (variable == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(3);
            }
            if (writeVars.isEmpty()) {
                return null;
            }
            PsiManager psiManager = variable.getManager();
            return StreamEx.ofValues(writeVars, v -> psiManager.areElementsEquivalent((PsiElement)v, (PsiElement)variable)).findFirst().orElse(null);
        }

        @Override
        @NotNull
        public Collection<VariableInfo> getResult() {
            List list = ContainerUtil.map((Collection)this.writtenTwiceVariables[this.myStartOffset].entrySet(), entry -> new VariableInfo((PsiVariable)entry.getKey(), (PsiElement)entry.getValue()));
            if (list == null) {
                InitializedTwiceClientVisitor.$$$reportNull$$$0(4);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "writeVars";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$InitializedTwiceClientVisitor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getResult";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpression";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getLatestWriteVarExpression";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class ControlFlowGraph
    extends InstructionClientVisitor<Void> {
        final int[][] nextOffsets;

        ControlFlowGraph(int size) {
            this.nextOffsets = new int[size][];
        }

        @Override
        public void visitInstruction(Instruction instruction, int offset, int nextOffset) {
            if (nextOffset > this.size()) {
                nextOffset = this.size();
            }
            this.addArc(offset, nextOffset);
        }

        void addArc(int offset, int nextOffset) {
            if (this.nextOffsets[offset] == null) {
                this.nextOffsets[offset] = new int[]{nextOffset, -1};
            } else {
                int[] targets = this.nextOffsets[offset];
                if (ArrayUtil.indexOf((int[])targets, (int)nextOffset) < 0) {
                    int freeIndex = ArrayUtil.indexOf((int[])targets, (int)-1);
                    if (freeIndex >= 0) {
                        targets[freeIndex] = nextOffset;
                    } else {
                        int oldLength = targets.length;
                        targets = ArrayUtil.realloc((int[])targets, (int)(oldLength * 3 / 2));
                        this.nextOffsets[offset] = targets;
                        Arrays.fill(targets, oldLength, targets.length, -1);
                        targets[oldLength] = nextOffset;
                    }
                }
            }
        }

        int @NotNull [] getNextOffsets(int offset) {
            int[] nArray = this.nextOffsets[offset] != null ? this.nextOffsets[offset] : ArrayUtilRt.EMPTY_INT_ARRAY;
            if (nArray == null) {
                ControlFlowGraph.$$$reportNull$$$0(0);
            }
            return nArray;
        }

        int size() {
            return this.nextOffsets.length;
        }

        public String toString() {
            StringBuilder s = new StringBuilder();
            for (int i = 0; i < this.nextOffsets.length; ++i) {
                int[] targets = this.nextOffsets[i];
                if (targets == null || targets.length == 0 || targets[0] == -1) continue;
                if (s.length() != 0) {
                    s.append(' ');
                }
                s.append('(').append(i).append("->");
                for (int j = 0; j < targets.length && targets[j] != -1; ++j) {
                    if (j != 0) {
                        s.append(",");
                    }
                    s.append(targets[j]);
                }
                s.append(')');
            }
            return s.toString();
        }

        boolean depthFirstSearch(int startOffset) {
            return this.depthFirstSearch(startOffset, new BitSet(this.size()));
        }

        boolean depthFirstSearch(int startOffset, @NotNull BitSet visitedOffsets) {
            if (visitedOffsets == null) {
                ControlFlowGraph.$$$reportNull$$$0(1);
            }
            IntArrayList walkThroughStack = new IntArrayList(Math.max(this.size() / 2, 2));
            visitedOffsets.clear();
            walkThroughStack.push(startOffset);
            while (!walkThroughStack.isEmpty()) {
                int[] nextOffsets;
                int currentOffset = walkThroughStack.popInt();
                if (currentOffset >= this.size() || visitedOffsets.get(currentOffset)) continue;
                visitedOffsets.set(currentOffset);
                for (int nextOffset : nextOffsets = this.getNextOffsets(currentOffset)) {
                    if (nextOffset == -1) break;
                    if (this.isComplete(currentOffset, nextOffset)) {
                        return true;
                    }
                    walkThroughStack.push(nextOffset);
                }
            }
            return false;
        }

        @Override
        public Void getResult() {
            return null;
        }

        boolean isComplete(int offset, int nextOffset) {
            return false;
        }

        void buildFrom(@NotNull ControlFlow flow) {
            if (flow == null) {
                ControlFlowGraph.$$$reportNull$$$0(2);
            }
            ControlFlowUtil.depthFirstSearch(flow, this, 0, flow.getSize());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/controlFlow/ControlFlowUtil$ControlFlowGraph";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitedOffsets";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "flow";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOffsets";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/controlFlow/ControlFlowUtil$ControlFlowGraph";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "depthFirstSearch";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "buildFrom";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static final class CallStackItem {
        final CallStackItem next;
        final int target;

        private CallStackItem(CallStackItem next, int target) {
            this.next = next;
            this.target = target;
        }
    }

    public static class ControlFlowEdge {
        public final int myFrom;
        public final int myTo;

        ControlFlowEdge(int from, int to) {
            this.myFrom = from;
            this.myTo = to;
        }

        public String toString() {
            return this.myFrom + "->" + this.myTo;
        }
    }
}

