/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInsight.NullabilityAnnotationInfo;
import com.intellij.codeInsight.NullabilitySource;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.TypeNullability;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class JavaTypeNullabilityUtil {
    @NotNull
    public static TypeNullability getTypeNullability(@NotNull PsiClassType type) {
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(0);
        }
        return JavaTypeNullabilityUtil.getTypeNullability(type, null, !JavaTypeNullabilityUtil.isLocal(type));
    }

    @NotNull
    private static TypeNullability getTypeNullability(@NotNull PsiClassType type, @Nullable Set<PsiClassType> visited, boolean checkContainer) {
        NullabilityAnnotationInfo typeUseNullability;
        NullableNotNullManager manager;
        if (type == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(1);
        }
        if (visited != null && visited.contains(type)) {
            TypeNullability typeNullability = TypeNullability.UNKNOWN;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(2);
            }
            return typeNullability;
        }
        TypeNullability fromAnnotations = JavaTypeNullabilityUtil.getNullabilityFromAnnotations(type.getAnnotations());
        if (!fromAnnotations.equals(TypeNullability.UNKNOWN)) {
            TypeNullability typeNullability = fromAnnotations;
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(3);
            }
            return typeNullability;
        }
        PsiElement context = type.getPsiContext();
        if (context != null && checkContainer && (manager = NullableNotNullManager.getInstance(context.getProject())) != null && (typeUseNullability = manager.findDefaultTypeUseNullability(context)) != null) {
            TypeNullability typeNullability = typeUseNullability.toTypeNullability();
            if (typeNullability == null) {
                JavaTypeNullabilityUtil.$$$reportNull$$$0(4);
            }
            return typeNullability;
        }
        PsiClass target = type.resolve();
        if (target instanceof PsiTypeParameter) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)target;
            PsiReferenceList extendsList = typeParameter.getExtendsList();
            Object[] extendTypes = extendsList.getReferencedTypes();
            if (extendTypes.length == 0 && checkContainer) {
                NullabilityAnnotationInfo typeUseNullability2;
                NullableNotNullManager manager2 = NullableNotNullManager.getInstance(typeParameter.getProject());
                NullabilityAnnotationInfo nullabilityAnnotationInfo = typeUseNullability2 = manager2 == null ? null : manager2.findDefaultTypeUseNullability(typeParameter);
                if (typeUseNullability2 != null) {
                    TypeNullability typeNullability = typeUseNullability2.toTypeNullability().inherited();
                    if (typeNullability == null) {
                        JavaTypeNullabilityUtil.$$$reportNull$$$0(5);
                    }
                    return typeNullability;
                }
            } else {
                HashSet<PsiClassType> nextVisited = visited == null ? new HashSet<PsiClassType>() : visited;
                nextVisited.add(type);
                List nullabilities = ContainerUtil.map((Object[])extendTypes, t -> JavaTypeNullabilityUtil.getTypeNullability(t, nextVisited, checkContainer));
                TypeNullability typeNullability = TypeNullability.intersect(nullabilities).inherited();
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(6);
                }
                return typeNullability;
            }
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(7);
        }
        return typeNullability;
    }

    private static boolean isLocal(PsiClassType classType) {
        PsiElement context = classType.getPsiContext();
        return context instanceof PsiJavaCodeReferenceElement && context.getParent() instanceof PsiTypeElement && context.getParent().getParent() instanceof PsiLocalVariable;
    }

    @NotNull
    public static TypeNullability getNullabilityFromAnnotations(@NotNull @NotNull PsiAnnotation @NotNull [] annotations) {
        if (annotations == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(8);
        }
        for (PsiAnnotation annotation : annotations) {
            String qualifiedName = annotation.getQualifiedName();
            NullableNotNullManager manager = NullableNotNullManager.getInstance(annotation.getProject());
            if (manager == null) {
                TypeNullability typeNullability = TypeNullability.UNKNOWN;
                if (typeNullability == null) {
                    JavaTypeNullabilityUtil.$$$reportNull$$$0(9);
                }
                return typeNullability;
            }
            Optional<Nullability> optionalNullability = manager.getAnnotationNullability(qualifiedName);
            if (!optionalNullability.isPresent()) continue;
            Nullability nullability = optionalNullability.get();
            return new TypeNullability(nullability, new NullabilitySource.ExplicitAnnotation(annotation));
        }
        TypeNullability typeNullability = TypeNullability.UNKNOWN;
        if (typeNullability == null) {
            JavaTypeNullabilityUtil.$$$reportNull$$$0(10);
        }
        return typeNullability;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JavaTypeNullabilityUtil";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeNullability";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getNullabilityFromAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getTypeNullability";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNullabilityFromAnnotations";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

