/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.lower.inline;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.CommonBackendErrors;
import org.jetbrains.kotlin.backend.common.ModuleLoweringPass;
import org.jetbrains.kotlin.backend.common.PreSerializationLoweringContext;
import org.jetbrains.kotlin.backend.common.lower.inline.CallEdge;
import org.jetbrains.kotlin.backend.common.lower.inline.CallNode;
import org.jetbrains.kotlin.backend.common.lower.inline.IrInlineCallGraphBuilder;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.impl.DeduplicatingDiagnosticReporterKt;
import org.jetbrains.kotlin.ir.IrDiagnosticReporter;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.KtDiagnosticReporterWithImplicitIrBasedContext;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@PhaseDescription(name="InlineCallCycleCheckerLowering")
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J8\u0010\u000e\u001a\u00020\u000b2\u0018\u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0011\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u00102\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0012H\u0002R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering;", "Context", "Lorg/jetbrains/kotlin/backend/common/PreSerializationLoweringContext;", "Lorg/jetbrains/kotlin/backend/common/ModuleLoweringPass;", "context", "<init>", "(Lorg/jetbrains/kotlin/backend/common/PreSerializationLoweringContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/common/PreSerializationLoweringContext;", "Lorg/jetbrains/kotlin/backend/common/PreSerializationLoweringContext;", "lower", "", "irModule", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "traverseCallGraph", "callGraph", "", "Lorg/jetbrains/kotlin/backend/common/lower/inline/CallNode;", "", "Lorg/jetbrains/kotlin/backend/common/lower/inline/CallEdge;", "diagnosticReporter", "Lorg/jetbrains/kotlin/ir/IrDiagnosticReporter;", "callsInInlineCycle", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "ir.backend.common"})
@SourceDebugExtension(value={"SMAP\nInlineCallCycleCheckerLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InlineCallCycleCheckerLowering.kt\norg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,127:1\n1914#2,2:128\n951#2,15:130\n1914#2,2:145\n1914#2,2:147\n*S KotlinDebug\n*F\n+ 1 InlineCallCycleCheckerLowering.kt\norg/jetbrains/kotlin/backend/common/lower/inline/InlineCallCycleCheckerLowering\n*L\n83#1:128,2\n65#1:130,15\n66#1:145,2\n76#1:147,2\n*E\n"})
public final class InlineCallCycleCheckerLowering<Context extends PreSerializationLoweringContext>
implements ModuleLoweringPass {
    @NotNull
    private final Context context;

    public InlineCallCycleCheckerLowering(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter(context2, (String)"context");
        this.context = context2;
    }

    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @Override
    public void lower(@NotNull IrModuleFragment irModule) {
        Intrinsics.checkNotNullParameter((Object)irModule, (String)"irModule");
        KtDiagnosticReporterWithImplicitIrBasedContext irDiagnosticReporter = new KtDiagnosticReporterWithImplicitIrBasedContext((DiagnosticReporter)DeduplicatingDiagnosticReporterKt.deduplicating((DiagnosticReporter)((PreSerializationLoweringContext)this.context).getDiagnosticReporter()), CommonConfigurationKeysKt.getLanguageVersionSettings((CompilerConfiguration)((PreSerializationLoweringContext)this.context).getConfiguration()));
        Set callsInInlineCycle = new LinkedHashSet();
        Map callGraph = new LinkedHashMap();
        irModule.accept(new IrInlineCallGraphBuilder(callGraph), null);
        this.traverseCallGraph(callGraph, irDiagnosticReporter, callsInInlineCycle);
    }

    private final void traverseCallGraph(Map<CallNode, Set<CallEdge>> callGraph, IrDiagnosticReporter diagnosticReporter, Set<IrCall> callsInInlineCycle) {
        Set visited = new LinkedHashSet();
        Set completed = new LinkedHashSet();
        List inlineCallsStack = new ArrayList();
        Iterable $this$forEach$iv = callGraph.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CallNode it = (CallNode)element$iv;
            boolean bl = false;
            InlineCallCycleCheckerLowering.traverseCallGraph$dfs(it, visited, completed, inlineCallsStack, callGraph, callsInInlineCycle, diagnosticReporter, null);
        }
    }

    private static final Unit traverseCallGraph$reportInlineCallCycle(Set<IrCall> $callsInInlineCycle, IrDiagnosticReporter $diagnosticReporter, IrFunction caller, CallEdge callee) {
        Unit unit;
        IrCall irCall = callee.getCall();
        if (irCall != null) {
            IrCall call = irCall;
            boolean bl = false;
            $callsInInlineCycle.add(call);
            $diagnosticReporter.at((IrElement)call, IrUtilsKt.getFile(caller)).report(CommonBackendErrors.INSTANCE.getINLINE_CALL_CYCLE(), (Object)callee.getCallNode().getFunction());
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }

    private static final void traverseCallGraph$dfs(CallNode $this$traverseCallGraph_u24dfs, Set<CallNode> visited, Set<CallNode> completed, List<CallEdge> inlineCallsStack, Map<CallNode, Set<CallEdge>> $callGraph, Set<IrCall> $callsInInlineCycle, IrDiagnosticReporter $diagnosticReporter, IrCall call) {
        if (visited.contains($this$traverseCallGraph_u24dfs)) {
            if (!completed.contains($this$traverseCallGraph_u24dfs)) {
                List list;
                block11: {
                    List<CallEdge> $this$takeLastWhile$iv = inlineCallsStack;
                    boolean $i$f$takeLastWhile = false;
                    if ($this$takeLastWhile$iv.isEmpty()) {
                        list = CollectionsKt.emptyList();
                    } else {
                        ListIterator<CallEdge> iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            CallEdge callEdge = iterator$iv.previous();
                            boolean bl = false;
                            CallNode callNode = callEdge.component2();
                            if (!Intrinsics.areEqual((Object)callNode, (Object)$this$traverseCallGraph_u24dfs)) continue;
                            iterator$iv.next();
                            int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                            if (expectedSize$iv == 0) {
                                list = CollectionsKt.emptyList();
                            } else {
                                ArrayList<CallEdge> arrayList;
                                ArrayList<CallEdge> $this$takeLastWhile_u24lambda_u240$iv = arrayList = new ArrayList<CallEdge>(expectedSize$iv);
                                boolean bl2 = false;
                                while (iterator$iv.hasNext()) {
                                    $this$takeLastWhile_u24lambda_u240$iv.add(iterator$iv.next());
                                }
                                list = arrayList;
                            }
                            break block11;
                        }
                        list = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
                    }
                }
                List edgesInCycle = CollectionsKt.plus((Collection)list, (Object)new CallEdge(call, $this$traverseCallGraph_u24dfs));
                Iterable $this$forEach$iv = CollectionsKt.zipWithNext((Iterable)CollectionsKt.plus((Collection)edgesInCycle, (Object)CollectionsKt.first((List)edgesInCycle)));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair pair = (Pair)element$iv;
                    boolean bl = false;
                    CallEdge callerEdge = (CallEdge)pair.component1();
                    CallEdge calleeEdge = (CallEdge)pair.component2();
                    InlineCallCycleCheckerLowering.traverseCallGraph$reportInlineCallCycle($callsInInlineCycle, $diagnosticReporter, callerEdge.getCallNode().getFunction(), calleeEdge);
                }
            }
            return;
        }
        ((Collection)inlineCallsStack).add(new CallEdge(call, $this$traverseCallGraph_u24dfs));
        ((Collection)visited).add($this$traverseCallGraph_u24dfs);
        Set<CallEdge> set = $callGraph.get($this$traverseCallGraph_u24dfs);
        if (set != null) {
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CallEdge callEdge = (CallEdge)element$iv;
                boolean bl = false;
                IrCall call2 = callEdge.component1();
                CallNode node = callEdge.component2();
                InlineCallCycleCheckerLowering.traverseCallGraph$dfs(node, visited, completed, inlineCallsStack, $callGraph, $callsInInlineCycle, $diagnosticReporter, call2);
            }
        }
        CollectionsKt.removeLast(inlineCallsStack);
        ((Collection)completed).add($this$traverseCallGraph_u24dfs);
    }
}

