/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.common.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.IrModuleDependencies;
import org.jetbrains.kotlin.backend.common.serialization.IrModuleDependencyTracker;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.utils.CollectionsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDependencyTrackerImpl;", "Lorg/jetbrains/kotlin/backend/common/serialization/IrModuleDependencyTracker;", "<init>", "()V", "trackedModules", "", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "", "addModuleForTracking", "", "module", "trackDependency", "fromModule", "toModule", "reverseTopoOrder", "Lorg/jetbrains/kotlin/backend/common/IrModuleDependencies;", "moduleDependencies", "ir.serialization.common"})
@SourceDebugExtension(value={"SMAP\nIrModuleDependencyTracker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrModuleDependencyTracker.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDependencyTrackerImpl\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1#2:69\n776#3:70\n872#3,2:71\n872#3,2:73\n*S KotlinDebug\n*F\n+ 1 IrModuleDependencyTracker.kt\norg/jetbrains/kotlin/backend/common/serialization/IrModuleDependencyTrackerImpl\n*L\n54#1:70\n54#1:71,2\n60#1:73,2\n*E\n"})
public final class IrModuleDependencyTrackerImpl
implements IrModuleDependencyTracker {
    @NotNull
    private final Map<IrModuleFragment, Set<IrModuleFragment>> trackedModules = new LinkedHashMap();

    @Override
    public void addModuleForTracking(@NotNull IrModuleFragment module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Set<IrModuleFragment> oldValue = this.trackedModules.put(module, new LinkedHashSet());
        if (!(oldValue == null)) {
            boolean bl = false;
            String string = "Module " + module.getName() + " is already present in " + Reflection.getOrCreateKotlinClass(this.getClass());
            throw new IllegalStateException(string.toString());
        }
    }

    @Override
    public void trackDependency(@NotNull IrModuleFragment fromModule, @NotNull IrModuleFragment toModule) {
        Intrinsics.checkNotNullParameter((Object)fromModule, (String)"fromModule");
        Intrinsics.checkNotNullParameter((Object)toModule, (String)"toModule");
        if (fromModule != toModule) {
            Set<IrModuleFragment> set = this.trackedModules.get(fromModule);
            if (set == null) {
                throw new IllegalStateException(("No module data for " + fromModule.getName() + " in " + Reflection.getOrCreateKotlinClass(this.getClass())).toString());
            }
            Set<IrModuleFragment> dependencies = set;
            dependencies.add(toModule);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public IrModuleDependencies reverseTopoOrder(@NotNull IrModuleDependencies moduleDependencies) {
        void $this$filterTo$iv;
        List list;
        Object element$iv$iv2;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)moduleDependencies, (String)"moduleDependencies");
        Set modulesToSort = kotlin.collections.CollectionsKt.toSet((Iterable)moduleDependencies.getAll());
        Set untrackedModules = SetsKt.minus(this.trackedModules.keySet(), (Iterable)modulesToSort);
        if (!untrackedModules.isEmpty()) {
            boolean $i$a$-check-IrModuleDependencyTrackerImpl$reverseTopoOrder$22 = false;
            String $i$a$-check-IrModuleDependencyTrackerImpl$reverseTopoOrder$22 = "The following modules are not being tracked in " + Reflection.getOrCreateKotlinClass(this.getClass()) + ": " + kotlin.collections.CollectionsKt.joinToString$default((Iterable)untrackedModules, null, null, null, (int)0, null, IrModuleDependencyTrackerImpl::reverseTopoOrder$lambda$0$0, (int)31, null);
            throw new IllegalStateException($i$a$-check-IrModuleDependencyTrackerImpl$reverseTopoOrder$22.toString());
        }
        if (modulesToSort.size() <= 1) {
            return moduleDependencies;
        }
        List list2 = DFS.topologicalOrder((Iterable)modulesToSort, arg_0 -> IrModuleDependencyTrackerImpl.reverseTopoOrder$lambda$1(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"topologicalOrder(...)");
        Iterable $i$a$-check-IrModuleDependencyTrackerImpl$reverseTopoOrder$22 = list2;
        boolean $i$f$filter = false;
        void var7_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv$iv2;
            boolean bl = false;
            if (!modulesToSort.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        List sortedModules = kotlin.collections.CollectionsKt.reversed((Iterable)((List)destination$iv$iv));
        boolean bl = false;
        List $this$reverseTopoOrder_u24lambda_u243_u240 = list = kotlin.collections.CollectionsKt.createListBuilder();
        boolean bl2 = false;
        CollectionsKt.addIfNotNull((Collection)$this$reverseTopoOrder_u24lambda_u243_u240, (Object)moduleDependencies.getStdlib());
        element$iv$iv2 = sortedModules;
        Collection destination$iv = $this$reverseTopoOrder_u24lambda_u243_u240;
        boolean $i$f$filterTo2 = false;
        for (Object element$iv : $this$filterTo$iv) {
            IrModuleFragment it = (IrModuleFragment)element$iv;
            boolean bl3 = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)moduleDependencies.getStdlib()) && !Intrinsics.areEqual((Object)it, (Object)moduleDependencies.getIncluded()))) continue;
            destination$iv.add(element$iv);
        }
        CollectionsKt.addIfNotNull((Collection)$this$reverseTopoOrder_u24lambda_u243_u240, (Object)moduleDependencies.getIncluded());
        List sortedModules2 = kotlin.collections.CollectionsKt.build((List)list);
        return IrModuleDependencies.copy$default(moduleDependencies, sortedModules2, null, null, null, 14, null);
    }

    private static final CharSequence reverseTopoOrder$lambda$0$0(IrModuleFragment it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return string;
    }

    private static final Iterable reverseTopoOrder$lambda$1(IrModuleDependencyTrackerImpl this$0, IrModuleFragment module) {
        return (Iterable)MapsKt.getValue(this$0.trackedModules, (Object)module);
    }
}

