/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.InternalSymbolFinderAPI;
import org.jetbrains.kotlin.ir.SymbolFinder;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrFunctionSymbol;
import org.jetbrains.kotlin.ir.symbols.IrPropertySymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.util.IrExceptionBuilder;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@InternalSymbolFinderAPI
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0007\u001a\u00020\bH&J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH&J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0010\u001a\u00020\nH&J/\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00052\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J+\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0014\b\u0002\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u0014\"\u00020\u0015\u00a2\u0006\u0002\u0010\u0019J\u0018\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u001a\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0015J\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0015J\u001c\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0015J*\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0086\b\u00f8\u0001\u0000J2\u0010\u001e\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00152\u0014\b\u0002\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 H\u0086\b\u00f8\u0001\u0000J\u0016\u0010#\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u0015\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/SymbolFinder;", "", "<init>", "()V", "findFunctions", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "callableId", "Lorg/jetbrains/kotlin/name/CallableId;", "findProperties", "Lorg/jetbrains/kotlin/ir/symbols/IrPropertySymbol;", "findClass", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findGetter", "property", "name", "Lorg/jetbrains/kotlin/name/Name;", "packageNameSegments", "", "", "(Lorg/jetbrains/kotlin/name/Name;[Ljava/lang/String;)Ljava/lang/Iterable;", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "(Lorg/jetbrains/kotlin/name/Name;[Ljava/lang/String;)Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "topLevelClass", "packageName", "topLevelProperty", "topLevelFunctions", "topLevelFunction", "condition", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/symbols/IrFunctionSymbol;", "", "findTopLevelPropertyGetter", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrBuiltIns.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrBuiltIns.kt\norg/jetbrains/kotlin/ir/SymbolFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt\n+ 5 IrExceptionUtils.kt\norg/jetbrains/kotlin/ir/util/IrExceptionUtilsKt$irError$1\n*L\n1#1,316:1\n296#1:321\n297#1:325\n298#1,4:327\n296#1:331\n297#1,5:335\n1#2:317\n1#2:326\n1#2:345\n776#3:318\n872#3,2:319\n776#3:322\n872#3,2:323\n776#3:332\n872#3,2:333\n24#4,5:340\n29#4:347\n26#5:346\n*S KotlinDebug\n*F\n+ 1 IrBuiltIns.kt\norg/jetbrains/kotlin/ir/SymbolFinder\n*L\n309#1:321\n309#1:325\n309#1:327,4\n309#1:331\n309#1:335,5\n309#1:326\n314#1:345\n296#1:318\n296#1:319,2\n309#1:322\n309#1:323,2\n309#1:332\n309#1:333,2\n314#1:340,5\n314#1:347\n314#1:346\n*E\n"})
public abstract class SymbolFinder {
    @NotNull
    public abstract Iterable<IrSimpleFunctionSymbol> findFunctions(@NotNull CallableId var1);

    @NotNull
    public abstract Iterable<IrPropertySymbol> findProperties(@NotNull CallableId var1);

    @Nullable
    public abstract IrClassSymbol findClass(@NotNull ClassId var1);

    @Nullable
    public abstract IrSimpleFunctionSymbol findGetter(@NotNull IrPropertySymbol var1);

    @NotNull
    public final Iterable<IrSimpleFunctionSymbol> findFunctions(@NotNull Name name, String ... packageNameSegments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageNameSegments, (String)"packageNameSegments");
        return this.findFunctions(new CallableId(FqName.Companion.fromSegments(CollectionsKt.listOf((Object[])Arrays.copyOf(packageNameSegments, packageNameSegments.length))), name));
    }

    public static /* synthetic */ Iterable findFunctions$default(SymbolFinder symbolFinder, Name name, String[] stringArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findFunctions");
        }
        if ((n & 2) != 0) {
            String[] stringArray2 = new String[]{"kotlin"};
            stringArray = stringArray2;
        }
        return symbolFinder.findFunctions(name, stringArray);
    }

    @NotNull
    public final Iterable<IrSimpleFunctionSymbol> findFunctions(@NotNull Name name, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.findFunctions(new CallableId(packageFqName, name));
    }

    @NotNull
    public final Iterable<IrPropertySymbol> findProperties(@NotNull Name name, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.findProperties(new CallableId(packageFqName, name));
    }

    @Nullable
    public final IrClassSymbol findClass(@NotNull Name name, String ... packageNameSegments) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageNameSegments, (String)"packageNameSegments");
        return this.findClass(new ClassId(FqName.Companion.fromSegments(CollectionsKt.listOf((Object[])Arrays.copyOf(packageNameSegments, packageNameSegments.length))), name));
    }

    public static /* synthetic */ IrClassSymbol findClass$default(SymbolFinder symbolFinder, Name name, String[] stringArray, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findClass");
        }
        if ((n & 2) != 0) {
            String[] stringArray2 = new String[]{"kotlin"};
            stringArray = stringArray2;
        }
        return symbolFinder.findClass(name, stringArray);
    }

    @Nullable
    public final IrClassSymbol findClass(@NotNull Name name, @NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        return this.findClass(new ClassId(packageFqName, name));
    }

    @NotNull
    public final IrClassSymbol topLevelClass(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        IrClassSymbol irClassSymbol = this.findClass(classId.getShortClassName(), classId.getPackageFqName());
        if (irClassSymbol == null) {
            throw new IllegalStateException(("No class " + classId + " found").toString());
        }
        return irClassSymbol;
    }

    @NotNull
    public final IrClassSymbol topLevelClass(@NotNull FqName packageName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        IrClassSymbol irClassSymbol = this.findClass(name2, packageName);
        if (irClassSymbol == null) {
            throw new IllegalStateException(("No class " + packageName + '.' + name + " found").toString());
        }
        return irClassSymbol;
    }

    @NotNull
    public final IrPropertySymbol topLevelProperty(@NotNull FqName packageName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        List elements = CollectionsKt.toList(this.findProperties(name2, packageName));
        if (!(!((Collection)elements).isEmpty())) {
            boolean $i$a$-require-SymbolFinder$topLevelProperty$32 = false;
            String $i$a$-require-SymbolFinder$topLevelProperty$32 = "No property " + packageName + '.' + name + " found";
            throw new IllegalArgumentException($i$a$-require-SymbolFinder$topLevelProperty$32.toString());
        }
        if (!(elements.size() == 1)) {
            boolean bl = false;
            String string = "Several properties " + packageName + '.' + name + " found:\n" + CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return (IrPropertySymbol)CollectionsKt.single((List)elements);
    }

    @NotNull
    public final Iterable<IrSimpleFunctionSymbol> topLevelFunctions(@NotNull FqName packageName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        return this.findFunctions(name2, packageName);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunctionSymbol topLevelFunction(@NotNull CallableId callableId, @NotNull Function1<? super IrFunctionSymbol, Boolean> condition) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        boolean $i$f$topLevelFunction = false;
        Iterable<IrSimpleFunctionSymbol> $this$filter$iv = this.findFunctions(callableId);
        boolean $i$f$filter = false;
        Iterable<IrSimpleFunctionSymbol> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (!(!((Collection)elements).isEmpty())) {
            boolean $i$a$-require-SymbolFinder$topLevelFunction$42 = false;
            String $i$a$-require-SymbolFinder$topLevelFunction$42 = "No function " + callableId + " found corresponding given condition";
            throw new IllegalArgumentException($i$a$-require-SymbolFinder$topLevelFunction$42.toString());
        }
        if (!(elements.size() == 1)) {
            boolean bl = false;
            String string = "Several functions " + callableId + " found corresponding given condition:\n" + CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return (IrSimpleFunctionSymbol)CollectionsKt.single((List)elements);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ IrSimpleFunctionSymbol topLevelFunction$default(SymbolFinder $this, CallableId callableId, Function1 condition, int n, Object object) {
        void $this$filterTo$iv$iv;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: topLevelFunction");
        }
        if ((n & 2) != 0) {
            condition = topLevelFunction.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)callableId, (String)"callableId");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        boolean $i$f$topLevelFunction = false;
        Iterable<IrSimpleFunctionSymbol> $this$filter$iv = $this.findFunctions(callableId);
        boolean $i$f$filter = false;
        Iterable<IrSimpleFunctionSymbol> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv)).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List elements = (List)destination$iv$iv;
        if (!(!((Collection)elements).isEmpty())) {
            boolean $i$a$-require-SymbolFinder$topLevelFunction$42 = false;
            String $i$a$-require-SymbolFinder$topLevelFunction$42 = "No function " + callableId + " found corresponding given condition";
            throw new IllegalArgumentException($i$a$-require-SymbolFinder$topLevelFunction$42.toString());
        }
        if (!(elements.size() == 1)) {
            boolean bl = false;
            String string = "Several functions " + callableId + " found corresponding given condition:\n" + CollectionsKt.joinToString$default((Iterable)elements, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return (IrSimpleFunctionSymbol)CollectionsKt.single((List)elements);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IrSimpleFunctionSymbol topLevelFunction(@NotNull FqName packageName, @NotNull String name, @NotNull Function1<? super IrFunctionSymbol, Boolean> condition) {
        void $this$filterTo$iv$iv$iv;
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(condition, (String)"condition");
        boolean $i$f$topLevelFunction = false;
        SymbolFinder symbolFinder = this;
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        CallableId callableId$iv = new CallableId(packageName, name2);
        boolean $i$f$topLevelFunction2 = false;
        Iterable<IrSimpleFunctionSymbol> $this$filter$iv$iv = this_$iv.findFunctions(callableId$iv);
        boolean $i$f$filter = false;
        Iterable<IrSimpleFunctionSymbol> iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv$iv)).booleanValue()) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List elements$iv = (List)destination$iv$iv$iv;
        if (!(!((Collection)elements$iv).isEmpty())) {
            boolean $i$a$-require-SymbolFinder$topLevelFunction$2$iv22 = false;
            String $i$a$-require-SymbolFinder$topLevelFunction$2$iv22 = "No function " + callableId$iv + " found corresponding given condition";
            throw new IllegalArgumentException($i$a$-require-SymbolFinder$topLevelFunction$2$iv22.toString());
        }
        if (!(elements$iv.size() == 1)) {
            boolean bl = false;
            String string = "Several functions " + callableId$iv + " found corresponding given condition:\n" + CollectionsKt.joinToString$default((Iterable)elements$iv, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return (IrSimpleFunctionSymbol)CollectionsKt.single((List)elements$iv);
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ IrSimpleFunctionSymbol topLevelFunction$default(SymbolFinder $this, FqName packageName, String name, Function1 condition, int n, Object object) {
        void $this$filterTo$iv$iv$iv;
        void this_$iv;
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: topLevelFunction");
        }
        if ((n & 4) != 0) {
            condition = topLevelFunction.4.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        boolean $i$f$topLevelFunction = false;
        object = $this;
        Name name2 = Name.identifier((String)name);
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        CallableId callableId$iv = new CallableId(packageName, name2);
        boolean $i$f$topLevelFunction2 = false;
        Iterable<IrSimpleFunctionSymbol> $this$filter$iv$iv = this_$iv.findFunctions(callableId$iv);
        boolean $i$f$filter = false;
        Iterable<IrSimpleFunctionSymbol> iterable = $this$filter$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv$iv : $this$filterTo$iv$iv$iv) {
            if (!((Boolean)condition.invoke(element$iv$iv$iv)).booleanValue()) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        List elements$iv = (List)destination$iv$iv$iv;
        if (!(!((Collection)elements$iv).isEmpty())) {
            boolean $i$a$-require-SymbolFinder$topLevelFunction$2$iv22 = false;
            String $i$a$-require-SymbolFinder$topLevelFunction$2$iv22 = "No function " + callableId$iv + " found corresponding given condition";
            throw new IllegalArgumentException($i$a$-require-SymbolFinder$topLevelFunction$2$iv22.toString());
        }
        if (!(elements$iv.size() == 1)) {
            boolean bl = false;
            String string = "Several functions " + callableId$iv + " found corresponding given condition:\n" + CollectionsKt.joinToString$default((Iterable)elements$iv, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
            throw new IllegalArgumentException(string.toString());
        }
        return (IrSimpleFunctionSymbol)CollectionsKt.single((List)elements$iv);
    }

    @NotNull
    public final IrSimpleFunctionSymbol findTopLevelPropertyGetter(@NotNull FqName packageName, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        IrSimpleFunctionSymbol irSimpleFunctionSymbol = this.findGetter(this.topLevelProperty(packageName, name));
        if (irSimpleFunctionSymbol == null) {
            IrExceptionBuilder irExceptionBuilder;
            String message$iv = "Cannot find getter for " + packageName + '.' + name;
            boolean $i$f$irError = false;
            IrExceptionBuilder $this$irError_u24lambda_u240$iv = irExceptionBuilder = new IrExceptionBuilder(message$iv);
            boolean bl = false;
            IrExceptionBuilder irExceptionBuilder2 = $this$irError_u24lambda_u240$iv;
            boolean bl2 = false;
            IrExceptionBuilder irExceptionBuilder3 = irExceptionBuilder2;
            IrExceptionBuilder builder$iv = irExceptionBuilder;
            throw new IllegalStateException(builder$iv.buildString().toString());
        }
        return irSimpleFunctionSymbol;
    }
}

