/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.stack;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrReturnTarget;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.interpreter.Instruction;
import org.jetbrains.kotlin.ir.interpreter.InstructionKt;
import org.jetbrains.kotlin.ir.interpreter.InstructionsUnfolderKt;
import org.jetbrains.kotlin.ir.interpreter.stack.Frame;
import org.jetbrains.kotlin.ir.interpreter.stack.Variable;
import org.jetbrains.kotlin.ir.interpreter.state.State;
import org.jetbrains.kotlin.ir.interpreter.state.StateWithClosure;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0015\u001a\u00020\u000fJ\u0006\u0010\u0016\u001a\u00020\u000fJ\u0006\u0010\u0017\u001a\u00020\u000fJ\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u000fJ\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020#J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020'J\u0006\u0010(\u001a\u00020'J\b\u0010)\u001a\u0004\u0018\u00010'J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\b\u0010&\u001a\u0004\u0018\u00010'J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u000e\u0010/\u001a\u00020 2\u0006\u0010+\u001a\u00020,J\u000e\u00100\u001a\u00020'2\u0006\u0010+\u001a\u00020,J\u0016\u00101\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020,2\u0006\u00102\u001a\u00020'J\u000e\u00103\u001a\u00020\u000f2\u0006\u0010&\u001a\u000204J\u000e\u00105\u001a\u00020\u000f2\u0006\u0010&\u001a\u000204J\u0006\u00106\u001a\u00020\u000fJ\f\u00107\u001a\b\u0012\u0004\u0012\u00020908J\u0006\u0010:\u001a\u000209J\u0006\u0010;\u001a\u00020<R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006="}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/stack/CallStack;", "", "<init>", "()V", "frames", "Lkotlin/collections/ArrayDeque;", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "currentFrame", "getCurrentFrame", "()Lorg/jetbrains/kotlin/ir/interpreter/stack/Frame;", "currentFrameOwner", "Lorg/jetbrains/kotlin/ir/IrElement;", "getCurrentFrameOwner$ir_interpreter", "()Lorg/jetbrains/kotlin/ir/IrElement;", "newFrame", "", "frameOwner", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "Lorg/jetbrains/kotlin/ir/declarations/IrFunction;", "newSubFrame", "dropFrame", "dropFrameAndCopyResult", "dropSubFrame", "returnFromFrameWithResult", "irReturn", "Lorg/jetbrains/kotlin/ir/expressions/IrReturn;", "unrollInstructionsForBreakContinue", "breakOrContinue", "Lorg/jetbrains/kotlin/ir/expressions/IrBreakContinue;", "dropFramesUntilTryCatch", "hasNoInstructions", "", "pushInstruction", "instruction", "Lorg/jetbrains/kotlin/ir/interpreter/Instruction;", "popInstruction", "pushState", "state", "Lorg/jetbrains/kotlin/ir/interpreter/state/State;", "popState", "peekState", "storeState", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrSymbol;", "variable", "Lorg/jetbrains/kotlin/ir/interpreter/stack/Variable;", "containsStateInMemory", "loadState", "rewriteState", "newState", "storeUpValues", "Lorg/jetbrains/kotlin/ir/interpreter/state/StateWithClosure;", "loadUpValues", "copyUpValuesFromPreviousFrame", "getStackTrace", "", "", "getFileAndPositionInfo", "getStackCount", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nCallStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallStack.kt\norg/jetbrains/kotlin/ir/interpreter/stack/CallStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,180:1\n1914#2,2:181\n1585#2:185\n1660#2,3:186\n776#2:189\n872#2,2:190\n220#3,2:183\n*S KotlinDebug\n*F\n+ 1 CallStack.kt\norg/jetbrains/kotlin/ir/interpreter/stack/CallStack\n*L\n137#1:181,2\n176#1:185\n176#1:186,3\n176#1:189\n176#1:190,2\n173#1:183,2\n*E\n"})
public final class CallStack {
    @NotNull
    private final ArrayDeque<Frame> frames = new ArrayDeque();

    private final Frame getCurrentFrame() {
        return (Frame)this.frames.last();
    }

    @NotNull
    public final IrElement getCurrentFrameOwner$ir_interpreter() {
        return this.getCurrentFrame().getCurrentSubFrameOwner();
    }

    public final void newFrame(@NotNull IrElement frameOwner, @Nullable IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        this.frames.add((Object)new Frame(frameOwner, irFile));
    }

    public static /* synthetic */ void newFrame$default(CallStack callStack, IrElement irElement, IrFile irFile, int n, Object object) {
        if ((n & 2) != 0) {
            irFile = null;
        }
        callStack.newFrame(irElement, irFile);
    }

    public final void newFrame(@NotNull IrFunction frameOwner) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        this.frames.add((Object)new Frame(frameOwner, IrUtilsKt.getFileOrNull(frameOwner)));
    }

    public final void newSubFrame(@NotNull IrElement frameOwner) {
        Intrinsics.checkNotNullParameter((Object)frameOwner, (String)"frameOwner");
        this.getCurrentFrame().addSubFrame(frameOwner);
    }

    public final void dropFrame() {
        this.frames.removeLast();
    }

    public final void dropFrameAndCopyResult() {
        State state = this.peekState();
        if (state == null) {
            this.dropFrame();
            return;
        }
        State result = state;
        this.popState();
        this.dropFrame();
        this.pushState(result);
    }

    public final void dropSubFrame() {
        this.getCurrentFrame().removeSubFrame();
    }

    public final void returnFromFrameWithResult(@NotNull IrReturn irReturn) {
        Intrinsics.checkNotNullParameter((Object)irReturn, (String)"irReturn");
        State result = this.popState();
        IrReturnTarget returnTarget = irReturn.getReturnTargetSymbol().getOwner();
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (!Intrinsics.areEqual((Object)frameOwner, (Object)returnTarget)) {
            IrElement irElement = frameOwner;
            if (irElement instanceof IrTry) {
                this.dropSubFrame();
                this.pushState(result);
                InstructionKt.pushSimpleInstruction(this, irReturn);
                IrExpression irExpression = ((IrTry)frameOwner).getFinallyExpression();
                if (irExpression != null) {
                    InstructionsUnfolderKt.handleAndDropResult(irExpression, this);
                }
                return;
            }
            if (irElement instanceof IrCatch) {
                Instruction instruction = this.getCurrentFrame().dropInstructions();
                Intrinsics.checkNotNull((Object)instruction);
                IrElement irElement2 = instruction.getElement();
                Intrinsics.checkNotNull((Object)irElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrTry");
                IrTry tryBlock = (IrTry)irElement2;
                this.dropSubFrame();
                this.pushState(result);
                InstructionKt.pushSimpleInstruction(this, irReturn);
                IrExpression irExpression = tryBlock.getFinallyExpression();
                if (irExpression != null) {
                    InstructionsUnfolderKt.handleAndDropResult(irExpression, this);
                }
                return;
            }
            this.dropSubFrame();
            if (this.getCurrentFrame().hasNoSubFrames() && !Intrinsics.areEqual((Object)frameOwner, (Object)returnTarget)) {
                this.dropFrame();
            }
            frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        }
        this.getCurrentFrame().dropInstructions();
        InstructionKt.pushSimpleInstruction(this, returnTarget);
        if (!(returnTarget instanceof IrConstructor)) {
            this.pushState(result);
        }
    }

    public final void unrollInstructionsForBreakContinue(@NotNull IrBreakContinue breakOrContinue) {
        Intrinsics.checkNotNullParameter((Object)breakOrContinue, (String)"breakOrContinue");
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (!Intrinsics.areEqual((Object)frameOwner, (Object)breakOrContinue.getLoop())) {
            IrElement irElement = frameOwner;
            if (irElement instanceof IrTry) {
                this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
                InstructionKt.pushCompoundInstruction(this, breakOrContinue);
                this.newSubFrame(frameOwner);
                InstructionKt.pushSimpleInstruction(this, frameOwner);
                return;
            }
            if (irElement instanceof IrCatch) {
                Instruction instruction = this.getCurrentFrame().dropInstructions();
                Intrinsics.checkNotNull((Object)instruction);
                Instruction tryInstruction = instruction;
                this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
                InstructionKt.pushCompoundInstruction(this, breakOrContinue);
                IrElement irElement2 = tryInstruction.getElement();
                Intrinsics.checkNotNull((Object)irElement2);
                this.newSubFrame(irElement2);
                this.pushInstruction(tryInstruction);
                return;
            }
            this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
            frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        }
        if (breakOrContinue instanceof IrBreak) {
            this.getCurrentFrame().removeSubFrameWithoutDataPropagation();
        } else if (breakOrContinue.getLoop() instanceof IrDoWhileLoop) {
            InstructionKt.pushSimpleInstruction(this, breakOrContinue.getLoop());
            InstructionKt.pushCompoundInstruction(this, breakOrContinue.getLoop().getCondition());
        } else {
            InstructionKt.pushCompoundInstruction(this, breakOrContinue.getLoop());
        }
    }

    public final void dropFramesUntilTryCatch() {
        State exception = this.popState();
        IrElement frameOwner = this.getCurrentFrameOwner$ir_interpreter();
        while (!((Collection)this.frames).isEmpty()) {
            Frame frame = this.getCurrentFrame();
            while (!frame.hasNoSubFrames()) {
                frameOwner = frame.getCurrentSubFrameOwner();
                IrElement irElement = frameOwner;
                if (irElement instanceof IrTry) {
                    this.dropSubFrame();
                    this.newSubFrame(frameOwner);
                    InstructionKt.pushSimpleInstruction(this, frameOwner);
                    Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)((IrTry)frameOwner).getCatches());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IrCatch it = (IrCatch)element$iv;
                        boolean bl = false;
                        InstructionKt.pushCompoundInstruction(this, it);
                    }
                    this.pushState(exception);
                    return;
                }
                if (irElement instanceof IrCatch) {
                    Instruction instruction = frame.dropInstructions();
                    Intrinsics.checkNotNull((Object)instruction);
                    this.pushInstruction(instruction);
                    this.pushState(exception);
                    return;
                }
                frame.removeSubFrameWithoutDataPropagation();
            }
            this.dropFrame();
        }
        if (this.frames.size() == 0) {
            CallStack.newFrame$default(this, frameOwner, null, 2, null);
        }
        this.pushState(exception);
    }

    public final boolean hasNoInstructions() {
        return this.frames.isEmpty() || this.frames.size() == 1 && ((Frame)this.frames.first()).hasNoInstructions();
    }

    public final void pushInstruction(@NotNull Instruction instruction) {
        Intrinsics.checkNotNullParameter((Object)instruction, (String)"instruction");
        this.getCurrentFrame().pushInstruction(instruction);
    }

    @NotNull
    public final Instruction popInstruction() {
        return this.getCurrentFrame().popInstruction();
    }

    public final void pushState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getCurrentFrame().pushState(state);
    }

    @NotNull
    public final State popState() {
        return this.getCurrentFrame().popState();
    }

    @Nullable
    public final State peekState() {
        return this.getCurrentFrame().peekState();
    }

    public final void storeState(@NotNull IrSymbol symbol, @Nullable State state) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        this.getCurrentFrame().storeState(symbol, state);
    }

    private final void storeState(IrSymbol symbol, Variable variable) {
        this.getCurrentFrame().storeState(symbol, variable);
    }

    public final boolean containsStateInMemory(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return this.getCurrentFrame().containsStateInMemory(symbol);
    }

    @NotNull
    public final State loadState(@NotNull IrSymbol symbol) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        return this.getCurrentFrame().loadState(symbol);
    }

    public final void rewriteState(@NotNull IrSymbol symbol, @NotNull State newState) {
        Intrinsics.checkNotNullParameter((Object)symbol, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        this.getCurrentFrame().rewriteState(symbol, newState);
    }

    public final void storeUpValues(@NotNull StateWithClosure state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.getCurrentFrame().copyMemoryInto(state);
    }

    public final void loadUpValues(@NotNull StateWithClosure state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Map<IrSymbol, Variable> $this$forEach$iv = state.getUpValues();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<IrSymbol, Variable>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<IrSymbol, Variable> element$iv;
            Map.Entry<IrSymbol, Variable> entry = element$iv = iterator.next();
            boolean bl = false;
            IrSymbol symbol = entry.getKey();
            Variable variable = entry.getValue();
            this.storeState(symbol, variable);
        }
    }

    public final void copyUpValuesFromPreviousFrame() {
        ((Frame)this.frames.get(this.frames.size() - 2)).copyMemoryInto(this.getCurrentFrame());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getStackTrace() {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)this.frames;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Frame frame = (Frame)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Frame)((Object)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)"Not defined"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final String getFileAndPositionInfo() {
        return ((Frame)this.frames.get(this.frames.size() - 2)).getFileAndPositionInfo();
    }

    public final int getStackCount() {
        return this.frames.size();
    }
}

