/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.interpreter.state.reflection;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeParameter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.interpreter.CallInterceptor;
import org.jetbrains.kotlin.ir.interpreter.UtilsKt;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KMutableProperty1Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KMutableProperty2Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KProperty1Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KProperty2Proxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KRegularFunctionProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeParameterProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.KTypeProxy;
import org.jetbrains.kotlin.ir.interpreter.proxy.reflection.ReflectionProxy;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KFunctionState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KPropertyState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeParameterState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.KTypeState;
import org.jetbrains.kotlin.ir.interpreter.state.reflection.ReflectionState;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypesKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0005\u0010\bJ\u0018\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e0\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u0019\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00100\r2\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00150\u00122\u0006\u0010\u0017\u001a\u00020\u0018J\u0014\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0096\u0082\u0004J\n\u0010 \u001a\u00020!H\u0096\u0080\u0004J\n\u0010\"\u001a\u00020#H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u001a\u0010\f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0010\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/KClassState;", "Lorg/jetbrains/kotlin/ir/interpreter/state/reflection/ReflectionState;", "classReference", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "irClass", "<init>", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;", "(Lorg/jetbrains/kotlin/ir/expressions/IrClassReference;)V", "getClassReference", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "getIrClass", "_members", "", "Lkotlin/reflect/KCallable;", "_constructors", "Lkotlin/reflect/KFunction;", "_typeParameters", "", "Lkotlin/reflect/KTypeParameter;", "_supertypes", "Lkotlin/reflect/KType;", "getMembers", "callInterceptor", "Lorg/jetbrains/kotlin/ir/interpreter/CallInterceptor;", "getConstructors", "getTypeParameters", "getSupertypes", "equals", "", "other", "", "hashCode", "", "toString", "", "ir.interpreter"})
@SourceDebugExtension(value={"SMAP\nKClassState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KClassState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KClassState\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,104:1\n776#2:105\n872#2,2:106\n1585#2:108\n1660#2,3:109\n811#2,12:112\n1585#2:124\n1660#2,3:125\n1585#2:128\n1660#2,3:129\n1585#2:132\n1660#2,3:133\n1585#2:136\n1660#2,3:137\n*S KotlinDebug\n*F\n+ 1 KClassState.kt\norg/jetbrains/kotlin/ir/interpreter/state/reflection/KClassState\n*L\n33#1:105\n33#1:106,2\n34#1:108\n34#1:109,3\n62#1:112,12\n63#1:124\n63#1:125,3\n74#1:128\n74#1:129,3\n81#1:132\n81#1:133,3\n82#1:136\n82#1:137,3\n*E\n"})
public final class KClassState
extends ReflectionState {
    @NotNull
    private final IrClass classReference;
    @NotNull
    private final IrClass irClass;
    @Nullable
    private Collection<? extends KCallable<?>> _members;
    @Nullable
    private Collection<? extends KFunction<?>> _constructors;
    @Nullable
    private List<? extends KTypeParameter> _typeParameters;
    @Nullable
    private List<? extends KType> _supertypes;

    public KClassState(@NotNull IrClass classReference, @NotNull IrClass irClass) {
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        Intrinsics.checkNotNullParameter((Object)irClass, (String)"irClass");
        this.classReference = classReference;
        this.irClass = irClass;
    }

    @NotNull
    public final IrClass getClassReference() {
        return this.classReference;
    }

    @Override
    @NotNull
    public IrClass getIrClass() {
        return this.irClass;
    }

    public KClassState(@NotNull IrClassReference classReference) {
        Intrinsics.checkNotNullParameter((Object)classReference, (String)"classReference");
        IrSymbolOwner irSymbolOwner = classReference.getSymbol().getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrClass");
        IrClass irClass = (IrClass)irSymbolOwner;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull(classReference.getType());
        Intrinsics.checkNotNull((Object)irClassSymbol);
        this(irClass, (IrClass)irClassSymbol.getOwner());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KCallable<?>> getMembers(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        IrDeclaration it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._members != null) {
            Collection<? extends KCallable<?>> collection = this._members;
            Intrinsics.checkNotNull(collection);
            return collection;
        }
        Iterable iterable = this.classReference.getDeclarations();
        KClassState kClassState = this;
        boolean $i$f$filter = false;
        void var4_5 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrDeclaration)element$iv$iv;
            boolean bl = false;
            if (!(!(it instanceof IrClass) && !(it instanceof IrConstructor))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            ReflectionProxy reflectionProxy;
            Collection collection;
            block11: {
                void var11_12;
                void member;
                block10: {
                    it = (IrDeclaration)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    var11_12 = member;
                    if (!(var11_12 instanceof IrProperty)) break block10;
                    IrSimpleFunction irSimpleFunction = ((IrProperty)member).getGetter();
                    Intrinsics.checkNotNull((Object)irSimpleFunction);
                    int parameterCount = irSimpleFunction.getParameters().size();
                    IrClass irClass = (IrClass)callInterceptor.getIrBuiltIns().getKPropertyClass(((IrProperty)member).isVar(), parameterCount).getOwner();
                    KPropertyState propertyState = new KPropertyState(callInterceptor, (IrProperty)member, irClass, null, 8, null);
                    switch (parameterCount) {
                        case 0: {
                            throw new IllegalStateException("\"Static\" properties are not supported".toString());
                        }
                        case 1: {
                            reflectionProxy = ((IrProperty)member).isVar() ? (KProperty1Proxy)new KMutableProperty1Proxy(propertyState, callInterceptor) : new KProperty1Proxy(propertyState, callInterceptor);
                            break block11;
                        }
                        case 2: {
                            reflectionProxy = ((IrProperty)member).isVar() ? (KProperty2Proxy)new KMutableProperty2Proxy(propertyState, callInterceptor) : new KProperty2Proxy(propertyState, callInterceptor);
                            break block11;
                        }
                        default: {
                            String string = "Properties with context parameters are not supported";
                            throw new NotImplementedError("An operation is not implemented: " + string);
                        }
                    }
                }
                if (var11_12 instanceof IrFunction) {
                    IrClass irClass = callInterceptor.getIrBuiltIns().kFunctionN(((IrFunction)member).getParameters().size());
                    reflectionProxy = new KRegularFunctionProxy(new KFunctionState((IrFunction)member, irClass, callInterceptor.getEnvironment(), null, 8, null), callInterceptor);
                } else {
                    throw new NotImplementedError(null, 1, null);
                }
            }
            collection.add((KCallable)reflectionProxy);
        }
        kClassState._members = (List)destination$iv$iv;
        Collection<? extends KCallable<?>> collection = this._members;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<KFunction<?>> getConstructors(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._constructors != null) {
            Collection<? extends KFunction<?>> collection = this._constructors;
            Intrinsics.checkNotNull(collection);
            return collection;
        }
        Iterable iterable = this.classReference.getDeclarations();
        KClassState kClassState = this;
        boolean $i$f$filterIsInstance = false;
        void var4_5 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrConstructor)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrConstructor irConstructor = (IrConstructor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IrClass irClass = callInterceptor.getIrBuiltIns().kFunctionN(it.getParameters().size());
            collection.add(new KRegularFunctionProxy(new KFunctionState((IrFunction)it, irClass, callInterceptor.getEnvironment(), null, 8, null), callInterceptor));
        }
        kClassState._constructors = (List)destination$iv$iv;
        Collection<? extends KFunction<?>> collection = this._constructors;
        Intrinsics.checkNotNull(collection);
        return collection;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<KTypeParameter> getTypeParameters(@NotNull CallInterceptor callInterceptor) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._typeParameters != null) {
            List<KTypeParameter> list = this._typeParameters;
            Intrinsics.checkNotNull(list);
            return list;
        }
        IrClass kTypeParameterIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeParameterClass$ir_interpreter().getOwner();
        Iterable iterable = this.classReference.getTypeParameters();
        KClassState kClassState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KTypeParameterProxy(new KTypeParameterState((IrTypeParameter)it, kTypeParameterIrClass), callInterceptor));
        }
        kClassState._typeParameters = (List)destination$iv$iv;
        List<KTypeParameter> list = this._typeParameters;
        Intrinsics.checkNotNull(list);
        return list;
    }

    @NotNull
    public final List<KType> getSupertypes(@NotNull CallInterceptor callInterceptor) {
        IrType it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)callInterceptor, (String)"callInterceptor");
        if (this._supertypes != null) {
            List<KType> list = this._supertypes;
            Intrinsics.checkNotNull(list);
            return list;
        }
        IrClass kTypeIrClass = (IrClass)callInterceptor.getEnvironment().getKTypeClass$ir_interpreter().getOwner();
        Iterable iterable = this.classReference.getSuperTypes();
        KClassState kClassState = this;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrType irType = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it);
        }
        $this$map$iv = CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), (Object)callInterceptor.getIrBuiltIns().getAnyType()));
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KTypeProxy(new KTypeState(it, kTypeIrClass), callInterceptor));
        }
        kClassState._supertypes = (List)destination$iv$iv;
        List<KType> list = this._supertypes;
        Intrinsics.checkNotNull(list);
        return list;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        Object object2 = other;
        Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.interpreter.state.reflection.KClassState");
        KClassState cfr_ignored_0 = (KClassState)object2;
        return Intrinsics.areEqual((Object)this.classReference, (Object)((KClassState)other).classReference);
    }

    public int hashCode() {
        return this.classReference.hashCode();
    }

    @NotNull
    public String toString() {
        return "class " + UtilsKt.internalName(this.classReference);
    }
}

