/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.uml.settings;

import com.intellij.DynamicBundle;
import com.intellij.diagram.settings.DiagramConfiguration;
import com.intellij.diagram.settings.DiagramLayout;
import com.intellij.diagram.settings.DiagramLayoutOnCategorySwitch;
import com.intellij.diagram.settings.DiagramNodeItemStyle;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.fields.IntegerField;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.uml.settings.tree.DiagramSettingsTree;
import com.intellij.uml.settings.tree.DiagramSettingsTreeNode;
import com.intellij.uml.utils.DiagramBundle;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiagramSettingsForm {
    private static final String[] SCOPE_KEYS = new String[]{"diagram.scope.all", "diagram.scope.project.files", "diagram.scope.non-project.files", "diagram.scope.production", "diagram.scope.tests"};
    private static final String[] SCOPE_VALUES = new String[]{"All", "Project Files", "Non-Project Files", "Production", "Tests"};
    @NotNull
    private final DiagramConfiguration myInitialConfiguration;
    @NotNull
    private final DiagramConfiguration myConfiguration;
    private boolean myHasChanged;
    private JComboBox<String> myLayoutsComboBox;
    private JCheckBox myDoFitContentAfterLayoutCheckBox;
    private JPanel myComponent;
    private JCheckBox myDoRelayoutCheckBox;
    private JComboBox<String> myScopesCombobox;
    private Tree myTree;
    private JCheckBox myDoShowGridCheckBox;
    private JCheckBox myDoItemSyntaxHighlightingCheckBox;
    private JComboBox<DiagramNodeItemStyle> myNodeItemStyleCombobox;
    private IntegerField myItemMaxLengthField;
    private IntegerField myLayoutAnimationDurationMillisField;
    private JComboBox<DiagramLayoutOnCategorySwitch> myLayoutOnCategorySwitchComboBox;
    private JCheckBox myEnableAnimationsCheckBox;

    public DiagramSettingsForm(@NotNull DiagramConfiguration initialConfiguration) {
        if (initialConfiguration == null) {
            DiagramSettingsForm.$$$reportNull$$$0(0);
        }
        this.myInitialConfiguration = initialConfiguration;
        this.$$$setupUI$$$();
        this.myConfiguration = Objects.requireNonNull((DiagramConfiguration)XmlSerializerUtil.createCopy((Object)this.myInitialConfiguration));
        this.initUI(this.myInitialConfiguration);
        DiagramSettingsForm.installListener(this.myComponent, new ActionListener(){

            @Override
            public void actionPerformed(@Nullable ActionEvent e) {
                DiagramSettingsForm.this.update();
                DiagramSettingsForm.this.myHasChanged = true;
            }
        });
    }

    private void createUIComponents() {
        this.myTree = new DiagramSettingsTree(this.myInitialConfiguration);
        this.myTree.setRootVisible(false);
        TreeUtil.expandAll((JTree)this.myTree);
    }

    private static void installListener(JComponent component, final ActionListener listener) {
        if (component instanceof JCheckBox) {
            ((JCheckBox)component).addActionListener(listener);
            return;
        }
        if (component instanceof JComboBox) {
            ((JComboBox)component).addActionListener(listener);
            return;
        }
        if (component instanceof IntegerField) {
            ((IntegerField)component).getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    if (e == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    listener.actionPerformed(null);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/uml/settings/DiagramSettingsForm$2", "textChanged"));
                }
            });
        }
        for (Component comp : component.getComponents()) {
            if (!(comp instanceof JComponent)) continue;
            DiagramSettingsForm.installListener((JComponent)comp, listener);
        }
    }

    public void initUI(DiagramConfiguration conf) {
        for (DiagramLayout diagramLayout : DiagramLayout.values()) {
            this.myLayoutsComboBox.addItem(diagramLayout.getPresentableName());
        }
        for (String string : SCOPE_KEYS) {
            this.myScopesCombobox.addItem(DiagramBundle.message(string, new Object[0]));
        }
        this.myLayoutOnCategorySwitchComboBox.setModel(new DefaultComboBoxModel<DiagramLayoutOnCategorySwitch>(DiagramLayoutOnCategorySwitch.values()));
        this.myNodeItemStyleCombobox.setModel(new DefaultComboBoxModel<DiagramNodeItemStyle>(DiagramNodeItemStyle.values()));
        this.myEnableAnimationsCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DiagramSettingsForm.this.myLayoutAnimationDurationMillisField.setEnabled(DiagramSettingsForm.this.myEnableAnimationsCheckBox.isSelected());
            }
        });
    }

    private void fillValues(@NotNull DiagramConfiguration conf) {
        if (conf == null) {
            DiagramSettingsForm.$$$reportNull$$$0(1);
        }
        this.myScopesCombobox.setSelectedIndex(ArrayUtil.indexOf((Object[])SCOPE_VALUES, (Object)conf.getDefaultScope()));
        this.myNodeItemStyleCombobox.setSelectedItem((Object)conf.getDiagramNodeItemStyle());
        this.myItemMaxLengthField.setValue(Integer.valueOf(conf.getShortenNodeItemOnLength()));
        this.myDoShowGridCheckBox.setSelected(conf.doShowGridByDefault());
        this.myEnableAnimationsCheckBox.setSelected(conf.isAnimationsEnabled());
        this.myDoItemSyntaxHighlightingCheckBox.setSelected(conf.doNodeItemSyntaxHighlighting());
        this.myLayoutsComboBox.setSelectedItem(conf.getDefaultLayout().getPresentableName());
        this.myLayoutOnCategorySwitchComboBox.setSelectedItem((Object)DiagramLayoutOnCategorySwitch.WITH_LIGHT_LAYOUTER);
        this.myLayoutAnimationDurationMillisField.setValue(Integer.valueOf(conf.getLayoutAnimationDurationMillis()));
        this.myDoFitContentAfterLayoutCheckBox.setSelected(conf.doFitContentAfterLayout());
        this.myDoRelayoutCheckBox.setSelected(conf.doRelayoutOnNewElements());
    }

    public JPanel getJComponent() {
        return this.myComponent;
    }

    public void update() {
        String selectedScope = (String)this.myScopesCombobox.getSelectedItem();
        int length = SCOPE_KEYS.length;
        for (int i = 0; i < length; ++i) {
            if (!StringUtil.equals((CharSequence)selectedScope, (CharSequence)DiagramBundle.message(SCOPE_KEYS[i], new Object[0]))) continue;
            this.myConfiguration.setDefaultScope(SCOPE_VALUES[i]);
            break;
        }
        this.myConfiguration.setDiagramNodeItemStyle((DiagramNodeItemStyle)((Object)Objects.requireNonNull(this.myNodeItemStyleCombobox.getSelectedItem())));
        this.myConfiguration.setShortenNodeItemOnLength(this.myItemMaxLengthField.getValue());
        this.myConfiguration.setDoShowGridByDefault(this.myDoShowGridCheckBox.isSelected());
        this.myConfiguration.setAnimationsEnabled(this.myEnableAnimationsCheckBox.isSelected());
        this.myConfiguration.setDoNodeItemSyntaxHighlighting(this.myDoItemSyntaxHighlightingCheckBox.isSelected());
        this.myConfiguration.setDefaultLayout(DiagramLayout.fromLocalizedString((String)this.myLayoutsComboBox.getSelectedItem()));
        this.myConfiguration.setLayoutOnCategorySwitch((DiagramLayoutOnCategorySwitch)((Object)Objects.requireNonNull(this.myLayoutOnCategorySwitchComboBox.getSelectedItem())));
        this.myConfiguration.setLayoutAnimationDurationMillis(this.myLayoutAnimationDurationMillisField.getValue());
        this.myConfiguration.setDoFitContentAfterLayout(this.myDoFitContentAfterLayoutCheckBox.isSelected());
        this.myConfiguration.setDoRelayoutOnNewElements(this.myDoRelayoutCheckBox.isSelected());
    }

    public boolean changed() {
        return this.myHasChanged || ((DiagramSettingsTreeNode)((Object)this.myTree.getModel().getRoot())).isChanged();
    }

    public void setChanged(boolean changed) {
        this.myHasChanged = changed;
    }

    public void apply() {
        XmlSerializerUtil.copyBean((Object)this.myConfiguration, (Object)this.myInitialConfiguration);
        ((DiagramSettingsTree)this.myTree).apply(this.myInitialConfiguration);
        this.setChanged(false);
    }

    public void reset() {
        this.fillValues(this.myInitialConfiguration);
        ((DiagramSettingsTree)this.myTree).reset();
        this.setChanged(false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
        }
        objectArray2[1] = "com/intellij/uml/settings/DiagramSettingsForm";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "fillValues";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        IntegerField integerField;
        IntegerField integerField2;
        JCheckBox jCheckBox2;
        JCheckBox jCheckBox3;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.createUIComponents();
        this.myComponent = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(13, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myDoFitContentAfterLayoutCheckBox = jCheckBox5 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox5, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("fit.content.after.layout"));
        jPanel2.add((Component)jCheckBox5, new GridConstraints(11, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDoRelayoutCheckBox = jCheckBox4 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox4, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("do.relayout.when.new.elements.were.added"));
        jPanel2.add((Component)jCheckBox4, new GridConstraints(12, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDoShowGridCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox3, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("show.grid.by.default"));
        jPanel2.add((Component)jCheckBox3, new GridConstraints(4, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myDoItemSyntaxHighlightingCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("enable.node.items.syntax.highlighting"));
        jPanel2.add((Component)jCheckBox2, new GridConstraints(6, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("default.layout"));
        jPanel2.add((Component)jLabel, new GridConstraints(8, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(204, 19), null));
        JComboBox jComboBox = new JComboBox();
        this.myLayoutsComboBox = jComboBox;
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel);
        jPanel2.add(jComboBox, new GridConstraints(8, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("default.scope"));
        jPanel2.add((Component)jLabel2, new GridConstraints(0, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("layout.on.category.switch"));
        jPanel2.add((Component)jLabel3, new GridConstraints(9, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(204, 19), null));
        JComboBox jComboBox2 = new JComboBox();
        this.myScopesCombobox = jComboBox2;
        jPanel2.add(jComboBox2, new GridConstraints(0, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        JComboBox jComboBox3 = new JComboBox();
        this.myLayoutOnCategorySwitchComboBox = jComboBox3;
        jPanel2.add(jComboBox3, new GridConstraints(9, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("shorten.node.items.on.length"));
        jPanel2.add((Component)jBLabel, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(204, 19), null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("layout.animation.duration"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(10, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(204, 19), null));
        this.myItemMaxLengthField = integerField2 = new IntegerField();
        integerField2.setMaxValue(1000);
        integerField2.setMinValue(10);
        integerField2.setText("");
        jPanel2.add((Component)integerField2, new GridConstraints(3, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myLayoutAnimationDurationMillisField = integerField = new IntegerField();
        integerField.setMaxValue(5000);
        integerField.setMinValue(0);
        integerField.setText("");
        jPanel2.add((Component)integerField, new GridConstraints(10, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        TitledSeparator titledSeparator = new TitledSeparator();
        titledSeparator.setText(DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("diagram.settings.layout.title"));
        jPanel2.add((Component)titledSeparator, new GridConstraints(7, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        TitledSeparator titledSeparator2 = new TitledSeparator();
        titledSeparator2.setText(DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("diagram.settings.appearance.title"));
        jPanel2.add((Component)titledSeparator2, new GridConstraints(1, 0, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myEnableAnimationsCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("diagram.settings.enable.animations"));
        jPanel2.add((Component)jCheckBox, new GridConstraints(5, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel3, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("diagram.node.item.style"));
        jPanel2.add((Component)jBLabel3, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, new Dimension(204, 19), null));
        JComboBox jComboBox4 = new JComboBox();
        this.myNodeItemStyleCombobox = jComboBox4;
        jPanel2.add(jComboBox4, new GridConstraints(2, 2, 1, 1, 8, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 1, 6, 1, new Dimension(20, -1), null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(1, 0, 2, 1, 0, 3, 7, 3, null, new Dimension(358, 471), null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel3.add((Component)jBScrollPane, "Center");
        Tree tree = this.myTree;
        jBScrollPane.setViewportView((Component)tree);
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/DiagramBundle", DiagramSettingsForm.class).getString("settings.select.categories.text"));
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(358, 19), new Dimension(400, -1)));
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jComboBox2);
        jLabel3.setLabelFor(jComboBox3);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myComponent;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

