/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.database.Dbms;
import com.intellij.database.dataSource.LinkedDataSourceHelper;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasOperator;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.basic.BasicTableColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasScope;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.ObjectPath;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.util.SearchPath;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.TreePatternNode;
import com.intellij.database.util.TreePatternUtils;
import com.intellij.database.util.Version;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.SqlBundle;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.completion.SqlInsertHandlers;
import com.intellij.sql.completion.SqlQualifiedResolveResult;
import com.intellij.sql.dataFlow.DFABuildingVisitor;
import com.intellij.sql.dataFlow.SqlErrorSpecHelper;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportBuilder;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.dateTime.SqlDateTimeLanguageHelper;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.editor.QuoteIdentifierQuickFix;
import com.intellij.sql.editor.SqlBaseValidationDelegate;
import com.intellij.sql.editor.SqlCloseBlockProcessor;
import com.intellij.sql.editor.SqlValidatingHighlightVisitor;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.formatter.settings.SqlCodeStyles;
import com.intellij.sql.psi.SqlBatchBlock;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlIdentifierKeywordTokenType;
import com.intellij.sql.psi.SqlIfStatement;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlParameterDefinition;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlThenClause;
import com.intellij.sql.psi.SqlUseDatabaseStatement;
import com.intellij.sql.psi.SqlVariableDefinition;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlFunctionCallTableExpressionImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlReferenceTypeElementImpl;
import com.intellij.sql.psi.impl.SqlSelectIntoNewTableClauseImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.refactoring.SqlExtractVariableHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SqlLanguageDialectEx
extends SqlLanguageDialect {
    protected final ReservedEntity myDualEntity;
    private final Object myLock;
    private final ReservedEntity myNextValEntity;
    private final ReservedEntity myCurrValEntity;
    private volatile Map<String, BuiltinFunction.Type> myTypes;

    protected SqlLanguageDialectEx(@NonNls @NotNull String id) {
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(0);
        }
        super(id);
        this.myDualEntity = new ReservedEntity(this.getDbms(), "dual", ObjectKind.TABLE);
        this.myLock = new Object();
        this.myNextValEntity = new ReservedEntity(this.getDbms(), "nextval", ObjectKind.COLUMN);
        this.myCurrValEntity = new ReservedEntity(this.getDbms(), "currval", ObjectKind.COLUMN);
    }

    protected SqlLanguageDialectEx(@NotNull SqlLanguageDialect base, @NonNls @NotNull String id) {
        if (base == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(1);
        }
        if (id == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(2);
        }
        super(base, id);
        this.myDualEntity = new ReservedEntity(this.getDbms(), "dual", ObjectKind.TABLE);
        this.myLock = new Object();
        this.myNextValEntity = new ReservedEntity(this.getDbms(), "nextval", ObjectKind.COLUMN);
        this.myCurrValEntity = new ReservedEntity(this.getDbms(), "currval", ObjectKind.COLUMN);
    }

    @Nullable
    public IElementType getFunctionParserExtension(@NotNull String name) {
        if (name == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(3);
        }
        SqlReferenceElementType unused = SqlCompositeElementTypes.SQL_PARAMETER_REFERENCE;
        return SqlTokenRegistry.findCompositeType((String)("SQL_" + name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Map<String, BuiltinFunction.Type> getBuiltInTypes() {
        Object object = this.myLock;
        // MONITORENTER : object
        if (this.myTypes == null) {
            HashMap<String, BuiltinFunction.Type> res = new HashMap<String, BuiltinFunction.Type>();
            this.addTypes(res);
            this.myTypes = res;
        }
        Map<String, BuiltinFunction.Type> map = this.myTypes;
        // MONITOREXIT : object
        if (map != null) return map;
        SqlLanguageDialectEx.$$$reportNull$$$0(4);
        return map;
    }

    protected void addTypes(Map<String, BuiltinFunction.Type> myTypes) {
        SqlFunctionsUtil.addSimpleTypes(myTypes, this);
    }

    @NotNull
    public final DasTypeSystemBase getTypeSystem() {
        DasTypeSystemBase dasTypeSystemBase = DasTypeSystems.getTypeSystem((Dbms)this.getDbms());
        if (dasTypeSystemBase == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(5);
        }
        return dasTypeSystemBase;
    }

    @NotNull
    public Set<BuiltinFunction.Location> getExpectedFunctionLocations(@Nullable SqlExpression expression) {
        if (expression != null && SqlLanguageDialectEx.isTableFunctionCallRef((PsiElement)expression)) {
            EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.NORMAL, BuiltinFunction.Location.TABLE_FUNCTION);
            if (enumSet == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(6);
            }
            return enumSet;
        }
        EnumSet<BuiltinFunction.Location> enumSet = EnumSet.of(BuiltinFunction.Location.NORMAL);
        if (enumSet == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(7);
        }
        return enumSet;
    }

    @NotNull
    public abstract BuiltinFunctions getSupportedFunctions();

    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(8);
        }
        return true;
    }

    @NotNull
    public JBIterable<ObjectKind> getExtraKindsStrict(@NotNull SqlReferenceImpl reference) {
        if (reference == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(9);
        }
        if (reference.getReferenceElementType().getTargetKind() == ObjectKind.OBJECT_TYPE) {
            JBIterable jBIterable = JBIterable.of((Object[])new ObjectKind[]{ObjectKind.COLLECTION_TYPE, ObjectKind.ALIAS_TYPE, ObjectKind.TABLE_TYPE});
            if (jBIterable == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @NotNull
    public Set<ObjectKind> getIgnoredParentKinds(@Nullable PsiElement context, @NotNull ObjectKind target) {
        if (target == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(12);
        }
        Set<ObjectKind> set = Collections.emptySet();
        if (set == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(13);
        }
        return set;
    }

    public boolean processTypeExtra(SqlTableType type, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        return true;
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        DatabaseDialectEx databaseDialectEx = DbImplUtilCore.getDatabaseDialect((Dbms)this.getDbms());
        if (databaseDialectEx == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(14);
        }
        return databaseDialectEx;
    }

    @NotNull
    public TreePattern applyImplicitImports(@Nullable ObjectName[] dsNames, @NotNull TreePattern pattern) {
        if (pattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(15);
        }
        TreePattern treePattern = pattern;
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    public boolean shouldWrap(SqlDefinition o, ObjectKind kind) {
        return kind == ObjectKind.PACKAGE || kind == ObjectKind.OBJECT_TYPE;
    }

    public boolean isTableAliasAllowedAt(@NotNull PsiElement element) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(17);
        }
        return PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{SqlFromClause.class}) != null;
    }

    public boolean requiresAsForAliasAt(@NotNull PsiElement element) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(18);
        }
        return false;
    }

    public boolean canBeCalledWithoutParens(@NotNull BuiltinFunction.Prototype prototype) {
        if (prototype == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(19);
        }
        BuiltinFunction def = prototype.getFunction();
        return prototype.getParams().length == 0 && !"required".equals(def.getDialectAttribute("parens")) && !"true".equals(def.getDialectAttribute("analytic"));
    }

    @NotNull
    public TreePattern processImports(@NotNull List<SqlReferenceExpression> references, final boolean isInclusive, @NotNull SqlFile sqlFile, @NotNull TreePattern prev) {
        if (references == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(20);
        }
        if (sqlFile == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(21);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(22);
        }
        SmartList refs = new SmartList();
        ObjectKind kind = null;
        boolean reset = false;
        for (SqlReferenceExpression ref : ContainerUtil.iterateBackward(references)) {
            if (ref == null) {
                reset = true;
                break;
            }
            refs.add(ref);
            ObjectKind k = ref.getReferenceElementType().getTargetKind();
            assert (kind == null || kind == k);
            kind = k;
        }
        if (reset) {
            TreePattern treePattern = SqlImportBuilder.getDefaultInitialPattern(sqlFile);
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(23);
            }
            return treePattern;
        }
        if (refs.isEmpty()) {
            if (!this.canBeWithoutCurrentSchema()) {
                TreePattern treePattern = prev;
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(24);
                }
                return treePattern;
            }
            List<ObjectKind> path = SqlImportUtil.getSingleRootPath(ObjectKind.SCHEMA, this.getDbms());
            if (path == null) {
                TreePattern treePattern = this.applyImplicitImports(null, TreePattern.EMPTY);
                if (treePattern == null) {
                    SqlLanguageDialectEx.$$$reportNull$$$0(25);
                }
                return treePattern;
            }
            ObjectKind[] kinds = ContainerUtil.reverse(path.subList(1, path.size())).toArray(new ObjectKind[path.size() - 1]);
            boolean[] mask = new boolean[kinds.length];
            Arrays.fill(mask, true);
            TreePattern treePattern = this.applyImplicitImports(null, TreePatternUtils.mask((TreePattern)prev, (ObjectKind[])kinds, (boolean[])mask, (boolean)false));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(26);
            }
            return treePattern;
        }
        TreePattern state = TreePatternUtils.union((Iterable)JBIterable.from((Iterable)refs).transform(r -> this.createRefPattern(prev, (SqlReferenceExpression)r)).filter(x -> x != null));
        state = new TreePatternUtils.GroupedGroupFactory(this){

            protected boolean checkGroup(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode.Group> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(0);
                }
                return this.hasSecond(value);
            }

            protected boolean checkNode(TreePatternNode.BaseNaming naming, ObjectKind kind, @NotNull Iterable<TreePatternNode> value) {
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                return this.hasSecond(value);
            }

            protected boolean willDestroyEmpty(TreePatternNode.BaseNaming naming, ObjectKind kind, Iterable<TreePatternNode> groups) {
                return !this.hasSecond(groups);
            }

            private boolean hasSecond(@NotNull Iterable<?> value) {
                Object second;
                Iterator<?> it;
                if (value == null) {
                    1.$$$reportNull$$$0(2);
                }
                Object first = (it = value.iterator()).hasNext() ? it.next() : null;
                Object v0 = second = it.hasNext() ? it.next() : null;
                if (second == null) {
                    return first != null && isInclusive;
                }
                if (!(second instanceof TreePatternNode)) {
                    return true;
                }
                if (((TreePatternNode)second).naming instanceof TreePatternNode.PositiveNaming) {
                    return true;
                }
                return first != null;
            }

            public boolean mergeChildren() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "value";
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkGroup";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "checkNode";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "hasSecond";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }.merge(Arrays.asList(prev, state));
        TreePattern treePattern = this.applyImplicitImports(null, state);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(27);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern processImports(@NotNull SqlUseDatabaseStatement stmt, @NotNull TreePattern prev) {
        if (stmt == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(28);
        }
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(29);
        }
        TreePattern treePattern = this.processImports(stmt.getUseReferences(), stmt.isInclusive(), (SqlFile)stmt.getContainingFile(), prev);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(30);
        }
        return treePattern;
    }

    protected TreePattern createRefPattern(@NotNull TreePattern prev, @NotNull SqlReferenceExpression ref) {
        if (prev == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(31);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(32);
        }
        return SqlImportUtil.createRefPattern(ref, ref.getReferenceElementType().getTargetKind(), this.getDbms());
    }

    public boolean canContainDdl(@NotNull PsiElement e) {
        if (e == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(33);
        }
        return e instanceof SqlBatchBlock || e instanceof SqlIfStatement || e instanceof SqlThenClause || e instanceof SqlSelectStatement || e instanceof SqlExpression || e instanceof SqlDefinitionHolder;
    }

    @NotNull
    public SqlImportBuilder getImportBuilder() {
        SqlImportBuilder sqlImportBuilder = SqlImportBuilder.INSTANCE;
        if (sqlImportBuilder == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(34);
        }
        return sqlImportBuilder;
    }

    protected boolean canBeWithoutCurrentSchema() {
        return false;
    }

    @NotNull
    public TreePattern getDefaultImports(@Nullable DbDataSource dataSource) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        TreePattern imports = this.getBaseImports(dataSource, dsNames);
        TreePattern treePattern = this.applyImplicitImports(dsNames, imports);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(35);
        }
        return treePattern;
    }

    @NotNull
    protected TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        ObjectKind kind;
        JBIterable kinds = DbImplUtilCore.getMetaModel((Dbms)this.getDbms()).getRootNamespaceKinds();
        if (kinds.contains((Object)ObjectKind.DATABASE)) {
            kind = ObjectKind.DATABASE;
        } else if (kinds.contains((Object)ObjectKind.SCHEMA)) {
            kind = ObjectKind.SCHEMA;
        } else {
            throw new AssertionError((Object)"Unexpected root kind");
        }
        ObjectName userName = ObjectName.plain((String)SqlDialectImplUtilCore.getUserName(SqlImportUtil.getConnectionConfig(dataSource)));
        DasNamespace namespace = SqlLanguageDialectEx.getDefaultNamespace(dataSource, userName);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtilCore.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : SqlImportUtil.createNodeIfNotNull(userName, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                SqlLanguageDialectEx.$$$reportNull$$$0(36);
            }
            return treePattern;
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(userName, kind, new TreePatternNode.Group[0])));
    }

    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        ObjectName[] dsNames = SqlImportUtil.getRealDsNames(dataSource);
        List elements = SearchPath.getElements((SearchPath)searchPath);
        TreePattern treePattern = this.applyImplicitImports(dsNames, !elements.isEmpty() ? TreePatternUtils.union((Iterable)JBIterable.from((Iterable)elements).transform(n -> SqlDialectImplUtilCore.createObjectPattern(dsNames, this.getDbms(), n, (TreePatternNode.Group[])null))) : (dsNames == null ? TreePattern.EMPTY : this.getBaseImports(dataSource, dsNames)));
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(37);
        }
        return treePattern;
    }

    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath object) {
        if (object == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(38);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, object);
        if (treePattern == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(39);
        }
        return treePattern;
    }

    public boolean isSpecialFunctionReference(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(40);
        }
        return false;
    }

    public boolean isVariablePrefix(@Nullable String prefix) {
        return false;
    }

    public boolean isMultiIdReference(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(41);
        }
        return false;
    }

    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(42);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(43);
        }
        return this.quoteIdentifier(identifier, newElementName, SqlImplUtil.getIdentifierKind(identifier));
    }

    protected String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(44);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(45);
        }
        return this.quoteIdentifier(identifier.getProject(), newElementName, kind);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(46);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(47);
        }
        return this.quoteIdentifier(project, newElementName, null);
    }

    public String quoteIdentifier(@NotNull Project project, @NotNull String newElementName, @Nullable ObjectKind kind) {
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(48);
        }
        if (newElementName == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(49);
        }
        SqlCodeStyleSettings settings = SqlCodeStyles.getSqlSettings((Project)project, (Language)this);
        boolean force = settings.QUOTE_IDENTIFIER == 2 || this.isReservedKeyword((IElementType)SqlTokenRegistry.findTokenType((String)newElementName));
        NamingService namingService = NamingServices.getNamingService((Dbms)this.getDbms());
        if (namingService.isQuoted(newElementName)) {
            return newElementName;
        }
        return force ? namingService.enquote(newElementName, kind, settings.getQuotesPriority()) : namingService.catToScript(newElementName, kind, true, settings.getQuotesPriority(), false);
    }

    @NotNull
    public JBIterable<? extends DasArgument> getSignatureParameters(@NotNull DasRoutine routine) {
        if (routine == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(50);
        }
        JBIterable jBIterable = DasUtil.getParameters((DasRoutine)routine);
        if (jBIterable == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(51);
        }
        return jBIterable;
    }

    public boolean supportsSql92CharSetSpecFor(@NotNull IElementType element) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(52);
        }
        return false;
    }

    @NotNull
    public Icon getIcon() {
        Dbms dbms = this.getDbms();
        Icon icon = dbms == Dbms.UNKNOWN ? DatabaseIcons.Sql : dbms.getIcon();
        if (icon == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(53);
        }
        return icon;
    }

    public boolean isResolveTargetAccepted(@Nullable DasSymbol symbol, ObjectKind type, @NotNull Set<ObjectKind> expectedTypes, @Nullable PsiElement place, boolean strict, boolean isCompletion) {
        if (expectedTypes == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(54);
        }
        if (isCompletion && this.supportsRowTypeSyntax()) {
            PsiElement grandParent;
            PsiElement parent;
            PsiElement psiElement = parent = place != null ? place.getParent() : null;
            if (parent instanceof SqlReferenceTypeElementImpl && parent.getParent() instanceof SqlVariableDefinition) {
                return SqlLanguageDialectEx.isTableTypeLookupCandidate(type, expectedTypes) || SqlLanguageDialectEx.isColumnTypeLookupCandidate(type, expectedTypes);
            }
            PsiElement psiElement2 = grandParent = parent != null ? parent.getParent() : null;
            if (parent instanceof SqlReferenceExpression && grandParent instanceof SqlReferenceTypeElementImpl && grandParent.getParent() instanceof SqlVariableDefinition) {
                return ModelConsts.TABLE_OR_VIEW_KINDS.contains(type);
            }
        }
        return super.isResolveTargetAccepted(symbol, type, expectedTypes, place, strict, isCompletion);
    }

    @NotNull
    public String getDisplayName() {
        String string = this.getDbms().getDisplayName();
        if (string == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(55);
        }
        return string;
    }

    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(56);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(57);
        }
        DasTypeSystemBase typeSystem = this.getTypeSystem();
        if ((SqlImplUtil.equalsInsensitiveOrTrue(name, this.myNextValEntity.name, resolve) || SqlImplUtil.equalsInsensitiveOrTrue(name, this.myCurrValEntity.name, resolve)) && SqlImplUtil.getQualifierKind(place) == ObjectKind.SEQUENCE) {
            if (!processor.executeTarget((DasSymbol)this.myNextValEntity, typeSystem.getIntType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
            if (!processor.executeTarget((DasSymbol)this.myCurrValEntity, typeSystem.getIntType(), Boolean.valueOf(false), ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    private boolean isLinkedDSReference(@NotNull SqlReferenceExpression ref) {
        LinkedDataSourceHelper helper;
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(58);
        }
        if ((helper = LinkedDataSourceHelper.of((Dbms)this.getDbms())) == null) {
            return false;
        }
        ObjectKind linkedKind = helper.getLinkedDataSourceKind();
        ObjectKind kind = ref.getReferenceElementType().getTargetKind();
        if (kind == linkedKind) {
            return true;
        }
        if (kind != SqlDbElementType.ANY && kind != ObjectKind.NONE) {
            return false;
        }
        for (ResolveResult result : ref.multiResolve(false)) {
            DasSymbol symbol = DasSymbolUtil.getSymbol(result);
            if (symbol == null || symbol.getKind() != linkedKind) continue;
            return true;
        }
        return false;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull DasType qualifierType) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(59);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(60);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(61);
        }
        if (qualifierType == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(62);
        }
        if (SqlImplUtil.isProcessingOneOf(processor, ObjectKind.COLUMN) && qualifierType instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)qualifierType;
            return SqlImplUtil.processDeclarationsInType(tableType2, processor, state, ref.getElement());
        }
        return true;
    }

    public boolean processQualifiedResolve(@NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull SqlReference ref, @NotNull SqlExpression qualifier) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(63);
        }
        if (state == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(64);
        }
        if (ref == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(65);
        }
        if (qualifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(66);
        }
        if (!this.processQualifiedResolve(processor, state, ref, qualifier.getDasType())) {
            return false;
        }
        DasType dasType = DasTypeUtilsKt.unwrap((DasType)qualifier.getDasType());
        ResolveState qualifiedState = SqlImplUtil.setQualifier(state, (PsiElement)qualifier);
        if (processor.mayAccept(ObjectKind.COLUMN) && dasType instanceof DasColumniationType) {
            DasColumniationType columniationType = (DasColumniationType)dasType;
            if (!processor.isResultEmpty()) {
                return false;
            }
            if (!DasSymbolUtil.processScope(processor, qualifiedState, (DasScope<? extends DasObject>)columniationType.getColumnScope())) {
                return false;
            }
        }
        if (qualifier instanceof SqlReferenceExpression && this.isLinkedDSReference((SqlReferenceExpression)qualifier)) {
            for (ResolveResult qualifierResult : ((SqlReferenceExpression)qualifier).multiResolve(false)) {
                DasObject qualifierObject;
                DasSymbol qualifierSymbol = DasSymbolUtil.getSymbol(qualifierResult);
                DasObject dasObject = qualifierObject = qualifierSymbol != null ? qualifierSymbol.getDasObject() : null;
                if (!(ref instanceof SqlReferenceImpl) || qualifierObject == null) continue;
                Project project = qualifier.getProject();
                ObjectPath path = ObjectPaths.of((DasObject)qualifierObject);
                for (DbDataSource dataSource : processor.getDataSources()) {
                    boolean result;
                    LocalDataSource localDataSource = DbImplUtilCore.getMaybeLocalDataSource((DasDataSource)dataSource);
                    if (localDataSource == null) continue;
                    String linkedDataSourceId = (String)localDataSource.getLinkedDataSourceIds().get(path);
                    DbDataSource linkedDataSource = DbPsiFacade.getInstance((Project)project).findDataSource(linkedDataSourceId);
                    if (linkedDataSource == null || (result = ((SqlReferenceImpl)ref).processUnqualifiedResolveInDataSource(processor, ResolveState.initial(), ((SqlReferenceImpl)ref).getTopLevelSqlFile().getOriginalFile(), null, false, linkedDataSource))) continue;
                    return false;
                }
            }
            return !processor.isResultEmpty() || processor.executeTarget(DasSymbolUtil.getInlineSymbol(ref, true), null, Boolean.valueOf(false), state);
        }
        return super.processQualifiedResolve(processor, state, ref, qualifier);
    }

    @Nullable
    public Condition<DasObject> getAdditionalExpandCondition(@NotNull SqlScopeProcessor processor, @NotNull PsiElement place) {
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(67);
        }
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(68);
        }
        if (processor instanceof SqlCompletionScopeProcessor && this.getDatabaseDialect().getSearchPathObjectKind() == ObjectKind.DATABASE) {
            return o -> o.getKind() == ObjectKind.SCHEMA;
        }
        return super.getAdditionalExpandCondition(processor, place);
    }

    public int getMaxIdentifierLength(@NotNull SqlIdentifier identifier, @Nullable Version version) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(69);
        }
        return Integer.MAX_VALUE;
    }

    protected boolean processReservedEntitiesWithTypeDual(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(70);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(71);
        }
        if (processor.isExpected(ObjectKind.COLUMN)) {
            return true;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, SqlFromClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class}) == null) {
            return true;
        }
        if (element instanceof SqlReferenceExpression && ((SqlReferenceExpression)element).getQualifierExpression() != null) {
            return true;
        }
        return SqlLanguageDialectEx.processReservedEntitiesWithTypeSimple(this.myDualEntity, (DasType)SqlTableTypeBase.EMPTY_TABLE, name, element, resolve, processor, true, false);
    }

    public boolean processNamedArgumentCandidates(@Nullable DasSymbol callableSymbol, Processor<? super DasSymbol> processor, @NotNull Project project) {
        DasObject object;
        DasRoutine routine;
        if (project == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(72);
        }
        if ((routine = SqlFunctionsUtil.getRoutineOrConstructor(callableSymbol)) == null) {
            return true;
        }
        DasObject dasObject = object = callableSymbol != null ? callableSymbol.getDasObject() : null;
        if (object instanceof SqlProcedureDefinitionImpl) {
            SqlProcedureDefinitionImpl procedure = (SqlProcedureDefinitionImpl)object;
            Iterable<SqlParameterDefinition> parameters = procedure.getArguments();
            for (SqlParameterDefinition parameter : parameters) {
                if (processor.process((Object)parameter)) continue;
                return false;
            }
        } else {
            for (DasArgument parameter : DasUtil.getParameters((DasRoutine)routine)) {
                if (processor.process((Object)DasSymbolUtil.wrapObjectToSymbol((DasObject)parameter, project))) continue;
                return false;
            }
        }
        return true;
    }

    public TokenSet getStatementSeparators() {
        return SqlCommonTokens.STATEMENT_SEPARATORS;
    }

    public boolean isAutoIncrementColumn(@NotNull DasColumn column) {
        ASTNode node;
        SqlColumnStub stub;
        if (column == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(73);
        }
        SqlColumnStub sqlColumnStub = stub = column instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)column).getGreenStub() : null;
        if (stub != null) {
            BasicTableColumn tc = (BasicTableColumn)ObjectUtils.tryCast((Object)stub.getElement(), BasicTableColumn.class);
            return tc != null && tc.isAutoInc();
        }
        ASTNode aSTNode = node = column instanceof PsiElement ? ((PsiElement)column).getNode() : null;
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_AS_IDENTITY_CLAUSE) != null;
    }

    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result, ObjectKind type) {
        if (type instanceof SqlDbElementType) {
            ContainerUtil.addIfNotNull(result, (Object)((SqlDbElementType)type).parentType);
        }
        if (type == ObjectKind.VARIABLE) {
            result.add((ObjectKind)ObjectKind.VARIABLE);
        }
        if (type == ObjectKind.INDEX) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.TRIGGER) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.OBJECT_TYPE) {
            result.add((ObjectKind)ObjectKind.SCHEMA);
        }
        if (type == ObjectKind.PARTITION) {
            result.add((ObjectKind)ObjectKind.TABLE);
        }
        DbImplUtilCore.getMetaModel((Dbms)this.getDbms()).getParentKinds(this.unaliased(type)).addAllTo(result);
        if (type == ObjectKind.USER) {
            result.add((ObjectKind)ObjectKind.USER);
        }
        if (type == SqlDbElementType.SYSTEM_VARIABLE) {
            result.add((ObjectKind)SqlDbElementType.SYSTEM_VARIABLE);
        }
        return result;
    }

    public boolean respectsCurrentTracerContext(@Nullable SqlDefinition definition) {
        return true;
    }

    @NotNull
    public Trinity<ObjectKind, Boolean, String> getImplicitParentInfo(@Nullable SqlDefinition definition, @NotNull ObjectKind parentKind) {
        if (parentKind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(74);
        }
        Trinity trinity = Trinity.create((Object)parentKind, (Object)true, (Object)"");
        if (trinity == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(75);
        }
        return trinity;
    }

    public JBIterable<? extends SqlDefinition> extractDefinitions(@NotNull SqlElement statement) {
        if (statement == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(76);
        }
        if (statement instanceof SqlSelectStatement) {
            return ((SyntaxTraverser)SqlImplUtil.sqlTraverser((PsiElement)statement).expand(Conditions.notInstanceOf(SqlSelectIntoNewTableClauseImpl.class))).filter(SqlSelectIntoNewTableClauseImpl.class);
        }
        if (statement instanceof SqlBlockStatementImpl) {
            JBIterable children = SqlImplUtil.childrenIt((PsiElement)statement).filter(SqlCompositeElement.class);
            return children.filter(SqlDefinition.class).append((Iterable)children.flatten(this::extractDefinitions));
        }
        return JBIterable.empty();
    }

    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        return type != SqlDbElementType.CHARSET && type != ObjectKind.COLLATION && type != ObjectKind.TABLESPACE && type != SqlDbElementType.GENERIC_AT_LINK && type != ObjectKind.USER && type != SqlDbElementType.SYSTEM_VARIABLE && type != ObjectKind.ROLE && type != ObjectKind.OPERATOR;
    }

    @NotNull
    public final Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(77);
        }
        Casing casing = this.getDatabaseDialect().getCasing(kind, context);
        if (casing == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(78);
        }
        return casing;
    }

    public boolean mayContainExternalPsi() {
        return false;
    }

    @NotNull
    public Collection<ObjectKind> getMajorChildKinds() {
        Collection<ObjectKind> collection = LazyData.MAJOR_CHILD_KINDS;
        if (collection == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(79);
        }
        return collection;
    }

    public boolean shouldSkipFromQualification(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(80);
        }
        return DbImplUtilCore.isDataTable((ObjectKind)kind);
    }

    public boolean canBeQualified(@NotNull SqlIdentifier identifier) {
        if (identifier == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(81);
        }
        return true;
    }

    @NotNull
    protected TreePattern getSchemaBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames, boolean useSchemaDefault) {
        String schemaName = SqlDialectImplUtilCore.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource));
        if (schemaName == null && useSchemaDefault) {
            schemaName = "default";
        }
        return new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.createNodeIfNotNull(ObjectName.quoted((String)schemaName), ObjectKind.SCHEMA, new TreePatternNode.Group[0])));
    }

    public boolean supportsJoinUsing() {
        return false;
    }

    public boolean supportsNaturalJoin() {
        return false;
    }

    public boolean supportsNestedColumns() {
        return false;
    }

    public boolean shouldHide(@Nullable DasSymbol symbol, @Nullable PsiElement place) {
        if (place != null && SqlPsiUtilCoreKt.isSqlCalleeExpression(place)) {
            DasObject dasObject;
            SqlFunctionCallExpression call = (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)place, SqlFunctionCallExpression.class);
            DasObject dasObject2 = dasObject = symbol != null ? symbol.getDasObject() : null;
            if (call != null && dasObject instanceof DasRoutine && !this.checkArgumentMatch((DasRoutine)dasObject, call)) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkArgumentMatch(@NotNull DasRoutine routine, @NotNull SqlFunctionCallExpression call) {
        SqlExpression arg;
        if (routine == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(82);
        }
        if (call == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(83);
        }
        if (routine instanceof DasOperator) {
            return true;
        }
        SqlExpressionList parameterList = call.getParameterList();
        List arguments = parameterList != null ? parameterList.getExpressionList() : Collections.emptyList();
        List parameters = this.getSignatureParameters(routine).toList();
        HashMap<DasArgument, JBIterable> argumentMap = new HashMap<DasArgument, JBIterable>();
        int paramCount = parameters.size();
        int argCount = arguments.size();
        int argIndex = 0;
        while (argIndex < argCount && !((arg = (SqlExpression)arguments.get(argIndex)) instanceof SqlNamedParameterValueExpression)) {
            if (argIndex >= paramCount) {
                return false;
            }
            DasArgument parameter = (DasArgument)parameters.get(argIndex);
            if (parameter.isVariadic()) {
                argumentMap.put(parameter, JBIterable.from(arguments.subList(argIndex, argCount)));
                argIndex = argCount;
                continue;
            }
            argumentMap.put(parameter, JBIterable.of((Object)arg));
            ++argIndex;
        }
        int namedArgStart = argIndex;
        while (argIndex < argCount) {
            SqlExpression arg2 = (SqlExpression)arguments.get(argIndex);
            if (!(arg2 instanceof SqlNamedParameterValueExpression)) {
                return false;
            }
            SqlReferenceExpression paramRef = (SqlReferenceExpression)((SqlNamedParameterValueExpression)arg2).getLOperand();
            Condition condition = DbSqlUtilCore.byName((String)paramRef.getName(), (boolean)paramRef.isQuoted(), null, (CasingProvider)this);
            int paramIndex = ContainerUtil.indexOf((List)parameters, (Condition)condition);
            if (paramIndex < namedArgStart) {
                return false;
            }
            argumentMap.put((DasArgument)parameters.get(paramIndex), JBIterable.of((Object)arg2));
            ++argIndex;
        }
        for (DasArgument parameter : parameters) {
            JBIterable args = (JBIterable)argumentMap.get(parameter);
            if (args == null && !parameter.isDefaulted()) {
                return false;
            }
            if (args == null) continue;
            for (SqlExpression arg3 : args) {
                if (this.getTypeSystem().supportsImplicitConversion(arg3.getDasType().toDataType(), parameter.getDasType().toDataType())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public SqlExtractVariableHelper getExtractVariableHelper() {
        return null;
    }

    @Nullable
    public SqlExtractFunctionHelper getExtractFunctionHelper() {
        return null;
    }

    @Nullable
    public ProblemDescriptor checkIdentifierText(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        return this.checkIdentifierIsKeyword(o, manager, onTheFly, false);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierIsKeyword(SqlIdentifier o, InspectionManager manager, boolean onTheFly, boolean pl) {
        IElementType type = PsiUtilCore.getElementType((PsiElement)o.getFirstChild());
        if (type instanceof SqlIdentifierKeywordTokenType) {
            type = ((SqlIdentifierKeywordTokenType)type).getKeyword();
        }
        if (!(type instanceof SqlKeywordTokenType) || !(!pl ? this.isReservedKeyword(type) : this.isReservedKeywordPL(type))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message((String)"identifier.1.should.be.quoted", (Object[])new Object[]{o.getName()}), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly);
    }

    @Nullable
    protected ProblemDescriptor checkIdentifierStartsWithLetter(SqlIdentifier o, InspectionManager manager, boolean onTheFly) {
        String text = o.getText();
        if (text.length() <= 0 || Character.isLetter(text.charAt(0))) {
            return null;
        }
        return manager.createProblemDescriptor((PsiElement)o, SqlBundle.message((String)"identifier.should.start.with.letter", (Object[])new Object[0]), (LocalQuickFix)new QuoteIdentifierQuickFix(this), ProblemHighlightType.GENERIC_ERROR, onTheFly);
    }

    @Nullable
    public TextAttributesKey getHighlightingByCustomKind(@NotNull ObjectKind kind) {
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(84);
        }
        return null;
    }

    @NotNull
    public SqlValidatingHighlightVisitor.Delegate createValidationDelegate(@NotNull HighlightInfoHolder holder) {
        if (holder == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(85);
        }
        return new SqlBaseValidationDelegate(this, holder);
    }

    @NotNull
    public DFABuildingVisitor createDFAVisitor() {
        return new DFABuildingVisitor(this);
    }

    @NotNull
    public SqlErrorSpecHelper getErrorSpecHelper() {
        SqlErrorSpecHelper sqlErrorSpecHelper = SqlErrorSpecHelper.DEFAULT_INSTANCE;
        if (sqlErrorSpecHelper == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(86);
        }
        return sqlErrorSpecHelper;
    }

    @Nullable
    public SqlDateTimeLanguageHelper getDateTimeHelper() {
        return null;
    }

    public SqlCloseBlockProcessor[] getEnterHandlerBlockProcessors() {
        SqlCloseBlockProcessor[] sqlCloseBlockProcessorArray;
        SqlCloseBlockProcessor processor = this.getEnterHandlerBlockProcessor();
        if (processor != null) {
            SqlCloseBlockProcessor[] sqlCloseBlockProcessorArray2 = new SqlCloseBlockProcessor[1];
            sqlCloseBlockProcessorArray = sqlCloseBlockProcessorArray2;
            sqlCloseBlockProcessorArray2[0] = processor;
        } else {
            sqlCloseBlockProcessorArray = null;
        }
        return sqlCloseBlockProcessorArray;
    }

    @Nullable
    protected SqlCloseBlockProcessor getEnterHandlerBlockProcessor() {
        return null;
    }

    protected boolean supportsRowTypeSyntax() {
        return false;
    }

    private static boolean isTableTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(87);
        }
        return ModelConsts.TABLE_OR_VIEW_KINDS.contains(type) && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    private static boolean isColumnTypeLookupCandidate(ObjectKind type, @NotNull Set<ObjectKind> expectedTypes) {
        if (expectedTypes == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(88);
        }
        return type == ObjectKind.COLUMN && expectedTypes.contains(ObjectKind.OBJECT_TYPE);
    }

    @Nullable
    public List<LookupElementBuilder> createCompletionLookups(@NotNull SqlQualifiedResolveResult resolveResult, @NotNull String lookupString, @NotNull ObjectKind kind, @NotNull Set<ObjectKind> expectedTypes) {
        if (resolveResult == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(89);
        }
        if (lookupString == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(90);
        }
        if (kind == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(91);
        }
        if (expectedTypes == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(92);
        }
        if (SqlLanguageDialectEx.isTableTypeLookupCandidate(kind, expectedTypes)) {
            return new SmartList((Object[])new LookupElementBuilder[]{LookupElementBuilder.create((Object)resolveResult, (String)(lookupString + "%rowtype")), LookupElementBuilder.create((Object)resolveResult, (String)lookupString).withInsertHandler(SqlInsertHandlers.DOT_INSERT_HANDLER)});
        }
        if (SqlLanguageDialectEx.isColumnTypeLookupCandidate(kind, expectedTypes)) {
            return Collections.singletonList(LookupElementBuilder.create((Object)resolveResult, (String)(lookupString + "%type")));
        }
        return null;
    }

    private static boolean isTableFunctionCallRef(@NotNull PsiElement expr) {
        PsiElement parent;
        if (expr == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(93);
        }
        return (parent = expr.getParent()) instanceof SqlFunctionCallExpression && parent.getParent() instanceof SqlFunctionCallTableExpressionImpl || parent instanceof SqlQueryExpression;
    }

    @Nullable
    protected static DasNamespace getDefaultTopNamespace(@Nullable DbDataSource dataSource, @Nullable ObjectName fallback) {
        DasModel model;
        LocalDataSource ds = dataSource == null ? null : (LocalDataSource)ObjectUtils.tryCast((Object)dataSource.getDelegate(), LocalDataSource.class);
        DasModel dasModel = model = ds == null ? null : ds.getModel();
        if (model == null) {
            return null;
        }
        DasNamespace cur = model.getCurrentRootNamespace();
        if (cur == null && fallback != null) {
            cur = (DasNamespace)model.getModelRoots().filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
        }
        return cur;
    }

    @Nullable
    protected static DasNamespace getDefaultNamespace(@Nullable DbDataSource dataSource, @Nullable ObjectName fallback) {
        DasNamespace cur = SqlLanguageDialectEx.getDefaultTopNamespace(dataSource, fallback);
        if (cur == null || cur.getKind() == ObjectKind.SCHEMA) {
            return cur;
        }
        DasNamespace sc = SqlLanguageDialectEx.getCurrentSchema(cur);
        return (DasNamespace)ObjectUtils.chooseNotNull((Object)sc, (Object)cur);
    }

    @Nullable
    protected static DasNamespace getCurrentSchema(@Nullable DasNamespace cur) {
        return cur == null ? null : (DasNamespace)cur.getDasChildren(ObjectKind.SCHEMA).filter(BasicNamespace.class).filter(BasicNamespace::isCurrent).first();
    }

    protected static boolean processReservedEntitiesWithTypeSimple(@NotNull ReservedEntity entity, @Nullable DasType result, @Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor, boolean checkType, Boolean forcedCaseSense) {
        if (entity == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(94);
        }
        if (place == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(95);
        }
        if (processor == null) {
            SqlLanguageDialectEx.$$$reportNull$$$0(96);
        }
        return !SqlImplUtil.equalsInsensitiveOrTrue(name, entity.getName(), resolve) || checkType && !processor.isExpected(entity.getKind()) || processor.executeTarget((DasSymbol)entity, result, forcedCaseSense, ResolveState.initial());
    }

    @Nullable
    protected static DasNamespace getDefaultSubNamespace(@Nullable DasNamespace cur, @Nullable ObjectName fallback) {
        if (cur == null) {
            return null;
        }
        DasNamespace schema = SqlLanguageDialectEx.getCurrentSchema(cur);
        if (schema != null || fallback == null) {
            return schema;
        }
        return (DasNamespace)cur.getDasChildren(null).filter(DasNamespace.class).filter(n -> Comparing.strEqual((String)fallback.name, (String)n.getName(), (boolean)fallback.quoted)).first();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7, 10, 11, 13, 14, 16, 23, 24, 25, 26, 27, 30, 34, 35, 36, 37, 39, 51, 53, 55, 75, 78, 79, 86 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 51: 
            case 53: 
            case 55: 
            case 75: 
            case 78: 
            case 79: 
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 8: 
            case 32: 
            case 58: 
            case 61: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 17: 
            case 18: 
            case 52: 
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototype";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlFile";
                break;
            }
            case 22: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prev";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stmt";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 42: 
            case 44: 
            case 69: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 46: 
            case 48: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 50: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "routine";
                break;
            }
            case 54: 
            case 87: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedTypes";
                break;
            }
            case 56: 
            case 68: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 57: 
            case 59: 
            case 63: 
            case 67: 
            case 71: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 60: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentKind";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 77: 
            case 80: 
            case 84: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 90: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/SqlLanguageDialectEx";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInTypes";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpectedFunctionLocations";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraKindsStrict";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getIgnoredParentKinds";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "applyImplicitImports";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "processImports";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportBuilder";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultImports";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureParameters";
                break;
            }
            case 53: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 75: {
                objectArray = objectArray2;
                objectArray2[1] = "getImplicitParentInfo";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasing";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getMajorChildKinds";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorSpecHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionParserExtension";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 39: 
            case 51: 
            case 53: 
            case 55: 
            case 75: 
            case 78: 
            case 79: 
            case 86: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getExtraKindsStrict";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredParentKinds";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "applyImplicitImports";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isTableAliasAllowedAt";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "requiresAsForAliasAt";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "canBeCalledWithoutParens";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processImports";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "createRefPattern";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canContainDdl";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "isSpecialFunctionReference";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "isMultiIdReference";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureParameters";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "supportsSql92CharSetSpecFor";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isResolveTargetAccepted";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isLinkedDSReference";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processQualifiedResolve";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalExpandCondition";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "getMaxIdentifierLength";
                break;
            }
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeDual";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "processNamedArgumentCandidates";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "isAutoIncrementColumn";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitParentInfo";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "extractDefinitions";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getCasing";
                break;
            }
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "shouldSkipFromQualification";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "canBeQualified";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "checkArgumentMatch";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getHighlightingByCustomKind";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "createValidationDelegate";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "isTableTypeLookupCandidate";
                break;
            }
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "isColumnTypeLookupCandidate";
                break;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "createCompletionLookups";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "isTableFunctionCallRef";
                break;
            }
            case 94: 
            case 95: 
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithTypeSimple";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7, 10, 11, 13, 14, 16, 23, 24, 25, 26, 27, 30, 34, 35, 36, 37, 39, 51, 53, 55, 75, 78, 79, 86 -> new IllegalStateException(string);
        };
    }

    static class LazyData {
        private static final Collection<ObjectKind> MAJOR_CHILD_KINDS = Arrays.asList(ObjectKind.TRIGGER, ObjectKind.INDEX);

        LazyData() {
        }
    }

    public static interface BuiltinFunctions {
        @Nullable
        public BuiltinFunction get(@Nullable String var1);

        public boolean contains(@Nullable String var1);

        @NotNull
        public Iterable<BuiltinFunction> byMatcher(@NotNull PrefixMatcher var1);

        @NotNull
        public Collection<BuiltinFunction> forTokens();

        @Nullable
        public BuiltinFunctions typeMethods(@NotNull String var1, boolean var2);
    }
}

