/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DataType;
import com.intellij.database.model.LengthUnit;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasBuiltinTypeWithLength;
import com.intellij.database.types.DasBuiltinTypeWithLengthUnits;
import com.intellij.database.types.DasBuiltinTypeWithPrecision;
import com.intellij.database.types.DasBuiltinTypeWithScale;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasSimpleBuiltinTypeClass;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlTypeElementBase;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlBuiltinTypeElementImpl
extends SqlTypeElementBase {
    public SqlBuiltinTypeElementImpl(@NotNull IElementType elementType) {
        if (elementType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(0);
        }
        super(elementType);
    }

    protected static int parseIntAttribute(@Nullable PsiElement attributePsi, int defaultValue) {
        if (attributePsi == null) {
            return defaultValue;
        }
        String text = attributePsi.getText();
        if (text.equals("*")) {
            return 0x7FFFFFFE;
        }
        return StringUtil.parseInt((String)text, (int)defaultValue);
    }

    @Nullable
    protected PsiElement getIntAttributePsi(@Nullable PsiElement after) {
        JBIterable elements = after != null ? SqlImplUtil.siblings(after).skip(1) : SqlImplUtil.sqlChildren((PsiElement)this);
        return (PsiElement)elements.filter(e -> {
            IElementType elementType = PsiUtilCore.getElementType((PsiElement)e);
            return elementType == SqlCompositeElementTypes.SQL_NUMERIC_LITERAL || elementType == SqlTokens.SQL_INTEGER_TOKEN || elementType == SqlCommonTokens.SQL_ASTERISK;
        }).first();
    }

    protected int getIntAttribute() {
        return SqlBuiltinTypeElementImpl.parseIntAttribute(this.getIntAttributePsi(null), -1);
    }

    @NotNull
    private DasBuiltinTypeWithPrecision<?> adjustTypeWithPrecision(@NotNull DasBuiltinTypeWithPrecision dasType) {
        PsiElement precisionPsi;
        if (dasType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(1);
        }
        if ((precisionPsi = this.getIntAttributePsi(null)) == null) {
            DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = dasType;
            if (dasBuiltinTypeWithPrecision == null) {
                SqlBuiltinTypeElementImpl.$$$reportNull$$$0(2);
            }
            return dasBuiltinTypeWithPrecision;
        }
        int precision = SqlBuiltinTypeElementImpl.parseIntAttribute(precisionPsi, -1);
        PsiElement scalePsi = this.getIntAttributePsi(precisionPsi);
        int scale = SqlBuiltinTypeElementImpl.parseIntAttribute(scalePsi, 0);
        DasBuiltinTypeWithPrecision dasBuiltinTypeWithPrecision = dasType.copy(precision, scale);
        if (dasBuiltinTypeWithPrecision == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(3);
        }
        return dasBuiltinTypeWithPrecision;
    }

    @NotNull
    private DasBuiltinTypeWithScale<?> adjustTypeWithScale(@NotNull DasBuiltinTypeWithScale dasType) {
        PsiElement scalePsi;
        if (dasType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(4);
        }
        if ((scalePsi = this.getIntAttributePsi(null)) == null) {
            DasBuiltinTypeWithScale dasBuiltinTypeWithScale = dasType;
            if (dasBuiltinTypeWithScale == null) {
                SqlBuiltinTypeElementImpl.$$$reportNull$$$0(5);
            }
            return dasBuiltinTypeWithScale;
        }
        int scale = SqlBuiltinTypeElementImpl.parseIntAttribute(scalePsi, 0);
        DasBuiltinTypeWithScale dasBuiltinTypeWithScale = dasType.copy(scale);
        if (dasBuiltinTypeWithScale == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(6);
        }
        return dasBuiltinTypeWithScale;
    }

    @NotNull
    private DasBuiltinTypeWithLength<?> adjustTypeWithLength(@NotNull DasBuiltinTypeWithLength dasType) {
        if (dasType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(7);
        }
        DasBuiltinTypeWithLength dasBuiltinTypeWithLength = dasType.copy(this.getIntAttribute());
        if (dasBuiltinTypeWithLength == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(8);
        }
        return dasBuiltinTypeWithLength;
    }

    @NotNull
    private DasBuiltinTypeWithLengthUnits<?> adjustTypeWithLengthUnits(@NotNull DasBuiltinTypeWithLengthUnits dasType) {
        LengthUnit unit;
        if (dasType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(9);
        }
        int length = this.getIntAttribute();
        DasBuiltinTypeWithLengthUnits dasBuiltinTypeWithLengthUnits = dasType.copy(length, unit, (unit = this.getLengthUnit()) != LengthUnit.NONE);
        if (dasBuiltinTypeWithLengthUnits == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(10);
        }
        return dasBuiltinTypeWithLengthUnits;
    }

    @NotNull
    protected LengthUnit getLengthUnit() {
        LengthUnit lengthUnit = LengthUnit.NONE;
        if (lengthUnit == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(11);
        }
        return lengthUnit;
    }

    @Nullable
    protected DasType parseBuiltinTypeBase() {
        DataType dataType = this.parseDataType();
        SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)this);
        DasTypeCategory category = dialect.getTypeSystem().getTypeCategory(dataType);
        DasSimpleBuiltinTypeClass typeClass = DasSimpleBuiltinTypeClass.Companion.of(dataType.typeName, category);
        return DasDataBuiltinType.Companion.of(typeClass, dataType);
    }

    @NotNull
    protected DasBuiltinType<?> adjustType(@NotNull DasBuiltinType<?> dasType) {
        if (dasType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(12);
        }
        if (dasType instanceof DasBuiltinTypeWithLengthUnits) {
            return this.adjustTypeWithLengthUnits((DasBuiltinTypeWithLengthUnits)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithLength) {
            return this.adjustTypeWithLength((DasBuiltinTypeWithLength)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithPrecision) {
            return this.adjustTypeWithPrecision((DasBuiltinTypeWithPrecision)dasType);
        }
        if (dasType instanceof DasBuiltinTypeWithScale) {
            return this.adjustTypeWithScale((DasBuiltinTypeWithScale)dasType);
        }
        DasBuiltinType<?> dasBuiltinType = dasType;
        if (dasBuiltinType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(13);
        }
        return dasBuiltinType;
    }

    @Override
    @NotNull
    protected DasType computeDasType() {
        DasType dasType = this.parseBuiltinTypeBase();
        if (dasType == null) {
            DasBuiltinType dasBuiltinType = DasTypeSystemBase.UNKNOWN;
            if (dasBuiltinType == null) {
                SqlBuiltinTypeElementImpl.$$$reportNull$$$0(14);
            }
            return dasBuiltinType;
        }
        if (!(dasType instanceof DasBuiltinType)) {
            DasType dasType2 = dasType;
            if (dasType2 == null) {
                SqlBuiltinTypeElementImpl.$$$reportNull$$$0(15);
            }
            return dasType2;
        }
        DasBuiltinType<?> dasBuiltinType = this.adjustType((DasBuiltinType)dasType);
        if (dasBuiltinType == null) {
            SqlBuiltinTypeElementImpl.$$$reportNull$$$0(16);
        }
        return dasBuiltinType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 6, 8, 10, 11, 13, 14, 15, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlBuiltinTypeElementImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithPrecision";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithScale";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithLength";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustTypeWithLengthUnits";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLengthUnit";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "adjustType";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDasType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithPrecision";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithScale";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithLength";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "adjustTypeWithLengthUnits";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "adjustType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 6, 8, 10, 11, 13, 14, 15, 16 -> new IllegalStateException(string);
        };
    }
}

