/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlForeignKeyDefinition;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.stubs.SqlForeignKeyStub;
import com.intellij.util.containers.JBIterator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlForeignKeyDefinitionImpl
extends SqlKIFKImpl<SqlForeignKeyStub>
implements SqlForeignKeyDefinition {
    private MultiRef<? extends DasTypedObject> myRefColumns;

    public SqlForeignKeyDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    public SqlForeignKeyDefinitionImpl(SqlForeignKeyStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(1);
        }
        return objectKind;
    }

    @Nullable
    public SqlReferenceExpression getRefTableReference() {
        SqlTableColumnsList list = this.getRefTableColumnList();
        return list == null ? null : list.getTableReference();
    }

    public String getRefTableName() {
        SqlReferenceExpression tableRef = this.getRefTableReference();
        return tableRef == null ? null : tableRef.getName();
    }

    public String getRefTableSchema() {
        String part = SqlImplUtil.getCasedPart(this.getRefTableReference(), ObjectKind.SCHEMA);
        return DasUtil.isNoName((String)part) ? null : part;
    }

    public String getRefTableCatalog() {
        String part = SqlImplUtil.getCasedPart(this.getRefTableReference(), ObjectKind.DATABASE);
        return DasUtil.isNoName((String)part) ? null : part;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myRefColumns = null;
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getRefColumns() {
        if (this.myRefColumns == null) {
            DasTableKey pk;
            List<SqlReferenceExpression> refList = this.getRefList();
            this.myRefColumns = refList.isEmpty() ? ((pk = this.getRefPk()) != null ? pk.getColumnsRef() : DasUtil.emptyMultiRef()) : SqlForeignKeyDefinitionImpl.asColumnsRef(refList);
        }
        MultiRef<? extends DasTypedObject> multiRef = this.myRefColumns;
        if (multiRef == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(2);
        }
        return multiRef;
    }

    @Nullable
    private DasTableKey getRefPk() {
        DasTable table = this.getRefTable();
        return table != null ? DasUtil.getPrimaryKey((DasTable)table) : null;
    }

    @Nullable
    public DasTable getRefTable() {
        SqlReferenceExpression expression = this.getRefTableReference();
        if (expression != null) {
            for (ResolveResult result : expression.multiResolve(false)) {
                if (!(result.getElement() instanceof DasTable)) continue;
                return (DasTable)result.getElement();
            }
        }
        return null;
    }

    @NotNull
    private List<SqlReferenceExpression> getRefList() {
        List<SqlReferenceExpression> list = SqlImplUtil.getReferenceList(this.getRefTableColumnList());
        if (list == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(3);
        }
        return list;
    }

    public DasForeignKey.RuleAction getDeleteRule() {
        SqlForeignKeyStub stub = (SqlForeignKeyStub)this.getGreenStub();
        if (stub != null) {
            return ((DasForeignKey)stub.getElement()).getDeleteRule();
        }
        return this.getRuleAction((IElementType)SqlCommonKeywords.SQL_DELETE);
    }

    public DasForeignKey.RuleAction getUpdateRule() {
        SqlForeignKeyStub stub = (SqlForeignKeyStub)this.getGreenStub();
        if (stub != null) {
            return ((DasForeignKey)stub.getElement()).getUpdateRule();
        }
        return this.getRuleAction((IElementType)SqlCommonKeywords.SQL_UPDATE);
    }

    @Nullable
    private DasForeignKey.RuleAction getRuleAction(@NotNull IElementType second) {
        if (second == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(4);
        }
        for (SqlClause clause : SyntaxTraverser.psiTraverser((PsiElement)this).filter(SqlClause.class)) {
            JBIterator<IElementType> type;
            if (PsiUtilCore.getElementType((PsiElement)clause) != SqlCompositeElementTypes.SQL_FOREIGN_KEY_CASCADE_OPTION || !(type = SqlForeignKeyDefinitionImpl.getTokens((PsiElement)clause)).advance() || type.current() != SqlCommonKeywords.SQL_ON || !type.advance() || type.current() != second) continue;
            if (!type.advance()) {
                return null;
            }
            if (type.current() == SqlCommonKeywords.SQL_SET) {
                if (!type.advance()) {
                    return null;
                }
                if (type.current() == SqlCommonKeywords.SQL_DEFAULT) {
                    return DasForeignKey.RuleAction.SET_DEFAULT;
                }
                if (type.current() == SqlCommonKeywords.SQL_NULL) {
                    return DasForeignKey.RuleAction.SET_NULL;
                }
                return null;
            }
            if (type.current() == SqlCommonKeywords.SQL_CASCADE) {
                return DasForeignKey.RuleAction.CASCADE;
            }
            if (type.current() == SqlCommonKeywords.SQL_RESTRICT) {
                return DasForeignKey.RuleAction.RESTRICT;
            }
            if (type.current() != SqlCommonKeywords.SQL_NO) continue;
            if (!type.advance()) {
                return null;
            }
            if (type.current() == SqlCommonKeywords.SQL_ACTION) {
                return DasForeignKey.RuleAction.NO_ACTION;
            }
            return null;
        }
        return null;
    }

    @NotNull
    private static JBIterator<IElementType> getTokens(PsiElement c) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterator jBIterator = JBIterator.from((Iterator)api.children((Object)c).filter(e -> !(e instanceof PsiComment) && !(e instanceof PsiWhiteSpace) && !(e instanceof PsiErrorElement)).transform(api.TO_TYPE).iterator());
        if (jBIterator == null) {
            SqlForeignKeyDefinitionImpl.$$$reportNull$$$0(5);
        }
        return jBIterator;
    }

    public DasForeignKey.Deferrability getDeferrability() {
        SqlForeignKeyStub stub = (SqlForeignKeyStub)this.getGreenStub();
        if (stub != null) {
            return ((DasForeignKey)stub.getElement()).getDeferrability();
        }
        PsiElement characteristic = this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_CONSTRAINT_CHARACTERISTIC_CLAUSE);
        if (characteristic == null) {
            return null;
        }
        JBIterator<IElementType> tokens = SqlForeignKeyDefinitionImpl.getTokens(characteristic);
        IElementType prev = null;
        boolean deferrable = false;
        boolean deferred = false;
        while (tokens.advance()) {
            IElementType cur = (IElementType)tokens.current();
            if (cur == SqlCommonKeywords.SQL_DEFERRABLE) {
                boolean bl = deferrable = prev != SqlCommonKeywords.SQL_NOT;
            }
            if (prev == SqlCommonKeywords.SQL_INITIALLY) {
                deferred = cur == SqlCommonKeywords.SQL_DEFERRED;
            }
            prev = cur;
        }
        return !deferrable ? DasForeignKey.Deferrability.NOT_DEFERRABLE : (deferred ? DasForeignKey.Deferrability.INITIALLY_DEFERRED : DasForeignKey.Deferrability.INITIALLY_IMMEDIATE);
    }

    private SqlClause getReferencesClause() {
        return (SqlClause)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_FOREIGN_KEY_REFERENCES_CLAUSE);
    }

    public SqlTableColumnsList getRefTableColumnList() {
        SqlForeignKeyStub stub = (SqlForeignKeyStub)this.getStub();
        if (stub != null) {
            return stub.getRefColumnList();
        }
        SqlClause refClause = this.getReferencesClause();
        return refClause == null ? null : (SqlTableColumnsList)PsiTreeUtil.getChildOfType((PsiElement)refClause, SqlTableColumnsList.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlForeignKeyDefinitionImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefColumns";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRefList";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRuleAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 5 -> new IllegalStateException(string);
        };
    }
}

