/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.impl;

import com.google.common.collect.Iterables;
import com.intellij.database.Dbms;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasHideableObject;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamed;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasScopeAware;
import com.intellij.database.model.DasScopeProcessor;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DataType;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiColumn;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.TrigEvent;
import com.intellij.database.model.basic.BasicTableOrViewColumn;
import com.intellij.database.model.meta.BasicMetaModel;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.model.meta.BasicMetaUtils;
import com.intellij.database.model.properties.DataTypeFactory;
import com.intellij.database.psi.DbColumn;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespace;
import com.intellij.database.psi.DbPresentationCore;
import com.intellij.database.psi.DbTable;
import com.intellij.database.script.generator.NamingService;
import com.intellij.database.script.generator.NamingServices;
import com.intellij.database.symbols.DasPredefinedSymbol;
import com.intellij.database.symbols.DasSymbol;
import com.intellij.database.symbols.PsiColumnWithSymbol;
import com.intellij.database.types.DasArrayType;
import com.intellij.database.types.DasBuiltinType;
import com.intellij.database.types.DasCollectionType;
import com.intellij.database.types.DasColumniationType;
import com.intellij.database.types.DasDataBuiltinType;
import com.intellij.database.types.DasDefinedType;
import com.intellij.database.types.DasMapType;
import com.intellij.database.types.DasType;
import com.intellij.database.types.DasTypeCategory;
import com.intellij.database.types.DasTypeFacade;
import com.intellij.database.types.DasTypeSystem;
import com.intellij.database.types.DasTypeSystemBase;
import com.intellij.database.types.DasTypeSystems;
import com.intellij.database.types.DasTypeUtilsKt;
import com.intellij.database.types.DasUnresolvedTypeReference;
import com.intellij.database.util.Case;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.database.util.DbUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.util.NameChecker;
import com.intellij.database.util.TreePattern;
import com.intellij.database.util.Version;
import com.intellij.database.util.common.StringFun;
import com.intellij.extapi.psi.StubBasedPsiElementBase;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.ASTNode;
import com.intellij.lang.BracePair;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.completion.SqlCompletionScopeProcessor;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.BuiltinFunction;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDataSourceMappings;
import com.intellij.sql.dialects.SqlDialectImplUtilCore;
import com.intellij.sql.dialects.SqlImportState;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.intentions.UtilsKt;
import com.intellij.sql.psi.SqlAlterInstruction;
import com.intellij.sql.psi.SqlAlterStatement;
import com.intellij.sql.psi.SqlAsExpression;
import com.intellij.sql.psi.SqlClause;
import com.intellij.sql.psi.SqlCodeBlockElement;
import com.intellij.sql.psi.SqlColumnDefinition;
import com.intellij.sql.psi.SqlCommonKeywords;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElement;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateTableStatement;
import com.intellij.sql.psi.SqlCreateViewStatement;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlDefinitionHolder;
import com.intellij.sql.psi.SqlDmlInstruction;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExplicitTableExpression;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlExtraDeclarationsProvider;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlFromClause;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlGroupByClause;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlImplicitDeclarationsProvider;
import com.intellij.sql.psi.SqlImplicitSymbol;
import com.intellij.sql.psi.SqlImplicitTarget;
import com.intellij.sql.psi.SqlInsertDmlInstruction;
import com.intellij.sql.psi.SqlJoinExpression;
import com.intellij.sql.psi.SqlKeywordTokenType;
import com.intellij.sql.psi.SqlLateralAwareExpression;
import com.intellij.sql.psi.SqlLocalDefinition;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlParenthesizedExpression;
import com.intellij.sql.psi.SqlQueryClause;
import com.intellij.sql.psi.SqlQueryExpression;
import com.intellij.sql.psi.SqlReference;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlReferenceList;
import com.intellij.sql.psi.SqlResolveResult;
import com.intellij.sql.psi.SqlResultSetExpression;
import com.intellij.sql.psi.SqlScopeProcessor;
import com.intellij.sql.psi.SqlScopingExpression;
import com.intellij.sql.psi.SqlSelectClause;
import com.intellij.sql.psi.SqlSelectStatement;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.SqlTableDefinition;
import com.intellij.sql.psi.SqlTableExpression;
import com.intellij.sql.psi.SqlTableType;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlTypeCastExpression;
import com.intellij.sql.psi.SqlTypeElement;
import com.intellij.sql.psi.SqlTypedDefinition;
import com.intellij.sql.psi.SqlUsingClause;
import com.intellij.sql.psi.SqlValuesExpression;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.SqlWithClause;
import com.intellij.sql.psi.impl.SqlAsteriskSymbol;
import com.intellij.sql.psi.impl.SqlBlockStatementImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnAliasListImpl;
import com.intellij.sql.psi.impl.SqlColumnDefinitionImpl;
import com.intellij.sql.psi.impl.SqlColumnSymbol;
import com.intellij.sql.psi.impl.SqlDeclareStatementImpl;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlLabelDefinitionImpl;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlPositionalReference;
import com.intellij.sql.psi.impl.SqlProcedureDefinitionImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.impl.SqlReferenceImpl;
import com.intellij.sql.psi.impl.SqlTableTypeBase;
import com.intellij.sql.psi.impl.SqlValuesParameterInfoUtils;
import com.intellij.sql.psi.impl.TableBasedSqlTableTypeImpl;
import com.intellij.sql.psi.stubs.SqlColumnStub;
import com.intellij.sql.psi.stubs.SqlLazyParseablePsiElement;
import com.intellij.sql.psi.stubs.SqlStubbedDefinitionImpl;
import com.intellij.sql.slicer.SqlPsiUtilCoreKt;
import com.intellij.sql.symbols.DasInlineSymbol;
import com.intellij.sql.symbols.DasPsiWrappingSymbol;
import com.intellij.sql.symbols.DasSymbolUtil;
import com.intellij.sql.symbols.virtual.DasVirtualColumnSymbol;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.text.TextRangeUtil;
import icons.DatabaseIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.swing.Icon;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SqlImplUtil {
    public static final Function<StubElement, PsiElement> STUB_TO_PSI = element -> element.getPsi();
    public static final Function<SqlNameElement, String> IDENT_TO_NAME = element -> element.getName();
    public static final DasTable NO_TABLE = new EmptyTable();
    public static final String NULL_STRING = DasUtil.NO_NAME;
    public static final DasSymbol ANY_SYMBOL = new DasPredefinedSymbol(){

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = Dbms.UNKNOWN;
            if (dbms == null) {
                1.$$$reportNull$$$0(0);
            }
            return dbms;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.ANY;
            if (objectKind == null) {
                1.$$$reportNull$$$0(1);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            return "";
        }

        public boolean isQuoted() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    };
    private static final Key<PsiElement> CURRENT_QUALIFIER = Key.create((String)"CURRENT_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_QUALIFIER = Key.create((String)"IMMEDIATE_QUALIFIER");
    private static final Key<PsiElement> IMMEDIATE_TARGET = Key.create((String)"IMMEDIATE_TARGET");
    private static final Key<SqlQueryExpression> LAST_QUERY_EXPRESSION = Key.create((String)"LAST_QUERY_EXPRESSION");
    private static final int ITEM_TEXT_LENGTH = 50;
    private static final Pattern SPACES = Pattern.compile("\\s+");

    private SqlImplUtil() {
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlReferenceList list) {
        List list2 = list == null ? Collections.emptyList() : list.getReferenceList();
        if (list2 == null) {
            SqlImplUtil.$$$reportNull$$$0(0);
        }
        return list2;
    }

    @NotNull
    public static List<SqlReferenceExpression> getReferenceList(@Nullable SqlTableColumnsList list) {
        return list == null ? Collections.emptyList() : SqlImplUtil.getReferenceList(list.getColumnsReferenceList());
    }

    public static Collection<PsiElement> getReferencedElements(@NotNull SqlDefinition o) {
        SqlNameElement nameElement;
        PsiReference reference;
        SqlFileImpl.GroupImpl mirror;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(1);
        }
        LinkedHashSet<PsiElement> result = new LinkedHashSet<PsiElement>();
        Couple<SqlFileImpl.GroupImpl> mirrorPair = SqlImplUtil.getMirror(o);
        SqlFileImpl.GroupImpl groupImpl = mirrorPair.second != null ? (SqlFileImpl.GroupImpl)((Object)mirrorPair.second) : (mirror = o.getKind() == SqlDbElementType.BODY ? (SqlFileImpl.GroupImpl)((Object)mirrorPair.first) : null);
        if (mirror != null) {
            mirror.delegates().addAllTo(result);
        }
        PsiReference psiReference = reference = (nameElement = o.getNameElement()) != null && nameElement.getTextLength() > 0 ? nameElement.findReferenceAt(nameElement.getTextLength() - 1) : null;
        if (reference != null) {
            if (reference instanceof PsiPolyVariantReference) {
                ResolveResult[] results;
                for (ResolveResult resolveResult : results = ((PsiPolyVariantReference)reference).multiResolve(false)) {
                    PsiElement element = resolveResult.getElement();
                    result.add(element);
                }
            } else {
                PsiElement element = reference.resolve();
                result.add(element);
            }
        }
        return result;
    }

    @NotNull
    public static Couple<SqlFileImpl.GroupImpl> getMirror(@NotNull SqlDefinition o) {
        PsiFile file;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(2);
        }
        if ((file = o.getContainingFile()) instanceof SqlFileImpl) {
            Couple<SqlFileImpl.GroupImpl> couple = ((SqlFileImpl)file).getMirror(o);
            if (couple == null) {
                SqlImplUtil.$$$reportNull$$$0(3);
            }
            return couple;
        }
        Couple couple = Couple.getEmpty();
        if (couple == null) {
            SqlImplUtil.$$$reportNull$$$0(4);
        }
        return couple;
    }

    @NotNull
    private static <T> ResolveState getModifiedState(@NotNull ResolveState state, Key<T> key, T value) {
        Object qual;
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(5);
        }
        if ((qual = state.get(key)) != null || value == null) {
            ResolveState resolveState = state;
            if (resolveState == null) {
                SqlImplUtil.$$$reportNull$$$0(6);
            }
            return resolveState;
        }
        ResolveState resolveState = state.put(key, value);
        if (resolveState == null) {
            SqlImplUtil.$$$reportNull$$$0(7);
        }
        return resolveState;
    }

    @NotNull
    public static ResolveState setQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(8);
        }
        return SqlImplUtil.getModifiedState(state, CURRENT_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateQualifier(@NotNull ResolveState state, @Nullable PsiElement qualifier) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(9);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_QUALIFIER, qualifier);
    }

    @NotNull
    public static ResolveState setImmediateTarget(@NotNull ResolveState state, @Nullable PsiElement immediateTarget) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(10);
        }
        return SqlImplUtil.getModifiedState(state, IMMEDIATE_TARGET, immediateTarget);
    }

    public static boolean processQualifier(SqlReferenceExpression reference, SqlScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        Set<ObjectKind> expectedTypes;
        boolean found;
        if (reference == null) {
            return true;
        }
        ObjectKind kind = reference.getReferenceElementType().getTargetKind();
        if (kind != SqlDbElementType.ANY ? !SqlImplUtil.isProcessingChildOf(processor, kind) : !(found = (expectedTypes = ((SqlReferenceImpl)reference.getReference()).getExpectedTypes(true)).stream().anyMatch(expected -> SqlImplUtil.isProcessingChildOf(processor, expected)))) {
            return true;
        }
        if (PsiTreeUtil.isContextAncestor((PsiElement)reference, (PsiElement)place, (boolean)false)) {
            return true;
        }
        try {
            return SqlImplUtil.processQualifierImpl(reference, processor, resolveState, place);
        }
        catch (StackOverflowError e) {
            PsiElement placeParent = place.getParent();
            PsiElement referenceParent = reference.getParent();
            Logger.getInstance(SqlImplUtil.class).error("SOE while processing qualifier", (Throwable)e, new Attachment[]{new Attachment("place parent", SqlImplUtil.getInfo(placeParent) + "\n" + SqlImplUtil.getInfo(placeParent == null ? null : placeParent.getParent())), new Attachment("reference parent", SqlImplUtil.getInfo(referenceParent) + "\n" + SqlImplUtil.getInfo(referenceParent == null ? null : referenceParent.getParent()))});
            return true;
        }
    }

    @NotNull
    private static String getInfo(PsiElement placeParent) {
        Object object = placeParent == null ? "" : placeParent.getText() + "\n" + String.valueOf(PsiUtilCore.getElementType((PsiElement)placeParent));
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(11);
        }
        return object;
    }

    static boolean processQualifierImpl(@NotNull SqlReferenceExpression reference, SqlScopeProcessor processor, ResolveState resolveState, PsiElement place) {
        if (reference == null) {
            SqlImplUtil.$$$reportNull$$$0(12);
        }
        ResolveResult[] results = reference.multiResolve(false);
        PsiElement immediateQualifier = reference.getReference().resolveImmediate();
        ResolveState immediateQualifiedState = SqlImplUtil.setImmediateQualifier(resolveState, immediateQualifier);
        if (!SqlImplUtil.processDeclarationsInType((SqlExpression)reference, processor, immediateQualifiedState, place)) {
            return false;
        }
        if (!processor.isResultEmpty()) {
            return true;
        }
        boolean majorChildExpected = SqlImplUtil.isMajorChildExpected(processor);
        Project project = reference.getProject();
        for (ResolveResult result : results) {
            DbNamespace schemaElement;
            DasObject qualifierObject;
            DasSymbol qualifierSymbol = DasSymbolUtil.getSymbol(result);
            PsiElement qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            DasObject dasObject = qualifierObject = qualifierSymbol != null ? qualifierSymbol.getDasObject() : null;
            if (qualifierPsi == null) {
                if (qualifierObject == null) continue;
                for (DasObject child : qualifierObject.getDasChildren(null)) {
                    if (processor.execute(DasSymbolUtil.wrapObjectToSymbol(child, project), resolveState)) continue;
                    return false;
                }
                continue;
            }
            ResolveState qualifiedState = SqlImplUtil.setQualifier(resolveState, qualifierPsi);
            processor.setResolveContext(qualifierPsi);
            if (!qualifierSymbol.isValid()) continue;
            if (qualifierObject instanceof DasSynonym) {
                qualifierSymbol = DasSymbolUtil.wrapObjectToSymbol(qualifierObject = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)qualifierObject)), project);
                if (qualifierSymbol == null || !qualifierSymbol.isValid()) continue;
                qualifierPsi = DasSymbolUtil.getSinglePsiSource(qualifierSymbol);
            }
            if (qualifierSymbol instanceof DasScopeAware && !((DasScopeAware)qualifierSymbol).processDeclarations((DasScopeProcessor)processor, qualifiedState, null, place)) {
                return false;
            }
            if (qualifierObject instanceof DasTable) {
                if (!SqlImplUtil.processAlterStatements(processor, qualifiedState, place, qualifierObject)) {
                    return false;
                }
                PsiFile qualFile = qualifierPsi != null ? qualifierPsi.getContainingFile() : null;
                PsiFile placeFile = place.getContainingFile();
                if (!SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifierPsi, qualFile)) {
                    return false;
                }
                if (qualFile != null && qualFile != placeFile && !SqlImplUtil.processOnTableCreateStatements(processor, qualifiedState, qualifierPsi, placeFile)) {
                    return false;
                }
            }
            if ((schemaElement = (DbNamespace)ObjectUtils.tryCast((Object)qualifierObject, DbNamespace.class)) == null || schemaElement.getKind() != SqlDbElementType.SCHEMA || !majorChildExpected || SqlImplUtil.processSchemaMajorChildren(processor, (Processor<? super DbElement>)schemaElement.createDeclarationProcessor((DasScopeProcessor)processor, qualifiedState, null, place), (DbElement)schemaElement)) continue;
            return false;
        }
        return true;
    }

    public static boolean isMajorChildExpected(@Nullable SqlScopeProcessor processor) {
        if (processor == null) {
            return false;
        }
        Set expectedTypes = processor.getExpectedTypes();
        if (expectedTypes.contains(SqlDbElementType.ANY)) {
            return true;
        }
        for (ObjectKind type : expectedTypes) {
            if (!processor.getDialect().isMajorChild(type)) continue;
            return true;
        }
        return false;
    }

    private static boolean processOnTableCreateStatements(SqlScopeProcessor processor, ResolveState resolveState, PsiElement qualifier, PsiFile containingFile) {
        PsiFile psiFile = containingFile = containingFile == null ? null : containingFile.getOriginalFile();
        if (containingFile instanceof SqlFile) {
            for (SqlElement statement : ((SqlFile)containingFile).getDdl()) {
                SqlReferenceExpression ref;
                if (!(statement instanceof SqlTargetContextProvider) || !(statement instanceof SqlDefinition) || (ref = ((SqlTargetContextProvider)statement).getTargetContextExpression()) == null || !ref.getReference().isReferenceTo(qualifier) || processor.execute((DasSymbol)((SqlDefinition)statement), resolveState)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processAlterStatements(SqlScopeProcessor processor, ResolveState resolveState, PsiElement place, DasObject qualifier) {
        return SqlImplUtil.processAlterStatements(place.getContainingFile(), place, qualifier, (Processor<? super SqlAlterInstruction>)((Processor)instruction -> instruction.processDeclarations(processor, resolveState, null, place)));
    }

    public static boolean processAlterStatements(PsiFile file, PsiElement place, DasObject qualifierTarget, Processor<? super SqlAlterInstruction> processor) {
        if (!(file instanceof SqlFile)) {
            return true;
        }
        SqlFile original = (SqlFile)ObjectUtils.tryCast((Object)file.getOriginalFile(), SqlFile.class);
        if (original == null) {
            return true;
        }
        NameChecker checker = new NameChecker(qualifierTarget, original.getSqlLanguage());
        for (SqlElement ddl : original.getDdl()) {
            SqlReferenceExpression target;
            SqlAlterStatement statement = (SqlAlterStatement)ObjectUtils.tryCast((Object)ddl, SqlAlterStatement.class);
            if (statement == null || place != null && PsiTreeUtil.isContextAncestor((PsiElement)statement, (PsiElement)place, (boolean)false) || (target = statement.getAlterTargetReference()) == null || !checker.checkName((DasNamed)target, null) || !(qualifierTarget instanceof PsiElement) || !target.getReference().isReferenceTo((PsiElement)qualifierTarget) || ContainerUtil.process((Object[])statement.getAlterInstructions(), processor)) continue;
            return false;
        }
        return true;
    }

    public static boolean processPositionalDeclarationInType(SqlTableType tableType2, SqlScopeProcessor processor, ResolveState state, SqlPositionalReference place) {
        int position = place.getPosition();
        if (position < 1 || position > tableType2.getColumnCount()) {
            return false;
        }
        PsiElement columnImmediateSource = tableType2.getImmediateSourceColumnElement(position - 1);
        DasSymbol columnSourceSymbol = DasSymbolUtil.getSymbolByPsi(columnImmediateSource);
        if (columnSourceSymbol != null) {
            processor.execute(columnSourceSymbol, SqlImplUtil.setImmediateTarget(state, columnImmediateSource));
        }
        return false;
    }

    public static boolean processDeclarationsInType(SqlExpression expression, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            return true;
        }
        DasType t = DasTypeUtilsKt.unwrap((DasType)expression.getDasType());
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)t, SqlTableType.class);
        return type == null || SqlImplUtil.processDeclarationsInType(type, processor, state, place);
    }

    private static void processUnresolvedSymbol(SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        SqlReference reference = ((SqlReferenceExpression)place).getReference();
        DasSymbol unresolvedSymbol = DasSymbolUtil.getInlineSymbol(reference, true);
        processor.execute(unresolvedSymbol, state);
    }

    public static boolean processDeclarationsInType(SqlTableType tableType2, SqlScopeProcessor processor, ResolveState state, PsiElement place) {
        if (tableType2 instanceof SqlTableTypeBase.UnresolvedRefType && place instanceof SqlReferenceExpression && SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType2.getTypeElement());
            SqlImplUtil.processUnresolvedSymbol(processor, qualifiedState, place);
            return true;
        }
        Project project = place.getProject();
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.ROUTINE, SqlDbElementType.METHOD)) {
            ResolveState qualifiedState = SqlImplUtil.setQualifier(state, tableType2.getTypeElement());
            for (DasObject m : tableType2.getMethods()) {
                if (processor.execute(DasSymbolUtil.wrapObjectToSymbol(m, project), qualifiedState)) continue;
                return false;
            }
        }
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE, SqlDbElementType.OBJECT_ATTRIBUTE)) {
            return true;
        }
        if (SqlImplUtil.isAsteriskRef(place)) {
            SqlReferenceExpression asteriskRef = (SqlReferenceExpression)place;
            PsiElement immediateTypeElement = tableType2.getImmediateTypeElement();
            PsiElement context = immediateTypeElement != null ? immediateTypeElement : place;
            SqlAsteriskSymbol target = new SqlAsteriskSymbol(context, tableType2);
            return processor.execute(DasSymbolUtil.getInlineSymbol(asteriskRef.getReference()), SqlImplUtil.setImmediateTarget(state, (PsiElement)target));
        }
        if (place instanceof SqlPositionalReference) {
            return SqlImplUtil.processPositionalDeclarationInType(tableType2, processor, state, (SqlPositionalReference)place);
        }
        int columnCount = tableType2.getColumnCount();
        PsiElement prevQualifier = null;
        for (int i = 0; i < columnCount; ++i) {
            DasSymbol qualifierSymbol;
            ResolveResult[] results;
            PsiElement source;
            if (!tableType2.isResolvableColumn(i)) continue;
            PsiElement columnQualifier = tableType2.getColumnQualifier(i);
            PsiElement immediateSource = tableType2.getImmediateSourceColumnElement(i);
            ResolveState qualifiedState = SqlImplUtil.setImmediateTarget(SqlImplUtil.setQualifier(state, columnQualifier), immediateSource);
            processor.setResolveContext(columnQualifier);
            PsiElement element = tableType2.getColumnElement(i);
            PsiElement sourceElement = tableType2.getSourceColumnElement(i);
            PsiElement psiElement = source = element instanceof SqlDefinition || sourceElement == null ? element : sourceElement;
            if (source instanceof SqlParenthesizedExpression) {
                SqlParenthesizedExpression parenthesized = (SqlParenthesizedExpression)source;
                source = UtilsKt.deparenthesize((SqlExpression)parenthesized);
            }
            ResolveResult[] resolveResultArray = results = source instanceof SqlReferenceExpression ? ((SqlReferenceExpression)source).multiResolve(false) : ResolveResult.EMPTY_ARRAY;
            if (results.length > 0) {
                for (ResolveResult result : results) {
                    DasSymbol target = DasSymbolUtil.getSymbol(result);
                    if (target == null || processor.execute(target, qualifiedState)) continue;
                    return false;
                }
            } else {
                Object sourceSymbol = DasSymbolUtil.getSymbolByPsi(source);
                if (sourceSymbol == null) {
                    String columnName = tableType2.getColumnName(i);
                    if (columnName.isEmpty()) continue;
                    sourceSymbol = new DasVirtualColumnSymbol(columnName, tableType2.isColumnQuoted(i), source);
                }
                if (!processor.execute(sourceSymbol, qualifiedState)) {
                    return false;
                }
            }
            if (columnQualifier == null || columnQualifier == prevQualifier) continue;
            prevQualifier = columnQualifier;
            if ((processor instanceof SqlCompletionScopeProcessor && !SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !SqlImplUtil.isQualifiedContext(place)) && (qualifierSymbol = DasSymbolUtil.getSymbolByPsi(columnQualifier)) != null) {
                processor.execute(qualifierSymbol, state);
            }
            if (SqlImplUtil.hasAcceptedCompletionSuggestions(processor) || !(columnQualifier instanceof DasTable) || SqlImplUtil.processAlterStatements(processor, state, place, (DasObject)columnQualifier)) continue;
            return false;
        }
        return SqlImplUtil.getSqlDialectSafe(place).processTypeExtra(tableType2, processor, state, place);
    }

    private static boolean isQualifiedContext(@Nullable PsiElement place) {
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getQualifierExpression() != null;
    }

    private static boolean hasAcceptedCompletionSuggestions(@Nullable SqlScopeProcessor processor) {
        return processor instanceof SqlCompletionScopeProcessor && ((SqlCompletionScopeProcessor)processor).hasAcceptedCompletionVariants();
    }

    @Nullable
    public static PsiElement sqlParent(@Nullable PsiElement e) {
        PsiElement tmp;
        PsiElement psiElement = tmp = e == null ? null : SqlImplUtil.getStubOrPsiParent(e);
        while (tmp != null) {
            if (PsiUtilCore.getElementType((PsiElement)tmp) != SqlElementTypes.SQL_DUMMY_BLOCK) {
                return tmp;
            }
            tmp = SqlImplUtil.getStubOrPsiParent(tmp);
        }
        return null;
    }

    @NotNull
    public static CasingProvider getCasingProvider(@NotNull SqlLanguageDialectEx dialect, @NotNull Iterable<? extends DbDataSource> dataSources) {
        DbDataSource dataSource;
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(13);
        }
        if (dataSources == null) {
            SqlImplUtil.$$$reportNull$$$0(14);
        }
        DasModel model = (dataSource = (DbDataSource)Iterables.getFirst(dataSources, null)) == null ? DasUtil.emptyModel() : dataSource.getModel();
        SqlLanguageDialectEx sqlLanguageDialectEx = model == DasUtil.emptyModel() ? dialect : model;
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(15);
        }
        return sqlLanguageDialectEx;
    }

    @NotNull
    public static List<DbDataSource> getDataSources(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(16);
        }
        PsiFile file = element.getContainingFile();
        List<DbDataSource> list = SqlDataSourceMappings.getInstance(file.getProject()).getDataSources(file).stream().toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static int getParentTypes(@NotNull SqlLanguageDialect dialect, ObjectKind type, int minLevel, int maxLevel, @NotNull Set<ObjectKind> ignored, Set<? super ObjectKind> result) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(18);
        }
        if (ignored == null) {
            SqlImplUtil.$$$reportNull$$$0(19);
        }
        if (maxLevel > 0 && minLevel > maxLevel) {
            throw new IllegalArgumentException();
        }
        if (minLevel <= 0) {
            result.add((ObjectKind)type);
        }
        if (maxLevel == 0) {
            return 0;
        }
        LinkedList queue = new LinkedList();
        dialect.getParentDbTypes(queue, type);
        queue.removeAll(ignored);
        int curLevel = 0;
        int curSize = queue.size();
        LinkedHashSet<ObjectKind> levelSet = new LinkedHashSet<ObjectKind>();
        while (!queue.isEmpty()) {
            ObjectKind cur = (ObjectKind)queue.removeFirst();
            boolean isAdded = levelSet.add(cur);
            if (--curSize == 0) {
                if (minLevel <= ++curLevel && (maxLevel < 0 || curLevel <= maxLevel) && !result.addAll(levelSet)) break;
                levelSet.clear();
            }
            if (maxLevel > -1 && curLevel == maxLevel) break;
            if (isAdded) {
                dialect.getParentDbTypes(queue, cur);
            }
            if (curSize != 0) continue;
            curSize = queue.size();
        }
        return curLevel;
    }

    @NotNull
    public static SqlTableType createType(final String name, final @NotNull List<? extends Column> result, final @Nullable PsiElement qualifier, String vagueArg) {
        if (result == null) {
            SqlImplUtil.$$$reportNull$$$0(20);
        }
        final DataType dataType = DataTypeFactory.ofArgs(null, (String)"table", (String)vagueArg, (boolean)false);
        return result.isEmpty() ? SqlTableTypeBase.EMPTY_TABLE : new SqlTableTypeBase(){

            @NotNull
            public DataType toDataType() {
                DataType dataType2 = dataType;
                if (dataType2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                return dataType2;
            }

            @NotNull
            public List<DasObject> getMethods() {
                List<DasObject> list = Collections.emptyList();
                if (list == null) {
                    2.$$$reportNull$$$0(1);
                }
                return list;
            }

            @Override
            @Nullable
            public String getTypeName() {
                return name;
            }

            public int getColumnCount() {
                return result.size();
            }

            public String getColumnName(int i) {
                return ((Column)result.get((int)i)).name;
            }

            public boolean isColumnQuoted(int i) {
                Column column = (Column)result.get(i);
                Boolean quoted = 2.isQuoted(column.element);
                return quoted == null ? Boolean.TRUE.equals(2.isQuoted(column.sourceElement)) : quoted.booleanValue();
            }

            public DasType getColumnDasType(int i) {
                return ((Column)result.get((int)i)).dasType;
            }

            @Nullable
            public PsiElement getColumnQualifier(int i) {
                return qualifier;
            }

            @NotNull
            public PsiElement getColumnElement(int i) {
                PsiElement psiElement = ((Column)result.get((int)i)).element;
                if (psiElement == null) {
                    2.$$$reportNull$$$0(2);
                }
                return psiElement;
            }

            public PsiElement getSourceColumnElement(int i) {
                return ((Column)result.get((int)i)).sourceElement;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "toDataType";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMethods";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getColumnElement";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
    }

    @NotNull
    public static SqlTableType createType(@NotNull List<? extends Column> result, @Nullable PsiElement qualifier) {
        if (result == null) {
            SqlImplUtil.$$$reportNull$$$0(21);
        }
        return SqlImplUtil.createType(null, result, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name, @NotNull List<? extends Column> result, @Nullable PsiElement qualifier) {
        if (result == null) {
            SqlImplUtil.$$$reportNull$$$0(22);
        }
        return SqlImplUtil.createType(name, " ", result, qualifier);
    }

    @NotNull
    public static SqlTableType createType(String name, String typeSeparator, @NotNull List<? extends Column> result, @Nullable PsiElement qualifier) {
        if (result == null) {
            SqlImplUtil.$$$reportNull$$$0(23);
        }
        StringBuilder args = new StringBuilder();
        for (Column column : result) {
            if (!args.isEmpty()) {
                args.append(",");
            }
            if (column.name != null) {
                args.append(column.name).append(typeSeparator);
            }
            args.append(column.dasType.getSpecification());
        }
        return SqlImplUtil.createType(name, result, qualifier, args.toString());
    }

    @NotNull
    public static DasType getDasType(@NotNull SqlTypedDefinition definition, @NotNull SqlLanguageDialectEx dialect, @Nullable PsiElement place) {
        DasType type;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(24);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(25);
        }
        if ((type = definition.getDasType()) == DasTypeSystemBase.UNKNOWN || DasTypeUtilsKt.getCategory((DasType)type) == DasTypeCategory.RECORD) {
            DasType res = dialect.getTypeSystem().getDefinitionType(definition, place);
            DasType dasType = res == DasTypeSystemBase.UNKNOWN ? type : res;
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(26);
            }
            return dasType;
        }
        DasType dasType = type;
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(27);
        }
        return dasType;
    }

    @NotNull
    public static DasType getDasType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(28);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(29);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(30);
        }
        return SqlImplUtil.getDasType(object, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static DasType getDasType(@NotNull DasTypedObject object, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        DasType dasType;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(31);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(32);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(33);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(34);
        }
        if (object instanceof SqlTypedDefinition) {
            SqlTypedDefinition typedDef = (SqlTypedDefinition)object;
            DasType dasType2 = typedDef.getDasType();
            if (dasType2 == null) {
                SqlImplUtil.$$$reportNull$$$0(35);
            }
            return dasType2;
        }
        if (object instanceof DasUserDefinedType) {
            DasUserDefinedType typeDef = (DasUserDefinedType)object;
            dasType = typeDef.getSelfDasType();
        } else {
            dasType = object.getDasType();
        }
        DasType dasType3 = dasType;
        return SqlImplUtil.rebuildDasType(DasTypeUtilsKt.unwrap((DasType)dasType3, (boolean)true, (DasObject)object), dialect, holder, context, project);
    }

    @NotNull
    public static DasType getArrayElement(@NotNull DasType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(36);
        }
        DasType dasType = type instanceof DasArrayType ? ((DasArrayType)type).getComponentType() : type;
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(37);
        }
        return dasType;
    }

    @NotNull
    public static DasType getDasType(@NotNull DasUserDefinedType type, @NotNull PsiElement element, @NotNull SqlLanguageDialectEx dialect) {
        JBIterable children;
        List columns;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(38);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(39);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(40);
        }
        if (!(columns = (children = type.getDasChildren(null).filter(DasTypedObject.class)).filter(PsiObject.class).transform(e -> {
            DasType dasType = SqlImplUtil.getDasType((DasTypedObject)e, dialect, (PsiElement)e);
            return new Column(e.getName(), dasType, (PsiElement)e, (PsiElement)e);
        }).toList()).isEmpty()) {
            return SqlImplUtil.createType(columns, element);
        }
        DataType dataType = DataTypeFactory.ofArgs(null, (String)type.getName(), null, (boolean)true);
        DasType dasType = DasTypeFacade.resolve((DasType)dialect.getTypeSystem().createDasType(dataType), (DasObject)DbUtil.getDasObject((Object)type));
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(41);
        }
        return dasType;
    }

    @NotNull
    public static DasType rebuildDasType(@NotNull DasType dasType, @NotNull SqlLanguageDialectEx dialect, @NotNull PsiElement context) {
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(42);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(43);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(44);
        }
        return SqlImplUtil.rebuildDasType(dasType, dialect, (UserDataHolder)context, context, context.getProject());
    }

    @NotNull
    public static DasType rebuildDasType(@NotNull DasType dasType, @NotNull SqlLanguageDialectEx dialect, @NotNull UserDataHolder holder, @Nullable PsiElement context, @NotNull Project project) {
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(45);
        }
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(46);
        }
        if (holder == null) {
            SqlImplUtil.$$$reportNull$$$0(47);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(48);
        }
        if (!(dasType instanceof DasUnresolvedTypeReference || dasType instanceof DasDataBuiltinType && DasTypeUtilsKt.getCategoryOrUnknown((DasType)dasType) == DasTypeCategory.UNKNOWN)) {
            DasType dasType2 = dasType;
            if (dasType2 == null) {
                SqlImplUtil.$$$reportNull$$$0(49);
            }
            return dasType2;
        }
        DasType dasType3 = (DasType)((ConcurrentMap)CachedValuesManager.getManager((Project)project).getCachedValue(holder, () -> CachedValueProvider.Result.create((Object)ConcurrentFactoryMap.create(p2 -> SqlImplUtil.computeRebuiltDasType((DasType)p2.first, (SqlLanguageDialect)p2.second, context, project), ContainerUtil::createConcurrentSoftValueMap), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(Pair.create((Object)dasType, (Object)((Object)dialect)));
        if (dasType3 == null) {
            SqlImplUtil.$$$reportNull$$$0(50);
        }
        return dasType3;
    }

    @NotNull
    private static DasType computeRebuiltDasType(DasType dasType, SqlLanguageDialect language, @Nullable PsiElement context, @NotNull Project project) {
        SqlTypeElement unwrapped;
        SqlTypeElement type;
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(51);
        }
        if ((type = SqlPsiElementFactory.createDataTypeFromText(dasType.getSpecification(), language, project, context, true)) != null) {
            SqlReferenceImpl.IGNORE_DATA_SOURCES.set((UserDataHolder)type.getContainingFile(), (Object)true);
        }
        Object object = (unwrapped = type) == null ? DasTypeSystemBase.UNKNOWN : unwrapped.getDasType();
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(52);
        }
        return object;
    }

    @Nullable
    public static PsiElement getQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(53);
        }
        return (PsiElement)state.get(CURRENT_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(54);
        }
        return (PsiElement)state.get(IMMEDIATE_QUALIFIER);
    }

    @Nullable
    public static PsiElement getImmediateTarget(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(55);
        }
        return (PsiElement)state.get(IMMEDIATE_TARGET);
    }

    @Nullable
    public static SqlQueryExpression getLastQueryExpression(@NotNull ResolveState state) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(56);
        }
        return (SqlQueryExpression)state.get(LAST_QUERY_EXPRESSION);
    }

    @NotNull
    public static ResolveState setLastQueryExpression(@NotNull ResolveState state, @NotNull SqlQueryExpression queryExpression) {
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(57);
        }
        if (queryExpression == null) {
            SqlImplUtil.$$$reportNull$$$0(58);
        }
        return SqlImplUtil.getModifiedState(state, LAST_QUERY_EXPRESSION, queryExpression);
    }

    @Nullable
    public static PsiElement getQualifier(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateQualifier(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getImmediateQualifier() : null;
    }

    @Nullable
    public static PsiElement getImmediateTarget(@Nullable ResolveResult resolve) {
        return resolve instanceof SqlResolveResult ? ((SqlResolveResult)resolve).getImmediateTarget() : null;
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(59);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed(), false);
    }

    @NotNull
    private static JBIterable<PsiElement> getSiblingElements(@NotNull PsiElement e, SyntaxTraverser.ApiEx<PsiElement> api, boolean noDummy) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(60);
        }
        JBIterable parents = api.parents((Object)e).takeWhile(o -> o == e || api.typeOf(o) == SqlElementTypes.SQL_DUMMY_BLOCK);
        JBIterable roots = parents.flatten(p2 -> p2 == e ? api.siblings(p2) : api.siblings(p2).skip(1));
        SyntaxTraverser elements = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoots((Iterable)roots);
        elements = noDummy ? (SyntaxTraverser)elements.expandAndSkip(o -> api.typeOf(o) == SqlElementTypes.SQL_DUMMY_BLOCK) : (SyntaxTraverser)elements.expand(Conditions.alwaysFalse());
        JBIterable jBIterable = elements.traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(61);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> siblings(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(62);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApi(), false);
    }

    @NotNull
    public static JBIterable<PsiElement> revSiblingsNoDummy(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(63);
        }
        return SqlImplUtil.getSiblingElements(e, (SyntaxTraverser.ApiEx<PsiElement>)SyntaxTraverser.psiApiReversed(), true);
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlRevTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SyntaxTraverser.revPsiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)).withRoot((Object)element);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(64);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlRevChildren(@Nullable PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlRevTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(65);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildrenNoWS(@Nullable PsiElement element) {
        JBIterable jBIterable = SqlImplUtil.sqlChildren(element).filter(e -> !(e instanceof PsiWhiteSpace) && !(e instanceof PsiComment));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(66);
        }
        return jBIterable;
    }

    @NotNull
    public static Condition<PsiElement> byElementType(IElementType ... types) {
        if (types == null) {
            SqlImplUtil.$$$reportNull$$$0(67);
        }
        Condition condition = element -> ArrayUtil.contains((Object)element.getNode().getElementType(), (Object[])types);
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(68);
        }
        return condition;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlParents(@Nullable PsiElement e) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        JBIterable jBIterable = api.parents((Object)e).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.notEqualTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(69);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<SqlCompositeElement> sqlCompositeElements(@Nullable PsiElement root) {
        SyntaxTraverser s = SqlImplUtil.sqlTraverser(root).filterTypes(Conditions.notInstanceOf(SqlKeywordTokenType.class));
        JBIterable jBIterable = ((SyntaxTraverser)s.expand(Conditions.or((Condition)Conditions.is((Object)root), (Condition)Conditions.compose((Function)s.api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlCompositeElementTypes.SQL_BATCH_BLOCK))))).filter(SqlCompositeElement.class);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(70);
        }
        return jBIterable;
    }

    @Contract(value="null -> null")
    @Nullable
    public static SqlExpression skipParenthesizedExprDown(SqlExpression expression) {
        while (expression instanceof SqlParenthesizedExpression) {
            expression = ((SqlParenthesizedExpression)expression).getExpression();
        }
        return expression;
    }

    @Nullable
    public static IElementType getElementType(@Nullable PsiElement element) {
        ASTNode node = element == null ? null : element.getNode();
        return node == null ? null : node.getElementType();
    }

    @Nullable
    private static String getNameOrText(@Nullable PsiElement e, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(71);
        }
        if (e instanceof SqlNameElement) {
            SqlNameElement nameElement = (SqlNameElement)e;
            return nameElement.getName();
        }
        if (e instanceof DasObject) {
            DasObject obj = (DasObject)e;
            return obj.getName();
        }
        if (e != null) {
            Dbms dbms = dialect.getDbms();
            String text = e.getText();
            if (dbms.isSnowflake() || dbms.isH2()) {
                text = StringUtil.toUpperCase((String)text);
            } else if (dbms.isOracle()) {
                text = StringUtil.toUpperCase((String)text);
                text = StringFun.removeSpaces((String)text);
            }
            return text;
        }
        return null;
    }

    private static boolean hasResolvableColumnName(@Nullable PsiElement e, @NotNull SqlLanguageDialectEx dialect) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(72);
        }
        if (e == null) {
            return false;
        }
        if (e instanceof SqlNameElement || e instanceof DasObject) {
            return true;
        }
        Dbms dbms = dialect.getDbms();
        return !dbms.isDerby() && !dbms.isDb2() && !dbms.isBigQuery() && !dbms.isHsqldb() && !dbms.isTransactSql();
    }

    private static boolean shouldQuote(@Nullable PsiElement e) {
        if (e instanceof SqlNameElement) {
            SqlNameElement nameElement = (SqlNameElement)e;
            return nameElement.isQuotedIdentifier();
        }
        if (e instanceof SqlDefinition) {
            SqlDefinition definition = (SqlDefinition)e;
            return definition.isNameQuoted();
        }
        return true;
    }

    @Nullable
    public static SqlTableType convertToTableType(@NotNull DasType type, @NotNull PsiElement context) {
        DasType unwrapped;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(73);
        }
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(74);
        }
        if ((unwrapped = DasTypeUtilsKt.unwrapCollections((DasType)type)) instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)unwrapped;
            return tableType2;
        }
        if (unwrapped instanceof DasColumniationType) {
            DasColumniationType columniationType = (DasColumniationType)unwrapped;
            return new TableBasedSqlTableTypeImpl(context, columniationType.getColumnScope().getAllElements(), null);
        }
        if (unwrapped instanceof DasDefinedType) {
            PsiElement e;
            DasDefinedType definedType = (DasDefinedType)unwrapped;
            return SqlTableTypeBase.createObjectTypeType((DasObject)definedType.getTypeClass().getDefinition(), definedType instanceof PsiElement ? (e = (PsiElement)definedType) : context, context);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static SqlTableType getSelectType(@NotNull List<? extends SqlExpression> list, @Nullable PsiElement qualifier) {
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(75);
        }
        SqlTableType result = SqlTableTypeBase.EMPTY_TABLE;
        for (SqlExpression sqlExpression : list) {
            boolean flatten;
            void var4_4;
            SqlColumnAliasListImpl aliasList;
            if (sqlExpression instanceof SqlAsExpression && (aliasList = (SqlColumnAliasListImpl)PsiTreeUtil.getChildOfType((PsiElement)sqlExpression, SqlColumnAliasListImpl.class)) != null) {
                for (SqlDefinition alias : aliasList.getColumnAliasList()) {
                    DasType dasType = aliasList.getAliasedDasType(alias);
                    result = result.add(SqlTableTypeBase.ensureTableType(dasType, (PsiElement)alias, qualifier));
                }
                continue;
            }
            DasType dasType = sqlExpression.getDasType();
            String aliasName = null;
            SqlLanguageDialectEx dialect = SqlImplUtil.getSqlDialectSafe((PsiElement)sqlExpression);
            Dbms dbms = dialect.getDbms();
            if (dbms.isPostgres() || dbms.isVertica() || dbms.isHive()) {
                while (true) {
                    List args;
                    SqlFunctionCallExpression call;
                    BuiltinFunction builtin;
                    if (var4_4 instanceof SqlTypeCastExpression) {
                        SqlTypeCastExpression cast = (SqlTypeCastExpression)var4_4;
                        SqlExpression sqlExpression2 = cast.getExpression();
                        continue;
                    }
                    if (!(var4_4 instanceof SqlFunctionCallExpression) || (builtin = (call = (SqlFunctionCallExpression)var4_4).getFunctionDefinition()) == null || !builtin.getName().equalsIgnoreCase("cast")) break;
                    SqlExpressionList params = call.getParameterList();
                    List list2 = args = params == null ? null : params.getExpressionList();
                    if (ContainerUtil.isEmpty((Collection)args)) break;
                    SqlExpression sqlExpression3 = (SqlExpression)args.get(0);
                }
            }
            SqlExpression deparenthesized = UtilsKt.deparenthesize((SqlExpression)var4_4);
            String name = SqlImplUtil.getNameOrText((PsiElement)deparenthesized, dialect);
            boolean quoted = SqlImplUtil.shouldQuote((PsiElement)deparenthesized);
            if (var4_4 instanceof SqlReferenceExpression) {
                PsiElement columnQualifier = SqlImplUtil.getQualifier(((SqlReferenceExpression)var4_4).resolveSingle());
                aliasName = SqlImplUtil.getNameOrText(columnQualifier, dialect);
            }
            boolean bl = flatten = "*".equals(name) || list.size() == 1 && dbms == Dbms.EXASOL;
            if (flatten && dasType instanceof SqlTableType) {
                SqlTableType tableType2 = (SqlTableType)dasType;
                dasType = name == null ? dasType : tableType2.flattenedAlias(name, qualifier, (SqlElement)var4_4);
            } else {
                if (flatten && dasType == DasTypeSystemBase.UNKNOWN) continue;
                boolean isResolvable = SqlImplUtil.hasResolvableColumnName((PsiElement)deparenthesized, dialect);
                dasType = SqlTableTypeBase.createType((PsiElement)var4_4, dasType, name, quoted, false, isResolvable, qualifier, aliasName);
            }
            result = result.add(SqlTableTypeBase.ensureTableType(dasType, (PsiElement)var4_4, qualifier));
        }
        if (result != SqlTableTypeBase.EMPTY_TABLE) {
            result = result.alias(null, qualifier, Collections.emptyList());
        }
        SqlTableType sqlTableType = result;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(76);
        }
        return sqlTableType;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheLeftOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(77);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getPrevSibling(); psiElement != null; psiElement = psiElement.getPrevSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    public static boolean processFromReferences(SqlScopeProcessor processor, ResolveState state, SqlExpression fromExpression, PsiElement place, PsiElement lastParent) {
        DasType type;
        if (!SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN, SqlDbElementType.TABLE)) {
            return true;
        }
        DasType dasType = type = fromExpression == null ? null : SqlImplUtil.getTypeLateralAware(fromExpression, place);
        if (!(type instanceof SqlTableType)) {
            SqlImplUtil.processUnresolvedSymbol(processor, state, place);
            return true;
        }
        ResolveState newState = state;
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.COLUMN)) {
            newState = SqlImplUtil.setImmediateQualifier(newState, (PsiElement)fromExpression);
        }
        if (SqlImplUtil.isProcessingOneOf(processor, SqlDbElementType.TABLE)) {
            newState = SqlImplUtil.setImmediateTarget(newState, (PsiElement)fromExpression);
        }
        return SqlImplUtil.processDeclarationsInType((SqlTableType)type, processor, newState, place);
    }

    @NotNull
    public static DasType getTypeLateralAware(@NotNull SqlExpression expression, @Nullable PsiElement end) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(78);
        }
        Object object = expression instanceof SqlLateralAwareExpression ? ((SqlLateralAwareExpression)expression).getDasType(end) : (end != null && PsiTreeUtil.isContextAncestor((PsiElement)expression, (PsiElement)end, (boolean)false) ? SqlTableTypeBase.EMPTY_TABLE : DasTypeUtilsKt.unwrap((DasType)expression.getDasType()));
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(79);
        }
        return object;
    }

    public static List<PsiColumnWithSymbol> createColumnInfos(SqlTableDefinition tableInfo, SqlTableType tableType2) {
        int count = tableType2.getColumnCount();
        ArrayList<PsiColumnWithSymbol> result = new ArrayList<PsiColumnWithSymbol>(count);
        for (int i = 0; i < count; ++i) {
            result.add(new MyColumnInfo(tableInfo, i, tableType2));
        }
        return result;
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(80);
        }
        return SqlImplUtil.getSiblingToTheRightOfType(element, strict, null, classes);
    }

    @Nullable
    public static <T extends PsiElement> T getSiblingToTheRightOfType(@Nullable PsiElement element, boolean strict, @Nullable Condition<? super PsiElement> skip, Class<? extends T> ... classes) {
        if (classes == null) {
            SqlImplUtil.$$$reportNull$$$0(81);
        }
        if (element == null) {
            return null;
        }
        for (PsiElement psiElement = element.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment || psiElement instanceof PsiErrorElement || skip != null && skip.value((Object)psiElement)) continue;
            for (Class<T> clazz : classes) {
                if (!clazz.isInstance(psiElement)) continue;
                return (T)psiElement;
            }
            if (strict) break;
        }
        return null;
    }

    @NotNull
    public static List<Pair<PsiElement, PsiElement>> resolveQualified(@Nullable SqlReferenceExpression ref) {
        ResolveResult[] results;
        ResolveResult[] resolveResultArray = results = ref == null ? null : ref.multiResolve(false);
        if (results == null || results.length == 0) {
            List<Pair<PsiElement, PsiElement>> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(82);
            }
            return list;
        }
        ArrayList<Pair<PsiElement, PsiElement>> res = new ArrayList<Pair<PsiElement, PsiElement>>();
        for (ResolveResult result : results) {
            DasSymbol symbol = DasSymbolUtil.getSymbol(result);
            if (symbol instanceof DasInlineSymbol && ((DasInlineSymbol)symbol).isUnresolved()) continue;
            PsiElement qualifier = SqlImplUtil.getImmediateQualifier(result);
            if (qualifier instanceof SqlReferenceExpression) {
                qualifier = (PsiElement)ObjectUtils.notNull((Object)((SqlReferenceExpression)qualifier).resolve(), (Object)qualifier);
            }
            res.add((Pair<PsiElement, PsiElement>)Pair.create((Object)qualifier, (Object)result.getElement()));
        }
        ArrayList<Pair<PsiElement, PsiElement>> arrayList = res;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(83);
        }
        return arrayList;
    }

    public static boolean processObjectParents(@Nullable DasSymbol startSymbol, SqlScopeProcessor processor, ResolveState resolveState) {
        Project project = processor.getPlace().getProject();
        for (DasObject object = startSymbol != null ? startSymbol.getDasObject() : null; object != null; object = object.getDasParent()) {
            DasSymbol symbol = DasSymbolUtil.wrapObjectToSymbol(object, project);
            if (processor.execute(symbol, resolveState)) continue;
            return false;
        }
        return true;
    }

    public static PsiElement getBlockContentElement(@NotNull PsiElement block) {
        if (block == null) {
            SqlImplUtil.$$$reportNull$$$0(84);
        }
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (PsiElement)api.children((Object)block).filter(Conditions.compose((Function)api.TO_TYPE, (Condition)Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK))).first();
    }

    public static <T> T @NotNull [] toArray(@Nullable Collection<? extends T> c, @NotNull ArrayFactory<? extends T> factory) {
        if (factory == null) {
            SqlImplUtil.$$$reportNull$$$0(85);
        }
        Object[] objectArray = c != null ? c.toArray(factory.create(c.size())) : factory.create(0);
        if (objectArray == null) {
            SqlImplUtil.$$$reportNull$$$0(86);
        }
        return objectArray;
    }

    @Nullable
    public static Version getMinDbmsVersion(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(87);
        }
        Version minVersion = null;
        for (DbDataSource dataSource : SqlImplUtil.getDataSources(element)) {
            Version version = Version.parse((String)dataSource.getDatabaseVersion().version);
            if (version == null || minVersion != null && version.compareTo(minVersion) >= 0) continue;
            minVersion = version;
        }
        return minVersion;
    }

    @NotNull
    public static SqlLanguageDialectEx getSqlDialectSafe(@Nullable PsiElement element) {
        SqlLanguageDialectEx sqlLanguageDialectEx = (SqlLanguageDialectEx)((Object)ObjectUtils.notNull((Object)DbSqlUtilCore.getSqlDialect((PsiElement)element), (Object)((Object)SqlDialectImplUtilCore.getDefaultSqlDialect())));
        if (sqlLanguageDialectEx == null) {
            SqlImplUtil.$$$reportNull$$$0(88);
        }
        return sqlLanguageDialectEx;
    }

    public static void acceptChildren(SqlElement parent, SqlVisitor visitor2) {
        for (PsiElement element : SqlImplUtil.sqlChildren((PsiElement)parent)) {
            if (!(element instanceof SqlElement)) continue;
            ((SqlElement)element).accept(visitor2);
        }
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser() {
        SyntaxTraverser syntaxTraverser = SyntaxTraverser.psiTraverser().forceDisregardTypes(Conditions.equalTo((Object)SqlElementTypes.SQL_DUMMY_BLOCK));
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(89);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static SyntaxTraverser<PsiElement> sqlTraverser(PsiElement element) {
        SyntaxTraverser syntaxTraverser = (SyntaxTraverser)SqlImplUtil.sqlTraverser().withRoot((Object)element);
        if (syntaxTraverser == null) {
            SqlImplUtil.$$$reportNull$$$0(90);
        }
        return syntaxTraverser;
    }

    @NotNull
    public static JBIterable<PsiElement> sqlChildren(@Nullable PsiElement element) {
        JBIterable jBIterable = ((SyntaxTraverser)SqlImplUtil.sqlTraverser(element).expandAndSkip(Conditions.is((Object)element))).traverse();
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(91);
        }
        return jBIterable;
    }

    public static JBIterable<? extends PsiElement> childrenTreeIt(PsiElement element) {
        return SqlImplUtil.sqlChildren(element).filter(SqlCompositeElement.class);
    }

    public static JBIterable<? extends PsiElement> childrenStubIt(StubElement<?> element) {
        return JBIterable.from((Iterable)element.getChildrenStubs()).transform(STUB_TO_PSI);
    }

    public static JBIterable<? extends PsiElement> childrenIt(PsiElement element) {
        StubElement stub;
        Object object = element instanceof StubBasedPsiElementBase ? ((StubBasedPsiElementBase)element).getStub() : (stub = element instanceof PsiFileImpl ? ((PsiFileImpl)element).getStub() : null);
        if (stub != null) {
            return SqlImplUtil.childrenStubIt(stub);
        }
        return SqlImplUtil.childrenTreeIt(element);
    }

    public static boolean processDeclarationsDefault(SqlElement element, boolean processChildrenDeclarations, SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        return SqlImplUtil.processDeclarationsDefault(element, SqlImplUtil.childrenTreeIt((PsiElement)element), processChildrenDeclarations, processor, state, lastParent, place, !(element instanceof SqlExpression) && !(element instanceof SqlFromClause));
    }

    public static boolean processDeclarationsDefault(SqlElement element, JBIterable<? extends PsiElement> notableChildren, boolean processChildrenDeclarations, SqlScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place, boolean allowForwardReferences) {
        if (lastParent instanceof SqlWithClause || lastParent instanceof SqlOnTargetClauseImpl) {
            return true;
        }
        ObjectKind kind = element instanceof DasObject ? ((DasObject)element).getKind() : SqlDbElementType.NONE;
        boolean checkLastParent = kind != SqlDbElementType.PACKAGE && kind != SqlDbElementType.OBJECT_TYPE && kind != SqlDbElementType.BODY && !(element instanceof SqlAlterInstruction) && (!(element instanceof SqlProcedureDefinitionImpl) || !processor.getDialect().getDbms().isOracle());
        for (PsiElement psiElement : notableChildren) {
            PsiElement scope;
            if (checkLastParent && psiElement == lastParent) {
                if (allowForwardReferences) continue;
                break;
            }
            PsiElement psiElement2 = scope = psiElement instanceof SqlLocalDefinition ? ((SqlLocalDefinition)psiElement).getDefinitionScope() : null;
            if (scope != null && !PsiTreeUtil.isContextAncestor((PsiElement)scope, (PsiElement)place, (boolean)true) || psiElement instanceof SqlQueryExpression) continue;
            if (psiElement instanceof DasSymbol ? !processor.execute((DasSymbol)psiElement, state) : (psiElement instanceof SqlDeclareStatementImpl || processChildrenDeclarations && (!(psiElement instanceof SqlStatement) || psiElement instanceof SqlDefinitionHolder)) && psiElement instanceof DasScopeAware && !((DasScopeAware)psiElement).processDeclarations((DasScopeProcessor)processor, state, lastParent, place)) {
                return false;
            }
            if (!(psiElement instanceof SqlExtraDeclarationsProvider)) continue;
            ((SqlExtraDeclarationsProvider)psiElement).processExtraDeclarations(processor, state, lastParent, place);
        }
        if (element instanceof SqlImplicitDeclarationsProvider) {
            SqlImplicitDeclarationsProvider provider = (SqlImplicitDeclarationsProvider)element;
            if (lastParent != null && PsiTreeUtil.isContextAncestor((PsiElement)element, (PsiElement)lastParent, (boolean)true)) {
                processor.setResolveContext((PsiElement)element);
                boolean stopIfFound = processor.getReferenceName() != null && processor.isResultEmpty() && provider.stopProcessingIfFoundInImplicitContext();
                boolean resume = provider.processImplicitContextDeclarations(processor, state, lastParent, place);
                return resume &= !stopIfFound || processor.isResultEmpty();
            }
        }
        return true;
    }

    public static ObjectKind getBodyParentKind(@Nullable SqlDefinition o) {
        SqlNameElement nameElement = o != null ? o.getNameElement() : null;
        PsiElement lastChild = nameElement == null ? null : nameElement.getLastChild();
        return lastChild instanceof SqlReferenceExpression ? ((SqlReferenceExpression)lastChild).getReferenceElementType().getTargetKind() : SqlDbElementType.ANY;
    }

    @NotNull
    public static String getCasedPart(@Nullable SqlReferenceExpression tableRef, @NotNull ObjectKind kind) {
        if (kind == null) {
            SqlImplUtil.$$$reportNull$$$0(92);
        }
        if (tableRef == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(93);
            }
            return string;
        }
        ArrayList<Trinity<ObjectKind, Boolean, String>> parts = new ArrayList<Trinity<ObjectKind, Boolean, String>>();
        CasingProvider casingProvider = (CasingProvider)ObjectUtils.tryCast((Object)tableRef.getContainingFile(), SqlFile.class);
        if (casingProvider == null) {
            casingProvider = SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef).getDatabaseDialect();
        }
        SqlFileImpl.splitRef(SqlImplUtil.getSqlDialectSafe((PsiElement)tableRef), tableRef, parts);
        for (Trinity trinity : parts) {
            if (trinity.first != kind) continue;
            String string = casingProvider.getCasing(kind, null).choose((Boolean)trinity.second == false).apply((String)trinity.third);
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(94);
            }
            return string;
        }
        String string = DasUtil.NO_NAME;
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(95);
        }
        return string;
    }

    public static Dbms getSqlDialectDbms(@Nullable PsiElement element) {
        return SqlImplUtil.getSqlDialectSafe(element).getDbms();
    }

    static boolean processSchemaMajorChildren(SqlScopeProcessor processor, Processor<? super DbElement> wrapper, DbElement schemaElement) {
        if (DbImplUtilCore.isExpandable((DasObject)schemaElement, (TreePattern)DbImplUtilCore.getIntrospectionScope((DasDataSource)schemaElement.getDataSource()))) {
            Condition majorChildCondition = element -> processor.getDialect().isMajorChild(element.getKind());
            for (DbTable child : schemaElement.getDasChildren(SqlDbElementType.TABLE).filter(DbTable.class)) {
                if (ContainerUtil.process((Iterable)child.getDasChildren(null).filter(majorChildCondition), wrapper)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isProcessingOneOf(@NotNull SqlScopeProcessor processor, ObjectKind ... kinds) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(96);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(97);
        }
        for (ObjectKind kind : kinds) {
            if (kind != SqlDbElementType.ANY && !processor.mayAccept(kind)) continue;
            return true;
        }
        return false;
    }

    public static boolean isProcessingChildOf(@NotNull SqlScopeProcessor processor, @NotNull ObjectKind parent) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(98);
        }
        if (parent == null) {
            SqlImplUtil.$$$reportNull$$$0(99);
        }
        return parent == SqlDbElementType.ANY || processor.mayAcceptParent(parent);
    }

    public static boolean isAsteriskRef(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(100);
        }
        return SqlImplUtil.getAsterisk(element) != null;
    }

    @Nullable
    public static PsiElement getAsterisk(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(101);
        }
        if (!(element instanceof SqlReferenceExpression)) {
            return null;
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (PsiUtilCore.getElementType((PsiElement)child) != SqlCommonTokens.SQL_ASTERISK) continue;
            return child;
        }
        return null;
    }

    @Contract(value="null,null->null")
    public static String getPresentableName(@Nullable PsiElement element, @Nullable String emptyName) {
        String name = SqlImplUtil.getPresentableName(element);
        return StringUtil.isEmpty((String)name) ? emptyName : name;
    }

    @Nullable
    private static String getPresentableName(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        if (element instanceof SqlSelectStatement) {
            SqlTableExpression fromClause;
            SqlQueryExpression qe = ((SqlSelectStatement)element).getQueryExpression();
            SqlSelectClause selectClause = qe != null ? qe.getSelectClause() : null;
            SqlTableExpression sqlTableExpression = fromClause = qe != null ? qe.getTableExpression() : null;
            if (selectClause != null && fromClause != null) {
                return SqlImplUtil.trimLong(selectClause.getText(), 25) + " " + SqlImplUtil.trimLong(fromClause.getText(), 25);
            }
            return SqlImplUtil.fromText(element);
        }
        if (element instanceof SqlWithClause) {
            return PsiTreeUtil.firstChild((PsiElement)element).getText();
        }
        if (element instanceof DasRoutine) {
            SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe(element);
            DatabaseDialectEx dialect = sqlDialect.getDatabaseDialect();
            DdlBuilder builder = new DdlBuilder().applyCodeStyle(element.getProject(), (SqlLanguageDialect)sqlDialect).withDialect(dialect);
            if (element instanceof PsiNamedElement) {
                builder.plain(StringUtil.notNullize((String)((PsiNamedElement)element).getName()));
            }
            return dialect.sqlDefinePrototype(builder, (DasRoutine)element, false, true).getStatement();
        }
        if (element instanceof SqlDefinition) {
            String name;
            SqlDefinition definition = (SqlDefinition)element;
            SqlNameElement namedElement = definition.getNameElement();
            if (namedElement == null) {
                if (element instanceof DasConstraint) {
                    Object info = DbPresentationCore.multiRef((MultiRef)((DasConstraint)element).getColumnsRef());
                    if (((String)info).isEmpty()) {
                        SqlDefinition type = (SqlDefinition)PsiTreeUtil.findChildOfType((PsiElement)element, SqlDefinition.class);
                        return SqlImplUtil.getPresentableName((PsiElement)type);
                    }
                    if (element instanceof DasForeignKey) {
                        DasForeignKey key = (DasForeignKey)element;
                        info = (String)info + DbPresentationCore.arrowToColumns(null, (String)key.getRefTableName(), (MultiRef)key.getRefColumns());
                    }
                    return info;
                }
                if (element instanceof DasIndex) {
                    return DbPresentationCore.multiRef((MultiRef)((DasIndex)element).getColumnsRef());
                }
            }
            if (StringUtil.isEmptyOrSpaces((String)(name = SqlImplUtil.getPresentableName((PsiElement)namedElement)))) {
                return SqlImplUtil.fromText(element);
            }
            return name;
        }
        if (element instanceof SqlNameElement) {
            String s = ((SqlNameElement)element).getName();
            return StringUtil.isEmptyOrSpaces((String)s) ? SqlImplUtil.fromText(element) : s;
        }
        if (element instanceof DasObject) {
            return ((DasObject)element).getName();
        }
        if (element instanceof SqlBlockStatementImpl) {
            return "begin ... end";
        }
        return SqlImplUtil.fromText(element);
    }

    @NotNull
    private static String fromText(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(102);
        }
        return SqlImplUtil.trimLong(element.getText(), 50);
    }

    @NotNull
    private static String trimLong(String text, int limit) {
        if (limit == 0) {
            return "";
        }
        String trim = SqlImplUtil.removeDuplicateSpaces(text).trim();
        Object object = trim.length() > limit ? String.valueOf(trim.subSequence(0, (int)((double)limit * 0.9))) + "..." + String.valueOf(trim.subSequence((int)((double)trim.length() - (double)limit * 0.1), trim.length())) : trim;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(103);
        }
        return object;
    }

    @NotNull
    private static String removeDuplicateSpaces(@Nullable String text) {
        if (StringUtil.isEmptyOrSpaces((String)text)) {
            return "";
        }
        String string = SPACES.matcher(text).replaceAll(" ");
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(104);
        }
        return string;
    }

    @NotNull
    static List<SqlLabelDefinitionImpl> getLabels(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(105);
        }
        List list = (List)CachedValuesManager.getCachedValue((PsiElement)element, () -> CachedValueProvider.Result.create(SqlImplUtil.calcLabels(element), (Object[])new Object[]{element}));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(106);
        }
        return list;
    }

    @NotNull
    private static List<SqlLabelDefinitionImpl> calcLabels(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(107);
        }
        List list = SqlImplUtil.sqlTraverser(element).filter(SqlLabelDefinitionImpl.class).toList();
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(108);
        }
        return list;
    }

    @Nullable
    public static PsiElement getChildOfType(@Nullable PsiElement e, @Nullable IElementType type) {
        if (e == null || type == null) {
            return null;
        }
        PsiElement child = e.getFirstChild();
        return child == null ? null : PsiTreeUtil.findSiblingForward((PsiElement)child, (IElementType)type, (boolean)false, null);
    }

    public static short calcPosition(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(109);
        }
        short count = 1;
        for (PsiElement element : SqlImplUtil.childrenIt(SqlImplUtil.sqlParent((PsiElement)definition))) {
            if (element == definition) {
                return count;
            }
            count = (short)(count + 1);
        }
        return 0;
    }

    @Nullable
    public static PsiElement getStubOrPsiParent(@Nullable PsiElement e) {
        if (e == null) {
            return null;
        }
        StubElement stub = e instanceof StubBasedPsiElement ? ((StubBasedPsiElement)e).getStub() : null;
        StubElement parent = stub == null ? null : stub.getParentStub();
        return parent == null ? e.getParent() : parent.getPsi();
    }

    @Nullable
    public static PsiReference getReference(@NotNull PsiElement element, @Nullable SqlIdentifier nameElement) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(110);
        }
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)element);
        ref.setRangeInElement(TextRange.from((int)nameElement.getStartOffsetInParent(), (int)nameElement.getTextLength()));
        return ref;
    }

    @NotNull
    public static PsiReference getImmediateReference(@NotNull SqlIdentifier element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(111);
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)element, (PsiElement)element);
        ref.setRangeInElement(element.getNameRange());
        PsiReferenceBase psiReferenceBase = ref;
        if (psiReferenceBase == null) {
            SqlImplUtil.$$$reportNull$$$0(112);
        }
        return psiReferenceBase;
    }

    public static boolean forbidGlobalTablesResolve(PsiElement place) {
        SqlReferenceExpression ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)place, SqlReferenceExpression.class);
        if (ref == null) {
            return false;
        }
        if (SqlImplUtil.getSqlDialectSafe(place).allowGlobalTableResolve(place)) {
            return false;
        }
        if (ref.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN) {
            return true;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)ObjectUtils.tryCast((Object)ref.getParent(), SqlReferenceExpression.class);
        if (parentRef == null) {
            return false;
        }
        if (parentRef.getParent() instanceof SqlTypeElement) {
            return false;
        }
        return parentRef.getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    public static boolean ignoreKinds(@NotNull SqlScopeProcessor processor, @NotNull Set<ObjectKind> kinds) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(113);
        }
        if (kinds == null) {
            SqlImplUtil.$$$reportNull$$$0(114);
        }
        processor.addIgnoredKinds(kinds);
        return !processor.getExpectedTypes().isEmpty();
    }

    @Nullable
    public static VirtualFile getAnyRoot(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        ProjectFileIndex index;
        VirtualFile root;
        if (virtualFile == null) {
            SqlImplUtil.$$$reportNull$$$0(115);
        }
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(116);
        }
        if ((root = (index = ProjectFileIndex.getInstance((Project)project)).getContentRootForFile(virtualFile)) == null) {
            root = index.getClassRootForFile(virtualFile);
        }
        if (root == null) {
            root = index.getSourceRootForFile(virtualFile);
        }
        return root;
    }

    public static Dbms getDbms(@Nullable PsiElement element) {
        List<DbDataSource> dataSources;
        Dbms dbms;
        if (element instanceof DbElement) {
            return DbImplUtilCore.getDbms((DbElement)((DbElement)element));
        }
        DbDataSource dataSource = element == null ? null : DbImplUtilCore.getForcedDataSource((PsiFile)element.getContainingFile().getOriginalFile());
        Dbms dataSourceDbms = dataSource == null ? Dbms.UNKNOWN : dataSource.getDbms();
        Dbms dbms2 = dbms = dataSourceDbms != Dbms.UNKNOWN ? dataSourceDbms : SqlImplUtil.getSqlDialectDbms(element);
        if (dbms == Dbms.UNKNOWN && element != null && !(dataSources = SqlDataSourceMappings.getInstance(element.getContainingFile().getProject()).getProvidedDataSources(element.getContainingFile())).isEmpty()) {
            return dataSources.get(0).getDbms();
        }
        return dbms;
    }

    public static Dbms getDbms(@Nullable DasObject dasObject) {
        return dasObject instanceof PsiElement ? SqlImplUtil.getDbms((PsiElement)dasObject) : DbImplUtilCore.getDbms((DasObject)dasObject);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    @Nullable
    public static PsiElement wrapObjectToPsi(@Nullable DasObject object, @NotNull Project project) {
        if (project == null) {
            SqlImplUtil.$$$reportNull$$$0(117);
        }
        if (object == null) {
            return null;
        }
        if (object instanceof PsiElement) {
            return (PsiElement)object;
        }
        return new DasPsiWrappingSymbol(object, project);
    }

    @NotNull
    public static ObjectKind getKindSynonymAware(@Nullable DasObject obj) {
        if (obj instanceof SqlAsExpression) {
            SqlAsExpression alias = (SqlAsExpression)obj;
            DasType type = DasTypeUtilsKt.unwrap((DasType)alias.getDasType());
            if (type instanceof DasCollectionType || type instanceof DasMapType) {
                ObjectKind objectKind = SqlDbElementType.COLLECTION;
                if (objectKind == null) {
                    SqlImplUtil.$$$reportNull$$$0(118);
                }
                return objectKind;
            }
            boolean isTable = type instanceof SqlTableType;
            if (type == DasTypeSystemBase.UNKNOWN) {
                PsiElement parent = alias.getParent();
                isTable = parent instanceof SqlJoinExpression || parent instanceof SqlFromClause;
            }
            ObjectKind objectKind = isTable ? SqlDbElementType.TABLE : SqlDbElementType.COLUMN;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(119);
            }
            return objectKind;
        }
        if (obj instanceof DasSynonym) {
            DasSynonym synonym = (DasSynonym)obj;
            ObjectKind kind = synonym.getTargetObjectKind();
            if (kind != SqlDbElementType.ANY && kind != SqlDbElementType.NONE) {
                ObjectKind objectKind = kind;
                if (objectKind == null) {
                    SqlImplUtil.$$$reportNull$$$0(120);
                }
                return objectKind;
            }
            DasObject target = DasUtil.resolveFinalTarget((DasSynonym)synonym);
            ObjectKind objectKind = target != null ? target.getKind() : SqlDbElementType.ANY;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(121);
            }
            return objectKind;
        }
        ObjectKind objectKind = obj != null ? obj.getKind() : SqlDbElementType.ANY;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(122);
        }
        return objectKind;
    }

    public static PsiFile getTopLevelSqlFile(@NotNull PsiFile tmpFile) {
        PsiFile topLevelFile;
        boolean sql;
        PsiFile contextFile;
        if (tmpFile == null) {
            SqlImplUtil.$$$reportNull$$$0(123);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)tmpFile)) {
            PsiElement context = tmpFile.getContext();
            PsiFile contextFile2 = context == null ? null : context.getContainingFile();
            return contextFile2 == null ? tmpFile : contextFile2;
        }
        if (tmpFile.getContext() != null && SqlImplUtil.isSameSqlFileDialect(tmpFile, contextFile = tmpFile.getContext().getContainingFile())) {
            tmpFile = contextFile;
        }
        if (sql = SqlImplUtil.isSameSqlFileDialect(tmpFile, topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile))) {
            return topLevelFile;
        }
        return tmpFile;
    }

    private static boolean isSameSqlFileDialect(@NotNull PsiFile child, @Nullable PsiFile parent) {
        if (child == null) {
            SqlImplUtil.$$$reportNull$$$0(124);
        }
        SqlLanguageDialect fileDialect = parent instanceof SqlFile ? ((SqlFile)parent).getSqlLanguage() : null;
        return fileDialect != null && fileDialect.getClass().isInstance((Object)SqlImplUtil.getSqlDialectSafe((PsiElement)child));
    }

    @NotNull
    public static DasTypeSystem getTypeSystem(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(125);
        }
        DasTypeSystemBase dasTypeSystemBase = DasTypeSystems.getTypeSystem((Dbms)SqlImplUtil.getDbms(element));
        if (dasTypeSystemBase == null) {
            SqlImplUtil.$$$reportNull$$$0(126);
        }
        return dasTypeSystemBase;
    }

    @Nullable
    public static BasicMetaObject<?> getMetaObject(@Nullable DasObject object) {
        BasicMetaObject res = DbImplUtilCore.getMetaObject((DasObject)object);
        if (res != null) {
            return res;
        }
        DasObject unw = (DasObject)ObjectUtils.tryCast((Object)DbImplUtilCore.unwrap((DasObject)object), DasObject.class);
        if (unw == null) {
            return null;
        }
        if (unw instanceof SqlStubbedDefinitionImpl) {
            return ((SqlStubbedDefinitionImpl)unw).getMetaObject();
        }
        if (unw instanceof SqlExplicitTableExpression) {
            return null;
        }
        if (unw instanceof PsiElement) {
            ObjectKind kind;
            Dbms dbms = SqlImplUtil.getSqlDialectSafe((PsiElement)unw).getDbms();
            BasicMetaModel metaModel = DbImplUtilCore.getMetaModel((Dbms)dbms);
            ArrayList objects = ContainerUtil.newArrayList((Iterable)metaModel.findMetaObjects(kind = unw.getKind()));
            if (objects.size() <= 1) {
                return (BasicMetaObject)ContainerUtil.getFirstItem((List)objects);
            }
            BasicMetaObject<?> pMeta = SqlImplUtil.getMetaObject(unw.getDasParent());
            return BasicMetaUtils.findChild(pMeta, (ObjectKind)kind);
        }
        return null;
    }

    @Nullable
    public static DasType getScopingType(@NotNull PsiElement element) {
        SqlScopingExpression scopingExpression;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(127);
        }
        if ((scopingExpression = SqlImplUtil.getScopingExpression(element)) == null) {
            return null;
        }
        SqlTypeElement typeElement = scopingExpression.getTypeElement();
        if (typeElement == null) {
            return null;
        }
        return typeElement.getDasType();
    }

    @Nullable
    public static SqlScopingExpression getScopingExpression(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(128);
        }
        if ((parent = element.getParent()) instanceof SqlFunctionCallExpression) {
            parent = parent.getParent();
        }
        return parent instanceof SqlScopingExpression ? (SqlScopingExpression)parent : null;
    }

    @NotNull
    public static DasType getCacheableDasType(@NotNull PsiElement context, @NotNull Supplier<? extends DasType> computeType) {
        DasType dasType;
        if (context == null) {
            SqlImplUtil.$$$reportNull$$$0(129);
        }
        if (computeType == null) {
            SqlImplUtil.$$$reportNull$$$0(130);
        }
        Object object = (dasType = (DasType)CachedValuesManager.getCachedValue((PsiElement)context, () -> CachedValueProvider.Result.create((Object)((DasType)computeType.get()), SqlFileImpl.getMaximalDependencies(context)))) != null ? dasType : DasTypeSystemBase.UNKNOWN;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(131);
        }
        return object;
    }

    public static boolean hasLocationOf(@NotNull BuiltinFunction definition, @NotNull Set<BuiltinFunction.Location> locations) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(132);
        }
        if (locations == null) {
            SqlImplUtil.$$$reportNull$$$0(133);
        }
        for (BuiltinFunction.Prototype prototype : definition.getPrototypes()) {
            if (!locations.contains(prototype.getLocation())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getResolveScope(@Nullable PsiFile tmpFile) {
        if (tmpFile == null) {
            return null;
        }
        PsiFile file = SqlImplUtil.getTopLevelSqlFile(tmpFile);
        PsiElement context = file.getContext();
        return context instanceof DbElement ? ((DbElement)context).getDataSource() : file;
    }

    public static boolean treeWalkUp(@NotNull DasScopeProcessor processor, @NotNull PsiElement entrance, @Nullable PsiElement maxScope, @NotNull ResolveState initialState) {
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(134);
        }
        if (entrance == null) {
            SqlImplUtil.$$$reportNull$$$0(135);
        }
        if (initialState == null) {
            SqlImplUtil.$$$reportNull$$$0(136);
        }
        PsiElement prevParent = entrance;
        PsiElement scope = entrance;
        ResolveState state = initialState;
        while (scope != null) {
            if (prevParent instanceof SqlQueryExpression) {
                state = SqlImplUtil.setLastQueryExpression(state, (SqlQueryExpression)prevParent);
            }
            if (scope instanceof DasScopeAware && !((DasScopeAware)scope).processDeclarations(processor, state, prevParent, entrance)) {
                return false;
            }
            if (scope == maxScope) break;
            prevParent = scope;
            scope = prevParent.getContext();
        }
        return true;
    }

    @Nullable
    public static DasObject unwrapPsiToObject(@Nullable PsiElement element) {
        if (element instanceof DasObject) {
            return (DasObject)element;
        }
        if (element instanceof DasSymbol) {
            return ((DasSymbol)element).getDasObject();
        }
        return null;
    }

    public static boolean canResolveToPgFunctionColumn(@Nullable PsiElement expr) {
        SqlReferenceExpression qualifierRef;
        DasSymbol qualifierSymbol;
        if (!(expr instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlReferenceExpression refExpr = (SqlReferenceExpression)expr;
        SqlExpression qualifier = refExpr.getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        if (qualifier instanceof SqlReferenceExpression && ((qualifierSymbol = (qualifierRef = (SqlReferenceExpression)qualifier).resolveSymbol()) == null || qualifierSymbol.getDasObject() instanceof DasNamespace)) {
            return false;
        }
        if (expr.getParent() instanceof SqlFunctionCallExpression) {
            return false;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)expr, SqlSelectClause.class) != null;
    }

    public static boolean isHidden(@NotNull ResolveResult resolveResult) {
        SqlResolveResult sqlResolveResult;
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(137);
        }
        return resolveResult instanceof SqlResolveResult && (sqlResolveResult = (SqlResolveResult)resolveResult).isHidden();
    }

    public static JBIterable<ResolveResult> resolveVisible(SqlReferenceExpression expression) {
        return SqlImplUtil.resolveVisible((PsiPolyVariantReference)expression.getReference());
    }

    public static JBIterable<ResolveResult> resolveVisible(PsiPolyVariantReference reference) {
        JBIterable targets = JBIterable.of((Object[])reference.multiResolve(false));
        if (targets.single() != null) {
            return targets;
        }
        return targets.filter(r -> !(r instanceof SqlResolveResult) || !((SqlResolveResult)r).isHidden());
    }

    public static boolean isMarkedUnresolved(@NotNull SqlReferenceExpression expression) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(138);
        }
        for (ResolveResult result : expression.multiResolve(false)) {
            if (!SqlImplUtil.isMarkedUnresolved(result)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMarkedUnresolved(@NotNull ResolveResult resolveResult) {
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(139);
        }
        return DasSymbolUtil.isUnresolved(DasSymbolUtil.getSymbol(resolveResult));
    }

    @Nullable
    public static VirtualFile getTopLevelFile(@NotNull PsiFile file) {
        PsiFile tmpFile;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(140);
        }
        if (SqlPsiElementFactory.isROFile((PsiElement)(tmpFile = file))) {
            PsiElement context = tmpFile.getContext();
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)(context == null ? null : context.getContainingFile()), (Object)tmpFile);
        } else {
            PsiFile topLevelFile = InjectedLanguageManager.getInstance((Project)tmpFile.getProject()).getTopLevelFile((PsiElement)tmpFile);
            tmpFile = (PsiFile)ObjectUtils.notNull((Object)topLevelFile, (Object)tmpFile);
        }
        return tmpFile.getOriginalFile().getVirtualFile();
    }

    public static SqlTableType getTableTypeOfColumnList(@NotNull List<? extends SqlReferenceExpression> colList, @Nullable SqlExpression tableExpression) {
        PsiElement psiElement;
        if (colList == null) {
            SqlImplUtil.$$$reportNull$$$0(141);
        }
        if (colList.isEmpty()) {
            SqlTableType tableType2;
            DasType type = tableExpression == null ? null : SqlImplUtil.filterHiddenColumns(tableExpression.getDasType());
            return type instanceof SqlTableType ? (tableType2 = (SqlTableType)type) : SqlTableTypeBase.EMPTY_TABLE;
        }
        ArrayList<Column> columns = new ArrayList<Column>();
        for (SqlReferenceExpression sqlReferenceExpression : colList) {
            PsiElement element = sqlReferenceExpression.resolve();
            if (element instanceof SqlColumnDefinition) {
                SqlColumnDefinition column = (SqlColumnDefinition)element;
                columns.add(new Column(column.getName(), column.getDasType(), (PsiElement)sqlReferenceExpression, element));
                continue;
            }
            if (element instanceof DbColumn) {
                DbColumn column = (DbColumn)element;
                DasType dasType = SqlImplUtil.rebuildDasType(column.getDasType(), SqlImplUtil.getSqlDialectSafe(element), (PsiElement)tableExpression);
                columns.add(new Column(column.getName(), dasType, (PsiElement)sqlReferenceExpression, element));
                continue;
            }
            columns.add(new Column(sqlReferenceExpression.getName(), (DasType)DasTypeSystemBase.UNKNOWN, (PsiElement)sqlReferenceExpression, null));
        }
        PsiElement qualifier = null;
        if (tableExpression instanceof SqlReferenceExpression && (psiElement = ((SqlReferenceExpression)tableExpression).resolve()) instanceof SqlCreateTableStatement) {
            qualifier = psiElement;
        }
        return SqlImplUtil.createType(columns, qualifier);
    }

    @Nullable
    public static ObjectKind getIdentifierKind(@NotNull SqlIdentifier identifier) {
        PsiElement parent;
        if (identifier == null) {
            SqlImplUtil.$$$reportNull$$$0(142);
        }
        if ((parent = identifier.getParent()) instanceof SqlReferenceExpression) {
            SqlReferenceExpression refExpression = (SqlReferenceExpression)parent;
            PsiElement result = refExpression.resolve();
            if (result instanceof DasObject) {
                return ((DasObject)result).getKind();
            }
            return refExpression.getReferenceElementType().getTargetKind();
        }
        if (parent instanceof SqlColumnDefinition) {
            return SqlDbElementType.COLUMN;
        }
        if (parent instanceof SqlColumnAliasDefinitionImpl) {
            return SqlDbElementType.COLUMN_ALIAS;
        }
        if (parent instanceof SqlAsExpression) {
            return SqlDbElementType.LOCAL_ALIAS;
        }
        if (parent instanceof SqlDefinition) {
            return ((SqlDefinition)parent).getKind();
        }
        return null;
    }

    @NotNull
    public static <T extends DasTypedObject> List<T> processColumnList(@NotNull List<? extends T> tgt, @NotNull List<T> src, boolean caseSensitive, @Nullable PairFunction<? super T, ? super T, Boolean> check, boolean skip) {
        if (tgt == null) {
            SqlImplUtil.$$$reportNull$$$0(143);
        }
        if (src == null) {
            SqlImplUtil.$$$reportNull$$$0(144);
        }
        ArrayList<DasTypedObject> result = new ArrayList<DasTypedObject>(tgt.size());
        Map tgtMap = DasUtil.newCaseAwareMap((boolean)caseSensitive);
        for (DasTypedObject column : src) {
            tgtMap.put(column.getName(), column);
        }
        for (DasTypedObject column : tgt) {
            boolean matched;
            DasTypedObject old = (DasTypedObject)tgtMap.remove(column.getName());
            boolean bl = matched = old != null && (check == null || (Boolean)check.fun((Object)old, (Object)column) != false);
            if (matched && skip) continue;
            result.add(matched ? old : column);
        }
        ArrayList<DasTypedObject> arrayList = result;
        if (arrayList == null) {
            SqlImplUtil.$$$reportNull$$$0(145);
        }
        return arrayList;
    }

    @Nullable
    private static TrigEvent getEvent(IElementType e) {
        if (e == SqlCommonKeywords.SQL_SELECT) {
            return TrigEvent.SELECT;
        }
        if (e == SqlCommonKeywords.SQL_INSERT) {
            return TrigEvent.INSERT;
        }
        if (e == SqlCommonKeywords.SQL_UPDATE) {
            return TrigEvent.UPDATE;
        }
        if (e == SqlCommonKeywords.SQL_DELETE) {
            return TrigEvent.DELETE;
        }
        return null;
    }

    @Nullable
    private static TrigEvent getEvent(PsiElement element) {
        SyntaxTraverser.ApiEx api = SyntaxTraverser.psiApi();
        return (TrigEvent)api.children((Object)element).transform(api.TO_TYPE).transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).first();
    }

    @NotNull
    public static Set<TrigEvent> getTriggerEvents(@NotNull SqlElement element) {
        SyntaxTraverser.ApiEx api;
        JBIterable events;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(146);
        }
        if ((events = (api = SyntaxTraverser.psiApi()).children((Object)element).filter(e -> api.typeOf(e) == SqlCompositeElementTypes.SQL_TRIGGER_EVENT_CLAUSE)).isEmpty()) {
            Set<TrigEvent> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(147);
            }
            return set;
        }
        Set set = events.transform(e -> SqlImplUtil.getEvent(e)).filter(Conditions.notNull()).toSet();
        if (set == null) {
            SqlImplUtil.$$$reportNull$$$0(148);
        }
        return set;
    }

    @NotNull
    public static DasType getTupleType(@NotNull SqlExpressionList expressionList, boolean forceTable) {
        if (expressionList == null) {
            SqlImplUtil.$$$reportNull$$$0(149);
        }
        return SqlImplUtil.getTupleType(expressionList.getExpressionList(), (PsiElement)expressionList, SqlImplUtil.getSqlDialectSafe((PsiElement)expressionList).getDbms(), forceTable);
    }

    @NotNull
    public static DasType getTupleType(@NotNull List<SqlExpression> expressions, @Nullable PsiElement expressionList, @NotNull Dbms dbms, boolean forceTable) {
        boolean tableTypeExpected;
        if (expressions == null) {
            SqlImplUtil.$$$reportNull$$$0(150);
        }
        if (dbms == null) {
            SqlImplUtil.$$$reportNull$$$0(151);
        }
        if (!(tableTypeExpected = forceTable) && expressionList != null) {
            IElementType startType = PsiUtilCore.getElementType((PsiElement)expressionList.getFirstChild());
            boolean bl = tableTypeExpected = expressionList.getParent() instanceof SqlValuesExpression || startType == SqlCommonKeywords.SQL_ROW || dbms.isBigQuery() && startType == SqlCommonKeywords.SQL_STRUCT;
        }
        if (expressions.isEmpty()) {
            Object object = tableTypeExpected ? SqlTableTypeBase.EMPTY_TABLE : DasTypeSystemBase.UNKNOWN;
            if (object == null) {
                SqlImplUtil.$$$reportNull$$$0(152);
            }
            return object;
        }
        if (expressions.size() == 1 && !tableTypeExpected) {
            DasType dasType = expressions.get(0).getDasType();
            if (dasType == null) {
                SqlImplUtil.$$$reportNull$$$0(153);
            }
            return dasType;
        }
        return new ValuesTableType(expressionList, expressions, dbms);
    }

    @NotNull
    public static DasType filterHiddenColumns(@NotNull DasType type) {
        DasType dasType;
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(154);
        }
        if (type instanceof SqlTableType) {
            SqlTableType tableType2 = (SqlTableType)type;
            dasType = SqlImplUtil.filterHiddenColumns(tableType2);
        } else {
            dasType = type;
        }
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(155);
        }
        return dasType;
    }

    @NotNull
    public static SqlTableType filterHiddenColumns(@NotNull SqlTableType type) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(156);
        }
        SqlTableType result = type;
        for (int i = type.getColumnCount() - 1; i >= 0; --i) {
            PsiElement source = type.getSourceColumnElement(i);
            if (!(source instanceof DasHideableObject) || !((DasHideableObject)source).isHidden()) continue;
            result = result.subtract(i);
        }
        SqlTableType sqlTableType = result;
        if (sqlTableType == null) {
            SqlImplUtil.$$$reportNull$$$0(157);
        }
        return sqlTableType;
    }

    @NotNull
    public static JBIterable<Version> getDbVersions(@NotNull SqlFile file) {
        DbDataSource ds;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(158);
        }
        if ((ds = DbImplUtilCore.getForcedDataSource((PsiFile)file)) != null) {
            JBIterable jBIterable = JBIterable.of((Object)ds.getVersion());
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(159);
            }
            return jBIterable;
        }
        JBIterable jBIterable = JBIterable.from(SqlImplUtil.getDataSources((PsiElement)file)).filterMap(DasDataSource::getVersion);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(160);
        }
        return jBIterable;
    }

    @Nullable
    public static PsiElement getTargetByIdElement(PsiElement o, boolean forceResolved) {
        PsiElement candidate;
        PsiElement parent = o.getParent();
        if (parent instanceof SqlDefinition && ((SqlDefinition)parent).getNameElement() == o) {
            candidate = parent;
        } else if (parent instanceof SqlReferenceExpression) {
            PsiElement target = ((SqlReferenceExpression)parent).resolve();
            candidate = forceResolved || target != null ? target : parent;
        } else {
            candidate = null;
        }
        return SqlImplUtil.getTargetElement(candidate);
    }

    public static PsiElement getTargetElement(PsiElement candidate) {
        DasObject result;
        if (candidate instanceof DasSynonym && ((DasSynonym)candidate).getKind() == SqlDbElementType.SYNONYM && ((result = DasUtil.resolveFinalTarget((DasSynonym)((DasSynonym)candidate))) == null || result instanceof PsiElement)) {
            return (PsiElement)result;
        }
        return candidate;
    }

    public static void quoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        String newName;
        PsiElement target = SqlImplUtil.getTargetByIdElement((PsiElement)identifier, true);
        if (target instanceof DbElement) {
            DbElement dbTarget = (DbElement)target;
            newName = dbTarget.getName();
        } else {
            newName = identifier.getName();
            if (target instanceof DasObject) {
                DasObject dasTarget = (DasObject)target;
                if (dialect instanceof SqlLanguageDialectEx) {
                    newName = dialect.getCasing((ObjectKind)dasTarget.getKind(), (DasObject)dasTarget).plain.apply(newName);
                }
            }
        }
        NamingService namingService = NamingServices.getNamingService((Dbms)SqlImplUtil.getDbms((PsiElement)identifier));
        String quotedName = namingService.enquote(newName, SqlImplUtil.getIdentifierKind(identifier));
        identifier.setName(quotedName);
    }

    public static void unquoteIdentifier(Project project, SqlIdentifier identifier, SqlLanguageDialect dialect) {
        SqlIdentifier newId = SqlPsiElementFactory.createIdentifierFromText(identifier.getName(), dialect, project);
        if (newId != null) {
            identifier.replace((PsiElement)newId);
        }
    }

    public static boolean canUnquote(@NotNull String newText, @Nullable ObjectKind kind, @NotNull NamingService namingService) {
        if (newText == null) {
            SqlImplUtil.$$$reportNull$$$0(161);
        }
        if (namingService == null) {
            SqlImplUtil.$$$reportNull$$$0(162);
        }
        return StringUtil.equals((CharSequence)namingService.catToScript(newText, kind), (CharSequence)newText);
    }

    @NotNull
    public static ObjectKind getQualifierKind(@NotNull PsiElement element) {
        PsiElement target;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(163);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        PsiElement psiElement = target = qualifier instanceof SqlReferenceExpression ? ((SqlReferenceExpression)qualifier).resolve() : null;
        if (qualifier == null && PsiTreeUtil.getParentOfType((PsiElement)element, SqlQueryClause.class) != null) {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                SqlImplUtil.$$$reportNull$$$0(164);
            }
            return objectKind;
        }
        ObjectKind objectKind = target instanceof DasObject ? SqlImplUtil.getKindSynonymAware((DasObject)target) : SqlDbElementType.NONE;
        if (objectKind == null) {
            SqlImplUtil.$$$reportNull$$$0(165);
        }
        return objectKind;
    }

    @NotNull
    public static DasType getQualifierDasType(@NotNull PsiElement element) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(166);
        }
        SqlExpression qualifier = element instanceof SqlReferenceExpression ? ((SqlReferenceExpression)element).getQualifierExpression() : null;
        DasType dasType = DasTypeUtilsKt.unwrap((DasType)(qualifier != null ? qualifier.getDasType() : DasTypeSystemBase.UNKNOWN), (boolean)true);
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(167);
        }
        return dasType;
    }

    public static boolean isAutoVal(@NotNull SqlColumnDefinition col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(168);
        }
        return SqlImplUtil.getSqlDialectSafe((PsiElement)col).isAutoIncrementColumn((DasColumn)col);
    }

    public static boolean isAutoVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(169);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isAutoVal((SqlColumnDefinition)col) : DasUtil.isAutoGenerated((DasColumn)col);
    }

    public static boolean isComputedVal(@NotNull SqlColumnDefinition col) {
        SqlColumnStub stub;
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(170);
        }
        SqlColumnStub sqlColumnStub = stub = col instanceof SqlColumnDefinitionImpl ? (SqlColumnStub)((SqlColumnDefinitionImpl)col).getGreenStub() : null;
        if (stub != null) {
            BasicTableOrViewColumn tc = (BasicTableOrViewColumn)ObjectUtils.tryCast((Object)stub.getElement(), BasicTableOrViewColumn.class);
            return tc != null && tc.isComputed();
        }
        ASTNode node = col.getNode();
        return node != null && node.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COLUMN_GENERATED_CLAUSE) != null;
    }

    public static boolean isComputedVal(@NotNull DasColumn col) {
        if (col == null) {
            SqlImplUtil.$$$reportNull$$$0(171);
        }
        return col instanceof SqlColumnDefinition ? SqlImplUtil.isComputedVal((SqlColumnDefinition)col) : DasUtil.isComputed((DasColumn)col);
    }

    @NotNull
    public static JBIterable<SqlStatement> iterateStatementsBackward(@NotNull PsiFile file, int offset) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(172);
        }
        JBIterable jBIterable = ((SyntaxTraverser)((SyntaxTraverser)SyntaxTraverser.revPsiTraverser().withRoot((Object)file)).expand(element -> element.getTextRange().getStartOffset() < offset && (!(element instanceof SqlStatement) || element.getTextRange().getEndOffset() >= offset))).postOrderDfsTraversal().filter(SqlStatement.class).filter(stmt -> stmt.getTextRange().getEndOffset() <= offset);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(173);
        }
        return jBIterable;
    }

    public static <T extends DasTypedObject> void mergeColumnListInto(@NotNull List<T> a, @NotNull List<T> b, boolean caseSensitive, @Nullable PairFunction<? super T, ? super T, Boolean> mergeCheck) {
        if (a == null) {
            SqlImplUtil.$$$reportNull$$$0(174);
        }
        if (b == null) {
            SqlImplUtil.$$$reportNull$$$0(175);
        }
        a.addAll(SqlImplUtil.processColumnList(b, a, caseSensitive, mergeCheck, true));
    }

    public static boolean hasSameTypes(@Nullable PsiColumn a, @Nullable PsiColumn b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.getDasType().toDataType().equals(b.getDasType().toDataType());
    }

    public static boolean equalsInsensitiveOrTrue(@Nullable String a, @Nullable String b, boolean compare) {
        return !compare || Comparing.strEqual((String)a, (String)b, (boolean)false);
    }

    public static PsiElement @NotNull [] getRelatedElements(@NotNull SqlDefinition definition) {
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(176);
        }
        PsiElement[] psiElementArray = (PsiElement[])CachedValuesManager.getCachedValue((PsiElement)definition, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcRelatedElements(definition), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (psiElementArray == null) {
            SqlImplUtil.$$$reportNull$$$0(177);
        }
        return psiElementArray;
    }

    private static PsiElement @NotNull [] calcRelatedElements(@NotNull SqlDefinition definition) {
        SqlReferenceExpression ref;
        if (definition == null) {
            SqlImplUtil.$$$reportNull$$$0(178);
        }
        if ((ref = (SqlReferenceExpression)ObjectUtils.tryCast((Object)definition.getNameElement(), SqlReferenceExpression.class)) == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(179);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        SqlReferenceExpression newRef = SqlPsiElementFactory.createReferenceFromText(ref.getText(), SqlImplUtil.getSqlDialectSafe((PsiElement)definition), ref.getReferenceElementType(), (PsiElement)definition);
        if (newRef == null) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(180);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        ResolveResult[] results = newRef.multiResolve(false);
        if (results.length == 0) {
            if (PsiElement.EMPTY_ARRAY == null) {
                SqlImplUtil.$$$reportNull$$$0(181);
            }
            return PsiElement.EMPTY_ARRAY;
        }
        PsiElement[] related = new PsiElement[results.length];
        for (int i = 0; i < results.length; ++i) {
            related[i] = results[i].getElement();
        }
        if (related == null) {
            SqlImplUtil.$$$reportNull$$$0(182);
        }
        return related;
    }

    public static boolean isBodyLazyBlock(@Nullable PsiElement e) {
        return e instanceof LazyParseablePsiElement && !(e instanceof SqlLazyParseablePsiElement) || e instanceof SqlCodeBlockElement;
    }

    @NotNull
    private static IntRange indicesOfImmediateSource(@NotNull SqlTableType type, @NotNull PsiElement source) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(183);
        }
        if (source == null) {
            SqlImplUtil.$$$reportNull$$$0(184);
        }
        int columnCount = type.getColumnCount();
        int from = -1;
        int to = columnCount;
        for (int i = 0; i < columnCount; ++i) {
            boolean isMatched;
            PsiElement actualSource = type.getImmediateSourceColumnElement(i);
            while (actualSource instanceof SqlImplicitTarget) {
                actualSource = ((SqlImplicitTarget)actualSource).getContextElement();
            }
            boolean bl = isMatched = actualSource == source || source instanceof SqlReferenceExpression && actualSource == ((SqlReferenceExpression)source).resolve();
            if (isMatched && from < 0) {
                from = i;
                continue;
            }
            if (isMatched || from < 0) continue;
            to = i;
            break;
        }
        return new IntRange(from, to - 1);
    }

    private static boolean inColumnProvidingContext(@NotNull SqlQueryExpression query) {
        if (query == null) {
            SqlImplUtil.$$$reportNull$$$0(185);
        }
        for (PsiElement parent : SqlImplUtil.sqlParents((PsiElement)query)) {
            if (parent instanceof SqlResultSetExpression || parent instanceof SqlClause && parent.getParent() instanceof SqlCreateViewStatement) continue;
            if (parent instanceof SqlInsertDmlInstruction) {
                return true;
            }
            if (!(parent instanceof SqlCreateViewStatement) || ((SqlCreateViewStatement)parent).getColumnAliases().length <= 0) break;
            return true;
        }
        return false;
    }

    @Nullable
    private static SqlExpression getSelectExpression(@NotNull SqlSelectClause selectClause, @NotNull PsiElement element) {
        if (selectClause == null) {
            SqlImplUtil.$$$reportNull$$$0(186);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(187);
        }
        for (SqlExpression expression : selectClause.getExpressions()) {
            if (!expression.getTextRange().contains(element.getTextRange().getStartOffset())) continue;
            return expression;
        }
        return null;
    }

    @Nullable
    private static SqlElement getResultSetExpressionList(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        SqlExpressionList list = SqlValuesParameterInfoUtils.findExpressions(element);
        if (list != null) {
            return list;
        }
        SqlSelectClause selectClause = (SqlSelectClause)PsiTreeUtil.getParentOfType((PsiElement)element, SqlSelectClause.class);
        if (selectClause != null) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)selectClause, SqlQueryExpression.class);
            return query != null && SqlImplUtil.inColumnProvidingContext(query) ? selectClause : null;
        }
        return null;
    }

    @Nullable
    public static IntRange getImmediateColumnSourceIndices(@Nullable PsiElement element, @Nullable SqlElement anExpressionList, boolean strict) {
        SqlElement expressionList;
        if (element == null) {
            return null;
        }
        SqlElement sqlElement = expressionList = anExpressionList != null ? anExpressionList : SqlImplUtil.getResultSetExpressionList(element);
        if (strict && element.getParent() != expressionList) {
            return null;
        }
        if (expressionList instanceof SqlExpressionList) {
            int index = SqlValuesParameterInfoUtils.getCurrentParameterIndex((SqlExpressionList)expressionList, element.getTextRange().getStartOffset());
            return index >= 0 ? new IntRange(index, index) : null;
        }
        if (expressionList instanceof SqlSelectClause) {
            SqlQueryExpression query = (SqlQueryExpression)PsiTreeUtil.getParentOfType((PsiElement)expressionList, SqlQueryExpression.class);
            if (query == null) {
                return null;
            }
            DasType type = query.getDasType();
            if (!(type instanceof SqlTableType)) {
                return null;
            }
            SqlTableType tableType2 = (SqlTableType)type;
            SqlExpression expression = SqlImplUtil.getSelectExpression((SqlSelectClause)expressionList, element);
            if (expression == null) {
                return null;
            }
            IntRange indices = SqlImplUtil.indicesOfImmediateSource(tableType2, (PsiElement)expression);
            return indices.getStart() >= 0 ? indices : null;
        }
        return null;
    }

    @NotNull
    public static JBIterable<? extends DasObject> unwrapFake(@Nullable DasObject obj) {
        JBIterable<SqlDefinition> jBIterable = obj instanceof SqlFileImpl.GroupImpl ? ((SqlFileImpl.GroupImpl)obj).delegates() : JBIterable.of((Object)obj);
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(188);
        }
        return jBIterable;
    }

    public static boolean isColumnQualifier(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(189);
        }
        return SqlImplUtil.isQualifier(place, SqlDbElementType.COLUMN);
    }

    public static boolean isQualifier(@NotNull PsiElement place, @NotNull ObjectKind qualifiedKind) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(190);
        }
        if (qualifiedKind == null) {
            SqlImplUtil.$$$reportNull$$$0(191);
        }
        if (!(place instanceof SqlReferenceExpression)) {
            return false;
        }
        PsiElement parent = place.getParent();
        if (!(parent instanceof SqlReferenceExpression)) {
            return false;
        }
        SqlReferenceExpression parentRef = (SqlReferenceExpression)parent;
        return parentRef.getQualifierExpression() == place && parentRef.getReferenceElementType().getTargetKind() == qualifiedKind;
    }

    @Nullable
    public static SqlExpression getQualifier(@NotNull PsiElement element) {
        SqlExpression sqlExpression;
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(192);
        }
        if (element instanceof SqlReferenceExpression) {
            SqlReferenceExpression re = (SqlReferenceExpression)element;
            sqlExpression = re.getQualifierExpression();
        } else {
            sqlExpression = null;
        }
        return sqlExpression;
    }

    public static boolean isColumnReference(@NotNull PsiElement place) {
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(193);
        }
        return place instanceof SqlReferenceExpression && ((SqlReferenceExpression)place).getReferenceElementType().getTargetKind() == SqlDbElementType.COLUMN;
    }

    @NotNull
    public static JBIterable<? extends DasObject> getSiblingObjects(@NotNull SqlDefinition anchor, @NotNull Class<? extends SqlDefinition> targetClass) {
        if (anchor == null) {
            SqlImplUtil.$$$reportNull$$$0(194);
        }
        if (targetClass == null) {
            SqlImplUtil.$$$reportNull$$$0(195);
        }
        JBIterable jBIterable = SqlImplUtil.sqlChildren(SqlImplUtil.sqlParent((PsiElement)anchor)).filter(targetClass).filter(DbSqlUtilCore.byName((DasObject)anchor, null, (CasingProvider)DbImplUtilCore.getCasingProvider((DasObject)anchor)));
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(196);
        }
        return jBIterable;
    }

    @NotNull
    public static DasType getObjectColumnDasType(@NotNull SqlLanguageDialectEx dialect, @NotNull DasColumn column, JBIterable<DasColumn> children) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(197);
        }
        if (column == null) {
            SqlImplUtil.$$$reportNull$$$0(198);
        }
        ProgressManager.checkCanceled();
        if (!children.isEmpty()) {
            PsiElement resolved = DbSqlUtilCore.getPsiDelegate((DasObject)column);
            return SqlImplUtil.createTableTypeWithColumns(dialect, children, resolved, (DasSymbol)column);
        }
        DasType dasType = column.getDasType();
        if (dasType == null) {
            SqlImplUtil.$$$reportNull$$$0(199);
        }
        return dasType;
    }

    @NotNull
    public static SqlTableType createTableTypeWithColumns(@NotNull SqlLanguageDialectEx dialect, @NotNull JBIterable<DasColumn> dasColumns, @Nullable PsiElement resolved, @NotNull DasSymbol symbol) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(200);
        }
        if (dasColumns == null) {
            SqlImplUtil.$$$reportNull$$$0(201);
        }
        if (symbol == null) {
            SqlImplUtil.$$$reportNull$$$0(202);
        }
        ProgressManager.checkCanceled();
        String prefix = symbol.getKind() == SqlDbElementType.COLUMN ? symbol.getName() + "." : "";
        ArrayList<Column> columns = new ArrayList<Column>();
        List sortedColumns = dasColumns.sort(Comparator.comparing(DasNamed::getName)).toList();
        for (int i = 0; i < sortedColumns.size(); ++i) {
            DasColumn current = (DasColumn)sortedColumns.get(i);
            ArrayList<DasColumn> children = new ArrayList<DasColumn>();
            String currentName = current.getName();
            while (i + 1 < sortedColumns.size() && ((DasColumn)sortedColumns.get(i + 1)).getName().startsWith(currentName + ".")) {
                children.add((DasColumn)sortedColumns.get(i + 1));
                ++i;
            }
            DasType dasType = SqlImplUtil.getObjectColumnDasType(dialect, current, (JBIterable<DasColumn>)JBIterable.from(children));
            columns.add(new Column(currentName.substring(prefix.length()), dasType, (PsiElement)((DbColumn)current), (PsiElement)((DbColumn)current)));
        }
        return SqlImplUtil.createType(null, ":", columns, resolved);
    }

    @Nullable
    private static PsiElement getPossiblyInjectedElement(@NotNull PsiFile file, int offset) {
        PsiElement result;
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(203);
        }
        if ((result = InjectedLanguageManager.getInstance((Project)file.getProject()).findInjectedElementAt(file, offset)) == null) {
            result = file.findElementAt(offset);
        }
        return result;
    }

    @Nullable
    public static <T extends PsiElement> T getElementBySelection(@NotNull PsiFile file, int start, int end, @NotNull Class<T> elementClass) {
        if (file == null) {
            SqlImplUtil.$$$reportNull$$$0(204);
        }
        if (elementClass == null) {
            SqlImplUtil.$$$reportNull$$$0(205);
        }
        PsiElement element1 = SqlImplUtil.getPossiblyInjectedElement(file, start);
        PsiElement element2 = SqlImplUtil.getPossiblyInjectedElement(file, end - 1);
        if (element1 instanceof PsiWhiteSpace) {
            element1 = file.findElementAt(element1.getTextRange().getEndOffset());
        }
        if (element2 instanceof PsiWhiteSpace) {
            element2 = file.findElementAt(element2.getTextRange().getStartOffset() - 1);
        }
        if (element1 == null || element2 == null) {
            return null;
        }
        PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)element1, (PsiElement)element2);
        return (T)PsiTreeUtil.getParentOfType((PsiElement)parent, elementClass, (boolean)false);
    }

    @NotNull
    public static String getEffectiveName(@NotNull String name, boolean isQuoted, @NotNull Casing casing) {
        Case aCase;
        if (name == null) {
            SqlImplUtil.$$$reportNull$$$0(206);
        }
        if (casing == null) {
            SqlImplUtil.$$$reportNull$$$0(207);
        }
        if ((aCase = casing.choose(!isQuoted)) == Case.MIXED) {
            aCase = Case.LOWER;
        }
        String string = aCase.apply(name);
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(208);
        }
        return string;
    }

    @NotNull
    public static DataType getNormalizedDataType(@NotNull SqlReferenceExpression expression) {
        SmartList refs;
        String typeName;
        Casing casing;
        block8: {
            if (expression == null) {
                SqlImplUtil.$$$reportNull$$$0(209);
            }
            casing = NamingServices.getNamingService((Dbms)SqlImplUtil.getDbms((PsiElement)expression)).getDefaultCasing();
            typeName = SqlImplUtil.getEffectiveName(expression.getName(), expression.isQuoted(), casing);
            if (expression.getQualifierExpression() == null) {
                DataType dataType = DataTypeFactory.ofArgs(null, (String)typeName, null, (boolean)true);
                if (dataType == null) {
                    SqlImplUtil.$$$reportNull$$$0(210);
                }
                return dataType;
            }
            refs = new SmartList();
            SqlReferenceExpression ref = expression;
            while (true) {
                refs.add(ref);
                SqlExpression qualifier = ref.getQualifierExpression();
                if (qualifier == null) break block8;
                if (!(qualifier instanceof SqlReferenceExpression)) break;
                ref = (SqlReferenceExpression)qualifier;
            }
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(211);
            }
            return dataType;
        }
        if (refs.size() > 3) {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                SqlImplUtil.$$$reportNull$$$0(212);
            }
            return dataType;
        }
        SqlReferenceExpression leftmostRef = (SqlReferenceExpression)refs.get(refs.size() - 1);
        String schemaName = refs.size() > 1 ? SqlImplUtil.getEffectiveName(leftmostRef.getName(), leftmostRef.isQuoted(), casing) : null;
        String packageName = refs.size() == 3 ? SqlImplUtil.getEffectiveName(((SqlReferenceExpression)refs.get(1)).getName(), ((SqlReferenceExpression)refs.get(1)).isQuoted(), casing) : null;
        DataType dataType = DataTypeFactory.of((String)schemaName, (String)packageName, (String)typeName, (int)-1, (int)0, null, null, (boolean)false, (boolean)true);
        if (dataType == null) {
            SqlImplUtil.$$$reportNull$$$0(213);
        }
        return dataType;
    }

    public static boolean traverseDataSources(@NotNull List<DbDataSource> roots, @Nullable SqlImportState importChecker, @NotNull Predicate<DbDataSource> consumer) {
        if (roots == null) {
            SqlImplUtil.$$$reportNull$$$0(214);
        }
        if (consumer == null) {
            SqlImplUtil.$$$reportNull$$$0(215);
        }
        HashSet<String> visited = new HashSet<String>();
        ArrayList<DbDataSource> queue = new ArrayList<DbDataSource>(roots);
        while (!queue.isEmpty()) {
            DbDataSource dataSource = (DbDataSource)queue.remove(0);
            if (!visited.add(dataSource.getUniqueId()) || importChecker != null && !importChecker.isImported((DasDataSource)dataSource.getDelegate(), null)) continue;
            if (!consumer.test(dataSource)) {
                return false;
            }
            RawDataSource d = dataSource.getDelegate();
            if (!(d instanceof SqlDataSource)) continue;
            ContainerUtil.addIfNotNull(queue, (Object)((SqlDataSource)d).getParentDataSource());
        }
        return true;
    }

    public static boolean processSqlDataSourceFiles(@NotNull SqlDataSource dataSource, @NotNull SqlScopeProcessor processor, @NotNull ResolveState state, @NotNull PsiFile contextFile, @NotNull PsiElement place) {
        if (dataSource == null) {
            SqlImplUtil.$$$reportNull$$$0(216);
        }
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(217);
        }
        if (state == null) {
            SqlImplUtil.$$$reportNull$$$0(218);
        }
        if (contextFile == null) {
            SqlImplUtil.$$$reportNull$$$0(219);
        }
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(220);
        }
        for (SqlFile file : dataSource.getSqlFiles()) {
            if (file.processDeclarations(processor, state, (PsiElement)contextFile, place)) continue;
            return false;
        }
        return true;
    }

    public static boolean isRefWithDblink(@NotNull PsiElement e) {
        if (e == null) {
            SqlImplUtil.$$$reportNull$$$0(221);
        }
        PsiElement last = e.getLastChild();
        return e instanceof SqlReferenceExpression && last instanceof SqlReferenceExpression && ((SqlReferenceExpression)last).getReferenceElementType().getTargetKind() == ObjectKind.DB_LINK;
    }

    public static boolean processExcludedRefInInsertConflict(@Nullable String name, @NotNull PsiElement place, boolean resolve, @NotNull SqlScopeProcessor processor, @NotNull ReservedEntity targetEntity) {
        SyntaxTraverser.ApiEx api;
        PsiElement conflictAction;
        if (place == null) {
            SqlImplUtil.$$$reportNull$$$0(222);
        }
        if (processor == null) {
            SqlImplUtil.$$$reportNull$$$0(223);
        }
        if (targetEntity == null) {
            SqlImplUtil.$$$reportNull$$$0(224);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, targetEntity.name, resolve) && (conflictAction = (PsiElement)(api = SyntaxTraverser.psiApi()).parents((Object)place).filter(SqlImplUtil.isType((IElementType)SqlCompositeElementTypes.SQL_CONFLICT_ACTION_CLAUSE)).first()) != null && !api.children((Object)conflictAction).filter(SqlImplUtil.isType((IElementType)SqlCommonKeywords.SQL_UPDATE)).isEmpty()) {
            SqlTableType entityType;
            SqlDmlInstruction insert = (SqlDmlInstruction)api.parents((Object)place).filter(SqlDmlInstruction.class).first();
            DasBuiltinType type = insert == null ? DasTypeSystemBase.UNKNOWN : insert.getTargetExpression().getDasType();
            Object object = entityType = type == DasTypeSystemBase.UNKNOWN ? SqlTableTypeBase.EMPTY_TABLE : type;
            if (!processor.executeTarget((DasSymbol)targetEntity, (DasType)entityType, null, ResolveState.initial())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isRecursive(@NotNull SqlTableDefinition table) {
        if (table == null) {
            SqlImplUtil.$$$reportNull$$$0(225);
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)table, () -> CachedValueProvider.Result.create((Object)SqlImplUtil.calcIsRecursive(table), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public static int findColumnByElement(@NotNull SqlTableType type, @Nullable PsiElement element) {
        if (type == null) {
            SqlImplUtil.$$$reportNull$$$0(226);
        }
        if (element == null) {
            return -1;
        }
        int count = type.getColumnCount();
        for (int i = 0; i < count; ++i) {
            PsiElement columnElement = type.getColumnElement(i);
            PsiElement sourceElement = type.getSourceColumnElement(i);
            if (!columnElement.isEquivalentTo(element) && (sourceElement == null || !sourceElement.isEquivalentTo(element))) continue;
            return i;
        }
        return -1;
    }

    public static boolean hasNonEditableFragment(@NotNull Document document, @NotNull PsiElement element) {
        if (document == null) {
            SqlImplUtil.$$$reportNull$$$0(227);
        }
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(228);
        }
        TextRange range = element.getTextRange();
        if (document instanceof DocumentWindow) {
            DocumentWindow window = (DocumentWindow)document;
            TextRange nonEditableRange = TextRangeUtil.getEnclosingTextRange((List)InjectedLanguageManager.getInstance((Project)element.getProject()).getNonEditableFragments(window));
            return nonEditableRange.intersects(range);
        }
        return document.getRangeGuard(range.getStartOffset(), range.getEndOffset()) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canBeQualifier(@NotNull ResolveResult resolveResult) {
        PsiElement element;
        if (resolveResult == null) {
            SqlImplUtil.$$$reportNull$$$0(229);
        }
        if (!((element = resolveResult.getElement()) instanceof DasObject)) return false;
        DasObject dasObject = (DasObject)element;
        if (!SqlImplUtil.getSqlDialectSafe(element).canBeQualifier(dasObject)) return false;
        return true;
    }

    private static boolean calcIsRecursive(@NotNull SqlTableDefinition table) {
        SqlExpression expression;
        if (table == null) {
            SqlImplUtil.$$$reportNull$$$0(230);
        }
        if (!((expression = table.getQueryExpression()) instanceof SqlQueryExpression)) {
            return false;
        }
        SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
        if (tableExpression == null) {
            return false;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return false;
        }
        SqlExpression fromExpression = fromClause.getFromExpression();
        if (fromExpression == null) {
            return false;
        }
        for (SqlReferenceExpression ref : SqlImplUtil.sqlTraverser((PsiElement)fromExpression).filter(SqlReferenceExpression.class)) {
            if (!ref.getReference().isReferenceTo((PsiElement)table)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static List<SqlReferenceExpression> getNonAggregateColumnRefs(@NotNull SqlQueryExpression o) {
        SqlSelectClause selectClause;
        if (o == null) {
            SqlImplUtil.$$$reportNull$$$0(231);
        }
        if ((selectClause = o.getSelectClause()) == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(232);
            }
            return list;
        }
        SqlTableExpression tableExpression = o.getTableExpression();
        if (tableExpression == null) {
            List<SqlReferenceExpression> list = Collections.emptyList();
            if (list == null) {
                SqlImplUtil.$$$reportNull$$$0(233);
            }
            return list;
        }
        final PsiElement table = SqlImplUtil.resolveTable(tableExpression);
        final List columns = table instanceof SqlAsExpression ? ((SqlAsExpression)table).getColumnAliasList() : (table instanceof DasObject ? DasUtil.getColumns((DasObject)((DasObject)table)).filter(PsiElement.class).toList() : ContainerUtil.emptyList());
        final boolean checkAggregatesPresent = SqlImplUtil.getSqlDialectSafe((PsiElement)o).getDbms().isH2() || tableExpression.getGroupByClause() == null;
        final boolean[] hasAggregates = new boolean[]{false};
        final SmartList nonAggregatedRefs = new SmartList();
        selectClause.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                SqlReferenceExpression ref;
                if (element == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (element instanceof SqlQueryExpression) {
                    return;
                }
                super.visitElement(element);
                if (checkAggregatesPresent && !hasAggregates[0] && element instanceof SqlFunctionCallExpression) {
                    hasAggregates[0] = SqlImplUtil.isAggregate((SqlFunctionCallExpression)element, false);
                }
                if (element instanceof SqlReferenceExpression && (ref = (SqlReferenceExpression)element).getNode().getElementType() == SqlCompositeElementTypes.SQL_COLUMN_REFERENCE && !SqlImplUtil.inAggregateFunctionCall(ref) && SqlImplUtil.isHighlightableForGroupBy(table, columns, ref)) {
                    nonAggregatedRefs.add((Object)ref);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$3", "visitElement"));
            }
        });
        Object object = checkAggregatesPresent && !hasAggregates[0] ? Collections.emptyList() : nonAggregatedRefs;
        if (object == null) {
            SqlImplUtil.$$$reportNull$$$0(234);
        }
        return object;
    }

    private static boolean isHighlightableForGroupBy(PsiElement table, List<? extends PsiElement> columns, SqlReferenceExpression e) {
        ObjectKind targetSymKind;
        SqlClause clause = (SqlClause)PsiTreeUtil.getContextOfType((PsiElement)e, SqlClause.class, (boolean)true, (Class[])new Class[]{SqlStatement.class});
        if (clause != null && !(clause instanceof SqlSelectClause)) {
            return false;
        }
        DasSymbol targetSym = e.resolveSymbol();
        ObjectKind objectKind = targetSymKind = targetSym != null ? targetSym.getKind() : null;
        if (targetSymKind != SqlDbElementType.COLUMN) {
            return false;
        }
        SqlResultSetExpression expression = SqlImplUtil.findResultSetExpression(e);
        if (expression == null) {
            return true;
        }
        if (SqlImplUtil.isCorrelatedQuery(expression, table)) {
            return columns.contains(e.resolve());
        }
        if (expression instanceof SqlQueryExpression) {
            SqlFromClause fromClause;
            SqlTableExpression tableExpression = ((SqlQueryExpression)expression).getTableExpression();
            SqlFromClause sqlFromClause = fromClause = tableExpression == null ? null : tableExpression.getFromClause();
            if (fromClause != null && fromClause.getFromExpression() instanceof SqlAsExpression) {
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static SqlResultSetExpression findResultSetExpression(SqlReferenceExpression e) {
        SqlParenthesizedExpression parenthesized = (SqlParenthesizedExpression)PsiTreeUtil.getContextOfType((PsiElement)e, (Class[])new Class[]{SqlParenthesizedExpression.class});
        if (parenthesized == null) {
            return null;
        }
        for (SqlExpression expression : parenthesized.getExpressionList()) {
            if (!(expression instanceof SqlResultSetExpression) || !PsiTreeUtil.isAncestor((PsiElement)expression, (PsiElement)e, (boolean)true)) continue;
            return (SqlResultSetExpression)expression;
        }
        return null;
    }

    private static boolean inAggregateFunctionCall(SqlReferenceExpression ref) {
        SqlFunctionCallExpression call = SqlImplUtil.getFunctionCallParent((PsiElement)ref);
        while (call != null) {
            if (SqlImplUtil.isAggregate(call, true)) {
                return true;
            }
            call = SqlImplUtil.getFunctionCallParent((PsiElement)call);
        }
        return false;
    }

    @Nullable
    private static SqlFunctionCallExpression getFunctionCallParent(@Nullable PsiElement o) {
        return (SqlFunctionCallExpression)PsiTreeUtil.getParentOfType((PsiElement)o, SqlFunctionCallExpression.class, (boolean)true, (Class[])new Class[]{SqlQueryExpression.class});
    }

    private static boolean isAggregate(@Nullable SqlFunctionCallExpression call, boolean allowAnalyticClause) {
        PsiElement analyticClause;
        if (call == null) {
            return false;
        }
        if (!allowAnalyticClause && (analyticClause = PsiTreeUtil.findSiblingForward((PsiElement)call.getFirstChild(), (IElementType)SqlCompositeElementTypes.SQL_ANALYTIC_CLAUSE, (boolean)true, null)) != null) {
            return false;
        }
        return SqlPsiUtilCoreKt.isAggregateCall(call);
    }

    public static boolean isCorrelatedQuery(@NotNull SqlResultSetExpression expression, @Nullable PsiElement table) {
        if (expression == null) {
            SqlImplUtil.$$$reportNull$$$0(235);
        }
        if (!(expression instanceof SqlQueryExpression)) {
            return false;
        }
        SqlQueryExpression query = (SqlQueryExpression)expression;
        PsiElement queryTable = SqlImplUtil.resolveTable(query.getTableExpression());
        return queryTable == null || !table.equals((Object)queryTable);
    }

    @Nullable
    public static PsiElement resolveTable(@Nullable SqlTableExpression tableExpression) {
        if (tableExpression == null) {
            return null;
        }
        SqlFromClause fromClause = tableExpression.getFromClause();
        if (fromClause == null) {
            return null;
        }
        SqlExpression fromExpression = fromClause.getFromExpression();
        if (fromExpression == null) {
            return null;
        }
        if (fromExpression instanceof SqlAsExpression) {
            SqlAsExpression alias = (SqlAsExpression)fromExpression;
            fromExpression = alias.getExpression();
        }
        if (!(fromExpression instanceof SqlReferenceExpression)) {
            return null;
        }
        SqlReferenceExpression ref = (SqlReferenceExpression)fromExpression;
        return ref.resolve();
    }

    @NotNull
    private static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, @Nullable SqlGroupByClause groupByClause) {
        if (ref == null) {
            SqlImplUtil.$$$reportNull$$$0(236);
        }
        JBIterable allColumns = JBIterable.from((Iterable)DbSqlUtilCore.resolveToColumnList((SqlReferenceExpression)ref));
        for (PsiElement column : allColumns) {
            if (!(column instanceof SqlAsExpression) && column != ref) continue;
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(237);
            }
            return jBIterable;
        }
        if (groupByClause == null) {
            JBIterable jBIterable = allColumns;
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(238);
            }
            return jBIterable;
        }
        LocalSearchScope scope = new LocalSearchScope((PsiElement)groupByClause);
        SmartHashSet posRefTargets = new SmartHashSet();
        for (SqlPositionalReference posRef : SqlImplUtil.sqlChildren((PsiElement)groupByClause).filter(SqlPositionalReference.class)) {
            PsiElement target = posRef.resolve();
            if (target instanceof SqlImplicitSymbol) {
                target = ((SqlImplicitSymbol)target).getTargetDefinition();
            }
            if (target == null) continue;
            posRefTargets.add((Object)target);
        }
        SqlExpression topExpression = SqlImplUtil.getTopExpression(ref);
        if (topExpression != null && SqlImplUtil.hasUsages((PsiElement)topExpression, (SearchScope)scope, (Set<PsiElement>)posRefTargets)) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(239);
            }
            return jBIterable;
        }
        if ((allColumns = allColumns.filter(element -> !SqlImplUtil.hasUsages(element, (SearchScope)scope, (Set<PsiElement>)posRefTargets))).isEmpty()) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlImplUtil.$$$reportNull$$$0(240);
            }
            return jBIterable;
        }
        JBIterable jBIterable = topExpression instanceof SqlAsExpression ? JBIterable.of((Object)topExpression) : allColumns;
        if (jBIterable == null) {
            SqlImplUtil.$$$reportNull$$$0(241);
        }
        return jBIterable;
    }

    @NotNull
    public static JBIterable<PsiElement> getResolvesNotInGroupBy(@NotNull SqlReferenceExpression ref, @Nullable SqlQueryExpression o) {
        if (ref == null) {
            SqlImplUtil.$$$reportNull$$$0(242);
        }
        return SqlImplUtil.getResolvesNotInGroupBy(ref, o == null || o.getTableExpression() == null ? null : o.getTableExpression().getGroupByClause());
    }

    private static boolean hasUsages(@NotNull PsiElement element, @NotNull SearchScope scope, @NotNull Set<PsiElement> extraTargets) {
        if (element == null) {
            SqlImplUtil.$$$reportNull$$$0(243);
        }
        if (scope == null) {
            SqlImplUtil.$$$reportNull$$$0(244);
        }
        if (extraTargets == null) {
            SqlImplUtil.$$$reportNull$$$0(245);
        }
        return extraTargets.contains(element) || ReferencesSearch.search((PsiElement)element, (SearchScope)scope).findFirst() != null;
    }

    private static SqlExpression getTopExpression(@NotNull SqlReferenceExpression ref) {
        if (ref == null) {
            SqlImplUtil.$$$reportNull$$$0(246);
        }
        SqlReferenceExpression e = ref;
        SqlReferenceExpression top = ref;
        while (!(e instanceof SqlSelectClause || e instanceof SqlQueryExpression || e instanceof PsiFile)) {
            if (!((e = e.getParent()) instanceof SqlExpression)) continue;
            top = (SqlExpression)e;
        }
        return top;
    }

    @NotNull
    public static String getResolvedColumnName(@NotNull DatabaseDialectEx dialect, @NotNull SqlReferenceExpression ref, @NotNull PsiElement resolved) {
        if (dialect == null) {
            SqlImplUtil.$$$reportNull$$$0(247);
        }
        if (ref == null) {
            SqlImplUtil.$$$reportNull$$$0(248);
        }
        if (resolved == null) {
            SqlImplUtil.$$$reportNull$$$0(249);
        }
        SqlTableType type = (SqlTableType)ObjectUtils.tryCast((Object)ref.getDasType(), SqlTableType.class);
        SqlLanguageDialectEx sqlDialect = SqlImplUtil.getSqlDialectSafe((PsiElement)ref);
        if (type == null || ref.getReference().isReferenceTo(resolved)) {
            String string = ref.getReference().getCanonicalText();
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(250);
            }
            return string;
        }
        for (int i = 0; i < type.getColumnCount(); ++i) {
            if (type.getColumnElement(i) != resolved) continue;
            DdlBuilder builder = new DdlBuilder(new StringBuilder()).configureBuilder(ref.getProject(), (SqlLanguageDialect)sqlDialect).withDialect(dialect);
            String name = StringUtil.notNullize((String)type.getColumnName(i));
            String typeAlias = type.getColumnTypeAlias(i);
            if (typeAlias == null) {
                String string = ref.getReference().getCanonicalText();
                if (string == null) {
                    SqlImplUtil.$$$reportNull$$$0(251);
                }
                return string;
            }
            builder.columnRef(typeAlias).symbol(".").columnRef(name);
            String string = builder.getStatement();
            if (string == null) {
                SqlImplUtil.$$$reportNull$$$0(252);
            }
            return string;
        }
        String string = ref.getReference().getCanonicalText();
        if (string == null) {
            SqlImplUtil.$$$reportNull$$$0(253);
        }
        return string;
    }

    @NotNull
    public static Collection<DasObject> getAllUsingTargets(@NotNull SqlUsingClause usingClause) {
        SqlReferenceList refList;
        if (usingClause == null) {
            SqlImplUtil.$$$reportNull$$$0(254);
        }
        if ((refList = usingClause.getReferenceList()) == null) {
            Set<DasObject> set = Collections.emptySet();
            if (set == null) {
                SqlImplUtil.$$$reportNull$$$0(255);
            }
            return set;
        }
        List refs = refList.getReferenceList();
        List list = ContainerUtil.flatMap((Iterable)refs, ref -> ContainerUtil.mapNotNull((Object[])ref.multiResolve(false), r -> {
            DasSymbol symbol = DasSymbolUtil.getSymbol(r);
            return symbol != null ? symbol.getDasObject() : null;
        }));
        if (list == null) {
            SqlImplUtil.$$$reportNull$$$0(256);
        }
        return list;
    }

    @NotNull
    private static Condition<PsiElement> isType(IElementType type) {
        Condition condition = Conditions.compose((Function)SyntaxTraverser.psiApi().TO_TYPE, (Condition)Conditions.is((Object)type));
        if (condition == null) {
            SqlImplUtil.$$$reportNull$$$0(257);
        }
        return condition;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 5, 8, 9, 10, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 36, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 51, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 71, 72, 73, 74, 75, 77, 78, 80, 81, 84, 85, 87, 92, 96, 97, 98, 99, 100, 101, 102, 105, 107, 109, 110, 111, 113, 114, 115, 116, 117, 123, 124, 125, 127, 128, 129, 130, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 146, 149, 150, 151, 154, 156, 158, 161, 162, 163, 166, 168, 169, 170, 171, 172, 174, 175, 176, 178, 183, 184, 185, 186, 187, 189, 190, 191, 192, 193, 194, 195, 197, 198, 200, 201, 202, 203, 204, 205, 206, 207, 209, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 235, 236, 242, 243, 244, 245, 246, 247, 248, 249, 254 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 1: 
            case 2: 
            case 231: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 218: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 13: 
            case 18: 
            case 25: 
            case 29: 
            case 32: 
            case 40: 
            case 43: 
            case 46: 
            case 71: 
            case 72: 
            case 197: 
            case 200: 
            case 247: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSources";
                break;
            }
            case 16: 
            case 39: 
            case 87: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 110: 
            case 111: 
            case 125: 
            case 127: 
            case 128: 
            case 146: 
            case 163: 
            case 166: 
            case 187: 
            case 192: 
            case 228: 
            case 243: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignored";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 24: 
            case 109: 
            case 132: 
            case 176: 
            case 178: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definition";
                break;
            }
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 30: 
            case 44: 
            case 74: 
            case 129: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 34: 
            case 48: 
            case 51: 
            case 116: 
            case 117: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 36: 
            case 38: 
            case 73: 
            case 154: 
            case 156: 
            case 183: 
            case 226: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 42: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasType";
                break;
            }
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "queryExpression";
                break;
            }
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 221: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 77: 
            case 80: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 78: 
            case 138: 
            case 209: 
            case 235: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 96: 
            case 98: 
            case 113: 
            case 134: 
            case 217: 
            case 223: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 97: 
            case 114: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kinds";
                break;
            }
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 115: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tmpFile";
                break;
            }
            case 124: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 130: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeType";
                break;
            }
            case 133: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locations";
                break;
            }
            case 135: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entrance";
                break;
            }
            case 136: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialState";
                break;
            }
            case 137: 
            case 139: 
            case 229: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 140: 
            case 158: 
            case 172: 
            case 203: 
            case 204: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colList";
                break;
            }
            case 142: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 143: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tgt";
                break;
            }
            case 144: {
                objectArray2 = objectArray3;
                objectArray3[0] = "src";
                break;
            }
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionList";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressions";
                break;
            }
            case 151: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbms";
                break;
            }
            case 161: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
            case 162: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namingService";
                break;
            }
            case 168: 
            case 169: 
            case 170: 
            case 171: {
                objectArray2 = objectArray3;
                objectArray3[0] = "col";
                break;
            }
            case 174: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 175: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 184: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 185: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 186: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectClause";
                break;
            }
            case 189: 
            case 190: 
            case 193: 
            case 220: 
            case 222: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 191: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedKind";
                break;
            }
            case 194: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 195: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClass";
                break;
            }
            case 198: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 201: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dasColumns";
                break;
            }
            case 202: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 205: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementClass";
                break;
            }
            case 206: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 207: {
                objectArray2 = objectArray3;
                objectArray3[0] = "casing";
                break;
            }
            case 214: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 215: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 216: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 219: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contextFile";
                break;
            }
            case 224: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetEntity";
                break;
            }
            case 225: 
            case 230: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 227: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 236: 
            case 242: 
            case 246: 
            case 248: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 244: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 245: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraTargets";
                break;
            }
            case 249: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
            case 254: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usingClause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferenceList";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 62: 
            case 63: 
            case 67: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 77: 
            case 78: 
            case 80: 
            case 81: 
            case 84: 
            case 85: 
            case 87: 
            case 92: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 105: 
            case 107: 
            case 109: 
            case 110: 
            case 111: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 123: 
            case 124: 
            case 125: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 146: 
            case 149: 
            case 150: 
            case 151: 
            case 154: 
            case 156: 
            case 158: 
            case 161: 
            case 162: 
            case 163: 
            case 166: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 197: 
            case 198: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 209: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 235: 
            case 236: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 254: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMirror";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getModifiedState";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasingProvider";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataSources";
                break;
            }
            case 26: 
            case 27: 
            case 35: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElement";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "rebuildDasType";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRebuiltDasType";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingElements";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevTraverser";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlRevChildren";
                break;
            }
            case 66: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildrenNoWS";
                break;
            }
            case 68: {
                objectArray = objectArray2;
                objectArray2[1] = "byElementType";
                break;
            }
            case 69: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlParents";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlCompositeElements";
                break;
            }
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectType";
                break;
            }
            case 79: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeLateralAware";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualified";
                break;
            }
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 88: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialectSafe";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlTraverser";
                break;
            }
            case 91: {
                objectArray = objectArray2;
                objectArray2[1] = "sqlChildren";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "getCasedPart";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "trimLong";
                break;
            }
            case 104: {
                objectArray = objectArray2;
                objectArray2[1] = "removeDuplicateSpaces";
                break;
            }
            case 106: {
                objectArray = objectArray2;
                objectArray2[1] = "getLabels";
                break;
            }
            case 108: {
                objectArray = objectArray2;
                objectArray2[1] = "calcLabels";
                break;
            }
            case 112: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateReference";
                break;
            }
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: {
                objectArray = objectArray2;
                objectArray2[1] = "getKindSynonymAware";
                break;
            }
            case 126: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeSystem";
                break;
            }
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheableDasType";
                break;
            }
            case 145: {
                objectArray = objectArray2;
                objectArray2[1] = "processColumnList";
                break;
            }
            case 147: 
            case 148: {
                objectArray = objectArray2;
                objectArray2[1] = "getTriggerEvents";
                break;
            }
            case 152: 
            case 153: {
                objectArray = objectArray2;
                objectArray2[1] = "getTupleType";
                break;
            }
            case 155: 
            case 157: {
                objectArray = objectArray2;
                objectArray2[1] = "filterHiddenColumns";
                break;
            }
            case 159: 
            case 160: {
                objectArray = objectArray2;
                objectArray2[1] = "getDbVersions";
                break;
            }
            case 164: 
            case 165: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierKind";
                break;
            }
            case 167: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifierDasType";
                break;
            }
            case 173: {
                objectArray = objectArray2;
                objectArray2[1] = "iterateStatementsBackward";
                break;
            }
            case 177: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelatedElements";
                break;
            }
            case 179: 
            case 180: 
            case 181: 
            case 182: {
                objectArray = objectArray2;
                objectArray2[1] = "calcRelatedElements";
                break;
            }
            case 188: {
                objectArray = objectArray2;
                objectArray2[1] = "unwrapFake";
                break;
            }
            case 196: {
                objectArray = objectArray2;
                objectArray2[1] = "getSiblingObjects";
                break;
            }
            case 199: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectColumnDasType";
                break;
            }
            case 208: {
                objectArray = objectArray2;
                objectArray2[1] = "getEffectiveName";
                break;
            }
            case 210: 
            case 211: 
            case 212: 
            case 213: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedDataType";
                break;
            }
            case 232: 
            case 233: 
            case 234: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonAggregateColumnRefs";
                break;
            }
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvesNotInGroupBy";
                break;
            }
            case 250: 
            case 251: 
            case 252: 
            case 253: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedColumnName";
                break;
            }
            case 255: 
            case 256: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllUsingTargets";
                break;
            }
            case 257: {
                objectArray = objectArray2;
                objectArray2[1] = "isType";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getReferencedElements";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMirror";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getModifiedState";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateQualifier";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setImmediateTarget";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processQualifierImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCasingProvider";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDataSources";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getParentTypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createType";
                break;
            }
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getDasType";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getArrayElement";
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "rebuildDasType";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "computeRebuiltDasType";
                break;
            }
            case 53: 
            case 192: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateQualifier";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateTarget";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getLastQueryExpression";
                break;
            }
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setLastQueryExpression";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "revSiblings";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingElements";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "siblings";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "revSiblingsNoDummy";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "byElementType";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getNameOrText";
                break;
            }
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "hasResolvableColumnName";
                break;
            }
            case 73: 
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "convertToTableType";
                break;
            }
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "getSelectType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheLeftOfType";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "getTypeLateralAware";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingToTheRightOfType";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "getBlockContentElement";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "getMinDbmsVersion";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getCasedPart";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingOneOf";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "isProcessingChildOf";
                break;
            }
            case 100: {
                objectArray = objectArray;
                objectArray[2] = "isAsteriskRef";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getAsterisk";
                break;
            }
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "fromText";
                break;
            }
            case 105: {
                objectArray = objectArray;
                objectArray[2] = "getLabels";
                break;
            }
            case 107: {
                objectArray = objectArray;
                objectArray[2] = "calcLabels";
                break;
            }
            case 109: {
                objectArray = objectArray;
                objectArray[2] = "calcPosition";
                break;
            }
            case 110: {
                objectArray = objectArray;
                objectArray[2] = "getReference";
                break;
            }
            case 111: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateReference";
                break;
            }
            case 113: 
            case 114: {
                objectArray = objectArray;
                objectArray[2] = "ignoreKinds";
                break;
            }
            case 115: 
            case 116: {
                objectArray = objectArray;
                objectArray[2] = "getAnyRoot";
                break;
            }
            case 117: {
                objectArray = objectArray;
                objectArray[2] = "wrapObjectToPsi";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelSqlFile";
                break;
            }
            case 124: {
                objectArray = objectArray;
                objectArray[2] = "isSameSqlFileDialect";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSystem";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "getScopingType";
                break;
            }
            case 128: {
                objectArray = objectArray;
                objectArray[2] = "getScopingExpression";
                break;
            }
            case 129: 
            case 130: {
                objectArray = objectArray;
                objectArray[2] = "getCacheableDasType";
                break;
            }
            case 132: 
            case 133: {
                objectArray = objectArray;
                objectArray[2] = "hasLocationOf";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray;
                objectArray[2] = "treeWalkUp";
                break;
            }
            case 137: {
                objectArray = objectArray;
                objectArray[2] = "isHidden";
                break;
            }
            case 138: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "isMarkedUnresolved";
                break;
            }
            case 140: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelFile";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "getTableTypeOfColumnList";
                break;
            }
            case 142: {
                objectArray = objectArray;
                objectArray[2] = "getIdentifierKind";
                break;
            }
            case 143: 
            case 144: {
                objectArray = objectArray;
                objectArray[2] = "processColumnList";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "getTriggerEvents";
                break;
            }
            case 149: 
            case 150: 
            case 151: {
                objectArray = objectArray;
                objectArray[2] = "getTupleType";
                break;
            }
            case 154: 
            case 156: {
                objectArray = objectArray;
                objectArray[2] = "filterHiddenColumns";
                break;
            }
            case 158: {
                objectArray = objectArray;
                objectArray[2] = "getDbVersions";
                break;
            }
            case 161: 
            case 162: {
                objectArray = objectArray;
                objectArray[2] = "canUnquote";
                break;
            }
            case 163: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierKind";
                break;
            }
            case 166: {
                objectArray = objectArray;
                objectArray[2] = "getQualifierDasType";
                break;
            }
            case 168: 
            case 169: {
                objectArray = objectArray;
                objectArray[2] = "isAutoVal";
                break;
            }
            case 170: 
            case 171: {
                objectArray = objectArray;
                objectArray[2] = "isComputedVal";
                break;
            }
            case 172: {
                objectArray = objectArray;
                objectArray[2] = "iterateStatementsBackward";
                break;
            }
            case 174: 
            case 175: {
                objectArray = objectArray;
                objectArray[2] = "mergeColumnListInto";
                break;
            }
            case 176: {
                objectArray = objectArray;
                objectArray[2] = "getRelatedElements";
                break;
            }
            case 178: {
                objectArray = objectArray;
                objectArray[2] = "calcRelatedElements";
                break;
            }
            case 183: 
            case 184: {
                objectArray = objectArray;
                objectArray[2] = "indicesOfImmediateSource";
                break;
            }
            case 185: {
                objectArray = objectArray;
                objectArray[2] = "inColumnProvidingContext";
                break;
            }
            case 186: 
            case 187: {
                objectArray = objectArray;
                objectArray[2] = "getSelectExpression";
                break;
            }
            case 189: {
                objectArray = objectArray;
                objectArray[2] = "isColumnQualifier";
                break;
            }
            case 190: 
            case 191: {
                objectArray = objectArray;
                objectArray[2] = "isQualifier";
                break;
            }
            case 193: {
                objectArray = objectArray;
                objectArray[2] = "isColumnReference";
                break;
            }
            case 194: 
            case 195: {
                objectArray = objectArray;
                objectArray[2] = "getSiblingObjects";
                break;
            }
            case 197: 
            case 198: {
                objectArray = objectArray;
                objectArray[2] = "getObjectColumnDasType";
                break;
            }
            case 200: 
            case 201: 
            case 202: {
                objectArray = objectArray;
                objectArray[2] = "createTableTypeWithColumns";
                break;
            }
            case 203: {
                objectArray = objectArray;
                objectArray[2] = "getPossiblyInjectedElement";
                break;
            }
            case 204: 
            case 205: {
                objectArray = objectArray;
                objectArray[2] = "getElementBySelection";
                break;
            }
            case 206: 
            case 207: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveName";
                break;
            }
            case 209: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedDataType";
                break;
            }
            case 214: 
            case 215: {
                objectArray = objectArray;
                objectArray[2] = "traverseDataSources";
                break;
            }
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: {
                objectArray = objectArray;
                objectArray[2] = "processSqlDataSourceFiles";
                break;
            }
            case 221: {
                objectArray = objectArray;
                objectArray[2] = "isRefWithDblink";
                break;
            }
            case 222: 
            case 223: 
            case 224: {
                objectArray = objectArray;
                objectArray[2] = "processExcludedRefInInsertConflict";
                break;
            }
            case 225: {
                objectArray = objectArray;
                objectArray[2] = "isRecursive";
                break;
            }
            case 226: {
                objectArray = objectArray;
                objectArray[2] = "findColumnByElement";
                break;
            }
            case 227: 
            case 228: {
                objectArray = objectArray;
                objectArray[2] = "hasNonEditableFragment";
                break;
            }
            case 229: {
                objectArray = objectArray;
                objectArray[2] = "canBeQualifier";
                break;
            }
            case 230: {
                objectArray = objectArray;
                objectArray[2] = "calcIsRecursive";
                break;
            }
            case 231: {
                objectArray = objectArray;
                objectArray[2] = "getNonAggregateColumnRefs";
                break;
            }
            case 235: {
                objectArray = objectArray;
                objectArray[2] = "isCorrelatedQuery";
                break;
            }
            case 236: 
            case 242: {
                objectArray = objectArray;
                objectArray[2] = "getResolvesNotInGroupBy";
                break;
            }
            case 243: 
            case 244: 
            case 245: {
                objectArray = objectArray;
                objectArray[2] = "hasUsages";
                break;
            }
            case 246: {
                objectArray = objectArray;
                objectArray[2] = "getTopExpression";
                break;
            }
            case 247: 
            case 248: 
            case 249: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedColumnName";
                break;
            }
            case 254: {
                objectArray = objectArray;
                objectArray[2] = "getAllUsingTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 5, 8, 9, 10, 12, 13, 14, 16, 18, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 36, 38, 39, 40, 42, 43, 44, 45, 46, 47, 48, 51, 53, 54, 55, 56, 57, 58, 59, 60, 62, 63, 67, 71, 72, 73, 74, 75, 77, 78, 80, 81, 84, 85, 87, 92, 96, 97, 98, 99, 100, 101, 102, 105, 107, 109, 110, 111, 113, 114, 115, 116, 117, 123, 124, 125, 127, 128, 129, 130, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 146, 149, 150, 151, 154, 156, 158, 161, 162, 163, 166, 168, 169, 170, 171, 172, 174, 175, 176, 178, 183, 184, 185, 186, 187, 189, 190, 191, 192, 193, 194, 195, 197, 198, 200, 201, 202, 203, 204, 205, 206, 207, 209, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228, 229, 230, 231, 235, 236, 242, 243, 244, 245, 246, 247, 248, 249, 254 -> new IllegalArgumentException(string);
        };
    }

    public static class Column {
        public final String name;
        public final DasType dasType;
        public final PsiElement element;
        public final PsiElement sourceElement;

        public Column(String name, DasType dasType, @NotNull PsiElement element, PsiElement sourceElement) {
            if (element == null) {
                Column.$$$reportNull$$$0(0);
            }
            this.name = name;
            this.dasType = dasType;
            this.element = element;
            this.sourceElement = sourceElement;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/sql/psi/impl/SqlImplUtil$Column", "<init>"));
        }
    }

    private static class MyColumnInfo
    extends RenameableFakePsiElement
    implements PsiColumn,
    SqlTypedDefinition,
    PsiColumnWithSymbol {
        final SqlTableDefinition myTableInfo;
        final int myIndex;
        final SqlTableType myTableType;
        final DasObject myInfo;

        MyColumnInfo(@NotNull SqlTableDefinition parent, int index, @NotNull SqlTableType tableType2) {
            if (parent == null) {
                MyColumnInfo.$$$reportNull$$$0(0);
            }
            if (tableType2 == null) {
                MyColumnInfo.$$$reportNull$$$0(1);
            }
            super((PsiElement)parent.getContainingFile());
            this.myTableInfo = parent;
            this.myIndex = index;
            this.myTableType = tableType2;
            PsiElement columnElement = tableType2.getSourceColumnElement(index);
            this.myInfo = (DasObject)ObjectUtils.tryCast((Object)columnElement, DasObject.class);
        }

        @NotNull
        public Dbms getDbms() {
            Dbms dbms = SqlImplUtil.getSqlDialectDbms((PsiElement)this.myTableInfo);
            if (dbms == null) {
                MyColumnInfo.$$$reportNull$$$0(2);
            }
            return dbms;
        }

        @NotNull
        public PsiColumn getDasObject() {
            MyColumnInfo myColumnInfo = this;
            if (myColumnInfo == null) {
                MyColumnInfo.$$$reportNull$$$0(3);
            }
            return myColumnInfo;
        }

        public boolean isNameQuoted() {
            return this.myTableType.isColumnQuoted(this.myIndex);
        }

        public DasTable getTable() {
            return this.myTableInfo;
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.COLUMN;
            if (objectKind == null) {
                MyColumnInfo.$$$reportNull$$$0(4);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = StringUtil.notNullize((String)this.myTableType.getColumnName(this.myIndex), (String)DasUtil.NO_NAME);
            if (string == null) {
                MyColumnInfo.$$$reportNull$$$0(5);
            }
            return string;
        }

        public String getComment() {
            return this.myInfo == null ? null : this.myInfo.getComment();
        }

        public DasObject getDasParent() {
            return this.getTable();
        }

        @Nullable
        public SqlTypeElement getTypeElement() {
            return null;
        }

        @NotNull
        public DasType getDasType() {
            DasType dasType = this.myTableType.getColumnDasType(this.myIndex);
            if (dasType == null) {
                MyColumnInfo.$$$reportNull$$$0(6);
            }
            return dasType;
        }

        public boolean isNotNull() {
            return this.myInfo instanceof DasTypedObject && ((DasTypedObject)this.myInfo).isNotNull();
        }

        public String getDefault() {
            return this.myInfo instanceof DasTypedObject ? ((DasTypedObject)this.myInfo).getDefault() : null;
        }

        public PsiElement getParent() {
            return this.myTableInfo;
        }

        public String getTypeName() {
            return DbPresentationCore.getPresentableName((ObjectKind)this.getKind(), (Dbms)DbImplUtilCore.getDbms((DasObject)this.myTableInfo));
        }

        public Icon getIcon() {
            return DatabaseIcons.Col;
        }

        @NotNull
        public PsiElement getNavigationElement() {
            PsiElement psiElement = this.myTableType.getColumnElement(this.myIndex);
            if (psiElement == null) {
                MyColumnInfo.$$$reportNull$$$0(7);
            }
            return psiElement;
        }

        public short getPosition() {
            return (short)(this.myIndex + 1);
        }

        @Nullable
        public SqlNameElement getNameElement() {
            return null;
        }

        @Nullable
        public PsiElement getNameIdentifier() {
            return null;
        }

        public void accept(SqlVisitor visitor2) {
            visitor2.visitSqlElement((SqlElement)this);
        }

        public void acceptChildren(SqlVisitor visitor2) {
            SqlImplUtil.acceptChildren((SqlElement)this, visitor2);
        }

        public boolean isEquivalentTo(PsiElement another) {
            if (!(another instanceof MyColumnInfo)) {
                return false;
            }
            MyColumnInfo info = (MyColumnInfo)another;
            return this.myIndex == info.myIndex && Objects.equals(this.myTableInfo, info.myTableInfo) && Objects.equals(this.myInfo, info.myInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4, 5, 6, 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tableType";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$MyColumnInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDbms";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasObject";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDasType";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNavigationElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4, 5, 6, 7 -> new IllegalStateException(string);
            };
        }
    }

    public static class ValuesTableType
    extends ValuesTableTypeBase {
        private String myColumnNamePrefix;

        public ValuesTableType(@Nullable PsiElement expressionList, @NotNull List<SqlExpression> expressions, @NotNull Dbms dbms) {
            if (expressions == null) {
                ValuesTableType.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(1);
            }
            super(expressionList, expressions, dbms);
        }

        @Override
        protected void initCustom(@NotNull Dbms dbms) {
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(2);
            }
            this.myColumnNamePrefix = ValuesTableType.getColumnNamePrefix(dbms);
        }

        @Override
        protected SqlColumnSymbol createColumn(int index, @NotNull SqlExpression expression, @NotNull Dbms dbms) {
            if (expression == null) {
                ValuesTableType.$$$reportNull$$$0(3);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(4);
            }
            String name = this.calcColumnName(index, this.myColumnNamePrefix, dbms);
            boolean needQuotes = this.needQuotes(index, this.myColumnNamePrefix, dbms);
            return new ValueTypeColumnSymbol(name, needQuotes, expression, index, null, null);
        }

        @NotNull
        private static String getColumnNamePrefix(@NotNull Dbms dbms) {
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(5);
            }
            if (dbms.isH2() || dbms.isHsqldb()) {
                return "C";
            }
            if (dbms.isSqlite() || dbms == Dbms.POSTGRES || dbms == Dbms.GREENPLUM || dbms == Dbms.COCKROACH) {
                return "column";
            }
            if (dbms.isSnowflake()) {
                return "COLUMN";
            }
            if (dbms.isHive()) {
                return "col";
            }
            return "";
        }

        @NotNull
        private String calcColumnName(int i, @NotNull String prefix, @NotNull Dbms dbms) {
            if (prefix == null) {
                ValuesTableType.$$$reportNull$$$0(6);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(7);
            }
            PsiElement columnElement = this.getColumnElement(i);
            if (dbms.isHive() && columnElement instanceof DasNamed) {
                DasNamed named = (DasNamed)columnElement;
                String string = named.getName();
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(8);
                }
                return string;
            }
            if (dbms.isBigQuery()) {
                String string;
                IElementType startType = PsiUtilCore.getElementType((PsiElement)this.myExpressionList.getFirstChild());
                if (startType == SqlCommonKeywords.SQL_STRUCT && columnElement instanceof DasNamed) {
                    DasNamed named = (DasNamed)columnElement;
                    string = named.getName();
                } else {
                    string = "";
                }
                return string;
            }
            int num = i + 1;
            if (!prefix.isEmpty()) {
                String string = prefix + num;
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(9);
                }
                return string;
            }
            if (dbms == Dbms.MARIA) {
                String string = columnElement instanceof SqlStringLiteralExpression ? StringUtil.notNullize((String)((SqlStringLiteralExpression)columnElement).getValue()) : columnElement.getText();
                if (string == null) {
                    ValuesTableType.$$$reportNull$$$0(10);
                }
                return string;
            }
            String string = columnElement instanceof SqlDefinition ? ((SqlDefinition)columnElement).getName() : String.valueOf(num);
            if (string == null) {
                ValuesTableType.$$$reportNull$$$0(11);
            }
            return string;
        }

        private boolean needQuotes(int i, @NotNull String prefix, @NotNull Dbms dbms) {
            if (prefix == null) {
                ValuesTableType.$$$reportNull$$$0(12);
            }
            if (dbms == null) {
                ValuesTableType.$$$reportNull$$$0(13);
            }
            PsiElement columnElement = this.getColumnElement(i);
            if (dbms.isHive() && columnElement instanceof DasNamed) {
                DasNamed named = (DasNamed)columnElement;
                return named.isQuoted();
            }
            return prefix.isEmpty();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10, 11 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressions";
                    break;
                }
                case 1: 
                case 2: 
                case 4: 
                case 5: 
                case 7: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 6: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableType";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "calcColumnName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "initCustom";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "createColumn";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "getColumnNamePrefix";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "calcColumnName";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    break;
                }
                case 12: 
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "needQuotes";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10, 11 -> new IllegalStateException(string);
            };
        }
    }

    private static class EmptyTable
    implements DasTable {
        private EmptyTable() {
        }

        @NotNull
        public ObjectKind getKind() {
            ObjectKind objectKind = SqlDbElementType.TABLE;
            if (objectKind == null) {
                EmptyTable.$$$reportNull$$$0(0);
            }
            return objectKind;
        }

        @NotNull
        public String getName() {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                EmptyTable.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean isQuoted() {
            return true;
        }

        public boolean isSystem() {
            return false;
        }

        public boolean isTemporary() {
            return false;
        }

        @NotNull
        public Set<DasColumn.Attribute> getColumnAttrs(@Nullable DasColumn c) {
            if (c instanceof PsiElement && SqlImplUtil.getSqlDialectSafe((PsiElement)c).isAutoIncrementColumn(c)) {
                EnumSet<DasColumn.Attribute> enumSet = EnumSet.of(DasColumn.Attribute.AUTO_GENERATED);
                if (enumSet == null) {
                    EmptyTable.$$$reportNull$$$0(2);
                }
                return enumSet;
            }
            Set set = DasUtil.NO_ATTRS;
            if (set == null) {
                EmptyTable.$$$reportNull$$$0(3);
            }
            return set;
        }

        @Nullable
        public String getComment() {
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/sql/psi/impl/SqlImplUtil$EmptyTable";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKind";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnAttrs";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static abstract class ValuesTableTypeBase
    extends SqlTableTypeBase {
        protected final PsiElement myExpressionList;
        private final List<SqlExpression> myExpressions;
        private final List<SqlColumnSymbol> myColumns;

        protected ValuesTableTypeBase(@Nullable PsiElement expressionList, @NotNull List<SqlExpression> expressions, @NotNull Dbms dbms) {
            if (expressions == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(0);
            }
            if (dbms == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(1);
            }
            this.myColumns = new ArrayList<SqlColumnSymbol>();
            this.myExpressionList = expressionList;
            this.myExpressions = expressions;
            this.initCustom(dbms);
            int size = expressions.size();
            for (int i = 0; i < size; ++i) {
                SqlExpression expression = expressions.get(i);
                SqlColumnSymbol symbol = this.createColumn(i, expression, dbms);
                this.myColumns.add(symbol);
            }
        }

        protected void initCustom(@NotNull Dbms dbms) {
            if (dbms == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(2);
            }
        }

        protected abstract SqlColumnSymbol createColumn(int var1, @NotNull SqlExpression var2, @NotNull Dbms var3);

        @NotNull
        public DataType toDataType() {
            DataType dataType = DataType.UNKNOWN;
            if (dataType == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(3);
            }
            return dataType;
        }

        @NotNull
        public List<DasObject> getMethods() {
            List<DasObject> list = Collections.emptyList();
            if (list == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(4);
            }
            return list;
        }

        public int getColumnCount() {
            return this.myExpressions.size();
        }

        public String getColumnName(int i) {
            return this.myColumns.get(i).getName();
        }

        public boolean isColumnQuoted(int i) {
            return this.myColumns.get(i).isQuoted();
        }

        public DasType getColumnDasType(int i) {
            return this.myExpressions.get(i).getDasType();
        }

        @Nullable
        public PsiElement getColumnQualifier(int i) {
            return this.myExpressionList;
        }

        @NotNull
        public PsiElement getColumnElement(int i) {
            PsiElement psiElement = (PsiElement)this.myExpressions.get(i);
            if (psiElement == null) {
                ValuesTableTypeBase.$$$reportNull$$$0(5);
            }
            return psiElement;
        }

        @Nullable
        public PsiElement getSourceColumnElement(int i) {
            return (PsiElement)this.myColumns.get(i);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expressions";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbms";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableTypeBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$ValuesTableTypeBase";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toDataType";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMethods";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getColumnElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "initCustom";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4, 5 -> new IllegalStateException(string);
            };
        }
    }

    public static class ValueTypeColumnSymbol
    extends SqlColumnSymbol {
        public ValueTypeColumnSymbol(@NotNull String name, boolean quoted, @NotNull SqlExpression expression, int index, @Nullable PsiElement targetDefinition, @Nullable PsiElement qualifier) {
            if (name == null) {
                ValueTypeColumnSymbol.$$$reportNull$$$0(0);
            }
            if (expression == null) {
                ValueTypeColumnSymbol.$$$reportNull$$$0(1);
            }
            super(name, quoted, (PsiElement)expression, index, targetDefinition, qualifier);
        }

        @Override
        @NotNull
        public DasType getType() {
            DasType dasType = ((SqlExpression)this.getContextElement()).getDasType();
            if (dasType == null) {
                ValueTypeColumnSymbol.$$$reportNull$$$0(2);
            }
            return dasType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/sql/psi/impl/SqlImplUtil$ValueTypeColumnSymbol";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/sql/psi/impl/SqlImplUtil$ValueTypeColumnSymbol";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getType";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static final class TokenSets {
        public static final BracePair[] BRACE_PAIRS = new BracePair[]{new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_PAREN, (IElementType)SqlCommonTokens.SQL_RIGHT_PAREN, true), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACE, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACE, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_BRACKET, (IElementType)SqlCommonTokens.SQL_RIGHT_BRACKET, false), new BracePair((IElementType)SqlCommonTokens.SQL_LEFT_ANGLES, (IElementType)SqlCommonTokens.SQL_RIGHT_ANGLES, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_RQUOTE, false), new BracePair((IElementType)SqlTokens.SQL_CUSTOM_PARAM_LQUOTE, (IElementType)SqlTokens.SQL_CUSTOM_PARAM_RQUOTE, false)};
    }
}

