/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.stubs.StubElement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlTableColumnsList;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKIFKImpl;
import com.intellij.sql.psi.impl.SqlPsiElementFactory;
import com.intellij.sql.psi.stubs.SqlDefinitionExStubElementType;
import com.intellij.sql.psi.stubs.SqlDefinitionStub;
import com.intellij.util.io.StringRef;
import org.jetbrains.annotations.NotNull;

public class SqlTableKeyStub<T extends SqlDefinition>
extends SqlDefinitionStub<T> {
    private final StringRef myKeyText;
    private SqlTableColumnsList myColumnList;

    protected SqlTableKeyStub(StubElement<?> parent, @NotNull SqlDefinitionExStubElementType<? extends SqlTableKeyStub<T>, T> type, StringRef name, SqlDefinitionStub.ModelInfo info, StringRef keyText) {
        if (type == null) {
            SqlTableKeyStub.$$$reportNull$$$0(0);
        }
        super(parent, type, name, info);
        this.myKeyText = keyText;
    }

    public String getKeyText() {
        return this.myKeyText == null ? null : this.myKeyText.getString();
    }

    public SqlTableColumnsList getKeyColumnList() {
        if (this.myColumnList == null) {
            this.myColumnList = this.createTableColumnsList(this.getKeyText());
        }
        return this.myColumnList;
    }

    protected SqlTableColumnsList createTableColumnsList(String text) {
        if (StringUtil.isNotEmpty((String)text)) {
            SqlKIFKImpl psi = (SqlKIFKImpl)this.getPsi();
            return SqlPsiElementFactory.createTableColumnListFromText(text, SqlImplUtil.getSqlDialectSafe((PsiElement)psi), (PsiElement)psi);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/sql/psi/stubs/SqlTableKeyStub", "<init>"));
    }
}

