/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javaee.build.jspValidation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.artifacts.ArtifactBuildTarget;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.javaee.build.jspValidation.JspValidationRootDescriptor;
import org.jetbrains.jps.javaee.model.app.EarArtifactType;
import org.jetbrains.jps.javaee.model.web.WebArtifactType;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactService;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactOutputPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;

public final class JspValidationTarget
extends BuildTarget<JspValidationRootDescriptor> {
    public static final Type TYPE = new Type();
    public static final String TYPE_ID = "jsp-validation";
    private final JpsArtifact myWebArtifact;
    private final Collection<JpsArtifact> myParentEars;

    public JspValidationTarget(@NotNull JpsArtifact webArtifact, @NotNull Collection<JpsArtifact> parentEars) {
        if (webArtifact == null) {
            JspValidationTarget.$$$reportNull$$$0(0);
        }
        if (parentEars == null) {
            JspValidationTarget.$$$reportNull$$$0(1);
        }
        super((BuildTargetType)TYPE);
        this.myWebArtifact = webArtifact;
        this.myParentEars = parentEars;
    }

    @NotNull
    public String getId() {
        String string = this.myWebArtifact.getName();
        if (string == null) {
            JspValidationTarget.$$$reportNull$$$0(2);
        }
        return string;
    }

    public JpsArtifact getArtifact() {
        return this.myWebArtifact;
    }

    public Collection<JpsArtifact> getParentEars() {
        return this.myParentEars;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JspValidationTarget && this.getId().equals(((JspValidationTarget)((Object)obj)).getId());
    }

    @NotNull
    public Collection<BuildTarget<?>> computeDependencies(@NotNull BuildTargetRegistry targetRegistry, @NotNull TargetOutputIndex outputIndex) {
        if (targetRegistry == null) {
            JspValidationTarget.$$$reportNull$$$0(3);
        }
        if (outputIndex == null) {
            JspValidationTarget.$$$reportNull$$$0(4);
        }
        SmartList dependencies = new SmartList((Object)new ArtifactBuildTarget(this.myWebArtifact));
        for (JpsArtifact parentEar : this.myParentEars) {
            dependencies.add(new ArtifactBuildTarget(parentEar));
        }
        SmartList smartList = dependencies;
        if (smartList == null) {
            JspValidationTarget.$$$reportNull$$$0(5);
        }
        return smartList;
    }

    @NotNull
    public List<JspValidationRootDescriptor> computeRootDescriptors(@NotNull JpsModel model, @NotNull ModuleExcludeIndex index, @NotNull IgnoredFileIndex ignoredFileIndex, @NotNull BuildDataPaths dataPaths) {
        String outputPath;
        if (model == null) {
            JspValidationTarget.$$$reportNull$$$0(6);
        }
        if (index == null) {
            JspValidationTarget.$$$reportNull$$$0(7);
        }
        if (ignoredFileIndex == null) {
            JspValidationTarget.$$$reportNull$$$0(8);
        }
        if (dataPaths == null) {
            JspValidationTarget.$$$reportNull$$$0(9);
        }
        List<JspValidationRootDescriptor> list = (outputPath = this.myWebArtifact.getOutputPath()) != null ? Collections.singletonList(new JspValidationRootDescriptor(new File(outputPath), this)) : Collections.emptyList();
        if (list == null) {
            JspValidationTarget.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public JspValidationRootDescriptor findRootDescriptor(@NotNull String rootId, @NotNull BuildRootIndex rootIndex) {
        if (rootId == null) {
            JspValidationTarget.$$$reportNull$$$0(11);
        }
        if (rootIndex == null) {
            JspValidationTarget.$$$reportNull$$$0(12);
        }
        List descriptors = rootIndex.getRootDescriptors(new File(rootId), Collections.singletonList(TYPE), null);
        return (JspValidationRootDescriptor)((Object)ContainerUtil.getFirstItem((List)descriptors));
    }

    @NotNull
    public String getPresentableName() {
        String string = "Validate JSPs in '" + this.myWebArtifact.getName() + "'";
        if (string == null) {
            JspValidationTarget.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "webArtifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentEars";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/javaee/build/jspValidation/JspValidationTarget";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetRegistry";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputIndex";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "index";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoredFileIndex";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPaths";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootId";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootIndex";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/javaee/build/jspValidation/JspValidationTarget";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeDependencies";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "computeRootDescriptors";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "computeDependencies";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "computeRootDescriptors";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRootDescriptor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 10: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @ApiStatus.Internal
    public static final class Type
    extends BuildTargetType<JspValidationTarget> {
        private Type() {
            super(JspValidationTarget.TYPE_ID, true);
        }

        @NotNull
        public List<JspValidationTarget> computeAllTargets(@NotNull JpsModel model) {
            if (model == null) {
                Type.$$$reportNull$$$0(0);
            }
            List artifacts = JpsArtifactService.getInstance().getArtifacts(model.getProject());
            ArrayList<JpsArtifact> webArtifacts = new ArrayList<JpsArtifact>();
            HashMap<JpsArtifact, Set> webToParentEar = new HashMap<JpsArtifact, Set>();
            for (JpsArtifact artifact : artifacts) {
                if (StringUtil.isEmpty((String)artifact.getOutputPath())) continue;
                JpsArtifactType artifactType = artifact.getArtifactType();
                if (artifactType.equals((Object)WebArtifactType.EXPLODED)) {
                    webArtifacts.add(artifact);
                    continue;
                }
                if (!artifactType.equals((Object)EarArtifactType.EXPLODED)) continue;
                for (JpsArtifact includedWeb : Type.getIncludedWebArtifacts(artifact)) {
                    webToParentEar.computeIfAbsent(includedWeb, __ -> new HashSet()).add(artifact);
                }
            }
            SmartList targets = new SmartList();
            Iterator iterator = webArtifacts.iterator();
            while (iterator.hasNext()) {
                JpsArtifact webArtifact;
                Collection ears = (Collection)webToParentEar.get(webArtifact = (JpsArtifact)iterator.next());
                targets.add(new JspValidationTarget(webArtifact, ears == null ? Collections.emptySet() : ears));
            }
            SmartList smartList = targets;
            if (smartList == null) {
                Type.$$$reportNull$$$0(1);
            }
            return smartList;
        }

        private static List<JpsArtifact> getIncludedWebArtifacts(JpsArtifact earArtifact) {
            ArrayList<JpsArtifact> included = new ArrayList<JpsArtifact>();
            for (JpsPackagingElement child : earArtifact.getRootElement().getChildren()) {
                if (!(child instanceof JpsCompositePackagingElement)) continue;
                for (JpsPackagingElement grandChild : ((JpsCompositePackagingElement)child).getChildren()) {
                    JpsArtifact includedArtifact;
                    if (!(grandChild instanceof JpsArtifactOutputPackagingElement) || (includedArtifact = (JpsArtifact)((JpsArtifactOutputPackagingElement)grandChild).getArtifactReference().resolve()) == null || !includedArtifact.getArtifactType().equals((Object)WebArtifactType.EXPLODED)) continue;
                    included.add(includedArtifact);
                }
            }
            return included;
        }

        @NotNull
        public BuildTargetLoader<JspValidationTarget> createLoader(@NotNull JpsModel model) {
            if (model == null) {
                Type.$$$reportNull$$$0(2);
            }
            final Map targetById = this.computeAllTargets(model).stream().collect(Collectors.toMap(t -> t.getId(), Function.identity()));
            return new BuildTargetLoader<JspValidationTarget>(){

                @Nullable
                public JspValidationTarget createTarget(@NotNull String targetId) {
                    if (targetId == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return (JspValidationTarget)((Object)targetById.get(targetId));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetId", "org/jetbrains/jps/javaee/build/jspValidation/JspValidationTarget$Type$1", "createTarget"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "model";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/jps/javaee/build/jspValidation/JspValidationTarget$Type";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/jps/javaee/build/jspValidation/JspValidationTarget$Type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "computeAllTargets";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "computeAllTargets";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "createLoader";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

