/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion.common;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUiKind;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionResult;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.InitialConfigImportState;
import com.intellij.platform.trialPromotion.common.TrialStateService;
import com.intellij.platform.trialPromotion.common.TrialStateUtilsKt;
import com.intellij.ui.LicensingFacade;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.channels.ProduceKt;
import kotlinx.coroutines.channels.ProducerScope;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u0004\u0018\u00010\u0006J\u0006\u0010\u0007\u001a\u00020\u0005J\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\n\u001a\u00020\tJG\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0013J\u0019\u0010\u0014\u001a\u00020\u0005*\u00020\f2\u0006\u0010\u0015\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0016J\u0006\u0010\u0017\u001a\u00020\u0018J\n\u0010\u0019\u001a\u00020\u0005*\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00052\b\b\u0002\u0010\u001c\u001a\u00020\u0005J\b\u0010\u001e\u001a\u00020\u0005H\u0002J\b\u0010\u001f\u001a\u00020\u0005H\u0002Jt\u0010 \u001a\b\u0012\u0004\u0012\u0002H\"0!\"\b\b\u0000\u0010#*\u00020\u0001\"\u0004\b\u0001\u0010\"*\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\"0(2-\u0010)\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0+\u0012\n\u0012\b\u0012\u0004\u0012\u0002H#0,\u0012\u0006\u0012\u0004\u0018\u00010\u00010*\u00a2\u0006\u0002\b-H\u0000\u00a2\u0006\u0004\b.\u0010/Jj\u00100\u001a\b\u0012\u0004\u0012\u0002H\"01\"\b\b\u0000\u0010#*\u00020\u0001\"\u0004\b\u0001\u0010\"*\u00020$2\u0006\u00102\u001a\u0002032\f\u0010%\u001a\b\u0012\u0004\u0012\u0002H#0&2\f\u0010'\u001a\b\u0012\u0004\u0012\u0002H\"0(2\u001d\u0010)\u001a\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"05\u0012\u0004\u0012\u0002H#04\u00a2\u0006\u0002\b-H\u0000\u00a2\u0006\u0002\b6R\u000e\u0010\u001d\u001a\u00020\u000eX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/platform/trialPromotion/common/TrialStateUtils;", "", "<init>", "()V", "hasPlatformProductLicense", "", "Lcom/intellij/ui/LicensingFacade;", "isNonEvaluationLicenseActive", "getGracePeriodDays", "", "getTrialLengthDays", "showRegister", "Lcom/intellij/openapi/actionSystem/AnActionResult;", "productCode", "", "requestTrial", "requestRevalidate", "tryRequestTrial", "showTrialDialog", "(Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/intellij/openapi/actionSystem/AnActionResult;", "getAndLogActionResult", "action", "getAndLogActionResult$intellij_platform_trialPromotion_common", "openTrialStateTab", "", "isBeforeToday", "", "isEligibleForAutoTrial", "checkTrialState", "LS_URL_ENVIRONMENT_VAR", "isLicenseServerUrlSpecified", "isImportedConfigOldEnough", "subscribeAsFlow", "Lkotlinx/coroutines/flow/Flow;", "TValue", "TListener", "Lcom/intellij/util/messages/MessageBus;", "topic", "Lcom/intellij/util/messages/Topic;", "valueProvider", "Lkotlin/Function0;", "listenerProvider", "Lkotlin/Function2;", "Lkotlinx/coroutines/channels/ProducerScope;", "Lkotlin/coroutines/Continuation;", "Lkotlin/ExtensionFunctionType;", "subscribeAsFlow$intellij_platform_trialPromotion_common", "(Lcom/intellij/util/messages/MessageBus;Lcom/intellij/util/messages/Topic;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function2;)Lkotlinx/coroutines/flow/Flow;", "subscribeAsStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "Lkotlin/Function1;", "Lkotlinx/coroutines/flow/MutableStateFlow;", "subscribeAsStateFlow$intellij_platform_trialPromotion_common", "intellij.platform.trialPromotion.common"})
@SourceDebugExtension(value={"SMAP\nTrialStateUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TrialStateUtils.kt\ncom/intellij/platform/trialPromotion/common/TrialStateUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n1#2:197\n*E\n"})
public final class TrialStateUtils {
    @NotNull
    public static final TrialStateUtils INSTANCE = new TrialStateUtils();
    @NotNull
    private static final String LS_URL_ENVIRONMENT_VAR = "JETBRAINS_LICENSE_SERVER";

    private TrialStateUtils() {
    }

    public final boolean hasPlatformProductLicense(@Nullable LicensingFacade $this$hasPlatformProductLicense) {
        LicensingFacade licensingFacade = $this$hasPlatformProductLicense;
        return (licensingFacade != null ? licensingFacade.getConfirmationStamp($this$hasPlatformProductLicense.platformProductCode) : null) != null;
    }

    public final boolean isNonEvaluationLicenseActive() {
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return false;
        }
        LicensingFacade licensingFacade2 = licensingFacade;
        return this.hasPlatformProductLicense(licensingFacade2) && !licensingFacade2.isEvaluation;
    }

    public final int getGracePeriodDays() {
        Object object = LicensingFacade.getInstance();
        return object != null && (object = ((LicensingFacade)object).gracePeriodDays) != null ? (Integer)object : 0;
    }

    public final int getTrialLengthDays() {
        Date date;
        LicensingFacade licensingFacade = LicensingFacade.getInstance();
        if (licensingFacade == null) {
            return 0;
        }
        LicensingFacade license = licensingFacade;
        Date date2 = license.getLicenseExpirationDate();
        if (date2 == null) {
            return 0;
        }
        Date expirationDate = date2;
        String metadata = license.metadata;
        if (metadata == null || metadata.length() < 20) {
            return 0;
        }
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd", Locale.ENGLISH);
            String string = metadata.substring(2, 10);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            date = simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return 0;
        }
        Date generationDate = date;
        long result = Math.max(ChronoUnit.DAYS.between(generationDate.toInstant(), expirationDate.toInstant()), 0L);
        return (int)result;
    }

    @NotNull
    public final AnActionResult showRegister(@Nullable String productCode, @Nullable Boolean requestTrial, @Nullable Boolean requestRevalidate, @Nullable Boolean tryRequestTrial, @Nullable Boolean showTrialDialog) {
        ActionManager actionManager = ActionManager.getInstance();
        AnAction anAction = actionManager.getAction("Register");
        if (anAction == null) {
            return (AnActionResult)new AnActionResult.Ignored("Register action not found");
        }
        AnAction registerAction = anAction;
        DataContext dataContext = arg_0 -> TrialStateUtils.showRegister$lambda$0(productCode, requestRevalidate, requestTrial, tryRequestTrial, showTrialDialog, arg_0);
        AnActionEvent anActionEvent = AnActionEvent.createEvent((DataContext)dataContext, null, (String)"", (ActionUiKind)ActionUiKind.NONE, null);
        Intrinsics.checkNotNullExpressionValue((Object)anActionEvent, (String)"createEvent(...)");
        AnActionEvent event = anActionEvent;
        return ActionUtil.performAction((AnAction)registerAction, (AnActionEvent)event);
    }

    public static /* synthetic */ AnActionResult showRegister$default(TrialStateUtils trialStateUtils, String string, Boolean bl, Boolean bl2, Boolean bl3, Boolean bl4, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = null;
        }
        if ((n & 4) != 0) {
            bl2 = null;
        }
        if ((n & 8) != 0) {
            bl3 = null;
        }
        if ((n & 0x10) != 0) {
            bl4 = null;
        }
        return trialStateUtils.showRegister(string, bl, bl2, bl3, bl4);
    }

    public final boolean getAndLogActionResult$intellij_platform_trialPromotion_common(@NotNull AnActionResult $this$getAndLogActionResult, @NotNull String action) {
        Intrinsics.checkNotNullParameter((Object)$this$getAndLogActionResult, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)action, (String)"action");
        AnActionResult anActionResult = $this$getAndLogActionResult;
        if (anActionResult instanceof AnActionResult.Failed) {
            TrialStateUtilsKt.getTrialLogger().warn(action + " failed", ((AnActionResult.Failed)$this$getAndLogActionResult).getCause());
        } else if (anActionResult instanceof AnActionResult.Ignored) {
            TrialStateUtilsKt.getTrialLogger().warn(action + " ignored: " + ((AnActionResult.Ignored)$this$getAndLogActionResult).getReason());
        } else {
            if (anActionResult instanceof AnActionResult.Performed) {
                TrialStateUtilsKt.getTrialLogger().info(action + " performed");
                return true;
            }
            throw new NoWhenBranchMatchedException();
        }
        return false;
    }

    public final void openTrialStateTab() {
        AnAction action = ActionManager.getInstance().getAction("TrialStateWidget");
        if (action != null) {
            ActionManager.getInstance().tryToExecute(action, null, null, "MainToolbar", false);
        }
    }

    public final boolean isBeforeToday(long $this$isBeforeToday) {
        LocalDateTime time = Instant.ofEpochMilli($this$isBeforeToday).atZone(ZoneId.systemDefault()).toLocalDateTime();
        LocalDateTime startOfDay = LocalDate.now().atStartOfDay();
        return time.isBefore(startOfDay);
    }

    public final boolean isEligibleForAutoTrial(boolean checkTrialState) {
        if (!checkTrialState || TrialStateService.Companion.isTrialAvailable()) {
            if (this.isLicenseServerUrlSpecified()) {
                TrialStateUtilsKt.getTrialLogger().info("[auto-trial check] License server URL is specified. Auto-trial will be skipped");
                return false;
            }
            if (InitialConfigImportState.isNewUser()) {
                TrialStateUtilsKt.getTrialLogger().info("[auto-trial check] Eligible for auto-trial: a new user");
                return true;
            }
            if (this.isImportedConfigOldEnough()) {
                TrialStateUtilsKt.getTrialLogger().info("[auto-trial check] Eligible for auto-trial: the imported config is old");
                return true;
            }
            TrialStateUtilsKt.getTrialLogger().info("[auto-trial check] Not eligible for auto-trial: the user is not new or imported config is not old enough");
        } else {
            TrialStateUtilsKt.getTrialLogger().info("[auto-trial check] Trial is not available");
        }
        return false;
    }

    public static /* synthetic */ boolean isEligibleForAutoTrial$default(TrialStateUtils trialStateUtils, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return trialStateUtils.isEligibleForAutoTrial(bl);
    }

    private final boolean isLicenseServerUrlSpecified() {
        String systemProperty;
        String envVar;
        String string = EnvironmentUtil.getValue((String)LS_URL_ENVIRONMENT_VAR);
        if (string != null) {
            String string2;
            String it = string2 = string;
            boolean bl = false;
            v1 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
        } else {
            v1 = envVar = null;
        }
        if (envVar != null) {
            TrialStateUtilsKt.getTrialLogger().debug("License server URL is specified via environment variable");
            return true;
        }
        String string3 = System.getProperty(LS_URL_ENVIRONMENT_VAR, null);
        if (string3 != null) {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            v3 = !StringsKt.isBlank((CharSequence)it) ? string4 : null;
        } else {
            v3 = systemProperty = null;
        }
        if (systemProperty != null) {
            TrialStateUtilsKt.getTrialLogger().debug("License server URL is specified via system property");
            return true;
        }
        return false;
    }

    private final boolean isImportedConfigOldEnough() {
        String string = System.getProperty("intellij.config.imported.from");
        if (string == null) {
            return false;
        }
        String configFolder = string;
        Path configFolderPath = Path.of(configFolder, new String[0]);
        Intrinsics.checkNotNull((Object)configFolderPath);
        Matcher matcher = ConfigImportHelper.SELECTOR_PATTERN.matcher(PathsKt.getName((Path)configFolderPath));
        if (!matcher.matches()) {
            return false;
        }
        FileTime fileTime = ConfigImportHelper.getConfigLastModifiedTime((Path)configFolderPath);
        if (fileTime == null) {
            return false;
        }
        FileTime lastModified = fileTime;
        return ConfigImportHelper.isConfigOld((FileTime)lastModified);
    }

    @NotNull
    public final <TListener, TValue> Flow<TValue> subscribeAsFlow$intellij_platform_trialPromotion_common(@NotNull MessageBus $this$subscribeAsFlow, @NotNull Topic<TListener> topic, @NotNull Function0<? extends TValue> valueProvider, @NotNull Function2<? super ProducerScope<? super TValue>, ? super Continuation<? super TListener>, ? extends Object> listenerProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$subscribeAsFlow, (String)"<this>");
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(valueProvider, (String)"valueProvider");
        Intrinsics.checkNotNullParameter(listenerProvider, (String)"listenerProvider");
        return FlowKt.callbackFlow((Function2)new Function2<ProducerScope<? super TValue>, Continuation<? super Unit>, Object>($this$subscribeAsFlow, topic, listenerProvider, valueProvider, null){
            Object L$1;
            Object L$2;
            Object L$3;
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ MessageBus $this_subscribeAsFlow;
            final /* synthetic */ Topic<TListener> $topic;
            final /* synthetic */ Function2<ProducerScope<? super TValue>, Continuation<? super TListener>, Object> $listenerProvider;
            final /* synthetic */ Function0<TValue> $valueProvider;
            {
                this.$this_subscribeAsFlow = $receiver;
                this.$topic = $topic;
                this.$listenerProvider = $listenerProvider;
                this.$valueProvider = $valueProvider;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (ProducerScope)this.L$0;
                var7_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        connection = this.$this_subscribeAsFlow.connect((CoroutineScope)$this$callbackFlow);
                        var5_6 = this.$topic;
                        var4_7 = connection;
                        this.L$0 = $this$callbackFlow;
                        this.L$1 = connection;
                        this.L$2 = var4_7;
                        this.L$3 = var5_6;
                        this.label = 1;
                        v0 = this.$listenerProvider.invoke((Object)$this$callbackFlow, (Object)this);
                        if (v0 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl24
                    }
                    case 1: {
                        var5_6 = (Topic<TListener>)this.L$3;
                        var4_7 = (SimpleMessageBusConnection)this.L$2;
                        connection = (SimpleMessageBusConnection)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        var6_8 = v0;
                        var4_7.subscribe(var5_6, var6_8);
                        this.L$0 = $this$callbackFlow;
                        this.L$1 = connection;
                        this.L$2 = null;
                        this.L$3 = null;
                        this.label = 2;
                        v1 = $this$callbackFlow.send(this.$valueProvider.invoke(), (Continuation)this);
                        if (v1 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        connection = (SimpleMessageBusConnection)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl39:
                        // 2 sources

                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)$this$callbackFlow);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)connection);
                        this.label = 3;
                        v2 = ProduceKt.awaitClose((ProducerScope)$this$callbackFlow, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, invokeSuspend$lambda$0(com.intellij.util.messages.SimpleMessageBusConnection ), ()Lkotlin/Unit;)((SimpleMessageBusConnection)connection), (Continuation)((Continuation)this));
                        if (v2 == var7_3) {
                            return var7_3;
                        }
                        ** GOTO lbl50
                    }
                    case 3: {
                        connection = (SimpleMessageBusConnection)this.L$1;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl50:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(ProducerScope<? super TValue> p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }

            private static final Unit invokeSuspend$lambda$0(SimpleMessageBusConnection $connection) {
                $connection.disconnect();
                return Unit.INSTANCE;
            }
        });
    }

    @NotNull
    public final <TListener, TValue> StateFlow<TValue> subscribeAsStateFlow$intellij_platform_trialPromotion_common(@NotNull MessageBus $this$subscribeAsStateFlow, @NotNull CoroutineScope scope, @NotNull Topic<TListener> topic, @NotNull Function0<? extends TValue> valueProvider, @NotNull Function1<? super MutableStateFlow<TValue>, ? extends TListener> listenerProvider) {
        MutableStateFlow mutableStateFlow;
        Intrinsics.checkNotNullParameter((Object)$this$subscribeAsStateFlow, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter(topic, (String)"topic");
        Intrinsics.checkNotNullParameter(valueProvider, (String)"valueProvider");
        Intrinsics.checkNotNullParameter(listenerProvider, (String)"listenerProvider");
        MutableStateFlow mutableState = mutableStateFlow = StateFlowKt.MutableStateFlow((Object)valueProvider.invoke());
        boolean bl = false;
        SimpleMessageBusConnection connection = $this$subscribeAsStateFlow.connect(scope);
        connection.subscribe(topic, listenerProvider.invoke((Object)mutableState));
        mutableState.setValue(valueProvider.invoke());
        return FlowKt.asStateFlow((MutableStateFlow)mutableStateFlow);
    }

    private static final Object showRegister$lambda$0(String $productCode, Boolean $requestRevalidate, Boolean $requestTrial, Boolean $tryRequestTrial, Boolean $showTrialDialog, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return switch (it) {
            case "register.product-descriptor.code" -> $productCode;
            case "register.request.revalidate" -> $requestRevalidate;
            case "register.request.trial" -> $requestTrial;
            case "register.try.request.trial" -> $tryRequestTrial;
            case "register.show.trial.dialog" -> $showTrialDialog;
            default -> null;
        };
    }
}

