/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.mysqlbase;

import com.intellij.analysis.AnalysisBundle;
import com.intellij.database.DatabaseBundle;
import com.intellij.database.Dbms;
import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.console.JdbcConsoleRunContext;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.DatabaseDriverClasspathManager;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactContext;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactList;
import com.intellij.database.dataSource.artifacts.DatabaseArtifactManager;
import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dataSource.url.ParamEditor;
import com.intellij.database.dataSource.url.TypeDescriptorUi;
import com.intellij.database.dataSource.url.TypesRegistryUi;
import com.intellij.database.dataSource.url.ui.BaseTypeDescriptor;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.database.dataSource.url.ui.TextParamEditor;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.DatabaseFixFactory;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MysqlSocketParamEditor
extends TextParamEditor {
    MysqlSocketParamEditor(@NotNull DataInterchange interchange, @NlsContexts.Label @NotNull String caption) {
        if (interchange == null) {
            MysqlSocketParamEditor.$$$reportNull$$$0(0);
        }
        if (caption == null) {
            MysqlSocketParamEditor.$$$reportNull$$$0(1);
        }
        super(interchange, caption, FieldSize.LARGE, new AnAction[0]);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setHideIgnored(false);
        descriptor.setTitle(DatabaseBundle.message((String)"dialog.title.choose.socket.location", (Object[])new Object[0]));
        this.addButton((AnAction)new ParamEditorBase.FMChooseAction(descriptor));
    }

    protected void fireChanged() {
        if (StringUtil.isEmpty((String)this.getInterchange().getProperty("socketFactory"))) {
            this.getInterchange().putProperty("socketFactory", "org.newsclub.net.mysql.AFUNIXDatabaseSocketFactory");
        }
        super.fireChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "interchange";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caption";
                break;
            }
        }
        objectArray[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class Validator
    extends DatabaseConfigValidator<LocalDataSource> {
        public static final String JUS_ARTIFACT = "junixsocket-mysql";
        public static final String JNA_PLATFORM_ARTIFACT = "jna-platform";

        Validator() {
        }

        public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
            if (project == null) {
                Validator.$$$reportNull$$$0(0);
            }
            if (target == null) {
                Validator.$$$reportNull$$$0(1);
            }
            if (problems == null) {
                Validator.$$$reportNull$$$0(2);
            }
            if (!target.getDbms().in(Dbms.MYSQL_LIKE)) {
                return;
            }
            String url = target.getUrl();
            if (url == null) {
                return;
            }
            if (StringUtil.containsIgnoreCase((String)url, (String)"junixsocket.file=")) {
                this.suggestDep(project, target, problems, (Condition<LocalDataSource>)((Condition)p -> Validator.hasJUS(p, project)), Validator::findJUS);
            } else if (StringUtil.containsIgnoreCase((String)url, (String)"localSocket=")) {
                this.suggestDep(project, target, problems, (Condition<LocalDataSource>)((Condition)p -> Validator.hasJNA(p, project)), Validator::findJNA);
            }
        }

        private void suggestDep(final @NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @NotNull Condition<LocalDataSource> artifactCheck, @NotNull Supplier<// Could not load outer class - annotation placement on inner may be incorrect
         @Nullable DatabaseArtifactList.ArtifactVersion> artifact) {
            DatabaseDriver driver;
            if (project == null) {
                Validator.$$$reportNull$$$0(3);
            }
            if (target == null) {
                Validator.$$$reportNull$$$0(4);
            }
            if (problems == null) {
                Validator.$$$reportNull$$$0(5);
            }
            if (artifactCheck == null) {
                Validator.$$$reportNull$$$0(6);
            }
            if (artifact == null) {
                Validator.$$$reportNull$$$0(7);
            }
            if ((driver = target.getDatabaseDriver()) != null && !artifactCheck.value((Object)target)) {
                DatabaseFixFactory fixFactory = DatabaseFixFactory.getInstance();
                final ErrorInfo.Fix setUpFix = fixFactory == null ? null : fixFactory.setUpArtifact(driver, false, artifact);
                FixWithProgress fix = setUpFix == null ? null : new FixWithProgress(this, setUpFix.getName()){

                    public void run(@NotNull ProgressIndicator indicator, @Nullable DatabaseConfigEditor editor) {
                        if (indicator == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        ApplicationManager.getApplication().invokeAndWait(() -> DataSourceUiUtil.applyFix((Project)project, (ErrorInfo.Fix)setUpFix, (DatabaseConfigEditor)editor));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Validator$1", "run"));
                    }
                };
                problems.consume((Object)new DataSourceProblem((Object)target, (Object)this, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(AnalysisBundle.message((String)"notification.title.unix.socket.connection", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required.href.action0.download", (Object[])new Object[0]), DatabaseBundle.message((String)"notification.content.extra.libraries.required", (Object[])new Object[0]), new Object[]{fix}), fix));
            }
        }

        public Class<? extends LocalDataSource> getTargetClass() {
            return LocalDataSource.class;
        }

        private static boolean hasJUS(@NotNull LocalDataSource target, @NotNull Project project) {
            DatabaseDriver.ArtifactRef jus;
            DatabaseDriver driver;
            if (target == null) {
                Validator.$$$reportNull$$$0(8);
            }
            if (project == null) {
                Validator.$$$reportNull$$$0(9);
            }
            if ((driver = target.getDatabaseDriver()) != null && (jus = (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)driver.getArtifacts(), a -> a.getId().equals(JUS_ARTIFACT))) != null) {
                return true;
            }
            return JdbcConsoleRunContext.expandPackUrls((List)DatabaseDriverClasspathManager.Companion.getInstance(project).getClasspathElements(target), (DatabaseArtifactContext)DatabaseArtifactContext.Companion.getInstance(project, target.getDatabaseDriver())).find(u -> u.contains(JUS_ARTIFACT)) != null;
        }

        private static boolean hasJNA(@NotNull LocalDataSource target, @NotNull Project project) {
            DatabaseDriver.ArtifactRef jus;
            DatabaseDriver driver;
            if (target == null) {
                Validator.$$$reportNull$$$0(10);
            }
            if (project == null) {
                Validator.$$$reportNull$$$0(11);
            }
            if ((driver = target.getDatabaseDriver()) != null && (jus = (DatabaseDriver.ArtifactRef)ContainerUtil.find((Iterable)driver.getArtifacts(), a -> a.getId().equals(JNA_PLATFORM_ARTIFACT))) != null) {
                return true;
            }
            return JdbcConsoleRunContext.expandPackUrls((List)DatabaseDriverClasspathManager.Companion.getInstance(project).getClasspathElements(target), (DatabaseArtifactContext)DatabaseArtifactContext.Companion.getInstance(project, target.getDatabaseDriver())).find(u -> u.contains(JNA_PLATFORM_ARTIFACT)) != null;
        }

        @Nullable
        private static DatabaseArtifactList.ArtifactVersion findJUS() {
            return DatabaseArtifactManager.getArtifacts().resolveVersion(JUS_ARTIFACT, null, "stable", null);
        }

        @Nullable
        private static DatabaseArtifactList.ArtifactVersion findJNA() {
            return DatabaseArtifactManager.getArtifacts().resolveVersion(JNA_PLATFORM_ARTIFACT, null, "stable", null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 4: 
                case 8: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problems";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifactCheck";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "artifact";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Validator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectProblems";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[2] = "suggestDep";
                    break;
                }
                case 8: 
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasJUS";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasJNA";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Factory
    implements TypesRegistryUi.TypeDescriptorUiFactory {
        Factory() {
        }

        public void createTypeDescriptor(@NotNull Consumer<? super TypeDescriptorUi> consumer) {
            if (consumer == null) {
                Factory.$$$reportNull$$$0(0);
            }
            consumer.consume((Object)new BaseTypeDescriptor(this, "mysql.socket"){

                @NotNull
                protected ParamEditor createFieldImpl(@NlsContexts.Label @NotNull String caption, @Nullable String configuration, @NotNull DataInterchange interchange) {
                    if (caption == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (interchange == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return new MysqlSocketParamEditor(interchange, caption);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "caption";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "interchange";
                            break;
                        }
                    }
                    objectArray[1] = "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Factory$1";
                    objectArray[2] = "createFieldImpl";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/dialects/mysqlbase/MysqlSocketParamEditor$Factory", "createTypeDescriptor"));
        }
    }
}

