/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.template;

import com.intellij.codeInsight.template.TemplateActionContext;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.filters.FilterPositionUtil;
import com.intellij.spring.mvc.SpringControllerUtils;
import com.intellij.spring.mvc.SpringMvcBundle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/mvc/template/BaseSpringMvcTemplateContextType;", "Lcom/intellij/codeInsight/template/TemplateContextType;", "languageId", "", "<init>", "(Ljava/lang/String;)V", "getLanguageId", "()Ljava/lang/String;", "isInContext", "", "templateActionContext", "Lcom/intellij/codeInsight/template/TemplateActionContext;", "intellij.spring.mvc.impl"})
public abstract class BaseSpringMvcTemplateContextType
extends TemplateContextType {
    @NotNull
    private final String languageId;

    public BaseSpringMvcTemplateContextType(@NotNull String languageId) {
        Intrinsics.checkNotNullParameter((Object)languageId, (String)"languageId");
        super(SpringMvcBundle.message("mvc.framework.name", new Object[0]));
        this.languageId = languageId;
    }

    @NotNull
    public final String getLanguageId() {
        return this.languageId;
    }

    public boolean isInContext(@NotNull TemplateActionContext templateActionContext) {
        Intrinsics.checkNotNullParameter((Object)templateActionContext, (String)"templateActionContext");
        PsiFile psiFile = templateActionContext.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile psiFile2 = psiFile;
        if (!Intrinsics.areEqual((Object)psiFile2.getLanguage().getID(), (Object)this.languageId)) {
            return false;
        }
        Project project = psiFile2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (DumbService.Companion.isDumb(project)) {
            return false;
        }
        PsiElement psiElement = psiFile2.findElementAt(templateActionContext.getStartOffset() - 1);
        if (psiElement == null) {
            return false;
        }
        PsiElement psiElementAtCaret = psiElement;
        if (psiElementAtCaret instanceof PsiComment) {
            return false;
        }
        PsiElement prevElement = FilterPositionUtil.searchNonSpaceNonCommentBack((PsiElement)psiElementAtCaret);
        if (prevElement instanceof PsiKeyword) {
            return false;
        }
        Class[] classArray = new Class[]{UMethod.class, UClass.class};
        UElement uParentAtCaret = UastContextKt.getUastParentOfTypes((PsiElement)psiElementAtCaret.getParent(), (Class[])classArray, (boolean)false);
        if (uParentAtCaret instanceof UMethod) {
            return false;
        }
        UClass uClass = uParentAtCaret instanceof UClass ? (UClass)uParentAtCaret : null;
        if (uClass == null) {
            return false;
        }
        UClass uParentClass = uClass;
        return SpringControllerUtils.isController(uParentClass.getJavaPsi());
    }
}

