/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.mvc.webClient.mockMvc;

import com.intellij.microservices.jvm.cache.ScopedCacheValueHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.spring.model.utils.SpringFunctionalSearchersUtils;
import com.intellij.spring.mvc.functional.webClient.WebClientHolder;
import com.intellij.spring.mvc.functional.webClient.WebClientUrl;
import com.intellij.spring.mvc.webClient.SpringWebClientModel;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcConstants;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcMethod;
import com.intellij.spring.mvc.webClient.mockMvc.MockMvcUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0012\u0010\u0010\u001a\u00020\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0016J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\t2\u0006\u0010\u0015\u001a\u00020\u0016H\u0014J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\t2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0016J\u000e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0014J\b\u0010\u001c\u001a\u00020\u0005H\u0014\u00a8\u0006\u001d"}, d2={"Lcom/intellij/spring/mvc/webClient/mockMvc/MockMvcModel;", "Lcom/intellij/spring/mvc/webClient/SpringWebClientModel;", "<init>", "()V", "findHttpMethod", "", "urlNode", "Lorg/jetbrains/uast/UCallExpression;", "getEndpoints", "", "Lcom/intellij/spring/mvc/functional/webClient/WebClientUrl;", "group", "Lcom/intellij/spring/mvc/functional/webClient/WebClientHolder;", "findMockMvcEndpoints", "holderPsi", "Lcom/intellij/psi/PsiElement;", "findBaseUrl", "uExpression", "Lorg/jetbrains/uast/UExpression;", "getUrlApiMethods", "Lcom/intellij/psi/PsiMethod;", "module", "Lcom/intellij/openapi/module/Module;", "getApiClasses", "Lcom/intellij/psi/PsiClass;", "query", "Lcom/intellij/microservices/jvm/cache/ScopedCacheValueHolder;", "getPackageBlackList", "getWebClientPackage", "intellij.spring.mvc.impl"})
@SourceDebugExtension(value={"SMAP\nMockMvcModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MockMvcModel.kt\ncom/intellij/spring/mvc/webClient/mockMvc/MockMvcModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1374#2:64\n1460#2,5:65\n*S KotlinDebug\n*F\n+ 1 MockMvcModel.kt\ncom/intellij/spring/mvc/webClient/mockMvc/MockMvcModel\n*L\n51#1:64\n51#1:65,5\n*E\n"})
public final class MockMvcModel
extends SpringWebClientModel {
    @NotNull
    public static final MockMvcModel INSTANCE = new MockMvcModel();

    private MockMvcModel() {
    }

    @Override
    @Nullable
    public String findHttpMethod(@NotNull UCallExpression urlNode) {
        String methodName;
        Intrinsics.checkNotNullParameter((Object)urlNode, (String)"urlNode");
        PsiMethod psiMethod = urlNode.resolve();
        String string = methodName = psiMethod != null ? psiMethod.getName() : null;
        if (methodName == null) {
            return null;
        }
        if (Intrinsics.areEqual((Object)methodName, (Object)"request")) {
            UExpression expressionType = urlNode.getArgumentForParameter(0);
            if (expressionType instanceof USimpleNameReferenceExpression) {
                return ((USimpleNameReferenceExpression)expressionType).getResolvedName();
            }
            if (expressionType instanceof UQualifiedReferenceExpression) {
                return ((UQualifiedReferenceExpression)expressionType).getResolvedName();
            }
        } else {
            for (MockMvcMethod mockMvcMethod : MockMvcConstants.INSTANCE.getHTTP_METHOD_NAMES()) {
                if (!Intrinsics.areEqual((Object)mockMvcMethod.getMethod(), (Object)methodName)) continue;
                return mockMvcMethod.getType();
            }
        }
        return null;
    }

    @NotNull
    public final List<WebClientUrl> getEndpoints(@NotNull WebClientHolder group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        PsiElement holderPsi = group.getPsiElement();
        if (UastContextKt.toUElement((PsiElement)holderPsi) == null) {
            return CollectionsKt.emptyList();
        }
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)holderPsi.getProject());
        Object object = cachedValuesManager.getCachedValue((UserDataHolder)holderPsi, () -> MockMvcModel.getEndpoints$lambda$0(holderPsi));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebClientUrl> findMockMvcEndpoints(PsiElement holderPsi) {
        List list;
        HashSet methodCalls = new HashSet();
        Project project = holderPsi.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        for (PsiMethod apiMethod : MockMvcUtils.INSTANCE.getMockMvcBuildersApiMethods(project)) {
            methodCalls.addAll(SpringFunctionalSearchersUtils.findMethodCalls((PsiMethod)apiMethod, (SearchScope)((SearchScope)new LocalSearchScope(holderPsi))));
        }
        if (methodCalls.isEmpty()) {
            list = CollectionsKt.emptyList();
        } else {
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = methodCalls;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                UCallExpression it = (UCallExpression)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = INSTANCE.findUrl(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        }
        return list;
    }

    @Override
    @NotNull
    public String findBaseUrl(@Nullable UExpression uExpression) {
        return "";
    }

    @Override
    @NotNull
    protected List<PsiMethod> getUrlApiMethods(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Project project = module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return MockMvcUtils.INSTANCE.getMockMvcBuildersApiMethods(project);
    }

    @Override
    @NotNull
    public List<PsiClass> getApiClasses(@NotNull ScopedCacheValueHolder<?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        return MockMvcUtils.INSTANCE.getMockMvcApiClasses(query);
    }

    @Override
    @NotNull
    protected List<String> getPackageBlackList() {
        return MockMvcConstants.INSTANCE.getPACKAGE_SEARCH_BLACK_LIST();
    }

    @Override
    @NotNull
    protected String getWebClientPackage() {
        return "org.springframework.test.web.servlet";
    }

    private static final CachedValueProvider.Result getEndpoints$lambda$0(PsiElement $holderPsi) {
        return CachedValueProvider.Result.createSingleDependency(INSTANCE.findMockMvcEndpoints($holderPsi), (Object)$holderPsi.getContainingFile());
    }
}

