/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.parcelize.fir.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.AbstractSourceElementPositioningStrategy;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategies;
import org.jetbrains.kotlin.diagnostics.SourceElementPositioningStrategy;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.DelegateFieldsMapKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.parcelize.ParcelizeNames;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.FirParcelizeClassCheckerKt;
import org.jetbrains.kotlin.parcelize.fir.diagnostics.KtErrorsParcelize;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J \u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeClassChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirClassChecker;", "parcelizeAnnotations", "", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Ljava/util/List;)V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "checkParcelableClass", "klass", "checkParcelerClass", "parcelize.k2"})
@SourceDebugExtension(value={"SMAP\nFirParcelizeClassChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirParcelizeClassChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeClassChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,151:1\n68#2:152\n36#2:153\n13#2:154\n76#2:164\n2791#3,3:155\n831#3:161\n861#3,2:162\n220#4,2:158\n1#5:160\n*S KotlinDebug\n*F\n+ 1 FirParcelizeClassChecker.kt\norg/jetbrains/kotlin/parcelize/fir/diagnostics/FirParcelizeClassChecker\n*L\n48#1:152\n59#1:153\n71#1:154\n102#1:164\n76#1:155,3\n95#1:161\n95#1:162,2\n80#1:158,2\n*E\n"})
public final class FirParcelizeClassChecker
extends FirDeclarationChecker<FirClass> {
    @NotNull
    private final List<ClassId> parcelizeAnnotations;

    public FirParcelizeClassChecker(@NotNull List<ClassId> parcelizeAnnotations) {
        Intrinsics.checkNotNullParameter(parcelizeAnnotations, (String)"parcelizeAnnotations");
        super(MppCheckerKind.Platform);
        this.parcelizeAnnotations = parcelizeAnnotations;
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirClass declaration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.checkParcelableClass(declaration, context, reporter);
        this.checkParcelerClass(declaration, context, reporter);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkParcelableClass(FirClass klass, CheckerContext context, DiagnosticReporter reporter) {
        void $this$filterNotTo$iv$iv;
        Object v4;
        List constructorSymbols;
        KtSourceElement source;
        block24: {
            Object element$iv;
            Object element$iv22;
            boolean bl;
            block23: {
                ClassKind classKind;
                block28: {
                    block25: {
                        block27: {
                            block26: {
                                FirClassSymbol symbol = klass.getSymbol();
                                if (!FirParcelizeClassCheckerKt.isParcelize(symbol, context.getSession(), this.parcelizeAnnotations)) {
                                    return;
                                }
                                KtSourceElement ktSourceElement = klass.getSource();
                                if (ktSourceElement == null) {
                                    return;
                                }
                                source = ktSourceElement;
                                classKind = klass.getClassKind();
                                if (!(klass instanceof FirRegularClass)) break block25;
                                if (classKind == ClassKind.ANNOTATION_CLASS) break block26;
                                if (classKind != ClassKind.INTERFACE) break block27;
                                FirRegularClass $this$isSealed$iv = (FirRegularClass)klass;
                                boolean $i$f$isSealed = false;
                                if ($this$isSealed$iv.getStatus().getModality() == Modality.SEALED) break block27;
                            }
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_SHOULD_BE_CLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                            return;
                        }
                        FirRegularClassSymbol firRegularClassSymbol = ((FirRegularClass)klass).getCompanionObjectSymbol();
                        if (firRegularClassSymbol != null) {
                            FirRegularClassSymbol companionSymbol = firRegularClassSymbol;
                            boolean bl2 = false;
                            if (Intrinsics.areEqual((Object)companionSymbol.getClassId().getShortClassName(), (Object)ParcelizeNames.INSTANCE.getCREATOR_NAME())) {
                                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)companionSymbol.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getCREATOR_DEFINITION_IS_NOT_ALLOWED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                            }
                        }
                        FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)klass;
                        boolean $i$f$isInner = false;
                        if ($this$isInner$iv.getStatus().isInner()) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_CANT_BE_INNER_CLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                        }
                        if (((FirRegularClass)klass).isLocal()) {
                            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_CANT_BE_LOCAL_CLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                        }
                        break block28;
                    }
                    if (classKind != ClassKind.ENUM_ENTRY) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_SHOULD_BE_CLASS(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                        return;
                    }
                }
                if (classKind == ClassKind.CLASS) {
                    FirMemberDeclaration $this$isAbstract$iv = (FirMemberDeclaration)klass;
                    boolean $i$f$isAbstract = false;
                    if ($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT) {
                        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_SHOULD_BE_INSTANTIABLE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                    }
                }
                List supertypes = SupertypeUtilsKt.lookupSuperTypes$default((FirClass)klass, (boolean)true, (boolean)true, (FirSession)context.getSession(), (boolean)false, null, (int)32, null);
                Iterable $this$none$iv = supertypes;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv22 : $this$none$iv) {
                        ConeClassLikeType it = (ConeClassLikeType)element$iv22;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId((ConeKotlinType)((ConeKotlinType)it)), (Object)ParcelizeNames.INSTANCE.getPARCELABLE_ID())) continue;
                        bl = false;
                        break block23;
                    }
                    bl = true;
                }
            }
            if (bl) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getNO_PARCELABLE_SUPERTYPE(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
            }
            Map map = DelegateFieldsMapKt.getDelegateFieldsMap((FirClass)klass);
            if (map != null) {
                Map $this$forEach$iv = map;
                boolean $i$f$forEach = false;
                element$iv22 = $this$forEach$iv.entrySet().iterator();
                while (element$iv22.hasNext()) {
                    ConeClassLikeTypeImpl parcelableType;
                    Object bl3 = element$iv = (Map.Entry)element$iv22.next();
                    boolean bl4 = false;
                    int index = ((Number)bl3.getKey()).intValue();
                    FirTypeRef superTypeRef = (FirTypeRef)klass.getSuperTypeRefs().get(index);
                    ConeKotlinType superType = FirTypeUtilsKt.getConeType((FirTypeRef)superTypeRef);
                    if (!TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)superType, (ConeKotlinType)((ConeKotlinType)(parcelableType = new ConeClassLikeTypeImpl((ConeClassLikeLookupTag)TypeConstructionUtilsKt.toLookupTag((ClassId)ParcelizeNames.INSTANCE.getPARCELABLE_ID()), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null))), (FirSession)context.getSession(), (boolean)false, (int)4, null)) continue;
                    KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)superTypeRef.getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_DELEGATE_IS_NOT_ALLOWED(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
                }
            }
            constructorSymbols = DeclarationUtilsKt.constructors((FirClass)klass, (FirSession)context.getSession());
            element$iv22 = constructorSymbols;
            element$iv = element$iv22.iterator();
            while (element$iv.hasNext()) {
                Object bl3 = element$iv.next();
                FirConstructorSymbol it = (FirConstructorSymbol)bl3;
                boolean bl5 = false;
                if (!it.isPrimary()) continue;
                v4 = bl3;
                break block24;
            }
            v4 = null;
        }
        FirConstructorSymbol primaryConstructorSymbol = v4;
        Iterable $this$filterNot$iv = constructorSymbols;
        boolean $i$f$filterNot = false;
        Iterable bl3 = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            FirConstructorSymbol it = (FirConstructorSymbol)element$iv$iv;
            boolean bl = false;
            if (it.isPrimary()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List secondaryConstructorSymbols = (List)destination$iv$iv;
        if (primaryConstructorSymbol == null && !((Collection)secondaryConstructorSymbols).isEmpty()) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getPARCELABLE_SHOULD_HAVE_PRIMARY_CONSTRUCTOR(), (DiagnosticContext)((DiagnosticContext)context), null, (int)8, null);
        }
    }

    private final void checkParcelerClass(FirClass klass, CheckerContext context, DiagnosticReporter reporter) {
        block5: {
            block4: {
                if (!(klass instanceof FirRegularClass)) break block4;
                FirRegularClass $this$isCompanion$iv = (FirRegularClass)klass;
                boolean $i$f$isCompanion = false;
                if ($this$isCompanion$iv.getStatus().isCompanion()) break block5;
            }
            return;
        }
        if (SupertypeUtilsKt.isSubclassOf$default((FirClass)klass, (ConeClassLikeLookupTag)((ConeClassLikeLookupTag)TypeConstructionUtilsKt.toLookupTag((ClassId)ParcelizeNames.INSTANCE.getOLD_PARCELER_ID())), (FirSession)context.getSession(), (boolean)true, null, (boolean)false, (int)24, null)) {
            SourceElementPositioningStrategy strategy = Intrinsics.areEqual((Object)((FirRegularClass)klass).getName(), (Object)SpecialNames.NO_NAME_PROVIDED) ? SourceElementPositioningStrategies.INSTANCE.getOBJECT_KEYWORD() : SourceElementPositioningStrategies.INSTANCE.getNAME_IDENTIFIER();
            KtDiagnosticReportHelpersKt.reportOn((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)((FirRegularClass)klass).getSource()), (KtDiagnosticFactory0)KtErrorsParcelize.INSTANCE.getDEPRECATED_PARCELER(), (DiagnosticContext)((DiagnosticContext)context), (AbstractSourceElementPositioningStrategy)((AbstractSourceElementPositioningStrategy)strategy));
        }
    }
}

