/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.station.core.toolbox;

import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.station.core.toolbox.ToolboxDiscovery;
import com.intellij.station.core.toolbox.ToolboxStatus;
import com.intellij.station.core.toolbox.ToolboxStatusService;
import com.intellij.station.core.toolbox.ToolboxStatusServiceKt;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u000eJ\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0012J\u0006\u0010\u0014\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u000eH\u0086@\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u000eH\u0082@\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/station/core/toolbox/ToolboxStatusService;", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;)V", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "toolboxStatus", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/station/core/toolbox/ToolboxStatus;", "getToolboxStatus", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "rememberAboutInstallationAttempt", "", "rememberToolboxPromoPlaceholderDismissed", "forgetAboutInstallationAttempt", "wasToolboxOpenedViaLink", "", "wasToolboxPromoPlaceholderDismissed", "scheduleUpdateToolboxStatus", "updateToolboxStatusSafe", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "updateToolboxStatusUnsafe", "Companion", "intellij.station.core"})
@ApiStatus.Internal
public final class ToolboxStatusService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final MutableStateFlow<ToolboxStatus> toolboxStatus;

    public ToolboxStatusService(@NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.coroutineScope = coroutineScope;
        this.toolboxStatus = StateFlowKt.MutableStateFlow((Object)((Object)ToolboxStatus.NotYetComputed));
    }

    @NotNull
    public final CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public final MutableStateFlow<ToolboxStatus> getToolboxStatus() {
        return this.toolboxStatus;
    }

    public final void rememberAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", true);
    }

    public final void rememberToolboxPromoPlaceholderDismissed() {
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", true);
    }

    public final void forgetAboutInstallationAttempt() {
        PropertiesComponent.getInstance().setValue("toolbox.installation.attempt", false);
        PropertiesComponent.getInstance().setValue("toolbox.promo.placeholder.dismissed", false);
    }

    public final boolean wasToolboxOpenedViaLink() {
        boolean registryKeyEnabled = Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled", false);
        boolean userHadClickedOnOpenToolboxLink = PropertiesComponent.getInstance().getBoolean("toolbox.installation.attempt", false);
        ToolboxStatus[] toolboxStatusArray = new ToolboxStatus[]{ToolboxStatus.UpToDateAndRunning, ToolboxStatus.UpToDateAndNotRunning};
        boolean isUpToDateToolboxInstallationConfirmed = SetsKt.setOf((Object[])toolboxStatusArray).contains(this.toolboxStatus.getValue());
        ToolboxStatusServiceKt.access$getLOG().debug("Previous toolbox opening data: registry key enabled: " + registryKeyEnabled + ", user had clicked on 'open' link: " + userHadClickedOnOpenToolboxLink + ", is up to date toolbox installed: " + isUpToDateToolboxInstallationConfirmed);
        return registryKeyEnabled && userHadClickedOnOpenToolboxLink && isUpToDateToolboxInstallationConfirmed;
    }

    public final boolean wasToolboxPromoPlaceholderDismissed() {
        return PropertiesComponent.getInstance().getBoolean("toolbox.promo.placeholder.dismissed", false);
    }

    public final void scheduleUpdateToolboxStatus() {
        if (!Registry.Companion.is("gateway.ssh.welcome.screen.toolbox.promo.enabled", false) && !Registry.Companion.is("gateway.welcome.screen.toolbox.promo.enabled", false)) {
            return;
        }
        BuildersKt.launch$default((CoroutineScope)this.coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ ToolboxStatusService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.this$0.updateToolboxStatusSafe((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateToolboxStatusSafe(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateToolboxStatusSafe.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxStatusService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateToolboxStatusSafe((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.updateToolboxStatusUnsafe((Continuation<? super Unit>)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl28
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
                }
                catch (IllegalArgumentException exception) {
                    ToolboxStatusServiceKt.access$getLOG().warn("Failed to update toolbox status. Unsatisfied requirement: ", (Throwable)exception);
                    this.toolboxStatus.setValue((Object)ToolboxStatus.Unsupported);
                }
lbl28:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object updateToolboxStatusUnsafe(Continuation<? super Unit> $completion) {
        if (!($completion instanceof updateToolboxStatusUnsafe.1)) ** GOTO lbl-1000
        var6_2 = $completion;
        if ((var6_2.label & -2147483648) != 0) {
            var6_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                /* synthetic */ Object result;
                final /* synthetic */ ToolboxStatusService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ToolboxStatusService.access$updateToolboxStatusUnsafe(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var7_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                installedToolboxBuildNumber = ToolboxDiscovery.INSTANCE.getInstalledBuild$intellij_station_core();
                runningToolboxProcesses = ToolboxDiscovery.INSTANCE.listRunningToolboxProcesses();
                $continuation.L$0 = installedToolboxBuildNumber;
                $continuation.L$1 = runningToolboxProcesses;
                $continuation.label = 1;
                v0 = ToolboxDiscovery.INSTANCE.findOrDownloadFreshToolboxInstaller(false, (Continuation<? super Pair<? extends Path, BuildNumber>>)$continuation);
                if (v0 == var7_4) {
                    return var7_4;
                }
                ** GOTO lbl26
            }
            case 1: {
                runningToolboxProcesses = (List<ProcessInfo>)$continuation.L$1;
                installedToolboxBuildNumber = (BuildNumber)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl26:
                // 2 sources

                installerVersion = (BuildNumber)((Pair)v0).component2();
                ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery status: existing toolbox build " + installedToolboxBuildNumber + ", running processes " + runningToolboxProcesses.size() + ",installer version " + installerVersion);
                if (installedToolboxBuildNumber == null && runningToolboxProcesses.isEmpty()) {
                    v1 = ToolboxStatus.NotInstalled;
                } else if (installedToolboxBuildNumber != null && installedToolboxBuildNumber.compareTo(installerVersion) < 0) {
                    v1 = runningToolboxProcesses.isEmpty() ? ToolboxStatus.OutdatedAndNotRunning : ToolboxStatus.OutdatedAndRunning;
                } else if (installedToolboxBuildNumber != null && installedToolboxBuildNumber.compareTo(installerVersion) >= 0) {
                    v1 = runningToolboxProcesses.isEmpty() ? ToolboxStatus.UpToDateAndNotRunning : ToolboxStatus.UpToDateAndRunning;
                } else {
                    ToolboxStatusServiceKt.access$getLOG().debug("Toolbox discovery is unsure about installed version.Falling back to `not installed`");
                    v1 = ToolboxStatus.NotInstalled;
                }
                this.toolboxStatus.setValue((Object)v1);
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$updateToolboxStatusUnsafe(ToolboxStatusService $this, Continuation $completion) {
        return $this.updateToolboxStatusUnsafe((Continuation<? super Unit>)$completion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/station/core/toolbox/ToolboxStatusService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/station/core/toolbox/ToolboxStatusService;", "intellij.station.core"})
    @SourceDebugExtension(value={"SMAP\nToolboxStatusService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ToolboxStatusService.kt\ncom/intellij/station/core/toolbox/ToolboxStatusService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,119:1\n42#2,3:120\n*S KotlinDebug\n*F\n+ 1 ToolboxStatusService.kt\ncom/intellij/station/core/toolbox/ToolboxStatusService$Companion\n*L\n104#1:120,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ToolboxStatusService getInstance() {
            boolean $i$f$service = false;
            Class<ToolboxStatusService> serviceClass$iv = ToolboxStatusService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (ToolboxStatusService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

