/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.util;

import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.util.KubernetesStateWatcher;
import com.intellij.kubernetes.util.StateObjectList;
import com.intellij.openapi.diagnostic.Logger;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.util.Watch;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003*\b\u0012\u0004\u0012\u0002H\u00020\u0004H\u0002\u001a\u000e\u0010\u0005\u001a\u00020\u0006*\u0006\u0012\u0002\b\u00030\u0004\u001a2\u0010\u0007\u001a\u00020\b\"\b\b\u0000\u0010\u0002*\u00020\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\u00020\n2\n\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fH\u0087@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "T", "Lio/kubernetes/client/common/KubernetesObject;", "Lcom/intellij/kubernetes/util/KubernetesStateWatcher;", "getCoroutineName", "", "updateStateList", "", "list", "Lcom/intellij/kubernetes/util/StateObjectList;", "event", "Lio/kubernetes/client/util/Watch$Response;", "(Lcom/intellij/kubernetes/util/StateObjectList;Lio/kubernetes/client/util/Watch$Response;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesStateFlowWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesStateFlowWatcher.kt\ncom/intellij/kubernetes/util/KubernetesStateFlowWatcherKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,467:1\n13#2:468\n13#2:469\n13#2:470\n*S KotlinDebug\n*F\n+ 1 KubernetesStateFlowWatcher.kt\ncom/intellij/kubernetes/util/KubernetesStateFlowWatcherKt\n*L\n428#1:468\n437#1:469\n450#1:470\n*E\n"})
public final class KubernetesStateFlowWatcherKt {
    private static final <T extends KubernetesObject> Logger getLogger(KubernetesStateWatcher<T> $this$getLogger) {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesStateWatcher.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    @NotNull
    public static final String getCoroutineName(@NotNull KubernetesStateWatcher<?> $this$getCoroutineName) {
        Intrinsics.checkNotNullParameter($this$getCoroutineName, (String)"<this>");
        return "Getting " + $this$getCoroutineName.getEntity().getDisplayableKinds();
    }

    /*
     * Enabled aggressive block sorting
     */
    @VisibleForTesting
    @Nullable
    public static final <T extends KubernetesObject> Object updateStateList(@NotNull StateObjectList<T> list2, @NotNull Watch.Response<?> event2, @NotNull Continuation<? super Unit> $completion) {
        Object object = event2.object;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type T of com.intellij.kubernetes.util.KubernetesStateFlowWatcherKt.updateStateList");
        KubernetesObject resource = (KubernetesObject)object;
        String string = event2.type;
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 62122208: {
                    if (!string.equals("ADDED")) break;
                    n = 1;
                    break;
                }
                case -1506962122: {
                    if (!string.equals("BOOKMARK")) break;
                    n = 2;
                    break;
                }
                case 167113417: {
                    if (!string.equals("MODIFIED")) break;
                    n = 3;
                    break;
                }
                case -2026521607: {
                    if (!string.equals("DELETED")) break;
                    n = 4;
                    break;
                }
            }
            switch (n) {
                case 2: {
                    boolean $i$f$logger = false;
                    Logger logger = Logger.getInstance(KubernetesApiProvider.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Metadata processing is not supported yet");
                    return Unit.INSTANCE;
                }
                case 1: {
                    String nameId = resource.getMetadata().getName() + resource.getMetadata().getUid();
                    Object object2 = list2.updateValue(nameId, (Unit)resource, $completion);
                    if (object2 != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
                    return object2;
                }
                case 3: {
                    String nameId = resource.getMetadata().getName() + resource.getMetadata().getUid();
                    Object object3 = list2.updateValue(nameId, (Unit)resource, $completion);
                    if (object3 != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
                    return object3;
                }
                case 4: {
                    String nameId = resource.getMetadata().getName() + resource.getMetadata().getUid();
                    Object object4 = list2.removeValue(nameId, $completion);
                    if (object4 != IntrinsicsKt.getCOROUTINE_SUSPENDED()) return Unit.INSTANCE;
                    return object4;
                }
            }
        }
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(KubernetesApiProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.warn("Unknown event type: " + event2.type + "}");
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger(KubernetesStateWatcher $receiver) {
        return KubernetesStateFlowWatcherKt.getLogger($receiver);
    }
}

