/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.mappers;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesEntity;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapperKt;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeCondition;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1NodeSpec;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Taint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\u0006\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/kubernetes/view/mappers/KubernetesNodeMapper;", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "Lio/kubernetes/client/openapi/models/V1Node;", "Lio/kubernetes/client/openapi/models/V1NodeList;", "<init>", "()V", "getColumnDescriptors", "", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "getColumnDescriptorsForMultilineTable", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesNodeMapper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesNodeMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNodeMapper\n+ 2 KubernetesResourceMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesResourceMapper$ColumnDescriptor$Companion\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,62:1\n172#2,5:63\n172#2,5:68\n172#2,5:73\n172#2,5:78\n172#2,5:83\n172#2,5:88\n172#2,5:93\n172#2,5:98\n172#2,5:103\n172#2,5:108\n172#2,5:113\n1#3:118\n1056#4:119\n1563#4:120\n1634#4,3:121\n1563#4:132\n1634#4,3:133\n126#5:124\n153#5,3:125\n126#5:128\n153#5,3:129\n*S KotlinDebug\n*F\n+ 1 KubernetesNodeMapper.kt\ncom/intellij/kubernetes/view/mappers/KubernetesNodeMapper\n*L\n13#1:63,5\n16#1:68,5\n20#1:73,5\n23#1:78,5\n38#1:83,5\n39#1:88,5\n40#1:93,5\n41#1:98,5\n52#1:103,5\n56#1:108,5\n57#1:113,5\n35#1:119\n35#1:120\n35#1:121,3\n51#1:132\n51#1:133,3\n45#1:124\n45#1:125,3\n48#1:128\n48#1:129,3\n*E\n"})
public final class KubernetesNodeMapper
extends KubernetesResourceMapper<V1Node, V1NodeList> {
    @NotNull
    public static final KubernetesNodeMapper INSTANCE = new KubernetesNodeMapper();

    private KubernetesNodeMapper() {
        super(KubernetesEntity.Node);
    }

    @Override
    @NotNull
    public List<KubernetesResourceMapper.ColumnDescriptor<V1Node, ?>> getColumnDescriptors(@NotNull KubernetesApiModelInterface apiModel2) {
        String name$iv;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[6];
        columnDescriptorArray[0] = this.addNameField();
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string = KubernetesBundle.message("KubernetesResourceMapper.statusField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        String string2 = string;
        Function1 getValue$iv = KubernetesNodeMapper::getColumnDescriptors$lambda$0;
        boolean $i$f$simple = false;
        columnDescriptorArray[1] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        KubernetesResourceMapper.ColumnDescriptor.Companion this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string3 = KubernetesBundle.message("KubernetesNodeMapper.roleField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        name$iv = string3;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptors$lambda$1;
        $i$f$simple = false;
        columnDescriptorArray[2] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string4 = KubernetesBundle.message("KubernetesNodeMapper.versionField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        name$iv = string4;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptors$lambda$2;
        $i$f$simple = false;
        columnDescriptorArray[3] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string5 = KubernetesBundle.message("addresses", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        name$iv = string5;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptors$lambda$3;
        $i$f$simple = false;
        columnDescriptorArray[4] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        columnDescriptorArray[5] = this.addAgeField();
        return CollectionsKt.listOfNotNull((Object[])columnDescriptorArray);
    }

    @Override
    @NotNull
    public List<KubernetesResourceMapper.ColumnDescriptor<V1Node, ?>> getColumnDescriptorsForMultilineTable(@NotNull KubernetesApiModelInterface apiModel2) {
        String name$iv;
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Collection collection = this.getColumnDescriptors(apiModel2);
        KubernetesResourceMapper.ColumnDescriptor[] columnDescriptorArray = new KubernetesResourceMapper.ColumnDescriptor[13];
        String string = KubernetesBundle.message("KubernetesPodMapper.annotationsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        columnDescriptorArray[0] = this.addMultilineField(string, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$0);
        String string2 = KubernetesBundle.message("KubernetesNodeMapper.conditionsField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        columnDescriptorArray[1] = this.addMultilineField(string2, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$1);
        KubernetesResourceMapper.ColumnDescriptor.Companion companion = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string3 = KubernetesBundle.message("KubernetesNodeMapper.osImageField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        String string4 = string3;
        Function1 getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$2;
        boolean $i$f$simple = false;
        columnDescriptorArray[2] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        KubernetesResourceMapper.ColumnDescriptor.Companion this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string5 = KubernetesBundle.message("KubernetesNodeMapper.kernelVersionField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        name$iv = string5;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$3;
        $i$f$simple = false;
        columnDescriptorArray[3] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string6 = KubernetesBundle.message("KubernetesNodeMapper.containerRuntimeField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        name$iv = string6;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$4;
        $i$f$simple = false;
        columnDescriptorArray[4] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string7 = KubernetesBundle.message("KubernetesNodeMapper.architectureField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        name$iv = string7;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$5;
        $i$f$simple = false;
        columnDescriptorArray[5] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        String string8 = KubernetesBundle.message("KubernetesResourceMapper.capacityField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"message(...)");
        columnDescriptorArray[6] = this.addMultilineField(string8, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$6);
        String string9 = KubernetesBundle.message("KubernetesNodeMapper.allocatable.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"message(...)");
        columnDescriptorArray[7] = this.addMultilineField(string9, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$7);
        String string10 = KubernetesBundle.message("KubernetesNodeMapper.taints.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"message(...)");
        columnDescriptorArray[8] = this.addMultilineField(string10, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$8);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string11 = KubernetesBundle.message("KubernetesNodeMapper.podCIDRField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"message(...)");
        name$iv = string11;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$9;
        $i$f$simple = false;
        columnDescriptorArray[9] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        String string12 = KubernetesBundle.message("KubernetesResourceMapper.pod.cidrs.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"message(...)");
        columnDescriptorArray[10] = this.addMultilineField(string12, KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$10);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string13 = KubernetesBundle.message("KubernetesNodeMapper.providerIDField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"message(...)");
        name$iv = string13;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$11;
        $i$f$simple = false;
        columnDescriptorArray[11] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        this_$iv = KubernetesResourceMapper.ColumnDescriptor.Companion;
        String string14 = KubernetesBundle.message("KubernetesNodeMapper.unschedulableField.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"message(...)");
        name$iv = string14;
        getValue$iv = KubernetesNodeMapper::getColumnDescriptorsForMultilineTable$lambda$12;
        $i$f$simple = false;
        columnDescriptorArray[12] = new KubernetesResourceMapper.ColumnDescriptor(name$iv, Reflection.getOrCreateKotlinClass(String.class), null, null, null, null, null, getValue$iv, 124, null);
        return CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object[])columnDescriptorArray));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getColumnDescriptors$lambda$0(V1Node $this$simple) {
        Object v3;
        Object object;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
            V1NodeStatus v1NodeStatus = $this$simple.getStatus();
            object = v1NodeStatus;
            if (v1NodeStatus == null) return null;
            List list2 = object.getConditions();
            object = list2;
            if (list2 == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                V1NodeCondition it = (V1NodeCondition)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getType(), (Object)"Ready")) continue;
                v3 = t;
                break block1;
            }
            v3 = null;
        }
        V1NodeCondition v1NodeCondition = v3;
        object = v1NodeCondition;
        if (v1NodeCondition == null) return null;
        String string = object.getStatus();
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final String getColumnDescriptors$lambda$1(V1Node $this$simple) {
        Object v6;
        Object object;
        Object object2;
        block2: {
            Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
            object2 = $this$simple.getMetadata();
            if (object2 != null && (object2 = object2.getLabels()) != null) {
                String string = (String)object2.get("kubernetes.io/role");
                object2 = string;
                if (string != null) return object2;
            }
            V1ObjectMeta v1ObjectMeta = $this$simple.getMetadata();
            object = v1ObjectMeta;
            if (v1ObjectMeta == null) return null;
            Map map2 = object.getLabels();
            object = map2;
            if (map2 == null) return null;
            Set set = object.keySet();
            object = set;
            if (set == null) return null;
            Iterable iterable = (Iterable)object;
            for (Object t : iterable) {
                String it = (String)t;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                if (!StringsKt.startsWith$default((String)it, (String)"node-role.kubernetes.io/", (boolean)false, (int)2, null)) continue;
                v6 = t;
                break block2;
            }
            v6 = null;
        }
        String string = v6;
        object = string;
        if (string == null) return null;
        object2 = StringsKt.removePrefix((String)object, (CharSequence)"node-role.kubernetes.io/");
        return object2;
    }

    private static final String getColumnDescriptors$lambda$2(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeStatus v1NodeStatus = $this$simple.getStatus();
        return v1NodeStatus != null && (v1NodeStatus = v1NodeStatus.getNodeInfo()) != null ? v1NodeStatus.getKubeletVersion() : null;
    }

    private static final String getColumnDescriptors$lambda$3(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        Object object = $this$simple.getStatus();
        return object != null && (object = object.getAddresses()) != null ? CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)"\n", null, null, (int)0, null, KubernetesNodeMapper::getColumnDescriptors$lambda$3$0, (int)30, null) : null;
    }

    private static final CharSequence getColumnDescriptors$lambda$3$0(V1NodeAddress it) {
        return it.getType() + ": " + it.getAddress();
    }

    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$0(V1Node $this$addMultilineField) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getMetadata();
        return object != null && (object = object.getAnnotations()) != null ? KubernetesResourceMapperKt.getIterable((Map<String, String>)object) : null;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$1(V1Node $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getStatus();
        if (object != null && (object = object.getConditions()) != null) {
            Iterable $this$sortedBy$iv = (Iterable)object;
            boolean $i$f$sortedBy = false;
            object = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    V1NodeCondition it = (V1NodeCondition)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getType());
                    it = (V1NodeCondition)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getType())));
                }
            });
            if (object != null) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = (Iterable)object;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.iterator();
                while (true) {
                    String string;
                    void it;
                    if (!iterator.hasNext()) {
                        list2 = (List)destination$iv$iv;
                        return list2;
                    }
                    Object item$iv$iv = iterator.next();
                    V1NodeCondition v1NodeCondition = (V1NodeCondition)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string4 = it.getType();
                    string4 = it.getStatus();
                    string4 = it.getReason();
                    if (string4 == null) {
                        string4 = "";
                    }
                    if ((string = it.getMessage()) == null) {
                        string = "";
                    }
                    collection.add(string2 + ": " + string3 + " (" + string4 + " - " + string + ")");
                }
            }
        }
        list2 = null;
        return list2;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$2(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeStatus v1NodeStatus = $this$simple.getStatus();
        return v1NodeStatus != null && (v1NodeStatus = v1NodeStatus.getNodeInfo()) != null ? v1NodeStatus.getOsImage() : null;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$3(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeStatus v1NodeStatus = $this$simple.getStatus();
        return v1NodeStatus != null && (v1NodeStatus = v1NodeStatus.getNodeInfo()) != null ? v1NodeStatus.getKernelVersion() : null;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$4(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeStatus v1NodeStatus = $this$simple.getStatus();
        return v1NodeStatus != null && (v1NodeStatus = v1NodeStatus.getNodeInfo()) != null ? v1NodeStatus.getContainerRuntimeVersion() : null;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$5(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeStatus v1NodeStatus = $this$simple.getStatus();
        return v1NodeStatus != null && (v1NodeStatus = v1NodeStatus.getNodeInfo()) != null ? v1NodeStatus.getArchitecture() : null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$6(V1Node $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getStatus();
        if (object != null && (object = object.getCapacity()) != null) {
            void $this$mapTo$iv$iv;
            Object $this$map$iv = object;
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + ": " + it.getValue());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$7(V1Node $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getStatus();
        if (object != null && (object = object.getAllocatable()) != null) {
            void $this$mapTo$iv$iv;
            Object $this$map$iv = object;
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + ": " + it.getValue());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    /*
     * WARNING - void declaration
     */
    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$8(V1Node $this$addMultilineField) {
        List list2;
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        Object object = $this$addMultilineField.getSpec();
        if (object != null && (object = object.getTaints()) != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)object;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                V1Taint v1Taint = (V1Taint)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getKey();
                String string2 = it.getValue();
                if (string2 == null) {
                    string2 = "";
                }
                collection.add(string + "=" + string2 + ":" + it.getEffect());
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = null;
        }
        return list2;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$9(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeSpec v1NodeSpec = $this$simple.getSpec();
        return v1NodeSpec != null ? v1NodeSpec.getPodCIDR() : null;
    }

    private static final Iterable getColumnDescriptorsForMultilineTable$lambda$10(V1Node $this$addMultilineField) {
        Intrinsics.checkNotNullParameter((Object)$this$addMultilineField, (String)"$this$addMultilineField");
        V1NodeSpec v1NodeSpec = $this$addMultilineField.getSpec();
        return v1NodeSpec != null ? v1NodeSpec.getPodCIDRs() : null;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$11(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        V1NodeSpec v1NodeSpec = $this$simple.getSpec();
        return v1NodeSpec != null ? v1NodeSpec.getProviderID() : null;
    }

    private static final String getColumnDescriptorsForMultilineTable$lambda$12(V1Node $this$simple) {
        Intrinsics.checkNotNullParameter((Object)$this$simple, (String)"$this$simple");
        Object object = $this$simple.getSpec();
        return object != null && (object = object.getUnschedulable()) != null ? String.valueOf((Boolean)object) : null;
    }
}

