/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui.actions;

import com.intellij.icons.AllIcons;
import com.intellij.kubernetes.KubernetesUsageTriggerCollector;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.execution.KubernetesPodService;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesContainerObject;
import com.intellij.kubernetes.view.nodes.workloads.KubernetesPodServiceViewContributorDescriptor;
import com.intellij.kubernetes.view.ui.KubernetesPodContent;
import com.intellij.kubernetes.view.ui.actions.ActionUtilsKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesContainerBasedSmartGroup;
import com.intellij.kubernetes.view.ui.actions.KubernetesCreateActionsUtilKt;
import com.intellij.kubernetes.view.ui.actions.KubernetesPodContainerActionBase;
import com.intellij.kubernetes.view.ui.actions.SelectedKubernetesResource;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Pod;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R1\u0010\b\u001a\u001f\u0012\u0016\u0012\u0014 \f*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR1\u0010\u0010\u001a\u001f\u0012\u0016\u0012\u0014 \f*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u000fR\u0019\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\r8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001d"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodRunShellAction;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodContainerActionBase;", "container", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "isPerformParentGroup", "", "<init>", "(Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;Z)V", "text", "Ljava/util/function/Supplier;", "", "Lorg/jetbrains/annotations/Nls;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getText", "()Ljava/util/function/Supplier;", "description", "getDescription", "icon", "Ljavax/swing/Icon;", "getIcon", "()Ljavax/swing/Icon;", "actionPerformed", "", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Group", "intellij.clouds.kubernetes"})
public final class KubernetesPodRunShellAction
extends KubernetesPodContainerActionBase {
    public KubernetesPodRunShellAction(@NotNull KubernetesContainerObject container, boolean isPerformParentGroup) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(container, isPerformParentGroup);
    }

    public /* synthetic */ KubernetesPodRunShellAction(KubernetesContainerObject kubernetesContainerObject, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = true;
        }
        this(kubernetesContainerObject, bl);
    }

    @Override
    @NotNull
    protected Supplier<String> getText() {
        Supplier<String> supplier = KubernetesBundle.messagePointer("action.Kubernetes.PodRunShell.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return supplier;
    }

    @Override
    @NotNull
    protected Supplier<String> getDescription() {
        Object[] objectArray = new Object[]{this.getContainer().getName()};
        Supplier<String> supplier = KubernetesBundle.messagePointer("action.Kubernetes.PodRunShell.description", objectArray);
        Intrinsics.checkNotNullExpressionValue(supplier, (String)"messagePointer(...)");
        return supplier;
    }

    @Override
    @NotNull
    protected Icon getIcon() {
        Icon icon = AllIcons.Actions.ChangeView;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ChangeView");
        return icon;
    }

    @Override
    protected void actionPerformed(@NotNull KubernetesApiModelInterface apiModel2, @NotNull AnActionEvent event2) {
        Intrinsics.checkNotNullParameter((Object)apiModel2, (String)"apiModel");
        Intrinsics.checkNotNullParameter((Object)event2, (String)"event");
        Project project = event2.getProject();
        Intrinsics.checkNotNull((Object)project);
        Project project2 = project;
        KubernetesUsageTriggerCollector.INSTANCE.getACTION_TRIGGERED_EVENT().log(project2, "pod-run-shell-console");
        KubernetesPodServiceViewContributorDescriptor kubernetesPodServiceViewContributorDescriptor = KubernetesCreateActionsUtilKt.getSelectedPodDescriptor(event2);
        Intrinsics.checkNotNull((Object)kubernetesPodServiceViewContributorDescriptor);
        KubernetesPodServiceViewContributorDescriptor podDescriptor = kubernetesPodServiceViewContributorDescriptor;
        KubernetesPodService kubernetesPodService = KubernetesPodService.Companion.getInstance(project2);
        List<SelectedKubernetesResource> list2 = ActionUtilsKt.getSelectedKubernetesResources(event2);
        KubernetesObject kubernetesObject = list2 != null && (list2 = (SelectedKubernetesResource)CollectionsKt.singleOrNull(list2)) != null ? ((SelectedKubernetesResource)((Object)list2)).getSingleSelectedValue() : null;
        Intrinsics.checkNotNull((Object)kubernetesObject, (String)"null cannot be cast to non-null type io.kubernetes.client.openapi.models.V1Pod");
        kubernetesPodService.runPodShell(apiModel2, (V1Pod)kubernetesObject, ((KubernetesPodContent)podDescriptor.getContent()).createShellPanel(this.getContainer()));
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodRunShellAction$Group;", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesContainerBasedSmartGroup;", "<init>", "()V", "icon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getIcon", "()Ljavax/swing/Icon;", "createAction", "Lcom/intellij/kubernetes/view/ui/actions/KubernetesPodRunShellAction;", "container", "Lcom/intellij/kubernetes/view/nodes/workloads/KubernetesContainerObject;", "isPerformParentGroup", "", "intellij.clouds.kubernetes"})
    public static final class Group
    extends KubernetesContainerBasedSmartGroup {
        @Override
        @NotNull
        public Icon getIcon() {
            Icon icon = AllIcons.Actions.ChangeView;
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"ChangeView");
            return icon;
        }

        @Override
        @NotNull
        protected KubernetesPodRunShellAction createAction(@NotNull KubernetesContainerObject container, boolean isPerformParentGroup) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            return new KubernetesPodRunShellAction(container, isPerformParentGroup);
        }
    }
}

