/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.FileSelectInContext;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.CloseTabToolbarAction;
import com.intellij.ide.actions.RefreshAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.DeploymentConfigChangeListener;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.WebServerConfigsChangedListener;
import com.jetbrains.plugins.webDeployment.actions.PublishActionUtil;
import com.jetbrains.plugins.webDeployment.actions.SelectInRemoteHostAction;
import com.jetbrains.plugins.webDeployment.actions.WebDeploymentDataKeys;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.GroupedServersConfigManager;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerGroupingWrap;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.remoteEdit.EditRemoteFileAction;
import com.jetbrains.plugins.webDeployment.remoteEdit.fs.RemoteVirtualFile;
import com.jetbrains.plugins.webDeployment.ui.DefaultServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.ui.HiddenPathsManager;
import com.jetbrains.plugins.webDeployment.ui.PropertyProvider;
import com.jetbrains.plugins.webDeployment.ui.WebServerCombo;
import com.jetbrains.plugins.webDeployment.ui.config.ServerOrGroup;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTree;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeNode;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.ServerTreeViewOptions;
import com.jetbrains.plugins.webDeployment.ui.remotebrowser.WebServerTreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WebServerToolWindowPanel
extends SimpleToolWindowPanel {
    @NonNls
    public static final String ACTION_GROUP = "RemoteHostViewPopupMenu";
    @NonNls
    public static final String HELP_ID = "reference.tool.window.remote.host";
    private final Project myProject;
    @NotNull
    private final ToolWindow toolWindow;
    private WebServerCombo myServerCombo;
    private JPanel myViewContentPanel;
    private JPanel myTopPanel;
    private DefaultActionGroup myActionGroup;
    private ServerTree myTree;
    private Disposable myCurrentDisposable;
    private final MyToggleAction myShowSizeAction;
    private final MyToggleAction myShowTimestampAction;
    private final MyToggleAction myShowPermissionsAction;
    private final MyToggleAction myHighlightSymlinksAction;
    private final MyToggleAction myHighlightMappingsAction;
    private WebServerTreeBuilder myTreeBuilder;

    public WebServerToolWindowPanel(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        if (project == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(0);
        }
        if (toolWindow == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(1);
        }
        super(true);
        this.myProject = project;
        this.toolWindow = toolWindow;
        this.myShowSizeAction = new MyToggleAction("toolwindow.show.size", false);
        this.myShowTimestampAction = new MyToggleAction("toolwindow.show.date", false);
        this.myShowPermissionsAction = new MyToggleAction("toolwindow.show.permissions", false);
        this.myHighlightSymlinksAction = new MyToggleAction("toolwindow.highlight.symlinks", true);
        this.myHighlightMappingsAction = new MyToggleAction("toolwindow.highlight.mappings", true);
        this.constructUi();
        ApplicationManager.getApplication().getMessageBus().connect(toolWindow.getDisposable()).subscribe(WebDeploymentTopics.WEB_SERVER_CONFIGS, (Object)new WebServerConfigsChangedListener(){

            @Override
            public void serverConfigsChanged() {
                WebServerToolWindowPanel.this.constructTree();
            }
        });
    }

    private void constructUi() {
        Disposer.register((Disposable)GroupedServersConfigManager.getInstance(this.myProject), (Disposable)this.toolWindow.getDisposable());
        JPanel actionGroupPanel = new JPanel(new BorderLayout());
        this.myServerCombo = new WebServerCombo(true, 0, false, true);
        Disposer.register((Disposable)this.toolWindow.getDisposable(), (Disposable)this.myServerCombo);
        this.myServerCombo.setProject(this.myProject);
        this.myServerCombo.getComboBox().setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.myServerCombo.getComboBox().setMinimumAndPreferredWidth(100);
        this.myServerCombo.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                WebServerToolWindowPanel.this.constructTree();
            }
        });
        JPanel comboPanel = new JPanel(new BorderLayout());
        comboPanel.setBorder(JBUI.Borders.empty((int)4));
        comboPanel.add((Component)((Object)this.myServerCombo), "Center");
        this.myTopPanel = new JPanel(new GridBagLayout());
        this.myTopPanel.add((Component)comboPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myTopPanel.add((Component)actionGroupPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 10, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        this.myViewContentPanel = new JPanel();
        this.setToolbar(this.myTopPanel);
        this.setContent(this.myViewContentPanel);
        this.setBorder((Border)new ToolWindowEx.Border(true, false, false, false));
        this.myActionGroup = new DefaultActionGroup();
        ActionToolbar toolBar = ActionManager.getInstance().createActionToolbar("WebServerToolwindow", (ActionGroup)this.myActionGroup, true);
        toolBar.setTargetComponent((JComponent)((Object)this.myServerCombo));
        toolBar.setSecondaryActionsTooltip(WDBundle.message("server.browser.view.options.label", new Object[0]));
        this.createToolbarActions();
        actionGroupPanel.add((Component)toolBar.getComponent(), "Center");
        List<WebServerConfig> defaultServers = PublishConfig.getInstance(this.myProject).findDefaultServers();
        WebServerConfig serverConfig = (WebServerConfig)ContainerUtil.find(defaultServers, s -> s.needsTransfer());
        this.myServerCombo.resetToServerOrGroup(serverConfig != null ? new ServerOrGroup().setServer(serverConfig) : null);
        this.myServerCombo.setBorder(BorderFactory.createEmptyBorder());
        this.constructTree();
        ApplicationManager.getApplication().getMessageBus().connect(this.toolWindow.getDisposable()).subscribe(WebDeploymentTopics.SERVER_TREE, (Object)new DefaultServerTreeContentListener(null, null, null){

            @Override
            @Nullable
            protected WebServerTreeBuilder getTreeBuilder() {
                return WebServerToolWindowPanel.this.myTreeBuilder;
            }

            @Override
            @Nullable
            protected ServerTree getTree() {
                return WebServerToolWindowPanel.this.myTree;
            }

            @Override
            @Nullable
            protected Deployable getServer() {
                return Deployable.create((WebServerConfig)WebServerToolWindowPanel.this.myServerCombo.getSelectedElement().getSecond(), WebServerToolWindowPanel.this.myProject);
            }
        });
        this.myProject.getMessageBus().connect(this.toolWindow.getDisposable()).subscribe(WebDeploymentTopics.DEPLOYMENT_CONFIG, (Object)new DeploymentConfigChangeListener(){

            @Override
            public void optionsChanged() {
                ServerTreeNode root;
                Object node;
                if (WebServerToolWindowPanel.this.myTree == null || WebServerToolWindowPanel.this.myTreeBuilder == null || WebServerToolWindowPanel.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                WebServerConfig.RemotePath path = null;
                TreePath selection = WebServerToolWindowPanel.this.myTree.getSelectionPath();
                if (selection != null && (node = selection.getLastPathComponent()) instanceof ServerTreeNode) {
                    path = ((ServerTreeNode)((Object)node)).getPath();
                }
                if ((root = WebServerToolWindowPanel.this.myTreeBuilder.getRoot()) != null) {
                    ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(Deployable.create((WebServerConfig)WebServerToolWindowPanel.this.myServerCombo.getSelectedElement().getSecond(), WebServerToolWindowPanel.this.myProject), Collections.singleton(root.getPath()), false, false, path, this);
                }
            }
        });
    }

    private void constructTree() {
        JComponent treeComponent;
        if (this.myCurrentDisposable != null) {
            Disposer.dispose((Disposable)this.myCurrentDisposable);
        }
        Pair<WebServerGroupingWrap, WebServerConfig> selectedElement = this.myServerCombo.getSelectedElement();
        final WebServerConfig selectedServer = (WebServerConfig)selectedElement.second;
        if (selectedServer != null && selectedServer.getFileTransferConfig().validateFast() == null) {
            this.myCurrentDisposable = new Disposable(){

                public void dispose() {
                    if (WebServerToolWindowPanel.this.myTreeBuilder == null) {
                        return;
                    }
                    ServerTreeNode rootElement = WebServerToolWindowPanel.this.myTreeBuilder.getRoot();
                    if (rootElement != null) {
                        rootElement.releaseConnection();
                    }
                    Disposer.dispose((Disposable)WebServerToolWindowPanel.this.myTreeBuilder);
                }
            };
            Disposer.register((Disposable)this.toolWindow.getDisposable(), (Disposable)this.myCurrentDisposable);
            Deployable deployable = Deployable.create(selectedServer, this.myProject);
            ServerTreeNode root = new ServerTreeNode(this.myProject, ConnectionOwnerFactory.createConnectionOwner(this.myProject), deployable, PublishConfig.getInstance(this.myProject), false, FileTransferConfig.Origin.Default, new ServerTreeViewOptions(){

                @Override
                public boolean isShowSize() {
                    return WebServerToolWindowPanel.this.myShowSizeAction.mySelected;
                }

                @Override
                public boolean isShowTimestamp() {
                    return WebServerToolWindowPanel.this.myShowTimestampAction.mySelected;
                }

                @Override
                public boolean isShowPermissions() {
                    return WebServerToolWindowPanel.this.myShowPermissionsAction.mySelected;
                }

                @Override
                public boolean isShowPermissionsAsNumber() {
                    return false;
                }

                @Override
                public boolean isHighlightSymlinks() {
                    return WebServerToolWindowPanel.this.myHighlightSymlinksAction.mySelected;
                }

                @Override
                public boolean isHighlightMappings() {
                    return WebServerToolWindowPanel.this.myHighlightMappingsAction.mySelected;
                }

                @Override
                public boolean isHidden(FileName name) {
                    return HiddenPathsManager.getInstance(WebServerToolWindowPanel.this.myProject).isHidden(selectedServer, name);
                }
            });
            this.myTree = new ServerTree(this.myProject, deployable, root);
            this.myTreeBuilder = WebServerTreeBuilder.createInstance(root, (JTree)((Object)this.myTree), this.myCurrentDisposable);
            treeComponent = ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (boolean)true);
            new EditSourceOnDoubleClickHandler.TreeMouseListener(this, (JTree)((Object)this.myTree), null){

                protected void processDoubleClick(@NotNull MouseEvent e, @NotNull DataContext dataContext, @NotNull TreePath treePath) {
                    if (e == null) {
                        7.$$$reportNull$$$0(0);
                    }
                    if (dataContext == null) {
                        7.$$$reportNull$$$0(1);
                    }
                    if (treePath == null) {
                        7.$$$reportNull$$$0(2);
                    }
                    EditRemoteFileAction.editRemoteFile(dataContext, (ServerTreeNode)((Object)TreeUtil.getLastUserObject(ServerTreeNode.class, (TreePath)treePath)));
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "dataContext";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[0] = "treePath";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$7";
                    objectArray[2] = "processDoubleClick";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }.installOn((Component)((Object)this.myTree));
            PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)ACTION_GROUP, (String)"RemoteHostPopup");
        } else {
            this.myTree = null;
            this.myTreeBuilder = null;
            if (selectedServer != null) {
                String errorText = WDBundle.message("remote.host.invalid", selectedServer.getName(), selectedServer.getFileTransferConfig().validateFast());
                treeComponent = new JLabel(errorText, 0);
            } else if (selectedElement.first != null) {
                JPanel linkPanel = new JPanel();
                List servers = ((WebServerGroupingWrap)selectedElement.getFirst()).getServers();
                if ((servers = ContainerUtil.filter(servers, serverConfig -> serverConfig.needsTransfer())).isEmpty()) {
                    linkPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1));
                    GridConstraints constraints = new GridConstraints();
                    constraints.setRow(0);
                    constraints.setAnchor(8);
                    constraints.setFill(1);
                    JBLabel label = new JBLabel(WDBundle.message("remote.host.this.group.contains.no.servers", new Object[0]));
                    linkPanel.add((Component)label, constraints);
                } else {
                    linkPanel.setLayout((LayoutManager)new GridLayoutManager(servers.size(), 1));
                    for (int i = 0; i < servers.size(); ++i) {
                        GridConstraints constraints = new GridConstraints();
                        constraints.setRow(i);
                        constraints.setAnchor(8);
                        constraints.setFill(1);
                        WebServerConfig serverConfig2 = (WebServerConfig)servers.get(i);
                        ActionLink label = new ActionLink(serverConfig2.getName(), e -> {
                            this.myServerCombo.selectServer(serverConfig2);
                            this.constructTree();
                        });
                        linkPanel.add((Component)label, constraints);
                    }
                }
                linkPanel.setOpaque(false);
                linkPanel.setBorder((Border)JBUI.Borders.empty((int)5, (int)10));
                JPanel mainPanel = new JPanel(new BorderLayout());
                mainPanel.add((Component)linkPanel, "North");
                JPanel centerPanel = new JPanel();
                centerPanel.setOpaque(false);
                mainPanel.add((Component)centerPanel, "Center");
                treeComponent = mainPanel;
            } else {
                String errorText = this.myServerCombo.getSelectedErrorMessage();
                treeComponent = new JLabel(errorText, 0);
            }
        }
        treeComponent.setBackground(UIUtil.getTreeBackground());
        treeComponent.setOpaque(true);
        treeComponent.setBorder(BorderFactory.createEmptyBorder());
        this.myViewContentPanel.removeAll();
        this.myViewContentPanel.setLayout(new BorderLayout());
        this.myViewContentPanel.add((Component)treeComponent, "Center");
        this.myViewContentPanel.revalidate();
        this.myViewContentPanel.repaint();
        this.myTopPanel.revalidate();
    }

    private void createToolbarActions() {
        this.myActionGroup.removeAll();
        this.myActionGroup.addAction(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new DefaultTreeExpander(this, () -> this.myTree){

            protected void collapseAll(@NotNull JTree tree, int keepSelectionLevel) {
                if (tree == null) {
                    8.$$$reportNull$$$0(0);
                }
                MutableTreeNode root = (MutableTreeNode)tree.getModel().getRoot();
                Enumeration<? extends TreeNode> rootChildren = root.children();
                while (rootChildren.hasMoreElements()) {
                    TreePath treePath = new TreePath(new Object[]{root, rootChildren.nextElement()});
                    tree.collapsePath(treePath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$8", "collapseAll"));
            }
        }, (JComponent)((Object)this)));
        RefreshAction refreshAction = new RefreshAction(IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), IdeBundle.message((String)"action.refresh", (Object[])new Object[0]), AllIcons.Actions.Refresh){

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(0);
                }
                e.getPresentation().setEnabled(WebServerToolWindowPanel.this.myTree != null);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    9.$$$reportNull$$$0(1);
                }
                if (WebServerToolWindowPanel.this.myTreeBuilder == null || WebServerToolWindowPanel.this.myTreeBuilder.isDisposed()) {
                    return;
                }
                ServerTreeNode root = WebServerToolWindowPanel.this.myTreeBuilder.getRoot();
                if (root == null) {
                    return;
                }
                FileObject fileObject = root.getFileObject();
                FileSystemManager fileSystemManager = RemoteConnectionManager.getInstance().getManager();
                if (fileObject != null) {
                    fileSystemManager.getFilesCache().clear(fileObject.getFileSystem());
                }
                WebServerToolWindowPanel.this.myTreeBuilder.refreshRoot();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "e";
                objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$9";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "update";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "actionPerformed";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        refreshAction.registerShortcutOn((JComponent)((Object)this));
        this.myActionGroup.addAction((AnAction)refreshAction);
        this.myActionGroup.addAction((AnAction)new MyCloseAction());
        SelectInRemoteHostAction selectInRemoteHostAction = new SelectInRemoteHostAction(WDBundle.message("selest.open.file", new Object[0]), AllIcons.General.Locate){

            @Override
            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    10.$$$reportNull$$$0(0);
                }
                return actionUpdateThread;
            }

            @Override
            public void update(@NotNull AnActionEvent e) {
                Project project;
                if (e == null) {
                    10.$$$reportNull$$$0(1);
                }
                if ((project = e.getProject()) != null && WebServerToolWindowPanel.this.myServerCombo.getSelectedServer() != null && !WebServerToolWindowPanel.this.myServerCombo.getSelectedServer().getAccessType().equals((Object)AccessType.WEBDAV)) {
                    FileEditor fileEditor;
                    EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)WebServerToolWindowPanel.this.myProject).getCurrentWindow();
                    EditorComposite editorComposite = window == null ? null : window.getSelectedComposite();
                    FileEditor fileEditor2 = fileEditor = editorComposite == null ? null : editorComposite.getSelectedWithProvider().getFileEditor();
                    if (fileEditor != null) {
                        VirtualFile file = fileEditor.getFile();
                        if (file instanceof RemoteVirtualFile) {
                            e.getPresentation().setEnabled(true);
                        } else {
                            Pair<WebServerConfig, DeploymentPathMapping> mapping = PublishActionUtil.findMappingFor(file, WebServerToolWindowPanel.this.myServerCombo.getSelectedServer(), PublishConfig.getInstance(project), false);
                            WebServerConfig.RemotePath deployPath = mapping != null ? ((DeploymentPathMapping)mapping.getSecond()).mapToDeployPath(file.getPath(), (Mappable)WebServerToolWindowPanel.this.getSelectedServer()) : null;
                            e.getPresentation().setEnabled(deployPath != null);
                        }
                        return;
                    }
                }
                e.getPresentation().setEnabled(false);
            }

            @Override
            @Nullable
            protected SelectInContext createSelectInContext(DataContext dataContext) {
                FileEditor fileEditor;
                Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
                if (project == null) {
                    return null;
                }
                EditorWindow window = FileEditorManagerEx.getInstanceEx((Project)WebServerToolWindowPanel.this.myProject).getCurrentWindow();
                EditorComposite editorComposite = window == null ? null : window.getSelectedComposite();
                FileEditor fileEditor2 = fileEditor = editorComposite == null ? null : editorComposite.getSelectedWithProvider().getFileEditor();
                if (fileEditor == null) {
                    return null;
                }
                VirtualFile file = fileEditor.getFile();
                if (file == null) {
                    return null;
                }
                return new FileSelectInContext(project, file, null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$10";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$10";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
        this.myActionGroup.addAction((AnAction)selectInRemoteHostAction);
    }

    public void installGearActions(@NotNull ToolWindowEx window) {
        if (window == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(2);
        }
        DefaultActionGroup gearActions = new DefaultActionGroup();
        gearActions.add((AnAction)this.myShowSizeAction);
        gearActions.add((AnAction)this.myShowTimestampAction);
        gearActions.add((AnAction)this.myShowPermissionsAction);
        gearActions.add((AnAction)this.myHighlightSymlinksAction);
        gearActions.add((AnAction)this.myHighlightMappingsAction);
        window.setAdditionalGearActions((ActionGroup)gearActions);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(3);
        }
        super.uiDataSnapshot(sink);
        Pair<WebServerGroupingWrap, WebServerConfig> selection = this.myServerCombo.getSelectedElement();
        sink.lazy(WebDeploymentDataKeys.DEPLOYABLE, () -> Deployable.create((WebServerConfig)selection.getSecond(), this.myProject));
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)HELP_ID);
    }

    @Nullable
    public String getSelectedServerName() {
        WebServerConfig server = this.myServerCombo.getSelectedServer();
        return server != null ? server.getName() : null;
    }

    @Nullable
    public WebServerConfig getSelectedServer() {
        return this.myServerCombo.getSelectedServer();
    }

    public void selectInServerByName(@Nullable Project project, @NotNull String serverName, @NotNull WebServerConfig.RemotePath path) {
        Pair<WebServerGroupingWrap, WebServerConfig> server;
        if (serverName == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(4);
        }
        if (path == null) {
            WebServerToolWindowPanel.$$$reportNull$$$0(5);
        }
        if ((server = GroupedServersConfigManager.getInstance(project).findByName(serverName)) == null || server.second == null) {
            return;
        }
        this.myServerCombo.selectServer((WebServerConfig)server.second);
        if (this.myTreeBuilder != null) {
            this.myTreeBuilder.selectPath(path);
            IdeFocusManager.findInstanceByComponent((Component)((Object)this.myTree)).requestFocus((Component)((Object)this.myTree), true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "window";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serverName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "installGearActions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uiDataSnapshot";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "selectInServerByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class MyToggleAction
    extends ToggleAction
    implements DumbAware {
        private boolean mySelected;
        private final PropertyProvider myStoredValue;

        private MyToggleAction(@NlsActions.ActionDescription String textKey, String description, Icon icon, boolean defaultValue) {
            super(WDBundle.message(textKey, new Object[0]), description, icon);
            this.myStoredValue = new PropertyProvider(WebServerToolWindowPanel.this.myProject, "WebServerToolWindowPanel." + textKey, String.valueOf(defaultValue));
            this.mySelected = Boolean.parseBoolean(this.myStoredValue.readValue());
        }

        private MyToggleAction(String textKey, boolean defaultValue) {
            this(textKey, null, null, defaultValue);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(0);
            }
            return this.mySelected;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyToggleAction.$$$reportNull$$$0(1);
            }
            this.mySelected = state;
            this.myStoredValue.saveValue(String.valueOf(this.mySelected));
            if (WebServerToolWindowPanel.this.myTreeBuilder == null) {
                return;
            }
            WebServerToolWindowPanel.this.myTreeBuilder.queueUpdate();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyToggleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$MyToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$MyToggleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class MyCloseAction
    extends CloseTabToolbarAction {
        private MyCloseAction() {
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                MyCloseAction.$$$reportNull$$$0(0);
            }
            WebServerToolWindowPanel.this.toolWindow.remove();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyCloseAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$MyCloseAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/plugins/webDeployment/ui/WebServerToolWindowPanel$MyCloseAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

