/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.collaboration.snippets.PathHandlingMode;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ide.progress.TasksKt;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.GithubCreateGistService;
import org.jetbrains.plugins.github.GithubGistContentsCollector;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutorKt;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubGist;
import org.jetbrains.plugins.github.api.data.request.GithubGistRequest;
import org.jetbrains.plugins.github.authentication.GHLoginSource;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubCreateGistDialog;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubSettings;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\u0002\u0010\u0010JP\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00122\b\u0010\u001d\u001a\u0004\u0018\u00010\u0012H\u0087@\u00a2\u0006\u0002\u0010\u001eJ8\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000f2\u0006\u0010 \u001a\u00020!H\u0082@\u00a2\u0006\u0002\u0010\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/plugins/github/GithubCreateGistService;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "createGistAction", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "files", "", "(Lcom/intellij/openapi/editor/Editor;Lcom/intellij/openapi/vfs/VirtualFile;[Lcom/intellij/openapi/vfs/VirtualFile;)V", "createGist", "", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "contents", "", "Lorg/jetbrains/plugins/github/api/data/request/GithubGistRequest$FileContent;", "isSecret", "", "description", "filename", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GithubServerPath;Ljava/util/List;ZLjava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "renameContents", "pathHandlingMode", "Lcom/intellij/collaboration/snippets/PathHandlingMode;", "(Ljava/util/List;[Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/collaboration/snippets/PathHandlingMode;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nGithubCreateGistService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GithubCreateGistService.kt\norg/jetbrains/plugins/github/GithubCreateGistService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,146:1\n3516#2,8:147\n*S KotlinDebug\n*F\n+ 1 GithubCreateGistService.kt\norg/jetbrains/plugins/github/GithubCreateGistService\n*L\n141#1:147,8\n*E\n"})
public final class GithubCreateGistService {
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;

    public GithubCreateGistService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
    }

    public final void createGistAction(@Nullable Editor editor, @Nullable VirtualFile file, @NotNull VirtualFile[] files) {
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        GithubSettings settings = GithubSettings.getInstance();
        String fileName = GithubGistContentsCollector.Companion.getGistFileName(editor, files);
        GithubCreateGistDialog dialog = new GithubCreateGistDialog(this.project, fileName, settings.isPrivateGist(), settings.isOpenInBrowserGist(), settings.isCopyURLGist());
        if (!dialog.showAndGet()) {
            return;
        }
        settings.setPrivateGist(dialog.isSecret());
        settings.setOpenInBrowserGist(dialog.isOpenInBrowser());
        settings.setCopyURLGist(dialog.isCopyURL());
        GithubAccount githubAccount = dialog.getAccount();
        Intrinsics.checkNotNull((Object)((Object)githubAccount));
        GithubAccount account = githubAccount;
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, account, editor, file, files, dialog, null){
            int label;
            final /* synthetic */ GithubCreateGistService this$0;
            final /* synthetic */ GithubAccount $account;
            final /* synthetic */ Editor $editor;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ VirtualFile[] $files;
            final /* synthetic */ GithubCreateGistDialog $dialog;
            {
                this.this$0 = $receiver;
                this.$account = $account;
                this.$editor = $editor;
                this.$file = $file;
                this.$files = $files;
                this.$dialog = $dialog;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        Project project = GithubCreateGistService.access$getProject$p(this.this$0);
                        String string = GithubBundle.message("create.gist.process", new Object[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                        this.label = 1;
                        Object object2 = TasksKt.withBackgroundProgress((Project)project, (String)string, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$account, this.this$0, this.$editor, this.$file, this.$files, this.$dialog, null){
                            Object L$0;
                            Object L$1;
                            Object L$2;
                            int I$0;
                            int label;
                            final /* synthetic */ GithubAccount $account;
                            final /* synthetic */ GithubCreateGistService this$0;
                            final /* synthetic */ Editor $editor;
                            final /* synthetic */ VirtualFile $file;
                            final /* synthetic */ VirtualFile[] $files;
                            final /* synthetic */ GithubCreateGistDialog $dialog;
                            {
                                this.$account = $account;
                                this.this$0 = $receiver;
                                this.$editor = $editor;
                                this.$file = $file;
                                this.$files = $files;
                                this.$dialog = $dialog;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        token = GHCompatibilityUtil.getOrRequestToken(this.$account, GithubCreateGistService.access$getProject$p(this.this$0), GHLoginSource.GIST);
                                        if (token == null) {
                                            return Unit.INSTANCE;
                                        }
                                        requestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create(this.$account.getServer(), token);
                                        var5_7 = GithubGistContentsCollector.Companion.collectContents(GithubCreateGistService.access$getProject$p(this.this$0), this.$editor, this.$file, this.$files);
                                        var6_8 = this.this$0;
                                        var7_9 = this.$files;
                                        var8_10 = this.$dialog;
                                        it = var5_7;
                                        $i$a$-let-GithubCreateGistService$createGistAction$1$1$contents$1 = 0;
                                        v0 = var8_10.getPathMode();
                                        Intrinsics.checkNotNull((Object)v0);
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)token);
                                        this.L$1 = requestExecutor;
                                        this.L$2 = SpillingKt.nullOutSpilledVariable(it);
                                        this.I$0 = $i$a$-let-GithubCreateGistService$createGistAction$1$1$contents$1;
                                        this.label = 1;
                                        v1 = GithubCreateGistService.access$renameContents(var6_8, it, var7_9, v0, (Continuation)this);
                                        if (v1 == var11_2) {
                                            return var11_2;
                                        }
                                        ** GOTO lbl34
                                    }
                                    case 1: {
                                        $i$a$-let-GithubCreateGistService$createGistAction$1$1$contents$1 = this.I$0;
                                        it = (List)this.L$2;
                                        requestExecutor = (GithubApiRequestExecutor)this.L$1;
                                        token = (String)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl34:
                                        // 2 sources

                                        contents = (List)v1;
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)token);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)requestExecutor);
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)contents);
                                        this.label = 2;
                                        v2 = this.this$0.createGist(GithubCreateGistService.access$getProject$p(this.this$0), requestExecutor, this.$account.getServer(), contents, this.$dialog.isSecret(), this.$dialog.getDescription(), this.$dialog.getFileName(), (Continuation<? super String>)((Continuation)this));
                                        if (v2 == var11_2) {
                                            return var11_2;
                                        }
                                        ** GOTO lbl49
                                    }
                                    case 2: {
                                        contents = (List)this.L$2;
                                        requestExecutor = (GithubApiRequestExecutor)this.L$1;
                                        token = (String)this.L$0;
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl49:
                                        // 2 sources

                                        if ((gistUrl = (String)v2) == null) {
                                            return Unit.INSTANCE;
                                        }
                                        if (this.$dialog.isCopyURL()) {
                                            stringSelection = new StringSelection(gistUrl);
                                            CopyPasteManager.getInstance().setContents((Transferable)stringSelection);
                                        }
                                        if (this.$dialog.isOpenInBrowser()) {
                                            BrowserUtil.browse((String)gistUrl);
                                        } else {
                                            GithubNotifications.showInfoURL(GithubCreateGistService.access$getProject$p(this.this$0), "github.gist.created", GithubBundle.message("create.gist.success", new Object[0]), GithubBundle.message("create.gist.url", new Object[0]), gistUrl);
                                        }
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @VisibleForTesting
    @Nullable
    public final Object createGist(@NotNull Project project, @NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server, @NotNull List<? extends GithubGistRequest.FileContent> contents, boolean isSecret, @NotNull String description, @Nullable String filename, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof createGist.1)) ** GOTO lbl-1000
        var13_9 = $completion;
        if ((var13_9.label & -2147483648) != 0) {
            var13_9.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ GithubCreateGistService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.createGist(null, null, null, null, false, null, null, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var14_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (contents.isEmpty()) {
                    GithubNotifications.showWarning(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), GithubBundle.message("create.gist.error.empty", new Object[0]));
                    return null;
                }
                if (contents.size() == 1 && filename != null) {
                    var10_12 /* !! */  = new GithubGistRequest.FileContent[]{new GithubGistRequest.FileContent(filename, ((GithubGistRequest.FileContent)CollectionsKt.first((List)contents)).getContent())};
                    v0 = CollectionsKt.mutableListOf((Object[])var10_12 /* !! */ );
                } else {
                    v0 = contents;
                }
                contents = v0;
                $continuation.L$0 = project;
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)executor);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)server);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)contents);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)description);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)filename);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)contents);
                $continuation.Z$0 = isSecret;
                $continuation.label = 1;
                v1 = GithubApiRequestExecutorKt.executeSuspend(executor, GithubApiRequests.Gists.create(server, contents, description, isSecret == false), $continuation);
                ** if (v1 != var14_11) goto lbl35
lbl34:
                // 1 sources

                return var14_11;
lbl35:
                // 1 sources

                ** GOTO lbl49
            }
            case 1: {
                isSecret = $continuation.Z$0;
                contents = (List)$continuation.L$6;
                filename = (String)$continuation.L$5;
                description = (String)$continuation.L$4;
                contents = (List)$continuation.L$3;
                server = (GithubServerPath)$continuation.L$2;
                executor = (GithubApiRequestExecutor)$continuation.L$1;
                project = (Project)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl49:
                    // 2 sources

                    var10_12 /* !! */  = ((GithubGist)v1).getHtmlUrl();
                }
                catch (IOException e) {
                    GithubNotifications.showError(project, "github.gist.cannot.create", GithubBundle.message("cannot.create.gist", new Object[0]), e);
                    var10_12 /* !! */  = null;
                }
                return var10_12 /* !! */ ;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object renameContents(List<? extends GithubGistRequest.FileContent> contents, VirtualFile[] files, PathHandlingMode pathHandlingMode, Continuation<? super List<? extends GithubGistRequest.FileContent>> $completion) {
        if (!($completion instanceof renameContents.1)) ** GOTO lbl-1000
        var20_5 = $completion;
        if ((var20_5.label & -2147483648) != 0) {
            var20_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                /* synthetic */ Object result;
                final /* synthetic */ GithubCreateGistService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return GithubCreateGistService.access$renameContents(this.this$0, null, null, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var21_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        block0 : switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                fileNameExtractor = PathHandlingMode.Companion.getFileNameExtractor(this.project, ArraysKt.toList((Object[])files), pathHandlingMode);
                var6_9 = contents;
                other$iv = files;
                $i$f$zip = 0;
                arraySize$iv = other$iv.length;
                list$iv = new ArrayList(Math.min(CollectionsKt.collectionSizeOrDefault((Iterable)$this$zip$iv, (int)10), arraySize$iv));
                i$iv = 0;
                var12_15 = $this$zip$iv.iterator();
lbl20:
                // 2 sources

                while (var12_15.hasNext()) {
                    element$iv = var12_15.next();
                    if (i$iv >= arraySize$iv) break block0;
                    var14_17 = other$iv[i$iv++];
                    var15_18 = (GithubGistRequest.FileContent)element$iv;
                    var18_21 = list$iv;
                    $i$a$-zip-GithubCreateGistService$renameContents$2 = 0;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)contents);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)files);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)pathHandlingMode);
                    $continuation.L$3 = fileNameExtractor;
                    $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)$this$zip$iv);
                    $continuation.L$5 = other$iv;
                    $continuation.L$6 = list$iv;
                    $continuation.L$7 = var12_15;
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)element$iv);
                    $continuation.L$9 = SpillingKt.nullOutSpilledVariable((Object)file);
                    $continuation.L$10 = originalContent;
                    $continuation.L$11 = var18_21;
                    $continuation.I$0 = $i$f$zip;
                    $continuation.I$1 = arraySize$iv;
                    $continuation.I$2 = i$iv;
                    $continuation.I$3 = $i$a$-zip-GithubCreateGistService$renameContents$2;
                    $continuation.label = 1;
                    v0 = fileNameExtractor.invoke((Object)file, (Object)$continuation);
                    if (v0 == var21_7) {
                        return var21_7;
                    }
                    ** GOTO lbl68
                }
                break;
            }
            case 1: {
                $i$a$-zip-GithubCreateGistService$renameContents$2 = $continuation.I$3;
                i$iv = $continuation.I$2;
                arraySize$iv = $continuation.I$1;
                $i$f$zip = $continuation.I$0;
                var18_21 = (ArrayList)$continuation.L$11;
                originalContent = (GithubGistRequest.FileContent)$continuation.L$10;
                file = (VirtualFile)$continuation.L$9;
                element$iv = $continuation.L$8;
                var12_15 = (Iterator<T>)$continuation.L$7;
                list$iv = (ArrayList)$continuation.L$6;
                other$iv = (VirtualFile[])$continuation.L$5;
                $this$zip$iv = (Iterable)$continuation.L$4;
                fileNameExtractor = (Function2)$continuation.L$3;
                pathHandlingMode = (PathHandlingMode)$continuation.L$2;
                files = (VirtualFile[])$continuation.L$1;
                contents = (List)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl68:
                // 2 sources

                newFileName = (String)v0;
                var18_21.add(new GithubGistRequest.FileContent(StringsKt.replace$default((String)newFileName, (String)"/", (String)"\\", (boolean)false, (int)4, null), originalContent.getContent()));
                ** GOTO lbl20
            }
        }
        return list$iv;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Project access$getProject$p(GithubCreateGistService $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$renameContents(GithubCreateGistService $this, List contents, VirtualFile[] files, PathHandlingMode pathHandlingMode, Continuation $completion) {
        return $this.renameContents(contents, files, pathHandlingMode, (Continuation<? super List<? extends GithubGistRequest.FileContent>>)$completion);
    }
}

