/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.anim.AnimationFactory;
import com.intellij.openapi.graph.anim.AnimationListener;
import com.intellij.openapi.graph.anim.AnimationObject;
import com.intellij.openapi.graph.anim.AnimationPlayer;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.layout.GraphLayout;
import com.intellij.openapi.graph.services.GraphAnimationService;
import com.intellij.openapi.graph.services.GraphLayoutService;
import com.intellij.openapi.graph.util.DefaultMutableValue2D;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.LayoutMorpher;
import com.intellij.openapi.graph.view.ViewAnimationFactory;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GraphAnimationServiceImpl
implements GraphAnimationService {
    @NotNull
    private static final Key<Boolean> ZOOM_ANIMATION_DISABLED_KEY = Key.create((String)"com.intellij.openapi.graph.services.GraphAnimationService#ZOOM_ANIMATION_DISABLED_KEY");
    private static final double CONTENT_PADDINGS = 20.0;
    private static final int ANIMATION_PLAYER_FPS = 1200;
    private static final long FOCUS_VIEW_DURATION_MILLIS = 800L;
    private volatile int myLayoutDurationMillis = 1500;
    private volatile boolean myIsAnimationEnabledGlobally = true;
    private volatile boolean myIsAnimationPerformingNow = false;
    private volatile boolean myIsAnimationChangingZoomPerformingNow = false;

    public boolean isAnimationEnabledGlobally() {
        return this.myIsAnimationEnabledGlobally;
    }

    public void setAnimationEnabledGlobally(boolean isEnabled) {
        this.myIsAnimationEnabledGlobally = isEnabled;
    }

    public int getLayoutAnimationDuration() {
        return this.myLayoutDurationMillis;
    }

    public void setLayoutAnimationDuration(int durationMillis) {
        this.myLayoutDurationMillis = durationMillis;
    }

    public boolean isAnimationPerformingNow() {
        return this.myIsAnimationPerformingNow;
    }

    private void y(boolean bl) {
        this.myIsAnimationPerformingNow = bl;
    }

    public boolean isAnimationChangingZoomPerformingNow() {
        return this.myIsAnimationChangingZoomPerformingNow;
    }

    private void g(boolean bl) {
        this.myIsAnimationChangingZoomPerformingNow = bl;
    }

    public boolean isZoomAnimationEnabledFor(@NotNull GraphBuilder<?, ?> builder) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(0);
        }
        return builder.getUserData(ZOOM_ANIMATION_DISABLED_KEY) != Boolean.TRUE;
    }

    public void setZoomAnimationEnabledFor(@NotNull GraphBuilder<?, ?> builder, boolean isEnabled) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(1);
        }
        builder.putUserData(ZOOM_ANIMATION_DISABLED_KEY, (Object)(!isEnabled ? (char)'\u0001' : '\u0000'));
    }

    public void fitContent(@NotNull Graph2DView view, boolean animated) {
        if (view == null) {
            GraphAnimationServiceImpl.y(2);
        }
        if (!animated || !this.isAnimationEnabledGlobally()) {
            view.fitContent();
            return;
        }
        int n2 = view.getVerticalScrollBarPolicy();
        int n3 = view.getHorizontalScrollBarPolicy();
        if (n2 == 20) {
            view.setVerticalScrollBarPolicy(21);
        }
        if (n3 == 30) {
            view.setHorizontalScrollBarPolicy(31);
        }
        this.focusView(view, GraphAnimationServiceImpl.y(view), GraphAnimationServiceImpl.y(view, view.calculateContentBounds()), true);
        view.fitWorldRect();
        if (n2 == 20) {
            view.setVerticalScrollBarPolicy(20);
        }
        if (n2 == 31) {
            view.setVerticalScrollBarPolicy(31);
        }
    }

    private static double y(@NotNull Graph2DView graph2DView) {
        if (graph2DView == null) {
            GraphAnimationServiceImpl.y(3);
        }
        double d2 = graph2DView.getJComponent().getWidth();
        double d3 = graph2DView.getJComponent().getHeight();
        Rectangle rectangle = graph2DView.calculateContentBounds();
        if (rectangle.getWidth() <= d2 && rectangle.getHeight() <= d3) {
            return 1.0;
        }
        return d2 / d3 > (rectangle.getWidth() + 20.0) / (rectangle.getHeight() + 20.0) ? d3 / (rectangle.getHeight() + 20.0) : d2 / (rectangle.getWidth() + 20.0);
    }

    @NotNull
    private static Point2D.Double y(@NotNull Graph2DView graph2DView, @NotNull Rectangle rectangle) {
        if (graph2DView == null) {
            GraphAnimationServiceImpl.y(4);
        }
        if (rectangle == null) {
            GraphAnimationServiceImpl.y(5);
        }
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        double d2 = graph2DView.getJComponent().getWidth();
        double d3 = graph2DView.getJComponent().getHeight();
        if (rectangle.getWidth() <= d2 && rectangle.getHeight() <= d3) {
            if (rectangle.getWidth() > 0.0 && rectangle.getHeight() > 0.0) {
                double_.setLocation(rectangle.getX() + 0.5 * rectangle.getWidth(), rectangle.getY() + 0.5 * rectangle.getHeight());
            }
        } else {
            double_.setLocation(rectangle.getX() - 10.0 + 0.5 * (rectangle.getWidth() + 20.0), rectangle.getY() - 10.0 + 0.5 * (rectangle.getHeight() + 20.0));
        }
        Point2D.Double double_2 = double_;
        if (double_2 == null) {
            GraphAnimationServiceImpl.y(6);
        }
        return double_2;
    }

    public <N> void focusViewOnModelNodes(@NotNull GraphBuilder<N, ?> builder, @NotNull Collection<N> nodes, boolean animated) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(7);
        }
        if (nodes == null) {
            GraphAnimationServiceImpl.y(8);
        }
        this.focusViewOnNodes(builder, ContainerUtil.mapNotNull(nodes, arg_0 -> builder.getNode(arg_0)), animated);
    }

    public void focusViewOnNodes(@NotNull GraphBuilder<?, ?> builder, @NotNull Collection<Node> nodes, boolean animated) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(9);
        }
        if (nodes == null) {
            GraphAnimationServiceImpl.y(10);
        }
        Graph2D graph2D = builder.getGraph();
        switch (nodes.size()) {
            case 0: {
                break;
            }
            case 1: {
                Node node2 = nodes.iterator().next();
                Point2D.Double double_ = new Point2D.Double(graph2D.getCenterX(node2), graph2D.getCenterY(node2));
                Rectangle2D.Double double_2 = new Rectangle2D.Double(double_.getX(), double_.getY(), graph2D.getWidth(node2), graph2D.getHeight(node2));
                if (builder.getView().getVisibleRect2D().contains(double_2)) break;
                this.focusView(builder.getView(), double_, animated);
                break;
            }
            default: {
                double d2 = nodes.stream().mapToDouble(node -> graph2D.getY(node)).min().orElse(0.0);
                double d3 = nodes.stream().mapToDouble(node -> graph2D.getX(node)).min().orElse(0.0);
                double d4 = nodes.stream().mapToDouble(node -> graph2D.getY(node) + graph2D.getHeight(node)).max().orElse(0.0);
                double d5 = nodes.stream().mapToDouble(node -> graph2D.getX(node) + graph2D.getWidth(node)).max().orElse(0.0);
                if (builder.getView().getVisibleRect2D().contains(new Rectangle2D.Double(d3, d2, d5 - d3, d4 - d2))) break;
                this.zoomToArea(builder.getView(), d2, d3, d4, d5, animated);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void zoomToArea(@NotNull Graph2DView view, double topLeftY, double topLeftX, double bottomRightY, double d2, boolean bl) {
        void animated;
        void bottomRightX;
        if (view == null) {
            GraphAnimationServiceImpl.y(11);
        }
        Dimension dimension = view.getViewSize();
        void var12_8 = bottomRightX - topLeftX + 20.0;
        double d3 = bottomRightY - topLeftY + 20.0;
        double d4 = dimension.width == 0 || dimension.height == 0 ? 1.0 : Math.min(Math.min(dimension.getWidth() / var12_8, dimension.getHeight() / d3), 1.5);
        Logger.getInstance(GraphAnimationServiceImpl.class).assertTrue(d4 > 0.0, Arrays.asList(dimension, topLeftY, topLeftX, bottomRightY, (double)bottomRightX));
        Point2D.Double double_ = new Point2D.Double(topLeftX + var12_8 / 2.0, topLeftY + d3 / 2.0);
        this.focusView(view, d4, double_, (boolean)animated);
    }

    public void updateWorldRect(@NotNull Graph2DView view) {
        if (view == null) {
            GraphAnimationServiceImpl.y(12);
        }
        Rectangle rectangle = view.getGraph2D().getBoundingBox();
        int n2 = (int)rectangle.getX() - 20;
        int n3 = (int)rectangle.getY() - 20;
        int n4 = (int)rectangle.getWidth() + 40;
        int n5 = (int)rectangle.getHeight() + 40;
        view.setWorldRect(n2, n3, n4, n5);
    }

    public void focusView(@NotNull Graph2DView view, boolean animated) {
        if (view == null) {
            GraphAnimationServiceImpl.y(13);
        }
        this.focusView(view, GraphAnimationServiceImpl.y(view, view.calculateContentBounds()), animated);
    }

    public void focusView(@NotNull Graph2DView view, @NotNull Rectangle focusArea, boolean animated) {
        if (view == null) {
            GraphAnimationServiceImpl.y(14);
        }
        if (focusArea == null) {
            GraphAnimationServiceImpl.y(15);
        }
        this.focusView(view, GraphAnimationServiceImpl.y(view, focusArea), animated);
    }

    public void focusView(@NotNull Graph2DView view, @NotNull Point2D newViewCenter, boolean animated) {
        if (view == null) {
            GraphAnimationServiceImpl.y(16);
        }
        if (newViewCenter == null) {
            GraphAnimationServiceImpl.y(17);
        }
        this.focusView(view, view.getZoom(), newViewCenter, animated);
    }

    /*
     * WARNING - void declaration
     */
    public void focusView(@NotNull Graph2DView view, double targetZoom, @NotNull Point2D newViewCenter, boolean bl) {
        void animated;
        boolean bl2;
        if (view == null) {
            GraphAnimationServiceImpl.y(18);
        }
        if (newViewCenter == null) {
            GraphAnimationServiceImpl.y(19);
        }
        GraphBuilder graphBuilder = (GraphBuilder)GraphDataKeys.getData((Graph2DView)view, (String)GraphDataKeys.GRAPH_BUILDER.getName());
        boolean bl3 = Math.abs(view.getZoom() - targetZoom) > 0.01;
        boolean bl4 = bl2 = !this.isAnimationEnabledGlobally() || bl3 && graphBuilder != null && !this.isZoomAnimationEnabledFor(graphBuilder);
        if (animated != false && !bl2) {
            this.y(view, GraphAnimationServiceImpl.y(view, targetZoom, newViewCenter), bl3);
        }
        view.setCenter(newViewCenter.getX(), newViewCenter.getY());
        if (graphBuilder != null) {
            graphBuilder.setZoom(targetZoom);
        } else {
            view.setZoom(targetZoom);
        }
    }

    public void performAnimatedLayout(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphLayout layout) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(20);
        }
        if (layout == null) {
            GraphAnimationServiceImpl.y(21);
        }
        this.performAnimatedLayout(builder, layout, this.getLayoutAnimationDuration());
    }

    public void performAnimatedLayout(@NotNull GraphBuilder<?, ?> builder, @NotNull GraphLayout layout, int durationMillis) {
        if (builder == null) {
            GraphAnimationServiceImpl.y(22);
        }
        if (layout == null) {
            GraphAnimationServiceImpl.y(23);
        }
        if (!this.isAnimationEnabledGlobally()) {
            GraphLayoutService.getInstance().applyLayout(builder, layout);
        } else {
            this.y(builder.getView(), GraphAnimationServiceImpl.y(builder.getView(), layout, durationMillis), false);
        }
    }

    @NotNull
    private static AnimationObject y(@NotNull Graph2DView graph2DView, double d2, @NotNull Point2D point2D) {
        if (graph2DView == null) {
            GraphAnimationServiceImpl.y(24);
        }
        if (point2D == null) {
            GraphAnimationServiceImpl.y(25);
        }
        ViewAnimationFactory viewAnimationFactory = GraphManager.getGraphManager().createViewAnimationFactory(graph2DView);
        AnimationObject animationObject = AnimationFactory.Statics.createEasedAnimation((AnimationObject)viewAnimationFactory.focusView(d2, DefaultMutableValue2D.Statics.createView((Point2D)point2D), 800L));
        if (animationObject == null) {
            GraphAnimationServiceImpl.y(26);
        }
        return animationObject;
    }

    @NotNull
    private static AnimationObject y(@NotNull Graph2DView graph2DView, @NotNull GraphLayout graphLayout, int n2) {
        if (graph2DView == null) {
            GraphAnimationServiceImpl.y(27);
        }
        if (graphLayout == null) {
            GraphAnimationServiceImpl.y(28);
        }
        LayoutMorpher layoutMorpher = GraphManager.getGraphManager().createLayoutMorpher(graph2DView, graphLayout);
        layoutMorpher.setPreferredDuration((long)n2);
        layoutMorpher.setKeepZoomFactor(true);
        AnimationObject animationObject = AnimationFactory.Statics.createEasedAnimation((AnimationObject)layoutMorpher);
        if (animationObject == null) {
            GraphAnimationServiceImpl.y(29);
        }
        return animationObject;
    }

    @RequiresEdt
    private void y(@NotNull Graph2DView graph2DView, @NotNull AnimationObject animationObject, boolean bl) {
        if (graph2DView == null) {
            GraphAnimationServiceImpl.y(30);
        }
        if (animationObject == null) {
            GraphAnimationServiceImpl.y(31);
        }
        ThreadingAssertions.assertEventDispatchThread();
        AnimationPlayer animationPlayer = GraphManager.getGraphManager().createAnimationPlayer();
        animationPlayer.addAnimationListener((AnimationListener)graph2DView);
        animationPlayer.setFps(1200);
        GraphBuilder graphBuilder = (GraphBuilder)GraphDataKeys.getData((Graph2DView)graph2DView, (String)GraphDataKeys.GRAPH_BUILDER.getName());
        this.y(true);
        this.g(bl);
        animationPlayer.animate(animationObject);
        if (graphBuilder != null && bl) {
            graphBuilder.setZoom(graph2DView.getZoom());
        }
        this.g(false);
        this.y(false);
    }

    private static /* synthetic */ void y(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n2) {
            default -> 3;
            case 6, 26, 29 -> 2;
        }];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 18: 
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 6: 
            case 26: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/GraphAnimationServiceImpl";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "focusArea";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newViewCenter";
                break;
            }
            case 21: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "layout";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetCanvasCenter";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "animationObject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/GraphAnimationServiceImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "calcContentCenter";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "createFocusViewAnimationObject";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "createLayoutAnimationObject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isZoomAnimationEnabledFor";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setZoomAnimationEnabledFor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "fitContent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcFitContentZoom";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calcContentCenter";
                break;
            }
            case 6: 
            case 26: 
            case 29: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "focusViewOnModelNodes";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "focusViewOnNodes";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "zoomToArea";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "updateWorldRect";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "focusView";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "performAnimatedLayout";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createFocusViewAnimationObject";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "createLayoutAnimationObject";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "performAnimation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n2) {
            default -> new IllegalArgumentException(string);
            case 6, 26, 29 -> new IllegalStateException(string);
        };
    }
}

