/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ui;

import com.intellij.util.descriptors.ConfigFileInfo;
import com.intellij.util.descriptors.ConfigFileMetaData;
import com.intellij.util.descriptors.ConfigFileVersion;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public abstract class DescriptorInfo {
    public static DescriptorInfo create(ConfigFileInfo descriptor) {
        return new StandardDescriptorInfo(descriptor, null);
    }

    public static DescriptorInfo create(ConfigFileInfo descriptor, ConfigFileVersion version) {
        return new StandardDescriptorInfo(descriptor, version);
    }

    public abstract void addToCollection(Collection<ConfigFileInfo> var1);

    public abstract String getTitle();

    public abstract String getUrl();

    public abstract void setUrlAndDirectory(String var1, String var2);

    @Nullable
    public abstract ConfigFileMetaData getMetaData();

    @Nullable
    public abstract ConfigFileVersion getVersion();

    public abstract void setVersion(ConfigFileVersion var1);

    public abstract String getOutputDirectory();

    private static class StandardDescriptorInfo
    extends DescriptorInfo {
        private ConfigFileInfo myDescriptor;
        private ConfigFileVersion myVersion;

        StandardDescriptorInfo(ConfigFileInfo descriptor, @Nullable ConfigFileVersion version) {
            this.myVersion = version;
            this.myDescriptor = descriptor;
        }

        @Override
        public String getTitle() {
            return this.myDescriptor.getMetaData().getTitle();
        }

        @Override
        public String getUrl() {
            return this.myDescriptor.getUrl();
        }

        @Override
        public void setUrlAndDirectory(String url, String outputDirectory) {
            this.myDescriptor = new ConfigFileInfo(this.myDescriptor.getMetaData(), url);
        }

        @Override
        @Nullable
        public ConfigFileMetaData getMetaData() {
            return this.myDescriptor.getMetaData();
        }

        @Override
        public void setVersion(ConfigFileVersion version) {
            this.myVersion = version;
        }

        @Override
        public String getOutputDirectory() {
            return this.myDescriptor.getMetaData().getDirectoryPath();
        }

        @Override
        @Nullable
        public ConfigFileVersion getVersion() {
            return this.myVersion;
        }

        @Override
        public void addToCollection(Collection<ConfigFileInfo> descriptors) {
            descriptors.add(this.myDescriptor);
        }
    }
}

