/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.xmlSchemeGenerator.compatDataGenerator;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.CssCompatDataSchemaGeneratorKt;
import com.intellij.css.xmlSchemeGenerator.compatDataGenerator.ValueBrowserSpecificEquivalents;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.CssWebrefSchemaGenerator;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderImpl;
import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilderKt;
import com.intellij.psi.css.impl.util.scheme.CssElementDescriptorFactory2;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u00002\u00020\u0001B\t\b\u0016\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0011J\u0019\u0010\u0015\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\u0002\u0010\u0019J\u000e\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u0018J\u000e\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0012J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020$J\u000e\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020$J*\u0010)\u001a\u00020\u000f2\u0006\u0010*\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u00122\b\b\u0002\u0010.\u001a\u00020/H\u0002J<\u00100\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001202j\b\u0012\u0004\u0012\u00020\u0012`3\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u001202j\b\u0012\u0004\u0012\u00020\u0012`3012\u0006\u00104\u001a\u00020$H\u0002J\"\u00105\u001a\u00020\u000f2\u0006\u00106\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00122\b\u00107\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u00108\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020,H\u0002J\u0010\u00109\u001a\u00020\u00122\u0006\u0010+\u001a\u00020,H\u0002J!\u0010:\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\u0006\u0010;\u001a\u00020\u0012\u00a2\u0006\u0002\u0010<J\u0010\u0010=\u001a\u00020/2\u0006\u0010>\u001a\u00020,H\u0002J\u0010\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020,H\u0002R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00120\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006A"}, d2={"Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator;", "", "<init>", "()V", "xmlBuilder", "Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "getXmlBuilder", "()Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "setXmlBuilder", "(Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;)V", "cssDescriptorsFactory", "Lcom/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2;", "getCssDescriptorsFactory", "()Lcom/intellij/psi/css/impl/util/scheme/CssElementDescriptorFactory2;", "generate", "", "getMapOfCompatValues", "", "", "", "Lcom/intellij/css/xmlSchemeGenerator/compatDataGenerator/ValueBrowserSpecificEquivalents;", "generateXmlDefinitionsFromFiles", "listFiles", "", "Ljava/io/File;", "([Ljava/io/File;)V", "generateXmlDefinitionsFromFile", "file", "saveToFile", "filePath", "browserPrefixes", "", "getBrowserPrefixes", "()Ljava/util/List;", "generateXmlDefinitionsFromProperties", "properties", "Lcom/google/gson/JsonObject;", "generateXmlDefinitionsFromTypes", "types", "generateXmlDefinitionsFromSelectors", "selectors", "generateXmlDefinitionsFrom", "cssEntityKind", "cssEntityObject", "Lcom/google/gson/JsonElement;", "name", "isSelector", "", "getPrefixesAndAlternativeNamesSets", "Lkotlin/Pair;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "browsersSupportObject", "generateXmlDefinition", "xmlEntityKind", "prefix", "getBrowsersSupportObject", "getDescription", "generateListOfExclusion", "languageEntityName", "([Ljava/io/File;Ljava/lang/String;)V", "isImplementedInBrowser", "browserSupportObject", "hasAnyBrowserSupport", "propertyObject", "intellij.css.xmlSchemeGenerator"})
@SourceDebugExtension(value={"SMAP\nCssCompatDataSchemaGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CssCompatDataSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,315:1\n1#2:316\n382#3,7:317\n1563#4:324\n1634#4,3:325\n1869#4,2:328\n1869#4,2:330\n*S KotlinDebug\n*F\n+ 1 CssCompatDataSchemaGenerator.kt\ncom/intellij/css/xmlSchemeGenerator/compatDataGenerator/CssCompatDataSchemaGenerator\n*L\n59#1:317,7\n74#1:324\n74#1:325,3\n186#1:328,2\n199#1:330,2\n*E\n"})
public final class CssCompatDataSchemaGenerator {
    @NotNull
    private XmlBuilderImpl xmlBuilder = new XmlBuilderImpl();
    @NotNull
    private final CssElementDescriptorFactory2 cssDescriptorsFactory = new CssElementDescriptorFactory2();
    @NotNull
    private final List<String> browserPrefixes;

    @NotNull
    public final XmlBuilderImpl getXmlBuilder() {
        return this.xmlBuilder;
    }

    public final void setXmlBuilder(@NotNull XmlBuilderImpl xmlBuilderImpl) {
        Intrinsics.checkNotNullParameter((Object)xmlBuilderImpl, (String)"<set-?>");
        this.xmlBuilder = xmlBuilderImpl;
    }

    @NotNull
    public final CssElementDescriptorFactory2 getCssDescriptorsFactory() {
        return this.cssDescriptorsFactory;
    }

    public CssCompatDataSchemaGenerator() {
        Object[] objectArray = new String[]{"-moz-", "-webkit-", "-ms-"};
        this.browserPrefixes = CollectionsKt.listOf((Object[])objectArray);
        this.cssDescriptorsFactory.reload();
    }

    public final void generate() {
        String[] stringArray = new String[]{"types", "properties", "selectors"};
        for (String languageEntity : stringArray) {
            String path = "plugins/css/xmlSchemeGenerator/resources/browserCompatDataJsons/" + languageEntity;
            File directory = new File(path);
            if (!directory.exists() || !directory.isDirectory()) {
                return;
            }
            File[] listFiles = directory.listFiles();
            Intrinsics.checkNotNull((Object)listFiles);
            this.generateListOfExclusion(listFiles, languageEntity);
            this.generateXmlDefinitionsFromFiles(listFiles);
            this.saveToFile("plugins/css/xmlSchemeGenerator/resources/xmlsCompatData/prefixed-" + languageEntity + ".xml");
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, Set<ValueBrowserSpecificEquivalents>> getMapOfCompatValues() {
        Map mapOfCompatValues = new LinkedHashMap();
        String path = "plugins/css/xmlSchemeGenerator/resources/browserCompatDataJsons/properties";
        File directory = new File(path);
        if (!directory.exists() || !directory.isDirectory()) {
            return mapOfCompatValues;
        }
        File[] listFiles = directory.listFiles();
        Intrinsics.checkNotNull((Object)listFiles);
        for (File file : listFiles) {
            FileReader reader = new FileReader(file);
            JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (rootElementObject == null) continue;
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject properties = cssElementObject.getAsJsonObject("properties");
            for (Map.Entry entry : properties.entrySet()) {
                void $this$getOrPut$iv;
                Object v0;
                String propertyNameKey;
                JsonElement propertyObject;
                String propertyName;
                block8: {
                    Intrinsics.checkNotNull((Object)entry);
                    propertyName = (String)entry.getKey();
                    propertyObject = (JsonElement)entry.getValue();
                    if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(propertyName)) continue;
                    propertyNameKey = propertyName;
                    Object object = this.browserPrefixes;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)propertyName);
                        if (!StringsKt.startsWith$default((String)propertyName, (String)it, (boolean)false, (int)2, null)) continue;
                        v0 = t;
                        break block8;
                    }
                    v0 = null;
                }
                String prefixInName = v0;
                if (prefixInName != null) {
                    Intrinsics.checkNotNull((Object)propertyName);
                    propertyNameKey = StringsKt.removePrefix((String)propertyName, (CharSequence)prefixInName);
                }
                Map map = mapOfCompatValues;
                String key$iv = propertyNameKey;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(key$iv);
                if (value$iv == null) {
                    boolean bl = false;
                    Set answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(key$iv, answer$iv);
                }
                for (Object object : propertyObject.getAsJsonObject().entrySet()) {
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    JsonObject browsersSupportObject;
                    Intrinsics.checkNotNull((Object)object);
                    String valueName = (String)object.getKey();
                    JsonElement valueObject = (JsonElement)object.getValue();
                    if (Intrinsics.areEqual((Object)valueName, (Object)"__compat")) continue;
                    Intrinsics.checkNotNull((Object)valueObject);
                    if (this.getBrowsersSupportObject(valueObject) == null) continue;
                    Pair<HashSet<String>, HashSet<String>> pair = this.getPrefixesAndAlternativeNamesSets(browsersSupportObject);
                    HashSet uniquePrefixes = (HashSet)pair.component1();
                    HashSet alternativeNames = (HashSet)pair.component2();
                    String description = this.getDescription(valueObject);
                    String type = CssWebrefSchemaGenerator.Companion.getCssEntityType(description);
                    if (uniquePrefixes.isEmpty() && alternativeNames.isEmpty() || Intrinsics.areEqual((Object)type, (Object)"function")) continue;
                    Set browserSpecificEquivalents = new LinkedHashSet();
                    Iterable iterable = uniquePrefixes;
                    Set set = browserSpecificEquivalents;
                    boolean $i$f$map = false;
                    void var32_36 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        String string = (String)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((String)it + valueName);
                    }
                    set.addAll((List)destination$iv$iv);
                    browserSpecificEquivalents.addAll(alternativeNames);
                    Set set2 = (Set)mapOfCompatValues.get(propertyNameKey);
                    if (set2 == null) continue;
                    set2.add(new ValueBrowserSpecificEquivalents(valueName, browserSpecificEquivalents));
                }
                Set set = (Set)mapOfCompatValues.get(propertyNameKey);
                boolean bl = set != null ? set.isEmpty() : false;
                if (!bl) continue;
                mapOfCompatValues.remove(propertyNameKey);
            }
        }
        return mapOfCompatValues;
    }

    public final void generateXmlDefinitionsFromFiles(@NotNull File[] listFiles) {
        Intrinsics.checkNotNullParameter((Object)listFiles, (String)"listFiles");
        this.xmlBuilder = new XmlBuilderImpl();
        this.xmlBuilder.addTag("definitions", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFromFiles$lambda$0(listFiles, this, arg_0)));
    }

    public final void generateXmlDefinitionsFromFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        FileReader reader = new FileReader(file);
        JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        if (rootElementObject != null) {
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject types = cssElementObject.getAsJsonObject("types");
            JsonObject properties = cssElementObject.getAsJsonObject("properties");
            JsonObject selectors = cssElementObject.getAsJsonObject("selectors");
            if (types != null) {
                this.generateXmlDefinitionsFromTypes(types);
            }
            if (properties != null) {
                this.generateXmlDefinitionsFromProperties(properties);
            }
            if (selectors != null) {
                this.generateXmlDefinitionsFromSelectors(selectors);
            }
        }
    }

    public final void saveToFile(@NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        File xmlFile = new File(filePath);
        xmlFile.createNewFile();
        XmlBuilderKt.saveToFile(this.xmlBuilder, xmlFile);
    }

    @NotNull
    public final List<String> getBrowserPrefixes() {
        return this.browserPrefixes;
    }

    public final void generateXmlDefinitionsFromProperties(@NotNull JsonObject properties) {
        Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
        Set properties2 = properties.entrySet();
        for (Map.Entry entry : properties2) {
            Object v0;
            JsonElement propertyObject;
            String propertyName;
            block3: {
                Intrinsics.checkNotNull((Object)entry);
                propertyName = (String)entry.getKey();
                propertyObject = (JsonElement)entry.getValue();
                if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(propertyName)) continue;
                Iterable iterable = this.browserPrefixes;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)propertyName);
                    if (!StringsKt.startsWith$default((String)propertyName, (String)it, (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            String prefixInName = v0;
            if (prefixInName != null) {
                Intrinsics.checkNotNull((Object)propertyName);
                this.generateXmlDefinition("property", StringsKt.removePrefix((String)propertyName, (CharSequence)prefixInName), prefixInName);
                continue;
            }
            Intrinsics.checkNotNull((Object)propertyObject);
            Intrinsics.checkNotNull((Object)propertyName);
            CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$default(this, "property", propertyObject, propertyName, false, 8, null);
        }
    }

    public final void generateXmlDefinitionsFromTypes(@NotNull JsonObject types) {
        Intrinsics.checkNotNullParameter((Object)types, (String)"types");
        Set set = types.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"keySet(...)");
        String typeObjectKey = (String)CollectionsKt.first((Iterable)set);
        JsonObject typeObject = types.getAsJsonObject(typeObjectKey);
        Intrinsics.checkNotNull((Object)typeObject);
        String description = this.getDescription((JsonElement)typeObject);
        String entityType = CssWebrefSchemaGenerator.Companion.getCssEntityType(description);
        if (entityType != null) {
            JsonElement jsonElement = (JsonElement)typeObject;
            Intrinsics.checkNotNull((Object)typeObjectKey);
            CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$default(this, entityType, jsonElement, typeObjectKey, false, 8, null);
        }
        Set namedValues = typeObject.entrySet();
        for (Map.Entry entry : namedValues) {
            Intrinsics.checkNotNull((Object)entry);
            String namedValue = (String)entry.getKey();
            JsonElement namedValueObject = (JsonElement)entry.getValue();
            if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(namedValue)) continue;
            Intrinsics.checkNotNull((Object)namedValueObject);
            String description2 = this.getDescription(namedValueObject);
            String entityType2 = CssWebrefSchemaGenerator.Companion.getCssEntityType(description2);
            if (entityType2 == null) continue;
            Intrinsics.checkNotNull((Object)namedValue);
            CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$default(this, entityType2, namedValueObject, namedValue, false, 8, null);
        }
    }

    public final void generateXmlDefinitionsFromSelectors(@NotNull JsonObject selectors) {
        Intrinsics.checkNotNullParameter((Object)selectors, (String)"selectors");
        Set selectorNames = selectors.entrySet();
        for (Map.Entry entry : selectorNames) {
            String selectorType;
            Object v0;
            JsonElement selectorObject;
            String selectorName;
            block3: {
                Intrinsics.checkNotNull((Object)entry);
                selectorName = (String)entry.getKey();
                selectorObject = (JsonElement)entry.getValue();
                if (CssCompatDataSchemaGeneratorKt.getExcludeProperties().contains(selectorName)) continue;
                Intrinsics.checkNotNull((Object)selectorObject);
                String description = this.getDescription(selectorObject);
                if (CssWebrefSchemaGenerator.Companion.getCssEntityType(description) == null) continue;
                Iterable iterable = this.browserPrefixes;
                for (Object t : iterable) {
                    String it = (String)t;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)selectorName);
                    if (!StringsKt.startsWith$default((String)selectorName, (String)it, (boolean)false, (int)2, null)) continue;
                    v0 = t;
                    break block3;
                }
                v0 = null;
            }
            String prefixInName = v0;
            if (prefixInName != null) {
                Intrinsics.checkNotNull((Object)selectorName);
                this.generateXmlDefinition(selectorType, selectorName, null);
                continue;
            }
            Intrinsics.checkNotNull((Object)selectorName);
            this.generateXmlDefinitionsFrom(selectorType, selectorObject, selectorName, true);
        }
    }

    private final void generateXmlDefinitionsFrom(String cssEntityKind, JsonElement cssEntityObject, String name, boolean isSelector) {
        JsonObject jsonObject = this.getBrowsersSupportObject(cssEntityObject);
        if (jsonObject == null) {
            return;
        }
        JsonObject browsersSupportObject = jsonObject;
        Pair<HashSet<String>, HashSet<String>> pair = this.getPrefixesAndAlternativeNamesSets(browsersSupportObject);
        HashSet uniquePrefixes = (HashSet)pair.component1();
        HashSet alternativeNames = (HashSet)pair.component2();
        Iterable $this$forEach$iv = uniquePrefixes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String prefix = (String)element$iv;
            boolean bl = false;
            if (isSelector) {
                this.generateXmlDefinition(cssEntityKind, prefix + name, null);
                continue;
            }
            if (Intrinsics.areEqual((Object)cssEntityKind, (Object)"function")) {
                this.xmlBuilder.addTag("prefixed-function", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$0$0(name, prefix, arg_0)));
                continue;
            }
            this.generateXmlDefinition(cssEntityKind, name, prefix);
        }
        $this$forEach$iv = alternativeNames;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String alternativeName = (String)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)cssEntityKind, (Object)"property")) continue;
            this.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$1$0(alternativeName, this, name, arg_0)));
        }
    }

    static /* synthetic */ void generateXmlDefinitionsFrom$default(CssCompatDataSchemaGenerator cssCompatDataSchemaGenerator, String string, JsonElement jsonElement, String string2, boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        cssCompatDataSchemaGenerator.generateXmlDefinitionsFrom(string, jsonElement, string2, bl);
    }

    private final Pair<HashSet<String>, HashSet<String>> getPrefixesAndAlternativeNamesSets(JsonObject browsersSupportObject) {
        HashSet<String> uniquePrefixes = new HashSet<String>();
        HashSet<String> alternativeNamesSet = new HashSet<String>();
        for (Map.Entry entry : browsersSupportObject.entrySet()) {
            Iterator iterator;
            Intrinsics.checkNotNull((Object)entry);
            JsonElement browserSupportObject = (JsonElement)entry.getValue();
            if (browserSupportObject.isJsonObject()) {
                JsonPrimitive prefix;
                JsonPrimitive alternativeName = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("alternative_name");
                if (alternativeName != null) {
                    Intrinsics.checkNotNull((Object)browserSupportObject);
                    if (this.isImplementedInBrowser(browserSupportObject)) {
                        alternativeNamesSet.add(alternativeName.getAsString());
                    }
                }
                if ((prefix = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("prefix")) == null) continue;
                Intrinsics.checkNotNull((Object)browserSupportObject);
                if (!this.isImplementedInBrowser(browserSupportObject)) continue;
                uniquePrefixes.add(prefix.getAsString());
                continue;
            }
            if (!browserSupportObject.isJsonArray()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)browserSupportObject.getAsJsonArray().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                JsonPrimitive prefix;
                JsonElement browserSupportObject2 = (JsonElement)iterator.next();
                JsonPrimitive alternativeName = browserSupportObject2.getAsJsonObject().getAsJsonPrimitive("alternative_name");
                if (alternativeName != null) {
                    Intrinsics.checkNotNull((Object)browserSupportObject2);
                    if (this.isImplementedInBrowser(browserSupportObject2)) {
                        alternativeNamesSet.add(alternativeName.getAsString());
                    }
                }
                if ((prefix = browserSupportObject2.getAsJsonObject().getAsJsonPrimitive("prefix")) == null) continue;
                Intrinsics.checkNotNull((Object)browserSupportObject2);
                if (!this.isImplementedInBrowser(browserSupportObject2)) continue;
                uniquePrefixes.add(prefix.getAsString());
            }
        }
        return new Pair(uniquePrefixes, alternativeNamesSet);
    }

    private final void generateXmlDefinition(String xmlEntityKind, String name, String prefix) {
        Object tagName = prefix == null ? xmlEntityKind : "prefixed-" + xmlEntityKind;
        this.xmlBuilder.addTag((String)tagName, (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinition$lambda$0(name, prefix, arg_0)));
    }

    private final JsonObject getBrowsersSupportObject(JsonElement cssEntityObject) {
        JsonObject jsonObject = cssEntityObject.getAsJsonObject();
        return jsonObject != null && (jsonObject = jsonObject.getAsJsonObject("__compat")) != null ? jsonObject.getAsJsonObject("support") : null;
    }

    private final String getDescription(JsonElement cssEntityObject) {
        String string;
        String string2;
        String string3;
        JsonPrimitive jsonPrimitive;
        JsonObject jsonObject;
        JsonObject jsonObject2 = cssEntityObject.getAsJsonObject();
        return jsonObject2 != null && (jsonObject = jsonObject2.getAsJsonObject("__compat")) != null && (jsonPrimitive = jsonObject.getAsJsonPrimitive("description")) != null && (string3 = jsonPrimitive.getAsString()) != null && (string2 = StringsKt.removePrefix((String)string3, (CharSequence)"`")) != null && (string = StringsKt.removeSuffix((String)string2, (CharSequence)"`")) != null ? string : "";
    }

    public final void generateListOfExclusion(@NotNull File[] listFiles, @NotNull String languageEntityName) {
        Intrinsics.checkNotNullParameter((Object)listFiles, (String)"listFiles");
        Intrinsics.checkNotNullParameter((Object)languageEntityName, (String)"languageEntityName");
        for (File file : listFiles) {
            FileReader reader = new FileReader(file);
            JsonObject rootElementObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (rootElementObject == null) continue;
            JsonObject cssElementObject = rootElementObject.getAsJsonObject("css");
            JsonObject languageEntities = cssElementObject.getAsJsonObject(languageEntityName);
            for (Map.Entry entry : languageEntities.entrySet()) {
                String string;
                Object v1;
                Object object;
                String cssEntityName;
                block5: {
                    Intrinsics.checkNotNull((Object)entry);
                    cssEntityName = (String)entry.getKey();
                    JsonElement cssEntityObject = (JsonElement)entry.getValue();
                    Intrinsics.checkNotNull((Object)cssEntityObject);
                    if (!this.hasAnyBrowserSupport(cssEntityObject)) {
                        List<String> list = CssCompatDataSchemaGeneratorKt.getExcludeProperties();
                        Intrinsics.checkNotNull((Object)cssEntityName);
                        list.add(cssEntityName);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)languageEntityName, (Object)"selectors")) continue;
                    object = this.browserPrefixes;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Object t = iterator.next();
                        String it = (String)t;
                        boolean bl = false;
                        Intrinsics.checkNotNull((Object)cssEntityName);
                        if (!StringsKt.startsWith$default((String)cssEntityName, (String)it, (boolean)false, (int)2, null)) continue;
                        v1 = t;
                        break block5;
                    }
                    v1 = null;
                }
                if ((string = (String)v1) == null) {
                    string = "";
                }
                String prefixInName = string;
                Intrinsics.checkNotNull((Object)cssEntityName);
                String unprefixedPropertyName = StringsKt.removePrefix((String)cssEntityName, (CharSequence)prefixInName);
                object = languageEntityName;
                Collection unprefixedDefinition = Intrinsics.areEqual((Object)object, (Object)"properties") ? this.cssDescriptorsFactory.findProperty(unprefixedPropertyName) : (Intrinsics.areEqual((Object)object, (Object)"types") ? this.cssDescriptorsFactory.findFunction(unprefixedPropertyName) : null);
                if (!((object = unprefixedDefinition) == null || object.isEmpty())) continue;
                CssCompatDataSchemaGeneratorKt.getExcludeProperties().add(cssEntityName);
            }
        }
    }

    private final boolean isImplementedInBrowser(JsonElement browserSupportObject) {
        JsonPrimitive added = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("version_added");
        JsonPrimitive removed = browserSupportObject.getAsJsonObject().getAsJsonPrimitive("version_removed");
        return !Intrinsics.areEqual((Object)added.getAsString(), (Object)"false") && removed == null;
    }

    private final boolean hasAnyBrowserSupport(JsonElement propertyObject) {
        JsonObject browsersSupportObject = this.getBrowsersSupportObject(propertyObject);
        if (browsersSupportObject == null) {
            return false;
        }
        for (Map.Entry entry : browsersSupportObject.entrySet()) {
            Iterator iterator;
            Intrinsics.checkNotNull((Object)entry);
            String browserName = (String)entry.getKey();
            JsonElement browserSupportObject = (JsonElement)entry.getValue();
            if (Intrinsics.areEqual((Object)browserName, (Object)"mirror")) continue;
            if (browserSupportObject.isJsonObject()) {
                Intrinsics.checkNotNull((Object)browserSupportObject);
                if (this.isImplementedInBrowser(browserSupportObject)) {
                    return true;
                }
            }
            if (!browserSupportObject.isJsonArray()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)browserSupportObject.getAsJsonArray().iterator(), (String)"iterator(...)");
            while (iterator.hasNext()) {
                JsonElement supportObject = (JsonElement)iterator.next();
                Intrinsics.checkNotNull((Object)supportObject);
                if (!this.isImplementedInBrowser(supportObject)) continue;
                return true;
            }
        }
        return false;
    }

    private static final Unit generateXmlDefinitionsFromFiles$lambda$0(File[] $listFiles, CssCompatDataSchemaGenerator this$0, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("xmlns", "urn:schemas-jetbrains-com:css-xml");
        for (File file : $listFiles) {
            this$0.generateXmlDefinitionsFromFile(file);
        }
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$0$0(String $name, String $prefix, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        element.setAttribute("prefix", StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$prefix, (CharSequence)"-"), (CharSequence)"-"));
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$1$0(String $alternativeName, CssCompatDataSchemaGenerator this$0, String $name, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $alternativeName);
        element.setAttribute("declared-in", "0");
        this$0.xmlBuilder.addTag("property", (Function1<? super Element, Unit>)((Function1)arg_0 -> CssCompatDataSchemaGenerator.generateXmlDefinitionsFrom$lambda$1$0$0($name, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinitionsFrom$lambda$1$0$0(String $name, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        return Unit.INSTANCE;
    }

    private static final Unit generateXmlDefinition$lambda$0(String $name, String $prefix, Element element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.setAttribute("id", $name);
        if ($prefix != null) {
            element.setAttribute("prefix", StringsKt.removeSuffix((String)StringsKt.removePrefix((String)$prefix, (CharSequence)"-"), (CharSequence)"-"));
        } else {
            element.setAttribute("declared-in", "0");
        }
        return Unit.INSTANCE;
    }
}

