/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.xmlSchemeGenerator.webrefGenerator;

import com.intellij.css.xmlSchemeGenerator.webrefGenerator.XmlBuilder;
import java.io.File;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020\u001d0!H\u0016J\u0010\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020\u001fH\u0016J\n\u0010'\u001a\u0004\u0018\u00010\u0012H\u0016J\b\u0010(\u001a\u00020\u001dH\u0016J5\u0010)\u001a\u00020\u001d\"\b\b\u0000\u0010**\u00020\u00122\u0006\u0010+\u001a\u0002H*2\u0014\b\u0002\u0010 \u001a\u000e\u0012\u0004\u0012\u0002H*\u0012\u0004\u0012\u00020\u001d0!H\u0002\u00a2\u0006\u0002\u0010,J\u0010\u0010-\u001a\u00020\u001d2\u0006\u0010.\u001a\u00020/H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n \u0019*\u0004\u0018\u00010\u001b0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilderImpl;", "Lcom/intellij/css/xmlSchemeGenerator/webrefGenerator/XmlBuilder;", "<init>", "()V", "factory", "Ljavax/xml/parsers/DocumentBuilderFactory;", "getFactory", "()Ljavax/xml/parsers/DocumentBuilderFactory;", "builder", "Ljavax/xml/parsers/DocumentBuilder;", "getBuilder", "()Ljavax/xml/parsers/DocumentBuilder;", "document", "Lorg/w3c/dom/Document;", "getDocument", "()Lorg/w3c/dom/Document;", "nodeStack", "Ljava/util/Stack;", "Lorg/w3c/dom/Node;", "rootNode", "topNode", "getTopNode", "()Lorg/w3c/dom/Node;", "FORMATTING_XLS_PATH", "Ljava/net/URL;", "kotlin.jvm.PlatformType", "FORMATTING_FILE", "Ljava/io/File;", "addTag", "", "name", "", "action", "Lkotlin/Function1;", "Lorg/w3c/dom/Element;", "addComment", "text", "addAttributeToLastChild", "value", "getLastChild", "removeLastChild", "setupChild", "T", "element", "(Lorg/w3c/dom/Node;Lkotlin/jvm/functions/Function1;)V", "outputContent", "result", "Ljavax/xml/transform/stream/StreamResult;", "intellij.css.xmlSchemeGenerator"})
public final class XmlBuilderImpl
implements XmlBuilder {
    @NotNull
    private final DocumentBuilderFactory factory;
    @NotNull
    private final DocumentBuilder builder;
    @NotNull
    private final Document document;
    @NotNull
    private final Stack<Node> nodeStack;
    @Nullable
    private Node rootNode;
    private final URL FORMATTING_XLS_PATH;
    private final File FORMATTING_FILE;

    public XmlBuilderImpl() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilderFactory, (String)"newInstance(...)");
        this.factory = documentBuilderFactory;
        DocumentBuilder documentBuilder = this.factory.newDocumentBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)documentBuilder, (String)"newDocumentBuilder(...)");
        this.builder = documentBuilder;
        Document document = this.builder.newDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"newDocument(...)");
        this.document = document;
        this.nodeStack = new Stack();
        this.FORMATTING_XLS_PATH = XmlBuilderImpl.class.getResource("/formatter.xsl");
        this.FORMATTING_FILE = Paths.get(this.FORMATTING_XLS_PATH.toURI()).toFile();
    }

    @NotNull
    public final DocumentBuilderFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final DocumentBuilder getBuilder() {
        return this.builder;
    }

    @NotNull
    public final Document getDocument() {
        return this.document;
    }

    private final Node getTopNode() {
        Node node = this.nodeStack.peek();
        Intrinsics.checkNotNullExpressionValue((Object)node, (String)"peek(...)");
        return node;
    }

    @Override
    public void addTag(@NotNull String name, @NotNull Function1<? super Element, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Element element = this.document.createElement(name);
        Intrinsics.checkNotNullExpressionValue((Object)element, (String)"createElement(...)");
        this.setupChild((Node)element, action);
    }

    @Override
    public void addComment(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Comment comment = this.document.createComment(text);
        Intrinsics.checkNotNullExpressionValue((Object)comment, (String)"createComment(...)");
        XmlBuilderImpl.setupChild$default(this, comment, null, 2, null);
    }

    @Override
    public void addAttributeToLastChild(@NotNull String name, @NotNull String value) {
        Element element;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (!((Collection)this.nodeStack).isEmpty()) {
            Node node = this.getTopNode().getLastChild();
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
        } else {
            Node node = this.rootNode;
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            element = (Element)node;
        }
        Element lastChild = element;
        lastChild.setAttribute(name, value);
    }

    @Override
    @Nullable
    public Node getLastChild() {
        return !((Collection)this.nodeStack).isEmpty() ? this.getTopNode().getLastChild() : null;
    }

    @Override
    public void removeLastChild() {
        if (this.getLastChild() == null) {
            return;
        }
        Node newTopNode = this.getTopNode();
        newTopNode.removeChild(this.getTopNode().getLastChild());
        this.nodeStack.pop();
        this.nodeStack.push(newTopNode);
    }

    private final <T extends Node> void setupChild(T element, Function1<? super T, Unit> action) {
        if (this.rootNode == null) {
            this.rootNode = element;
        } else {
            this.getTopNode().appendChild(element);
        }
        this.nodeStack.push(element);
        action.invoke(element);
        this.nodeStack.pop();
    }

    static /* synthetic */ void setupChild$default(XmlBuilderImpl xmlBuilderImpl, Node node, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = XmlBuilderImpl::setupChild$lambda$0;
        }
        xmlBuilderImpl.setupChild(node, function1);
    }

    @Override
    public void outputContent(@NotNull StreamResult result) {
        Transformer transformer;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer $this$outputContent_u24lambda_u240 = transformer = transformerFactory.newTransformer(new StreamSource(this.FORMATTING_FILE));
        boolean bl = false;
        $this$outputContent_u24lambda_u240.setOutputProperty("version", "1.0");
        $this$outputContent_u24lambda_u240.setOutputProperty("encoding", "UTF-8");
        $this$outputContent_u24lambda_u240.setOutputProperty("indent", "yes");
        $this$outputContent_u24lambda_u240.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        Transformer transformer2 = transformer;
        DOMSource source = new DOMSource(this.rootNode);
        transformer2.transform(source, result);
    }

    private static final Unit setupChild$lambda$0(Node it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }
}

