/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.compose;

import com.intellij.docker.ConfigureNewRunConfig;
import com.intellij.docker.DockerCloudConfiguration;
import com.intellij.docker.DockerCloudType;
import com.intellij.docker.DockerDeploymentConfiguration;
import com.intellij.docker.DockerIcons;
import com.intellij.docker.DockerRunConfigurationCreator;
import com.intellij.docker.FireAsTemporaryRunConfigAction;
import com.intellij.docker.RunConfigActionBase;
import com.intellij.docker.RunExistingRunConfig;
import com.intellij.docker.agent.util.UtilsKt;
import com.intellij.docker.deployment.DockerRunConfig;
import com.intellij.docker.deploymentSource.DockerComposeDeploymentSourceType;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.docker.utils.DockerUtils;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b&\u0018\u0000  2\u00020\u0001:\u0003 !\"B3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0014J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0016H\u0014J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0019H$J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006#"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions;", "", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "getHelper", "()Lcom/intellij/docker/DockerRunConfigurationCreator;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getServer", "()Lcom/intellij/remoteServer/configuration/RemoteServer;", "createFirstGroup", "", "Lcom/intellij/docker/RunExistingRunConfig;", "configs", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "createSecondGroup", "Lcom/intellij/openapi/actionSystem/AnAction;", "configsFilter", "", "config", "createActions", "Companion", "ForSingleService", "ForAllServices", "intellij.clouds.docker"})
@SourceDebugExtension(value={"SMAP\nDockerComposeServiceActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeServiceActions.kt\ncom/intellij/docker/compose/DockerComposeServiceActions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n1869#2,2:170\n774#2:172\n865#2,2:173\n774#2:175\n865#2,2:176\n*S KotlinDebug\n*F\n+ 1 DockerComposeServiceActions.kt\ncom/intellij/docker/compose/DockerComposeServiceActions\n*L\n39#1:166\n39#1:167,3\n49#1:170,2\n63#1:172\n63#1:173,2\n70#1:175\n70#1:176,2\n*E\n"})
public abstract class DockerComposeServiceActions {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DockerRunConfigurationCreator helper;
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile file;
    @Nullable
    private final RemoteServer<DockerCloudConfiguration> server;
    private static final DockerComposeDeploymentSourceType COMPOSE = DockerComposeDeploymentSourceType.getInstance();

    @JvmOverloads
    public DockerComposeServiceActions(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @NotNull VirtualFile file, @Nullable RemoteServer<DockerCloudConfiguration> server) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.helper = helper;
        this.project = project;
        this.file = file;
        this.server = server;
    }

    public /* synthetic */ DockerComposeServiceActions(DockerRunConfigurationCreator dockerRunConfigurationCreator, Project project, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            remoteServer = null;
        }
        this(dockerRunConfigurationCreator, project, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
    }

    @NotNull
    protected final DockerRunConfigurationCreator getHelper() {
        return this.helper;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    @NotNull
    protected final VirtualFile getFile() {
        return this.file;
    }

    @Nullable
    protected final RemoteServer<DockerCloudConfiguration> getServer() {
        return this.server;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected List<RunExistingRunConfig> createFirstGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        Iterable $this$map$iv = configs;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DockerRunConfig.Wrapper wrapper = (DockerRunConfig.Wrapper)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new RunExistingRunConfig(this.helper, (DockerRunConfig.Wrapper)it));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    protected List<AnAction> createSecondGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
        List list;
        Intrinsics.checkNotNullParameter(configs, (String)"configs");
        List $this$createSecondGroup_u24lambda_u240 = list = (List)new ArrayList();
        boolean bl = false;
        if (this.server == null) {
            List dockerAccounts = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
            if (dockerAccounts.isEmpty()) {
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                $this$createSecondGroup_u24lambda_u240.add(DockerComposeServiceActions.Companion.withDockerIcon(new ConfigureNewRunConfig(this.helper, this.file, dockerComposeDeploymentSourceType, null)));
            } else {
                Iterable $this$forEach$iv = DockerUtils.allServersExceptKnowns(configs, this.project);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RemoteServer it = (RemoteServer)element$iv;
                    boolean bl2 = false;
                    DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
                    $this$createSecondGroup_u24lambda_u240.add(new FireAsTemporaryRunConfigAction(this.helper, this.file, dockerComposeDeploymentSourceType, (RemoteServer<DockerCloudConfiguration>)it));
                }
            }
        } else if (configs.isEmpty()) {
            DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
            Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
            $this$createSecondGroup_u24lambda_u240.add(new FireAsTemporaryRunConfigAction(this.helper, this.file, dockerComposeDeploymentSourceType, this.server));
        }
        return list;
    }

    protected abstract boolean configsFilter(@NotNull DockerRunConfig.Wrapper var1);

    @NotNull
    public final List<AnAction> createActions() {
        Iterable $this$filterTo$iv$iv;
        DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"COMPOSE");
        List<DockerRunConfig.Wrapper> allConfigs = DockerRunConfig.Wrapper.Companion.dockerConfigs(this.project, this.file, (DeploymentSourceType)dockerComposeDeploymentSourceType);
        Iterable $this$filter$iv = allConfigs;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DockerRunConfig.Wrapper it = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl = false;
            boolean bl2 = this.server != null ? Intrinsics.areEqual((Object)it.getConfig().getServerName(), (Object)this.server.getName()) : true;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            DockerRunConfig.Wrapper p0 = (DockerRunConfig.Wrapper)element$iv$iv;
            boolean bl = false;
            if (!this.configsFilter(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List configs = (List)destination$iv$iv;
        return DockerComposeServiceActions.Companion.combineGroups(this.createFirstGroup(configs), this.createSecondGroup(configs));
    }

    @JvmOverloads
    public DockerComposeServiceActions(@NotNull DockerRunConfigurationCreator helper, @NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this(helper, project, file, null, 8, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0007\u001a\u00020\b*\u00020\bH\u0002J*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u0002R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$Companion;", "", "<init>", "()V", "COMPOSE", "Lcom/intellij/docker/deploymentSource/DockerComposeDeploymentSourceType;", "kotlin.jvm.PlatformType", "withDockerIcon", "Lcom/intellij/docker/RunConfigActionBase;", "combineGroups", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "first", "second", "intellij.clouds.docker"})
    public static final class Companion {
        private Companion() {
        }

        private final RunConfigActionBase withDockerIcon(RunConfigActionBase $this$withDockerIcon) {
            RunConfigActionBase runConfigActionBase;
            RunConfigActionBase $this$withDockerIcon_u24lambda_u240 = runConfigActionBase = $this$withDockerIcon;
            boolean bl = false;
            $this$withDockerIcon_u24lambda_u240.getTemplatePresentation().setIcon(DockerIcons.Docker);
            return runConfigActionBase;
        }

        private final List<AnAction> combineGroups(List<? extends AnAction> first, List<? extends AnAction> second) {
            List list;
            List $this$combineGroups_u24lambda_u240 = list = (List)new ArrayList();
            boolean bl = false;
            $this$combineGroups_u24lambda_u240.addAll((Collection)first);
            if (!((Collection)first).isEmpty() && !((Collection)second).isEmpty()) {
                $this$combineGroups_u24lambda_u240.add(new Separator());
            }
            $this$combineGroups_u24lambda_u240.addAll((Collection)second);
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u000f"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForAllServices;", "Lcom/intellij/docker/compose/DockerComposeServiceActions;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "configsFilter", "", "config", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
    public static final class ForAllServices
    extends DockerComposeServiceActions {
        @JvmOverloads
        public ForAllServices(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile file, @Nullable RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Project project = helper.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            super(helper, project, file, server);
        }

        public /* synthetic */ ForAllServices(DockerRunConfigurationCreator dockerRunConfigurationCreator, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                remoteServer = null;
            }
            this(dockerRunConfigurationCreator, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
        }

        @Override
        protected boolean configsFilter(@NotNull DockerRunConfig.Wrapper config2) {
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            return config2.getDeploymentConfiguration().getServices().isEmpty();
        }

        @JvmOverloads
        public ForAllServices(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this(helper, file, null, 4, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB3\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\b\u0002\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0014J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011H\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService;", "Lcom/intellij/docker/compose/DockerComposeServiceActions;", "service", "", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "server", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Ljava/lang/String;Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "createFirstGroup", "", "Lcom/intellij/docker/RunExistingRunConfig;", "configs", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "createSecondGroup", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "configsFilter", "", "config", "Companion", "ConfigureServiceRunConfig", "UpOneServiceAsTemporaryAction", "intellij.clouds.docker"})
    @SourceDebugExtension(value={"SMAP\nDockerComposeServiceActions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerComposeServiceActions.kt\ncom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,165:1\n1563#2:166\n1634#2,3:167\n1869#2,2:170\n*S KotlinDebug\n*F\n+ 1 DockerComposeServiceActions.kt\ncom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService\n*L\n96#1:166\n96#1:167,3\n114#1:170,2\n*E\n"})
    public static final class ForSingleService
    extends DockerComposeServiceActions {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String service;

        @JvmOverloads
        public ForSingleService(@NotNull String service, @NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile file, @Nullable RemoteServer<DockerCloudConfiguration> server) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Project project = helper.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            super(helper, project, file, server);
            this.service = service;
        }

        public /* synthetic */ ForSingleService(String string, DockerRunConfigurationCreator dockerRunConfigurationCreator, VirtualFile virtualFile, RemoteServer remoteServer, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                remoteServer = null;
            }
            this(string, dockerRunConfigurationCreator, virtualFile, (RemoteServer<DockerCloudConfiguration>)remoteServer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        protected List<RunExistingRunConfig> createFirstGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            Iterable $this$map$iv = configs;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                DockerRunConfig.Wrapper wrapper = (DockerRunConfig.Wrapper)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                DockerDeploymentConfiguration deploymentConfiguration = it.getDeploymentConfiguration();
                if (!Intrinsics.areEqual((Object)CollectionsKt.first(deploymentConfiguration.getServices()), (Object)this.service)) {
                    Object[] objectArray = new String[]{this.service};
                    deploymentConfiguration.setServices(CollectionsKt.mutableListOf((Object[])objectArray));
                }
                collection.add(new RunExistingRunConfig(this.getHelper(), (DockerRunConfig.Wrapper)it));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @NotNull
        protected List<AnAction> createSecondGroup(@NotNull List<DockerRunConfig.Wrapper> configs) {
            List list;
            Intrinsics.checkNotNullParameter(configs, (String)"configs");
            List $this$createSecondGroup_u24lambda_u240 = list = (List)new ArrayList();
            boolean bl = false;
            if (this.getServer() == null) {
                List dockerAccounts = RemoteServersManager.getInstance().getServers((ServerType)DockerCloudType.getInstance());
                if (dockerAccounts.isEmpty()) {
                    $this$createSecondGroup_u24lambda_u240.add(Companion.withDockerIcon(new ConfigureServiceRunConfig(this.getHelper(), this.getFile(), this.service, null)));
                } else {
                    Iterable $this$forEach$iv = DockerUtils.allServersExceptKnowns(configs, this.getProject());
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        RemoteServer it = (RemoteServer)element$iv;
                        boolean bl2 = false;
                        $this$createSecondGroup_u24lambda_u240.add(new UpOneServiceAsTemporaryAction(this.getHelper(), this.getFile(), this.service, (RemoteServer<DockerCloudConfiguration>)it));
                    }
                }
            } else if (configs.isEmpty()) {
                $this$createSecondGroup_u24lambda_u240.add(new UpOneServiceAsTemporaryAction(this.getHelper(), this.getFile(), this.service, this.getServer()));
            }
            return list;
        }

        @Override
        protected boolean configsFilter(@NotNull DockerRunConfig.Wrapper config2) {
            Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
            return UtilsKt.containsOnly(config2.getDeploymentConfiguration().getServices(), (Object)this.service);
        }

        @JvmOverloads
        public ForSingleService(@NotNull String service, @NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)service, (String)"service");
            Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this(service, helper, file, null, 8, null);
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\t"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$Companion;", "", "<init>", "()V", "setupOneComposeService", "", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "service", "", "intellij.clouds.docker"})
        public static final class Companion {
            private Companion() {
            }

            private final void setupOneComposeService(DockerRunConfig.Wrapper $this$setupOneComposeService, String service) {
                DockerDeploymentConfiguration deployConfig = $this$setupOneComposeService.getDeploymentConfiguration();
                List<String> services = deployConfig.getServices();
                services.clear();
                services.add(service);
                $this$setupOneComposeService.getSettings().setName(COMPOSE.suggestConfigurationName(deployConfig));
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$ConfigureServiceRunConfig;", "Lcom/intellij/docker/ConfigureNewRunConfig;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "service", "", "docker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "customize", "", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
        private static final class ConfigureServiceRunConfig
        extends ConfigureNewRunConfig {
            @NotNull
            private final String service;

            public ConfigureServiceRunConfig(@NotNull DockerRunConfigurationCreator helper, @Nullable VirtualFile sourceFile, @NotNull String service, @Nullable RemoteServer<DockerCloudConfiguration> docker) {
                Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"access$getCOMPOSE$cp(...)");
                super(helper, sourceFile, dockerComposeDeploymentSourceType, docker);
                this.service = service;
            }

            @Override
            protected void customize(@NotNull DockerRunConfig.Wrapper runConfigWrapper) {
                Intrinsics.checkNotNullParameter((Object)runConfigWrapper, (String)"runConfigWrapper");
                super.customize(runConfigWrapper);
                Companion.setupOneComposeService(runConfigWrapper, this.service);
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/docker/compose/DockerComposeServiceActions$ForSingleService$UpOneServiceAsTemporaryAction;", "Lcom/intellij/docker/FireAsTemporaryRunConfigAction;", "helper", "Lcom/intellij/docker/DockerRunConfigurationCreator;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "service", "", "docker", "Lcom/intellij/remoteServer/configuration/RemoteServer;", "Lcom/intellij/docker/DockerCloudConfiguration;", "<init>", "(Lcom/intellij/docker/DockerRunConfigurationCreator;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;Lcom/intellij/remoteServer/configuration/RemoteServer;)V", "customize", "", "runConfigWrapper", "Lcom/intellij/docker/deployment/DockerRunConfig$Wrapper;", "intellij.clouds.docker"})
        private static final class UpOneServiceAsTemporaryAction
        extends FireAsTemporaryRunConfigAction {
            @NotNull
            private final String service;

            public UpOneServiceAsTemporaryAction(@NotNull DockerRunConfigurationCreator helper, @NotNull VirtualFile sourceFile, @NotNull String service, @NotNull RemoteServer<DockerCloudConfiguration> docker) {
                Intrinsics.checkNotNullParameter((Object)helper, (String)"helper");
                Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
                Intrinsics.checkNotNullParameter((Object)service, (String)"service");
                Intrinsics.checkNotNullParameter(docker, (String)"docker");
                DockerComposeDeploymentSourceType dockerComposeDeploymentSourceType = COMPOSE;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)dockerComposeDeploymentSourceType), (String)"access$getCOMPOSE$cp(...)");
                super(helper, sourceFile, dockerComposeDeploymentSourceType, docker);
                this.service = service;
                Object[] objectArray = new Object[]{docker.getName()};
                this.getTemplatePresentation().setText(DockerBundle.messagePointer((String)"DockerComposeActions.UpOneServiceAsTemporaryAction.text", (Object[])objectArray));
            }

            @Override
            protected void customize(@Nullable DockerRunConfig.Wrapper runConfigWrapper) {
                block0: {
                    DockerRunConfig.Wrapper wrapper = runConfigWrapper;
                    if (wrapper == null) break block0;
                    Companion.setupOneComposeService(wrapper, this.service);
                }
            }
        }
    }
}

